/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class ExplosionManager {
    public static final int EXPLODE_TYPE_NORMAL = 0;
    public static final int EXPLODE_TYPE_BEAT = 1;
    public static final int EXPLODE_TYPE_BOSS = 2;
    Sprite explosionSprite;
    Sprite beatExplosionSprite;
    Vector bossExplodeSpriteVector = new Vector();
    Vector explosionVector;

    public ExplosionManager(int stage) {
        this.init();
    }

    public void init() {
        this.explosionVector = new Vector();
        Image img = null;
        try {
            img = Image.createImage((String)"/explosion.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.explosionSprite = new Sprite(img, img.getWidth() / 9, img.getHeight());
        try {
            img = Image.createImage((String)"/explodehited.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.beatExplosionSprite = new Sprite(img, img.getWidth() / 2, img.getHeight());
        int i = 0;
        while (i < 6) {
            try {
                String fileName = new String("/mb" + i + ".png");
                img = Image.createImage((String)fileName);
            }
            catch (Exception fileName) {
                // empty catch block
            }
            Sprite sp = new Sprite(img, img.getWidth(), img.getHeight());
            this.bossExplodeSpriteVector.addElement(sp);
            ++i;
        }
    }

    public void createBossExplosion(int x, int y, int w, int h) {
        this.createExplosion(x, y, 2);
    }

    public void createExplosion(int x, int y, int explodeType) {
        GameObject bl = null;
        switch (explodeType) {
            case 0: {
                bl = new Explode(this.explosionSprite, x, y);
                break;
            }
            case 1: {
                bl = new BeatExplode(this.beatExplosionSprite, x, y);
                break;
            }
            case 2: {
                bl = new ExplodeBoss(this.bossExplodeSpriteVector, x, y);
            }
        }
        if (bl != null) {
            this.explosionVector.addElement(bl);
        }
    }

    public void calcExplosion() {
        int i = 0;
        while (i < this.explosionVector.size()) {
            GameObject bl = (GameObject)this.explosionVector.elementAt(i);
            if (bl.canDestroySelf()) {
                this.explosionVector.removeElement(bl);
                if (--i < 0) {
                    i = 0;
                }
            } else {
                bl.move();
            }
            ++i;
        }
    }

    public void paint(Graphics g) {
        int i = 0;
        while (i < this.explosionVector.size()) {
            GameObject bl = (GameObject)this.explosionVector.elementAt(i);
            bl.draw(g);
            ++i;
        }
    }
}

