/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

class CObstacleIce
extends CObstacleBase {
    static final int MAX_SLOT_CNT = 9;
    static final int OBSTACLE_STATE_PRE_FIRSTGEN = 0;
    static final int OBSTACLE_STATE_AFTER_FIRSTGEN = 1;
    static final int OBSTACLE_STATE_GENERATING = 2;
    static final int MAX_OBSTACLE_STATE = 3;
    static final int SLOT_STATE_NONE = 0;
    static final int SLOT_STATE_IDLE = 1;
    static final int SLOT_STATE_GEN = 2;
    static final int SLOT_STATE_GEN_ANI = 3;
    static final int SLOT_STATE_GEN_END = 4;
    static final int SLOT_STATE_CRACK_START = 5;
    static final int SLOT_STATE_CRACK = 6;
    static final int SLOT_STATE_CRACK_ANI = 7;
    static final int MAX_SLOT_STATE = 8;
    static final int ICE_IMG_FRAGILE = 0;
    static final int ICE_IMG_HALF = 1;
    static final int ICE_IMG_HARD = 2;
    static final int MAX_ICE_IMG = 3;
    static int m_dwObstacleState = 0;
    static int m_dwFirstGenElapse;
    static int m_dwReGenElapse;
    static int m_dwGenIceCnt;
    static int m_dwCurIceCnt;
    static int m_dwHardness;
    static STSlot[] m_stSlot;
    Image[] m_pImgIce = new Image[3];
    Image m_pImgIceBall;
    Image m_pNumber;
    static boolean m_bFirstGen;
    static boolean m_bShowClick;
    static int m_nCrackCnt;
    static boolean m_bCrackTouch;
    static final int HORI_ICE_SLOT_CNT = 3;
    static final int ICE_SLOT_WIDTH = 80;
    static final int ICE_SLOT_HEIGHT = 87;
    static final int ICEBALL_MOVE_PIXEL_Y = 20;
    static final int ICE_HEALTH = 3;
    static int m_dwIceHealth;
    static final int GIFT_BOX_RATE = 30;
    static final int REGEN_GIFT_BOX_RATE = 0;

    CObstacleIce() {
        this.m_bCharic = CDPCharic.HaveCharic(2);
    }

    void DestoryCObstacle() {
        this.Free();
        if (m_nCrackCnt > 0) {
            int nCrackCnt = CDPSaveAchieve.GetCrackIce();
            CDPSaveAchieve.SetCrackIce(m_nCrackCnt + nCrackCnt);
        }
    }

    int Init() {
        int i;
        String szFileName = "";
        for (i = 0; i < 3; ++i) {
            szFileName = "Obstacle_Ice_Bg_" + (3 - i) + ".png";
            this.m_pImgIce[i] = Yulib.LoadImage(szFileName);
        }
        this.m_pImgIceBall = Yulib.LoadImage("Obstacle_Ice_Ball.png");
        this.m_pNumber = Yulib.LoadImage("Obstacle_number_W20.png");
        for (i = 0; i < 9; ++i) {
            CObstacleIce.m_stSlot[i] = new STSlot();
        }
        for (i = 0; i < 9; ++i) {
            CObstacleIce.m_stSlot[i].pAniCrack = new CSWLAni();
            CObstacleIce.m_stSlot[i].pAniCrack.SetClock(MainCanvas.g_pGameClock);
            CObstacleIce.m_stSlot[i].pAniCrack.LoadFromRes("ani_crack_ice.txt");
            CObstacleIce.m_stSlot[i].pAniCharic = new CSWLAni();
            CObstacleIce.m_stSlot[i].pAniCharic.SetClock(MainCanvas.g_pGameClock);
            CObstacleIce.m_stSlot[i].pAniCharic.LoadFromRes("ani_ice_charic.txt");
        }
        this.m_nGiftBoxRate = 30;
        this.m_nGiftBoxRateRegen = 0;
        return 0;
    }

    void Free() {
        int i;
        for (i = 0; i < 3; ++i) {
            this.m_pImgIce[i] = null;
        }
        this.m_pImgIceBall = null;
        this.m_pNumber = null;
        for (i = 0; i < 9; ++i) {
            CObstacleIce.m_stSlot[i].pAniCrack = null;
            CObstacleIce.m_stSlot[i].pAniCharic = null;
        }
        this.m_pAniTouch = null;
    }

    void SetRoundData(CDPRnd lpRnd) {
        this.Init();
        STObstacleIce stIce = new STObstacleIce();
        lpRnd.GetObstacleIce(stIce);
        if (CMainViewSelPack.m_nSelPackIdx == 0) {
            CViewGameFDP.UseImg_fdp_data = CViewGameFDP.UseImg_fdp_data1;
        } else if (CMainViewSelPack.m_nSelPackIdx == 1) {
            CViewGameFDP.UseImg_fdp_data = CViewGameFDP.UseImg_fdp_data2;
        } else if (CMainViewSelPack.m_nSelPackIdx == 2) {
            CViewGameFDP.UseImg_fdp_data = CViewGameFDP.UseImg_fdp_data3;
        } else if (CMainViewSelPack.m_nSelPackIdx == 3) {
            CViewGameFDP.UseImg_fdp_data = CViewGameFDP.UseImg_fdp_data4;
        }
        int m_cBeginState = 0;
        if (CViewGameFDP.UseImg_fdp_data[CMainFrame.g_pMainDoc.GetCurrentLevel()][CMainDoc.GetCurrentRound()][0] == 0) {
            m_dwFirstGenElapse = CViewGameFDP.UseImg_fdp_data[CMainFrame.g_pMainDoc.GetCurrentLevel()][CMainDoc.GetCurrentRound()][7];
            m_dwReGenElapse = CViewGameFDP.UseImg_fdp_data[CMainFrame.g_pMainDoc.GetCurrentLevel()][CMainDoc.GetCurrentRound()][8];
            m_cBeginState = CViewGameFDP.UseImg_fdp_data[CMainFrame.g_pMainDoc.GetCurrentLevel()][CMainDoc.GetCurrentRound()][9];
            m_dwGenIceCnt = CViewGameFDP.UseImg_fdp_data[CMainFrame.g_pMainDoc.GetCurrentLevel()][CMainDoc.GetCurrentRound()][10];
            m_dwHardness = CViewGameFDP.UseImg_fdp_data[CMainFrame.g_pMainDoc.GetCurrentLevel()][CMainDoc.GetCurrentRound()][11];
        } else if (CViewGameFDP.UseImg_fdp_data[CMainFrame.g_pMainDoc.GetCurrentLevel()][CMainDoc.GetCurrentRound()][0] == 1) {
            m_dwFirstGenElapse = CViewGameFDP.UseImg_fdp_data[CMainFrame.g_pMainDoc.GetCurrentLevel()][CMainDoc.GetCurrentRound()][11];
            m_dwReGenElapse = CViewGameFDP.UseImg_fdp_data[CMainFrame.g_pMainDoc.GetCurrentLevel()][CMainDoc.GetCurrentRound()][12];
            m_cBeginState = CViewGameFDP.UseImg_fdp_data[CMainFrame.g_pMainDoc.GetCurrentLevel()][CMainDoc.GetCurrentRound()][13];
            m_dwGenIceCnt = CViewGameFDP.UseImg_fdp_data[CMainFrame.g_pMainDoc.GetCurrentLevel()][CMainDoc.GetCurrentRound()][14];
            m_dwHardness = CViewGameFDP.UseImg_fdp_data[CMainFrame.g_pMainDoc.GetCurrentLevel()][CMainDoc.GetCurrentRound()][15];
        } else if (CViewGameFDP.UseImg_fdp_data[CMainFrame.g_pMainDoc.GetCurrentLevel()][CMainDoc.GetCurrentRound()][0] == 2) {
            m_dwFirstGenElapse = CViewGameFDP.UseImg_fdp_data[CMainFrame.g_pMainDoc.GetCurrentLevel()][CMainDoc.GetCurrentRound()][9];
            m_dwReGenElapse = CViewGameFDP.UseImg_fdp_data[CMainFrame.g_pMainDoc.GetCurrentLevel()][CMainDoc.GetCurrentRound()][10];
            m_cBeginState = CViewGameFDP.UseImg_fdp_data[CMainFrame.g_pMainDoc.GetCurrentLevel()][CMainDoc.GetCurrentRound()][11];
            m_dwGenIceCnt = CViewGameFDP.UseImg_fdp_data[CMainFrame.g_pMainDoc.GetCurrentLevel()][CMainDoc.GetCurrentRound()][12];
            m_dwHardness = CViewGameFDP.UseImg_fdp_data[CMainFrame.g_pMainDoc.GetCurrentLevel()][CMainDoc.GetCurrentRound()][13];
        }
        if (m_cBeginState > 0) {
            CObstacleIce.GenerateIce(m_cBeginState, true);
        }
        this.m_qwGameStartTick = this.GetCurrentTick();
    }

    static int GenerateIce(int nGenCnt, boolean bBeginState) {
        int nRealGenCnt = SWLDefine.MIN(9 - m_dwCurIceCnt, nGenCnt);
        for (int i = 0; i < nRealGenCnt; ++i) {
            int nGenSlotIdx;
            do {
                nGenSlotIdx = Yulib.RAND(0, 9);
            } while (CObstacleIce.m_stSlot[nGenSlotIdx].nState != 0);
            if (bBeginState) {
                CObstacleIce.m_stSlot[nGenSlotIdx].nState = 1;
                CObstacleIce.m_stSlot[nGenSlotIdx].nHealth = m_dwIceHealth;
                CObstacleIce.m_stSlot[nGenSlotIdx].nHardness = m_dwHardness;
            } else {
                CObstacleIce.m_stSlot[nGenSlotIdx].nState = 2;
                CObstacleIce.m_stSlot[nGenSlotIdx].nHealth = 0;
                CObstacleIce.m_stSlot[nGenSlotIdx].nHardness = m_dwHardness;
                CObstacleIce.m_stSlot[nGenSlotIdx].nMoveTickCnt = 0;
                CObstacleIce.m_stSlot[nGenSlotIdx].ptEnd.x = nGenSlotIdx % 3 * 80 + 40;
                CObstacleIce.m_stSlot[nGenSlotIdx].ptEnd.y = nGenSlotIdx / 3 * 87 + 43;
                CObstacleIce.m_stSlot[nGenSlotIdx].nYIntercept = CObstacleIce.m_stSlot[nGenSlotIdx].ptEnd.y - Yulib.GetSqrt1000(3) * CObstacleIce.m_stSlot[nGenSlotIdx].ptEnd.x / 1000;
                CObstacleIce.m_stSlot[nGenSlotIdx].ptStart.y = 0;
                CObstacleIce.m_stSlot[nGenSlotIdx].ptStart.x = (CObstacleIce.m_stSlot[nGenSlotIdx].ptStart.y - CObstacleIce.m_stSlot[nGenSlotIdx].nYIntercept) * 1000 / Yulib.GetSqrt1000(3);
                CObstacleIce.m_stSlot[nGenSlotIdx].ptCur = CObstacleIce.m_stSlot[nGenSlotIdx].ptStart;
            }
            if (!m_bFirstGen) continue;
        }
        if (m_bFirstGen) {
            m_bShowClick = true;
            m_bFirstGen = false;
        }
        return 9 - (m_dwCurIceCnt += nGenCnt);
    }

    void CutIce(int nSlotIdx) {
        if (CObstacleIce.m_stSlot[nSlotIdx].nState == 2 || CObstacleIce.m_stSlot[nSlotIdx].nState == 4 || CObstacleIce.m_stSlot[nSlotIdx].nHealth == 0) {
            return;
        }
        CObstacleIce.m_stSlot[nSlotIdx].nState = 1;
        CObstacleIce.m_stSlot[nSlotIdx].nGenTick = 0;
        CObstacleIce.m_stSlot[nSlotIdx].pAniCharic.Play(true);
        m_bShowClick = false;
        if (this.m_bCharic) {
            CObstacleIce.m_stSlot[nSlotIdx].nHealth = 0;
            MainCanvas.Vibrator(300);
        } else {
            --CObstacleIce.m_stSlot[nSlotIdx].nHealth;
            if (CObstacleIce.m_stSlot[nSlotIdx].nHealth <= 0) {
                MainCanvas.Vibrator(300);
            }
        }
    }

    int CrackIce(CSWLPoint ptPos) {
        int nIdx = (ptPos.y - 50) / 87 * 3 + (ptPos.x - 0) / 80;
        if (nIdx > 8) {
            return 0;
        }
        if (CObstacleIce.m_stSlot[nIdx].nHealth == 0) {
            return 0;
        }
        if (this.m_bCharic && CObstacleIce.m_stSlot[nIdx].nState != 1) {
            return 1;
        }
        if (CObstacleIce.m_stSlot[nIdx].nHealth > 0) {
            CObstacleIce.m_stSlot[nIdx].nState = 5;
            if (!this.m_bCharic) {
                --CObstacleIce.m_stSlot[nIdx].nHardness;
                if (CObstacleIce.m_stSlot[nIdx].nHardness <= 0) {
                    --CObstacleIce.m_stSlot[nIdx].nHealth;
                    CObstacleIce.m_stSlot[nIdx].nHardness = m_dwHardness;
                }
            }
            if (m_bShowClick) {
                m_bShowClick = false;
            }
            if (this.m_bCharic) {
                MainCanvas.Vibrator(300);
            } else if (CObstacleIce.m_stSlot[nIdx].nHealth == 0) {
                MainCanvas.Vibrator(300);
            }
            return 1;
        }
        return 0;
    }

    int OnSWLKeyUp(STSWLEventKey stEvent) {
        switch (stEvent.key) {
            case -5: {
                CSWLPoint ptCursorPos = new CSWLPoint();
                ptCursorPos = this.m_lpGameView.GetPointer().GetPos(ptCursorPos);
                return this.CrackIce(ptCursorPos);
            }
            case 49: {
                this.CutIce(0);
                break;
            }
            case 50: {
                this.CutIce(1);
                break;
            }
            case 51: {
                this.CutIce(2);
                break;
            }
            case 52: {
                this.CutIce(3);
                break;
            }
            case 53: {
                this.CutIce(4);
                break;
            }
            case 54: {
                this.CutIce(5);
                break;
            }
            case 55: {
                this.CutIce(6);
                break;
            }
            case 56: {
                this.CutIce(7);
                break;
            }
            case 57: {
                this.CutIce(8);
            }
        }
        return 0;
    }

    int TouchClick(STSWLEventTouch stEvent) {
        if (m_bCrackTouch) {
            m_bCrackTouch = false;
            return 1;
        }
        return 0;
    }

    int OnSWLTouchDown(STSWLEventTouch stEvent) {
        CSWLPoint ptTouch = new CSWLPoint();
        ptTouch.x = stEvent.x;
        ptTouch.y = stEvent.y;
        if (this.CrackIce(ptTouch) > 0) {
            m_bCrackTouch = true;
            return 1;
        }
        return 0;
    }

    int OnSWLTouchDrag(STSWLEventTouch stEvent) {
        return 0;
    }

    int Process() {
        long qwCurTick = this.GetCurrentTick();
        switch (m_dwObstacleState) {
            case 0: {
                if ((int)(qwCurTick - this.m_qwGameStartTick) <= m_dwFirstGenElapse || 9 == m_dwCurIceCnt) break;
                m_dwObstacleState = 2;
                break;
            }
            case 1: {
                if ((int)(qwCurTick - this.m_qwGameStartTick) <= m_dwReGenElapse || 9 == m_dwCurIceCnt) break;
                m_dwObstacleState = 2;
                break;
            }
            case 2: {
                CObstacleIce.GenerateIce(m_dwGenIceCnt, false);
                this.m_qwGameStartTick = this.GetCurrentTick();
                m_dwObstacleState = 1;
            }
        }
        block22: for (int i = 0; i < 9; ++i) {
            switch (CObstacleIce.m_stSlot[i].nState) {
                case 2: {
                    CObstacleIce.m_stSlot[i].ptCur.y += 20;
                    CObstacleIce.m_stSlot[i].ptCur.x = (CObstacleIce.m_stSlot[i].ptCur.y - CObstacleIce.m_stSlot[i].nYIntercept) * 1000 / Yulib.GetSqrt1000(3);
                    if (Math.abs(CObstacleIce.m_stSlot[i].ptEnd.x - CObstacleIce.m_stSlot[i].ptCur.x) > 10 || Math.abs(CObstacleIce.m_stSlot[i].ptEnd.y - CObstacleIce.m_stSlot[i].ptCur.y) > 10) continue block22;
                    CObstacleIce.m_stSlot[i].nState = 3;
                    CObstacleIce.m_stSlot[i].nGenAlpha = 0;
                    CObstacleIce.m_stSlot[i].nGenTick = 0;
                    CObstacleIce.m_stSlot[i].nHealth = m_dwIceHealth;
                    continue block22;
                }
                case 3: {
                    ++CObstacleIce.m_stSlot[i].nGenTick;
                    if (CObstacleIce.m_stSlot[i].nGenTick % 2 == 0) {
                        CObstacleIce.m_stSlot[i].nGenAlpha += 8;
                    }
                    if (CObstacleIce.m_stSlot[i].nGenAlpha != 32) continue block22;
                    CObstacleIce.m_stSlot[i].nState = 1;
                    continue block22;
                }
                case 5: {
                    if (!this.m_bCharic) {
                        CObstacleIce.m_stSlot[i].pAniCrack.Play(false);
                    }
                    CObstacleIce.m_stSlot[i].nState = 6;
                    CObstacleIce.m_stSlot[i].nGenAlpha = 32;
                    if (!this.m_bCharic) continue block22;
                    CObstacleIce.m_stSlot[i].pAniCharic.Play(false);
                    continue block22;
                }
                case 6: {
                    if (this.m_bCharic) {
                        if (CObstacleIce.m_stSlot[i].pAniCharic.Process() == 0) {
                            CObstacleIce.m_stSlot[i].nState = 7;
                        }
                        if (CObstacleIce.m_stSlot[i].pAniCharic.GetCurrentFrmIdx() == 1) {
                            CObstacleIce.m_stSlot[i].pAniCrack.Play(false);
                            CObstacleIce.m_stSlot[i].nHealth = m_dwIceHealth - 1;
                        } else if (CObstacleIce.m_stSlot[i].pAniCharic.GetCurrentFrmIdx() == 3) {
                            CObstacleIce.m_stSlot[i].nGenAlpha = 16;
                        } else if (CObstacleIce.m_stSlot[i].pAniCharic.GetCurrentFrmIdx() == 4) {
                            CObstacleIce.m_stSlot[i].nGenAlpha = 8;
                        }
                        if (CObstacleIce.m_stSlot[i].pAniCrack.Process() != 0) continue block22;
                        CObstacleIce.m_stSlot[i].pAniCrack.Show(false);
                        continue block22;
                    }
                    if (CObstacleIce.m_stSlot[i].pAniCrack.Process() == 0) {
                        CObstacleIce.m_stSlot[i].nState = 7;
                        continue block22;
                    }
                    switch (CObstacleIce.m_stSlot[i].pAniCrack.GetCurrentFrmIdx()) {
                        case 0: {
                            CObstacleIce.m_stSlot[i].nGenAlpha = 24;
                            break;
                        }
                        case 1: {
                            CObstacleIce.m_stSlot[i].nGenAlpha = 16;
                            break;
                        }
                        case 2: {
                            CObstacleIce.m_stSlot[i].nGenAlpha = 8;
                            break;
                        }
                        default: {
                            CObstacleIce.m_stSlot[i].nGenAlpha = 0;
                        }
                    }
                    if (CObstacleIce.m_stSlot[i].pAniCrack.GetCurrentFrmIdx() > CObstacleIce.m_stSlot[i].pAniCrack.GetFrameCount() - 2) continue block22;
                    CObstacleIce.m_stSlot[i].nState = 7;
                    continue block22;
                }
                case 7: {
                    CSWLPoint ptPos;
                    if (this.m_bCharic) {
                        CObstacleIce.m_stSlot[i].nHealth = 0;
                        CObstacleIce.m_stSlot[i].nState = 0;
                        --m_dwCurIceCnt;
                        ptPos = new CSWLPoint(i % 3 * 80 + 40, i / 3 * 87 + 43);
                        this.GenerateGiftBox(ptPos);
                    } else if (CObstacleIce.m_stSlot[i].pAniCrack.Process() == 0) {
                        if (CObstacleIce.m_stSlot[i].nHealth == 0) {
                            CObstacleIce.m_stSlot[i].nState = 0;
                            --m_dwCurIceCnt;
                            ptPos = new CSWLPoint(i % 3 * 80 + 40, i / 3 * 87 + 43);
                            this.GenerateGiftBox(ptPos);
                        } else {
                            CObstacleIce.m_stSlot[i].nState = 1;
                        }
                    } else {
                        switch (CObstacleIce.m_stSlot[i].pAniCrack.GetCurrentFrmIdx()) {
                            case 0: {
                                CObstacleIce.m_stSlot[i].nGenAlpha = 24;
                                break;
                            }
                            case 1: {
                                CObstacleIce.m_stSlot[i].nGenAlpha = 16;
                                break;
                            }
                            case 2: {
                                CObstacleIce.m_stSlot[i].nGenAlpha = 8;
                                break;
                            }
                            default: {
                                CObstacleIce.m_stSlot[i].nGenAlpha = 0;
                            }
                        }
                    }
                    if (CObstacleIce.m_stSlot[i].nHealth != 0) continue block22;
                    ++m_nCrackCnt;
                }
            }
        }
        return 0;
    }

    void Draw(int x, int y) {
        int i;
        for (i = 0; i < 9; ++i) {
            if ((CObstacleIce.m_stSlot[i].nState == 6 || CObstacleIce.m_stSlot[i].nState == 7) && CObstacleIce.m_stSlot[i].nHealth > 1) {
                Yulib.m_g.drawImage(this.m_pImgIce[CObstacleIce.m_stSlot[i].nHealth - 2], x + i % 3 * 80, y + i / 3 * 87, 0);
            }
            if (CObstacleIce.m_stSlot[i].nHealth <= 0) continue;
            Yulib.m_g.drawImage(this.m_pImgIce[CObstacleIce.m_stSlot[i].nHealth - 1], x + i % 3 * 80, y + i / 3 * 87, 0);
            int nWidth = this.m_pNumber.getWidth() / 10;
            Yulib.m_g.drawRegion(this.m_pNumber, (i + 1) % 10 * nWidth, 0, nWidth, this.m_pNumber.getHeight(), 0, x + i % 3 * 80 + 32, y + i / 3 * 87 + 37, 0);
        }
        block6: for (i = 0; i < 9; ++i) {
            switch (CObstacleIce.m_stSlot[i].nState) {
                case 2: {
                    int nOffX = this.m_pImgIceBall.getWidth() >> 1;
                    int nOffY = this.m_pImgIceBall.getHeight() >> 1;
                    Yulib.m_g.drawImage(this.m_pImgIceBall, x + CObstacleIce.m_stSlot[i].ptCur.x - nOffX, y + CObstacleIce.m_stSlot[i].ptCur.y - nOffY, 0);
                    continue block6;
                }
                case 3: {
                    int nOffX = this.m_pImgIceBall.getWidth() >> 1;
                    int nOffY = this.m_pImgIceBall.getHeight() >> 1;
                    Yulib.m_g.drawImage(this.m_pImgIceBall, x + CObstacleIce.m_stSlot[i].ptCur.x - nOffX, y + CObstacleIce.m_stSlot[i].ptCur.y - nOffY, 0);
                    continue block6;
                }
                case 6: 
                case 7: {
                    CObstacleIce.m_stSlot[i].pAniCrack.Draw(x + i % 3 * 80 - 10, y + i / 3 * 87 - 20);
                    if (!this.m_bCharic) continue block6;
                    CObstacleIce.m_stSlot[i].pAniCharic.Draw(x + i % 3 * 80, y + i / 3 * 87 - 48);
                }
            }
        }
        if (m_bShowClick) {
            for (i = 0; i < 9; ++i) {
                if (CObstacleIce.m_stSlot[i].nHealth <= 0) continue;
                this.DrawTouchUp(x + i % 3 * 80, y + i / 3 * 87 - 20, 0);
                break;
            }
        }
    }

    static {
        m_stSlot = new STSlot[9];
        m_bFirstGen = true;
        m_dwIceHealth = 3;
    }

    class STSlot {
        int nState;
        int nHealth;
        int nHardness;
        CSWLPoint ptStart = new CSWLPoint();
        CSWLPoint ptEnd = new CSWLPoint();
        CSWLPoint ptCur = new CSWLPoint();
        int nMoveTickCnt;
        int nGenTick;
        int nGenAlpha;
        int nYIntercept;
        CSWLAni pAniCrack;
        CSWLAni pAniCharic;

        STSlot() {
        }
    }
}

