/*
 * Decompiled with CFR 0.152.
 */
class CSWLAni {
    public static final int SWL_ANI_STATE_STOP = 0;
    public static final int SWL_ANI_STATE_PLAY = 1;
    public static final int SWL_ANI_STATE_PAUSE = 2;
    public static final int SWL_ANI_STATE_PLAY_REPEAT = 3;
    public static final int MAX_SWL_ANI_STATE = 4;
    static final int LOAD_ANI_STATE_ANI = 0;
    static final int LOAD_ANI_STATE_ANI_OPT = 1;
    static final int LOAD_ANI_STATE_ANI_OPT_CHNGCLR = 2;
    static final int LOAD_ANI_STATE_FRM = 3;
    static final int LOAD_ANI_STATE_FRM_OPT = 4;
    static final int LOAD_ANI_STATE_FRM_OPT_CHNGCLR = 5;
    static final int LOAD_ANI_STATE_IMG = 6;
    static final int LOAD_ANI_STATE_IMG_OPT = 7;
    static final int LOAD_ANI_STATE_IMG_OPT_CHNGCLR = 8;
    static final int MAX_LOAD_ANI_STATE = 9;
    int m_eLoadAniState = 0;
    STSWLAni m_stAni = new STSWLAni();
    int m_nCurFrmIdx;
    CSWLAniFrm[] m_ppAniFrm;
    int m_eState = 0;
    boolean m_bAdvanceFrame;
    boolean m_bRepeat;
    boolean m_bShow;
    CSWLClock m_lpClock;
    long m_qwStartAniTick;
    long m_qwFrmStartTick;
    CSWLImgOpt m_imgOptOpt;
    STSWLAniFrm m_stLoadAniFrm;
    STSWLAniImg m_stLoadAniImg;
    int m_nLoadFrmCnt;
    int m_nLoadImgCnt;
    CSWLImgOpt m_imgOpt = new CSWLImgOpt();
    STImgOptChngClrOne[] m_pChngClrOne;
    int m_nCurImgOptCnt;
    int m_nLoadImgOptCnt;
    int m_nCurChngClrCnt;
    int m_nLoadChngClrCnt;
    static final String KEY_ANI_DATA = "ani_data";
    static final String KEY_FRM_DATA = "frm_data";
    static final String KEY_IMG_DATA = "img_data";
    static final String KEY_IMG_OPT = "img_opt";
    static final String KEY_IMG_OPT_CHNG_CLR = "chng_clr";

    void SetClock(CSWLClock lpClock) {
        this.m_lpClock = lpClock;
    }

    boolean IsShow() {
        return this.m_bShow;
    }

    int GetFrameCount() {
        return this.m_stAni.cFrmCnt;
    }

    int GetCurrentFrmIdx() {
        return this.m_nCurFrmIdx;
    }

    public CSWLAni() {
        this.m_stLoadAniImg = new STSWLAniImg();
        this.m_stLoadAniFrm = new STSWLAniFrm();
        this.m_imgOptOpt = new CSWLImgOpt();
    }

    void DestoryCSWLAni() {
        for (int i = 0; i < this.m_stAni.cFrmCnt; ++i) {
            this.m_ppAniFrm[i] = null;
        }
        this.m_ppAniFrm = null;
    }

    int LoadAni(String lpAniName, boolean bRes, CSWLImgOpt lpAniOpt) {
        if (lpAniName == null) {
            return -1;
        }
        if (lpAniOpt != null) {
            this.m_imgOptOpt = lpAniOpt;
        }
        if (bRes) {
            return this.LoadFromRes(lpAniName);
        }
        return this.LoadFromFile(lpAniName);
    }

    int LoadFromRes(String lpAniName) {
        if (lpAniName == null) {
            return -1;
        }
        int dwResSize = 0;
        String lpRes = Yulib.LoadWipiRes(lpAniName, dwResSize);
        if (lpRes == null) {
            return -1;
        }
        CSWLStringList strList = new CSWLStringList(lpRes, lpRes.length());
        int nListCnt = strList.GetListCount();
        CSWLToken tknList = new CSWLToken();
        int nTokenCnt = 0;
        int nRet = 0;
        TOKEN first_tok = null;
        TOKEN tok = null;
        String szKey = "";
        String szLine = "";
        for (int i = 0; i < nListCnt; ++i) {
            int j;
            szLine = strList.GetLine(i, szLine, 4096);
            char[] szLine1 = new char[szLine.length()];
            char[] szLine2 = new char["=, ".length()];
            for (j = 0; j < szLine.length(); ++j) {
                szLine1[j] = szLine.charAt(j);
            }
            for (j = 0; j < "=, ".length(); ++j) {
                szLine2[j] = "=, ".charAt(j);
            }
            nRet = tknList.TokenList(szLine1, nTokenCnt, szLine2);
            if (nRet < 0) {
                tknList.TokenFree(tknList.m_tok);
                continue;
            }
            if (CSWLToken.itok1 < 2) {
                tknList.TokenFree(tknList.m_tok);
                continue;
            }
            tok = first_tok = tknList.m_tok;
            szKey = szLine;
            tok = tok.Next;
            if (szKey.length() >= 2 && szKey.substring(0, 2).compareTo("//") == 0) {
                tknList.TokenFree(first_tok);
                continue;
            }
            if (szKey.length() >= 8 && szKey.substring(0, 8).compareTo(KEY_ANI_DATA) == 0) {
                this.LoadAniData(szKey);
            } else if (szKey.length() >= 8 && szKey.substring(0, 8).compareTo(KEY_FRM_DATA) == 0) {
                this.LoadFrmData(szKey);
            } else if (szKey.length() >= 8 && szKey.substring(0, 8).compareTo(KEY_IMG_DATA) == 0) {
                this.LoadImgData(szKey);
            } else if (szKey.length() >= 7 && szKey.substring(0, 7).compareTo(KEY_IMG_OPT) == 0) {
                this.LoadImgOpt(szKey);
            } else if (szKey.length() >= 8 && szKey.substring(0, 8).compareTo(KEY_IMG_OPT_CHNG_CLR) == 0) {
                this.LoadImgOptChngClr(szKey);
            }
            tknList.TokenFree(first_tok);
        }
        lpRes = null;
        return 0;
    }

    int LoadFromFile(String lpAniName) {
        return 0;
    }

    void LoadAniData(String szKey) {
        CSWLStrUtil.next = 0;
        this.m_eLoadAniState = 0;
        this.m_stAni.cWidth = CSWLStrUtil.AtoI1(0, szKey);
        this.m_stAni.cHeight = CSWLStrUtil.AtoI1(1, szKey);
        this.m_stAni.cFrmCnt = CSWLStrUtil.AtoI1(2, szKey);
        this.m_stAni.cAniOptCnt = CSWLStrUtil.AtoI1(3, szKey);
        this.m_ppAniFrm = new CSWLAniFrm[this.m_stAni.cFrmCnt];
        for (int i = 0; i < this.m_stAni.cFrmCnt; ++i) {
            this.m_ppAniFrm[i] = new CSWLAniFrm();
        }
        this.m_nLoadFrmCnt = 0;
        if (this.m_nCurImgOptCnt > 0) {
            this.m_imgOpt.Clear();
            this.m_nLoadImgOptCnt = 0;
        }
    }

    void LoadFrmData(String szKey) {
        CSWLStrUtil.next = 0;
        this.m_eLoadAniState = 3;
        this.m_stLoadAniFrm.wElapse = CSWLStrUtil.AtoI1(0, szKey);
        this.m_stLoadAniFrm.sDatumX = CSWLStrUtil.AtoI1(1, szKey);
        this.m_stLoadAniFrm.sDatumY = CSWLStrUtil.AtoI1(2, szKey);
        this.m_stLoadAniFrm.cImgCnt = CSWLStrUtil.AtoI1(3, szKey);
        this.m_stLoadAniFrm.cFrmOptCnt = CSWLStrUtil.AtoI1(4, szKey);
        this.m_nLoadImgCnt = 0;
        this.m_nCurImgOptCnt = this.m_stLoadAniFrm.cFrmOptCnt;
        if (this.m_nCurImgOptCnt > 0) {
            this.m_imgOpt.Clear();
            this.m_nLoadImgOptCnt = 0;
        } else {
            if (this.m_imgOptOpt.IsExistOpt() && !this.m_ppAniFrm[this.m_nLoadFrmCnt].IsExistAniOpt()) {
                this.m_ppAniFrm[this.m_nLoadFrmCnt].SetAniData(this.m_imgOptOpt);
            }
            this.m_ppAniFrm[this.m_nLoadFrmCnt].SetFrmData(this.m_stLoadAniFrm, null);
        }
    }

    void LoadImgData(String szKey) {
        CSWLStrUtil.next = 0;
        this.m_eLoadAniState = 6;
        this.m_stLoadAniImg.cImgOptCnt = CSWLStrUtil.AtoI1(1, szKey);
        for (int i = 11; i < szKey.length(); ++i) {
            if (szKey.charAt(i) != ',') continue;
            this.m_stLoadAniImg.szImgFileName = szKey.substring(11, CSWLStrUtil.next);
        }
        this.m_stLoadAniImg.sDrawX = CSWLStrUtil.AtoI1(2, szKey);
        this.m_stLoadAniImg.sDrawY = CSWLStrUtil.AtoI1(3, szKey);
        this.m_nCurImgOptCnt = this.m_stLoadAniImg.cImgOptCnt;
        if (this.m_nCurImgOptCnt > 0) {
            this.m_imgOpt.Clear();
            this.m_nLoadImgOptCnt = 0;
        } else {
            if (this.m_imgOptOpt.IsExistOpt() && !this.m_ppAniFrm[this.m_nLoadFrmCnt].IsExistAniOpt() && !this.m_ppAniFrm[this.m_nLoadFrmCnt].IsExistFrmOpt()) {
                this.m_ppAniFrm[this.m_nLoadFrmCnt].SetAniData(this.m_imgOptOpt);
            }
            this.m_ppAniFrm[this.m_nLoadFrmCnt].SetImgData(this.m_stLoadAniImg, null);
            ++this.m_nLoadImgCnt;
            if (this.m_stLoadAniFrm.cImgCnt == this.m_nLoadImgCnt) {
                ++this.m_nLoadFrmCnt;
            }
        }
    }

    void LoadImgOpt(String szKey) {
        CSWLStrUtil.next = 0;
        switch (this.m_eLoadAniState) {
            case 0: {
                this.m_eLoadAniState = 1;
                break;
            }
            case 3: {
                this.m_eLoadAniState = 4;
                break;
            }
            case 6: {
                this.m_eLoadAniState = 7;
            }
        }
        int nImgOptKind = CSWLStrUtil.AtoI1(0, szKey);
        switch (nImgOptKind) {
            case 2: {
                this.m_nCurChngClrCnt = CSWLStrUtil.AtoI1(1, szKey);
                this.m_pChngClrOne = new STImgOptChngClrOne[this.m_nCurChngClrCnt];
                for (int i = 0; i < this.m_nCurChngClrCnt; ++i) {
                    this.m_pChngClrOne[i] = new STImgOptChngClrOne();
                }
                this.m_nLoadChngClrCnt = 0;
                break;
            }
            case 4: {
                char nCalR = (char)CSWLStrUtil.AtoI1(2, szKey);
                char nCalG = (char)CSWLStrUtil.AtoI1(3, szKey);
                char nCalB = (char)CSWLStrUtil.AtoI1(4, szKey);
                this.m_imgOpt.SetCalClr(nCalR, nCalG, nCalB);
                break;
            }
            case 8: {
                this.m_imgOpt.Mirror();
                break;
            }
            case 16: {
                int nDegree = CSWLStrUtil.AtoI1(5, szKey);
                this.m_imgOpt.Rotate(nDegree);
                break;
            }
            case 32: {
                int nScale = CSWLStrUtil.AtoI1(6, szKey);
                this.m_imgOpt.Scaling(nScale);
                break;
            }
            case 64: {
                int nFXKind = CSWLStrUtil.AtoI1(7, szKey);
                int nAlpha = 0;
                switch (nFXKind) {
                    case 1: {
                        nAlpha = CSWLStrUtil.AtoI1(8, szKey);
                    }
                }
            }
        }
        if (nImgOptKind != 2) {
            ++this.m_nLoadImgOptCnt;
            if (this.m_nCurImgOptCnt == this.m_nLoadImgOptCnt) {
                switch (this.m_eLoadAniState) {
                    case 1: {
                        if (this.m_imgOptOpt.IsExistOpt()) {
                            this.m_imgOpt = this.m_imgOptOpt.operatorAddEqual(this.m_imgOptOpt);
                        }
                        this.m_ppAniFrm[this.m_nLoadFrmCnt].SetAniData(this.m_imgOpt);
                        break;
                    }
                    case 4: {
                        if (this.m_imgOptOpt.IsExistOpt() && !this.m_ppAniFrm[this.m_nLoadFrmCnt].IsExistAniOpt()) {
                            this.m_ppAniFrm[this.m_nLoadFrmCnt].SetAniData(this.m_imgOptOpt);
                        }
                        this.m_ppAniFrm[this.m_nLoadFrmCnt].SetFrmData(this.m_stLoadAniFrm, this.m_imgOpt);
                        break;
                    }
                    case 7: {
                        if (this.m_imgOptOpt.IsExistOpt() && !this.m_ppAniFrm[this.m_nLoadFrmCnt].IsExistAniOpt() && !this.m_ppAniFrm[this.m_nLoadFrmCnt].IsExistFrmOpt()) {
                            this.m_ppAniFrm[this.m_nLoadFrmCnt].SetAniData(this.m_imgOptOpt);
                        }
                        this.m_ppAniFrm[this.m_nLoadFrmCnt].SetImgData(this.m_stLoadAniImg, this.m_imgOpt);
                        ++this.m_nLoadImgCnt;
                        if (this.m_stLoadAniFrm.cImgCnt != this.m_nLoadImgCnt) break;
                        ++this.m_nLoadFrmCnt;
                    }
                }
            }
        }
    }

    void LoadImgOptChngClr(String szKey) {
        switch (this.m_eLoadAniState) {
            case 1: {
                this.m_eLoadAniState = 2;
                break;
            }
            case 4: {
                this.m_eLoadAniState = 5;
                break;
            }
            case 7: {
                this.m_eLoadAniState = 8;
            }
        }
        int nSrcR = CSWLStrUtil.AtoI1(0, szKey);
        int nSrcG = CSWLStrUtil.AtoI1(1, szKey);
        int nSrcB = CSWLStrUtil.AtoI1(2, szKey);
        int nDestR = CSWLStrUtil.AtoI1(3, szKey);
        int nDestG = CSWLStrUtil.AtoI1(4, szKey);
        int nDestB = CSWLStrUtil.AtoI1(5, szKey);
        this.m_pChngClrOne[this.m_nLoadChngClrCnt].cSrcRed = (byte)nSrcR;
        this.m_pChngClrOne[this.m_nLoadChngClrCnt].cSrcGreen = (byte)nSrcG;
        this.m_pChngClrOne[this.m_nLoadChngClrCnt].cSrcBlue = (byte)nSrcB;
        this.m_pChngClrOne[this.m_nLoadChngClrCnt].cDestRed = (byte)nDestR;
        this.m_pChngClrOne[this.m_nLoadChngClrCnt].cDestGreen = (byte)nDestG;
        this.m_pChngClrOne[this.m_nLoadChngClrCnt].cDestBlue = (byte)nDestB;
        ++this.m_nLoadChngClrCnt;
        if (this.m_nCurChngClrCnt == this.m_nLoadChngClrCnt) {
            this.m_imgOpt.SetChngClr(this.m_nCurChngClrCnt, this.m_pChngClrOne);
            this.m_pChngClrOne = null;
            ++this.m_nLoadImgOptCnt;
            if (this.m_nCurImgOptCnt == this.m_nLoadImgOptCnt) {
                switch (this.m_eLoadAniState) {
                    case 2: {
                        if (this.m_imgOptOpt.IsExistOpt()) {
                            this.m_imgOpt = this.m_imgOptOpt.operatorAddEqual(this.m_imgOptOpt);
                        }
                        this.m_ppAniFrm[this.m_nLoadFrmCnt].SetAniData(this.m_imgOpt);
                        break;
                    }
                    case 5: {
                        if (this.m_imgOptOpt.IsExistOpt() && !this.m_ppAniFrm[this.m_nLoadFrmCnt].IsExistAniOpt()) {
                            this.m_ppAniFrm[this.m_nLoadFrmCnt].SetAniData(this.m_imgOptOpt);
                        }
                        this.m_ppAniFrm[this.m_nLoadFrmCnt].SetFrmData(this.m_stLoadAniFrm, this.m_imgOpt);
                        break;
                    }
                    case 8: {
                        if (this.m_imgOptOpt.IsExistOpt() && !this.m_ppAniFrm[this.m_nLoadFrmCnt].IsExistAniOpt() && !this.m_ppAniFrm[this.m_nLoadFrmCnt].IsExistFrmOpt()) {
                            this.m_ppAniFrm[this.m_nLoadFrmCnt].SetAniData(this.m_imgOptOpt);
                        }
                        this.m_ppAniFrm[this.m_nLoadFrmCnt].SetImgData(this.m_stLoadAniImg, this.m_imgOpt);
                        ++this.m_nLoadImgCnt;
                        if (this.m_stLoadAniFrm.cImgCnt != this.m_nLoadImgCnt) break;
                        ++this.m_nLoadFrmCnt;
                    }
                }
            }
        }
    }

    void GetAniSize(CSWLSize siAni) {
        siAni.SetSize(this.m_stAni.cWidth, this.m_stAni.cHeight);
    }

    int GetCurFrmWidth() {
        return this.m_stAni.cWidth;
    }

    int GetCurFrmHeight() {
        return this.m_stAni.cHeight;
    }

    int GetCurFrmDatum(CSWLPoint ptDatum) {
        if (this.m_ppAniFrm == null || this.m_ppAniFrm[this.m_nCurFrmIdx] == null) {
            return 0;
        }
        return this.m_ppAniFrm[this.m_nCurFrmIdx].GetDatum(ptDatum);
    }

    int GetPixelColor16(CSWLPoint ptPixel) {
        if (this.m_ppAniFrm == null || this.m_ppAniFrm[this.m_nCurFrmIdx] == null) {
            return 0;
        }
        return this.m_ppAniFrm[this.m_nCurFrmIdx].GetPixelColor16(ptPixel);
    }

    int GetPixelColor(CSWLPoint ptPixel) {
        if (this.m_ppAniFrm == null || this.m_ppAniFrm[this.m_nCurFrmIdx] == null) {
            return 0;
        }
        return this.m_ppAniFrm[this.m_nCurFrmIdx].GetPixelColor(ptPixel);
    }

    boolean HitTest(CSWLPoint ptTest) {
        if (this.m_ppAniFrm == null || this.m_ppAniFrm[this.m_nCurFrmIdx] == null) {
            return false;
        }
        return this.m_ppAniFrm[this.m_nCurFrmIdx].HitTest(ptTest);
    }

    void Play(boolean bRepeat) {
        this.m_bShow = true;
        this.m_nCurFrmIdx = 0;
        this.m_qwFrmStartTick = System.currentTimeMillis();
        this.m_eState = 1;
        this.m_bRepeat = bRepeat;
        this.m_bAdvanceFrame = true;
        this.m_qwStartAniTick = System.currentTimeMillis();
    }

    void Stop() {
        this.m_eState = 0;
        this.m_bAdvanceFrame = false;
    }

    void Pause() {
        this.m_eState = 2;
        this.m_bAdvanceFrame = false;
    }

    void Resume() {
        this.m_eState = 1;
        this.m_bAdvanceFrame = true;
    }

    boolean IsPlay() {
        return this.m_eState == 1 || this.m_eState == 3;
    }

    void Show(boolean bShow) {
        this.m_bShow = bShow;
    }

    int Process() {
        if (!this.m_bAdvanceFrame) {
            return 0;
        }
        long qwCurTick = System.currentTimeMillis();
        long qwTotalAniElapse = 0L;
        long qwElapse = qwCurTick - this.m_qwStartAniTick;
        int nCurFrmIdx = -1;
        switch (this.m_eState) {
            case 1: {
                qwTotalAniElapse = this.GetTotalAniElapse();
                if (qwElapse != 0L && this.m_bRepeat && qwElapse >= qwTotalAniElapse) {
                    qwElapse = qwTotalAniElapse % qwElapse;
                }
                if ((nCurFrmIdx = this.CalCurFrmIdx(qwElapse)) < 0) {
                    this.m_nCurFrmIdx = this.m_stAni.cFrmCnt - 1;
                    this.Stop();
                    return 0;
                }
                int nRet = this.m_bRepeat && this.m_nCurFrmIdx != nCurFrmIdx && this.m_nCurFrmIdx == 0 ? 3 : 1;
                this.m_nCurFrmIdx = nCurFrmIdx;
                return nRet;
            }
        }
        return 0;
    }

    int GetTotalAniElapse() {
        int dwTempElapse = 0;
        for (int i = 0; i < this.m_stAni.cFrmCnt; ++i) {
            dwTempElapse += this.m_ppAniFrm[i].GetElapse();
        }
        return dwTempElapse;
    }

    int CalCurFrmIdx(long qwElapse) {
        long qwTempElapse = 0L;
        for (int i = 0; i < this.m_stAni.cFrmCnt; ++i) {
            if ((qwTempElapse += (long)this.m_ppAniFrm[i].GetElapse()) <= qwElapse) continue;
            return i;
        }
        return -1;
    }

    void Draw(int x, int y) {
        if (!this.m_bShow) {
            return;
        }
        this.m_ppAniFrm[this.m_nCurFrmIdx].Draw(x, y);
    }

    void SetDrawOptChngClr(int nCnt, STImgOptChngClrOne[] lpData) {
        this.m_ppAniFrm[this.m_nCurFrmIdx].SetDrawOptChngClr(nCnt, lpData);
    }

    void ResetDrawOptChngClr() {
        this.m_ppAniFrm[this.m_nCurFrmIdx].ResetDrawOptChngClr();
    }

    void SetDrawOptAlpha(byte cAlpha) {
        this.m_ppAniFrm[this.m_nCurFrmIdx].SetDrawOptAlpha(cAlpha);
    }

    void ResetDrawOptAlpha() {
        this.m_ppAniFrm[this.m_nCurFrmIdx].ResetDrawOptAlpha();
    }
}

