/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import javax.microedition.rms.RecordStore;

class CSWLFile {
    static final int OPEN_NEW = 0;
    static final int OPEN_MODIFY = 1;
    static final int OPEN_READ = 2;
    static final int FP_BEGIN = 0;
    static final int FP_CURRENT = 1;
    static final int FP_END = 2;
    int m_hFile = 0;
    static String m_szFileName = "";
    String m_szError = "";
    int m_nReadLineCnt;
    CSWLList m_pReadLineList = null;
    int m_nCurLineIdx;
    int m_nOpenCnt = 0;

    String ExtractFilePath(String lpFullFileName, String lpBuf) {
        if (lpFullFileName == null || lpBuf == null) {
            return null;
        }
        lpBuf = lpFullFileName;
        int len = lpFullFileName.length();
        char[] p = new char[len + 1];
        for (int i = len - 1; i >= 0; --i) {
            p[i] = lpFullFileName.charAt(i);
            if (p[i] != '\\' && p[i] != '/') continue;
            p[i] = '\u0000';
            return lpBuf;
        }
        return null;
    }

    String ExtractFileName(String lpFullFileName) {
        if (lpFullFileName == null) {
            return null;
        }
        int len = lpFullFileName.length();
        for (int i = len - 1; i >= 0; --i) {
            if (lpFullFileName.charAt(i) != '\\' && lpFullFileName.charAt(i) != '/') continue;
            return lpFullFileName.substring(i + 1);
        }
        return lpFullFileName;
    }

    String GetExtPtr(String lpFullFileName) {
        int len = lpFullFileName.length();
        char[] p = new char[len + 1];
        for (int i = len - 1; i > len - 8; --i) {
            p[i] = lpFullFileName.charAt(i);
            if (p[i] == '.') {
                return lpFullFileName.substring(i + 1);
            }
            if (p[i] != '\\' && p[i] != '/') continue;
            return null;
        }
        return null;
    }

    boolean CreateDir(String lpPathName) {
        if (lpPathName == null) {
            return false;
        }
        String szPathName = "";
        szPathName = lpPathName;
        CSWLStrUtil.LowerString(szPathName);
        return true;
    }

    static boolean DeleteDir(String lpPathName) {
        if (lpPathName == null) {
            return false;
        }
        String szPathName = "";
        szPathName = lpPathName;
        CSWLStrUtil.LowerString(szPathName);
        return true;
    }

    boolean RenameDir(String lpOldPath, String lpNewPath) {
        if (lpOldPath == null || lpNewPath == null) {
            return false;
        }
        if (!CSWLFile.DeleteDir(lpOldPath)) {
            return false;
        }
        return this.CreateDir(lpNewPath);
    }

    static boolean IsExistFile(String lpPathName, String lpFileName, boolean bFindSubDir) {
        if (lpPathName == null || lpFileName == null) {
            return false;
        }
        String szPathName = "";
        szPathName = lpPathName;
        CSWLStrUtil.LowerString(szPathName);
        String szFileName = "";
        szPathName = lpPathName;
        CSWLStrUtil.LowerString(szFileName);
        String szFile = "";
        szFile = szPathName;
        szFile = szFile + "/";
        szFile = szFile + szFileName;
        return true;
    }

    static boolean RemoveFile(String lpFileName) {
        if (lpFileName == null) {
            return false;
        }
        String szFileName = "";
        szFileName = lpFileName;
        CSWLStrUtil.LowerString(szFileName);
        return true;
    }

    boolean RenameFile(String lpOldName, String lpNewName) {
        if (lpOldName == null || lpOldName == null) {
            return false;
        }
        String szOldFileName = "";
        szOldFileName = lpOldName;
        CSWLStrUtil.LowerString(szOldFileName);
        String szNewFileName = "";
        szNewFileName = lpNewName;
        CSWLStrUtil.LowerString(szNewFileName);
        return true;
    }

    int CopyFile(String lpSrcFile, String lpDestFile) {
        if (lpSrcFile == null || lpDestFile == null) {
            return -1;
        }
        String szSrcFileName = "";
        szSrcFileName = lpSrcFile;
        CSWLStrUtil.LowerString(szSrcFileName);
        String szDestFileName = "";
        szDestFileName = lpDestFile;
        CSWLStrUtil.LowerString(szDestFileName);
        if (szSrcFileName == szDestFileName) {
            return -1;
        }
        byte[] buf = null;
        try {
            ByteArrayInputStream bis = null;
            DataInputStream dis = null;
            RecordStore rs = RecordStore.openRecordStore((String)szSrcFileName, (boolean)true);
            if (rs.getNumRecords() > 0) {
                bis = new ByteArrayInputStream(rs.getRecord(1));
                dis = new DataInputStream(bis);
                buf = new byte[dis.available()];
                dis.read(buf, 0, dis.available());
                dis.close();
                bis.close();
                rs.closeRecordStore();
            }
        }
        catch (Exception ioe) {
            // empty catch block
        }
        RecordStore ws = null;
        try {
            ws = RecordStore.openRecordStore((String)szDestFileName, (boolean)true);
            if (ws.getNumRecords() > 0) {
                ws.setRecord(1, buf, 0, buf.length);
            } else {
                ws.addRecord(buf, 0, buf.length);
            }
            ws.closeRecordStore();
        }
        catch (Exception ioe) {
            // empty catch block
        }
        buf = null;
        return 0;
    }

    int GetFileSize(String lpFileName) {
        if (lpFileName == null) {
            return -1;
        }
        int m_FileSize = 0;
        String szFileName = "";
        szFileName = lpFileName;
        CSWLStrUtil.LowerString(szFileName);
        try {
            RecordStore rs = RecordStore.openRecordStore((String)szFileName, (boolean)true);
            m_FileSize = rs.getSize();
            int nRet = rs.getNumRecords();
            if (nRet > 0) {
                return 0;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return m_FileSize;
    }

    CSWLFile() {
    }

    void DestoryCSWLFile() {
        if (this.m_hFile <= 0) {
            this.CloseFile();
        }
    }

    boolean OpenFile(String lpFileName, int eMode, int nDir) {
        m_szFileName = lpFileName;
        CSWLStrUtil.LowerString(m_szFileName);
        try {
            ByteArrayInputStream bis = null;
            DataInputStream dis = null;
            RecordStore rs = RecordStore.openRecordStore((String)m_szFileName, (boolean)true);
            if (rs.getNumRecords() > 0) {
                bis = new ByteArrayInputStream(rs.getRecord(1));
                dis = new DataInputStream(bis);
                this.m_hFile = dis.available();
                dis.close();
                bis.close();
                rs.closeRecordStore();
            }
        }
        catch (Exception ioe) {
            System.out.println("OpenFile Error!");
        }
        if (this.m_hFile <= 0 || this.m_hFile == 129) {
            return false;
        }
        ++this.m_nOpenCnt;
        return true;
    }

    void CloseFile() {
        if (this.m_hFile <= 0) {
            return;
        }
        --this.m_nOpenCnt;
        this.m_hFile = 0;
    }

    boolean CheckValidation(String pData, int dwSize) {
        if (this.m_hFile <= 0) {
            return false;
        }
        if (pData == null) {
            return false;
        }
        return dwSize != 0;
    }

    byte[] ReadFile(String fileName) {
        byte[] buf = null;
        try {
            ByteArrayInputStream bis = null;
            DataInputStream dis = null;
            RecordStore rs = RecordStore.openRecordStore((String)fileName, (boolean)true);
            if (rs.getNumRecords() > 0) {
                bis = new ByteArrayInputStream(rs.getRecord(1));
                dis = new DataInputStream(bis);
                buf = new byte[dis.available()];
                dis.read(buf, 0, dis.available());
                dis.close();
                bis.close();
                rs.closeRecordStore();
            }
        }
        catch (Exception ioe) {
            System.out.println("Read File Error!");
        }
        return buf;
    }

    boolean ReadFile(String lpBuf, int dwSize) {
        byte[] buf = null;
        try {
            ByteArrayInputStream bis = null;
            DataInputStream dis = null;
            RecordStore rs = RecordStore.openRecordStore((String)m_szFileName, (boolean)true);
            if (rs.getNumRecords() > 0) {
                bis = new ByteArrayInputStream(rs.getRecord(1));
                dis = new DataInputStream(bis);
                buf = new byte[dis.available()];
                dis.read(buf, 0, dis.available());
                dis.close();
                bis.close();
                rs.closeRecordStore();
            }
        }
        catch (Exception ioe) {
            System.out.println("Read File Error!");
        }
        return true;
    }

    boolean WriteFile(String pData, String fileName, int dwSize) {
        try {
            RecordStore ws = RecordStore.openRecordStore((String)fileName, (boolean)true);
            byte[] pBuf = new byte[dwSize];
            for (int i = 0; i < dwSize; ++i) {
                pBuf[i] = (byte)pData.charAt(i);
            }
            if (ws.getNumRecords() > 0) {
                ws.setRecord(1, pBuf, 0, pBuf.length);
            } else {
                ws.addRecord(pBuf, 0, pBuf.length);
            }
            ws.closeRecordStore();
        }
        catch (Exception ioe) {
            System.out.println("Write File Error!");
        }
        return true;
    }

    boolean SetFilePointer(int eStart, int nOffset) {
        int nNewPos = 0;
        return nNewPos >= 0;
    }

    int GetFileSize() {
        int m_FileSize = 0;
        try {
            RecordStore rs = RecordStore.openRecordStore((String)m_szFileName, (boolean)true);
            m_FileSize = rs.getSize();
            int nRet = rs.getNumRecords();
            if (nRet > 0) {
                return 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return m_FileSize;
    }

    void ReadLineToBuf(byte[] lpReadBuf, int dwSize) {
        int dwSrcIndex;
        int nSrcStart = 0;
        char cSrcChar = '\u0000';
        String szLineStr = "";
        for (dwSrcIndex = 0; dwSrcIndex < dwSize; ++dwSrcIndex) {
            cSrcChar = (char)lpReadBuf[dwSrcIndex];
            if (cSrcChar != '\n') continue;
            szLineStr = "";
            szLineStr = new String(lpReadBuf, nSrcStart, dwSrcIndex - nSrcStart);
            this.m_pReadLineList.Add(szLineStr);
            ++this.m_nReadLineCnt;
            nSrcStart = dwSrcIndex;
        }
        if (dwSrcIndex - nSrcStart > 0) {
            szLineStr = "";
            szLineStr = new String(lpReadBuf, nSrcStart, dwSrcIndex - nSrcStart);
            this.m_pReadLineList.Add(szLineStr);
            ++this.m_nReadLineCnt;
        }
    }

    void DelListByIdx(int nIdx) {
        String lpStr = null;
        if ((lpStr = this.m_pReadLineList.Item(nIdx, lpStr)) == null) {
            return;
        }
        this.m_pReadLineList.Delete(nIdx);
        lpStr = null;
    }

    void ReleaseList() {
        this.m_nCurLineIdx = 0;
        if (this.m_pReadLineList == null) {
            return;
        }
        while (this.m_pReadLineList.GetCount() > 0) {
            this.DelListByIdx(0);
        }
        this.m_pReadLineList = null;
    }

    boolean ReadLineStart() {
        if (this.m_hFile <= 0) {
            return false;
        }
        int dwSize = this.GetFileSize();
        String pReadLineBuf = "";
        this.SetFilePointer(0, 0);
        if (!this.ReadFile(pReadLineBuf, dwSize)) {
            pReadLineBuf = null;
            return false;
        }
        this.m_nReadLineCnt = 0;
        this.m_nCurLineIdx = 0;
        if (this.m_pReadLineList != null) {
            this.ReleaseList();
        }
        this.m_pReadLineList = new CSWLList();
        this.ReadLineToBuf(pReadLineBuf.getBytes(), dwSize);
        pReadLineBuf = null;
        return true;
    }

    boolean ReadLine(String lpBuf, int dwSize) {
        if (this.m_nReadLineCnt <= this.m_nCurLineIdx) {
            return false;
        }
        String lpSrc = null;
        if ((lpSrc = this.m_pReadLineList.Item(this.m_nCurLineIdx, lpSrc)) == null) {
            return false;
        }
        int nSrcLen = lpSrc.length();
        int nCopyLen = lpSrc.charAt(nSrcLen - 2) == '\r' && lpSrc.charAt(nSrcLen - 1) == '\n' ? SWLDefine.MIN(dwSize - 1, nSrcLen - 2) : SWLDefine.MIN(dwSize - 1, nSrcLen);
        lpBuf = lpSrc.substring(nCopyLen);
        ++this.m_nCurLineIdx;
        return true;
    }

    void ReadLineEnd() {
        this.ReleaseList();
    }
}

