/*
 * Decompiled with CFR 0.152.
 */
class CSWLRect {
    int left;
    int top;
    int right;
    int bottom;

    CSWLRect() {
        this.left = 0;
        this.top = 0;
        this.right = 240;
        this.bottom = 320;
    }

    CSWLRect(int l, int t, int r, int b) {
        this.left = l;
        this.top = t;
        this.right = r;
        this.bottom = b;
    }

    void SetRect(int x1, int y1, int x2, int y2) {
        this.left = x1;
        this.top = y1;
        this.right = x2;
        this.bottom = y2;
    }

    int Width() {
        return this.right - this.left;
    }

    int Height() {
        return this.bottom - this.top;
    }

    CSWLPoint TopLeft() {
        return new CSWLPoint(this.left, this.top);
    }

    CSWLPoint BottomRight() {
        return new CSWLPoint(this.right, this.bottom);
    }

    CSWLPoint TopRight() {
        return new CSWLPoint(this.right, this.top);
    }

    CSWLPoint BottomLeft() {
        return new CSWLPoint(this.left, this.bottom);
    }

    CSWLPoint CenterPoint() {
        int x = this.left + (this.right - this.left >> 1);
        int y = this.top + (this.bottom - this.top >> 1);
        return new CSWLPoint(x, y);
    }

    CSWLPoint CenterLeft() {
        int x = this.left;
        int y = this.top + (this.bottom - this.top >> 1);
        return new CSWLPoint(x, y);
    }

    CSWLPoint CenterRight() {
        int x = this.right;
        int y = this.top + (this.bottom - this.top >> 1);
        return new CSWLPoint(x, y);
    }

    CSWLPoint CenterTop() {
        int x = this.left + (this.right - this.left >> 1);
        int y = this.top;
        return new CSWLPoint(x, y);
    }

    CSWLPoint CenterBottom() {
        int x = this.left + (this.right - this.left >> 1);
        int y = this.bottom;
        return new CSWLPoint(x, y);
    }

    boolean PtInRect(CSWLPoint point) {
        return this.left <= point.x && point.x <= this.right && this.top <= point.y && point.y <= this.bottom;
    }

    boolean PtInRect2(CSWLPoint point) {
        return this.left < point.x && point.x < this.right && this.top < point.y && point.y < this.bottom;
    }

    boolean PtInRect3(CSWLPoint point) {
        int width = this.left + this.right;
        int height = this.top + this.bottom;
        return this.left <= point.x && point.x <= width && this.top <= point.y && point.y <= height;
    }

    void NormalizeRect() {
        int nTemp;
        if (this.left > this.right) {
            nTemp = this.left;
            this.left = this.right;
            this.right = nTemp;
        }
        if (this.top > this.bottom) {
            nTemp = this.top;
            this.top = this.bottom;
            this.bottom = nTemp;
        }
    }

    boolean IntersectRect(CSWLRect src1, CSWLRect src2) {
        if (src1.left >= src2.right || src1.right <= src2.left || src1.top >= src2.bottom || src1.bottom <= src2.top) {
            this.bottom = 0;
            this.right = 0;
            this.top = 0;
            this.left = 0;
            return false;
        }
        this.left = src1.left > src2.left ? src1.left : src2.left;
        this.top = src1.top > src2.top ? src1.top : src2.top;
        this.right = src1.right > src2.right ? src2.right : src1.right;
        this.bottom = src1.bottom > src2.bottom ? src2.bottom : src1.bottom;
        return true;
    }

    boolean UnionRect(CSWLRect src1, CSWLRect src2) {
        this.left = src1.left > src2.left ? src2.left : src1.left;
        this.top = src1.top > src2.top ? src2.top : src1.top;
        this.right = src1.right > src2.right ? src1.right : src2.right;
        this.bottom = src1.bottom > src2.bottom ? src1.bottom : src2.bottom;
        return true;
    }

    boolean SubtractRect(CSWLRect src1, CSWLRect src2) {
        if ((src1.left <= src2.left ? src1.right < src2.left : src1.left > src2.right) || (src1.top > src2.top ? src1.top > src2.bottom : src1.bottom < src2.top)) {
            this.bottom = 0;
            this.right = 0;
            this.top = 0;
            this.left = 0;
            return false;
        }
        if (src2.PtInRect2(new CSWLPoint(src1.left, src1.top)) || src2.PtInRect2(new CSWLPoint(src1.right, src1.top)) || src2.PtInRect2(new CSWLPoint(src1.left, src1.bottom)) || src2.PtInRect2(new CSWLPoint(src1.right, src1.bottom))) {
            this.bottom = 0;
            this.right = 0;
            this.top = 0;
            this.left = 0;
            return false;
        }
        if (src1.Width() <= src2.Width()) {
            if (src1.top > src2.top) {
                this.top = src2.bottom;
                this.bottom = src1.bottom;
            } else {
                this.top = src1.top;
                this.bottom = src2.top;
            }
        }
        if (src1.Height() <= src2.Height()) {
            if (src1.left > src2.left) {
                this.left = src2.right;
                this.right = src1.right;
            } else {
                this.left = src1.left;
                this.right = src2.left;
            }
        }
        return true;
    }

    void OffsetRect(int x, int y) {
        this.left += x;
        this.right += x;
        this.top += y;
        this.bottom += y;
    }

    void OffsetRect(CSWLPoint point) {
        this.OffsetRect(point.x, point.y);
    }

    void OffsetRect(CSWLSize size) {
        this.OffsetRect(size.cx, size.cy);
    }

    void SetRectEmpty() {
        this.bottom = 0;
        this.right = 0;
        this.top = 0;
        this.left = 0;
    }

    boolean IsRectEmpty() {
        return this.Width() <= 0 && this.Height() <= 0;
    }

    boolean IsRectNull() {
        return this.left <= 0 && this.top <= 0 && this.right <= 0 && this.bottom <= 0;
    }

    void InflateRect(int x, int y) {
        this.left -= x;
        this.right += x;
        this.top -= y;
        this.bottom += y;
    }

    void InflateRect(CSWLSize size) {
        this.left -= size.cx;
        this.right += size.cx;
        this.top -= size.cy;
        this.bottom += size.cy;
    }

    void InflateRect(int l, int t, int r, int b) {
        this.left -= l;
        this.right += r;
        this.top -= t;
        this.bottom += b;
    }

    void InflateRect(CSWLRect rect) {
        this.left -= rect.left;
        this.right += rect.right;
        this.top -= rect.top;
        this.bottom += rect.bottom;
    }

    void DeflateRect(int x, int y) {
        this.left += x;
        this.right -= x;
        this.top += y;
        this.bottom -= y;
    }

    void DeflateRect(CSWLSize size) {
        this.left += size.cx;
        this.right -= size.cx;
        this.top += size.cy;
        this.bottom -= size.cy;
    }

    void DeflateRect(int l, int t, int r, int b) {
        this.left += l;
        this.right -= r;
        this.top += t;
        this.bottom -= b;
    }

    void DeflateRect(CSWLRect rect) {
        this.left += rect.left;
        this.right -= rect.right;
        this.top += rect.top;
        this.bottom -= rect.bottom;
    }
}

