/*
 * Decompiled with CFR 0.152.
 */
class RGBQUAD {
    byte rgbBlue;
    byte rgbGreen;
    byte rgbRed;
    byte rgbReserved;

    RGBQUAD() {
        this.rgbBlue = 0;
        this.rgbGreen = 0;
        this.rgbRed = 0;
    }

    RGBQUAD(RGBQUAD pal) {
        this.rgbRed = pal.rgbRed;
        this.rgbGreen = pal.rgbGreen;
        this.rgbBlue = pal.rgbBlue;
    }

    RGBQUAD(int clr) {
        this.rgbRed = (byte)SWLGrpDefine.RGB_R(clr);
        this.rgbGreen = (byte)SWLGrpDefine.RGB_G(clr);
        this.rgbBlue = (byte)SWLGrpDefine.RGB_B(clr);
    }

    void SetVal(byte r, byte g, byte b) {
        this.rgbRed = r;
        this.rgbGreen = g;
        this.rgbBlue = b;
    }

    void AddVal(short r, short g, short b) {
        this.rgbRed = (byte)Yulib.SWL_Limit(this.rgbRed + r, 0, 255);
        this.rgbGreen = (byte)Yulib.SWL_Limit(this.rgbGreen + g, 0, 255);
        this.rgbBlue = (byte)Yulib.SWL_Limit(this.rgbBlue + b, 0, 255);
    }

    RGBQUAD operatorEqual(RGBQUAD pal) {
        this.rgbRed = pal.rgbRed;
        this.rgbGreen = pal.rgbGreen;
        this.rgbBlue = pal.rgbBlue;
        return this;
    }

    boolean operatorDEqual(RGBQUAD pal) {
        return this.rgbRed == pal.rgbRed && this.rgbGreen == pal.rgbGreen && this.rgbBlue == pal.rgbBlue;
    }

    boolean operatorDEqual(int clr) {
        return this.rgbRed == SWLGrpDefine.RGB_R(clr) && this.rgbGreen == SWLGrpDefine.RGB_G(clr) && this.rgbBlue == SWLGrpDefine.RGB_B(clr);
    }

    boolean operatorUnEqual(RGBQUAD pal) {
        return this.rgbRed != pal.rgbRed || this.rgbGreen != pal.rgbGreen || this.rgbBlue != pal.rgbBlue;
    }

    boolean operatorUnEqual(int clr) {
        return this.rgbRed != SWLGrpDefine.RGB_R(clr) || this.rgbGreen != SWLGrpDefine.RGB_G(clr) || this.rgbBlue != SWLGrpDefine.RGB_B(clr);
    }

    RGBQUAD operatorAddEqual(RGBQUAD rhs) {
        this.rgbRed = (byte)(this.rgbRed + rhs.rgbRed);
        this.rgbGreen = (byte)(this.rgbGreen + rhs.rgbGreen);
        this.rgbBlue = (byte)(this.rgbBlue + rhs.rgbBlue);
        return this;
    }

    RGBQUAD operatorAddEqual(int val) {
        this.rgbRed = (byte)(this.rgbRed + val);
        this.rgbGreen = (byte)(this.rgbGreen + val);
        this.rgbBlue = (byte)(this.rgbBlue + val);
        return this;
    }
}

