/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class EnemyBossPowerPlane
extends BasicPlane {
    Sprite hitSprite = null;
    Random rn = new Random();
    private long start1 = 0L;
    private long start2 = 0L;
    private long start3 = 0L;
    private long start4 = 0L;
    private long end = 0L;
    int state = 0;

    public EnemyBossPowerPlane(Sprite sprite, int x, int y) {
        try {
            this.sprite = sprite;
            this.x = x;
            this.y = y;
            this.w = sprite.getWidth();
            this.h = sprite.getHeight();
            this.life = 2000;
            this.attach = 2;
            this.dx = 1;
            this.dy = 1;
            this.currentFrame = 0;
            this.endFrame = sprite.getRawFrameCount() - 1;
            this.bulletType = 7;
            this.start2 = System.currentTimeMillis();
            Image img = null;
            try {
                img = Image.createImage((String)"/boss_2_2.png");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.hitSprite = new Sprite(img, img.getWidth(), img.getHeight());
        }
        catch (Exception e) {
            Util.debug("EnemyBossPowerPlane---------------init die!");
        }
    }

    public int getBossType() {
        return 3;
    }

    public boolean canDestroySelf() {
        return false;
    }

    public boolean canSendBullet() {
        this.end = System.currentTimeMillis();
        if (this.end - this.start1 > 3000L) {
            this.start1 = this.end;
            return true;
        }
        return false;
    }

    private void setMoveDirect(int direct) {
        switch (direct) {
            case 0: {
                if (this.dy < 0) {
                    this.dy = this.dy;
                    break;
                }
                this.dy = -this.dy;
                break;
            }
            case 1: {
                if (this.dy < 0) {
                    this.dy = -this.dy;
                    break;
                }
                this.dy = this.dy;
                break;
            }
            case 2: {
                if (this.dx < 0) {
                    this.dx = this.dx;
                    break;
                }
                this.dx = -this.dx;
                break;
            }
            case 3: {
                this.dx = this.dx < 0 ? -this.dx : this.dx;
            }
        }
    }

    public void setNeedDrawShadow(boolean isNeedDrawShadow) {
        long end = System.currentTimeMillis();
        if (end - this.start4 < 1000L) {
            return;
        }
        this.start4 = end;
        super.setNeedDrawShadow(isNeedDrawShadow);
    }

    private void autoResetMoveDirect() {
        Random rn = new Random();
        if (rn.nextInt() % 2 == 0) {
            this.dx = rn.nextInt() % 2 == 0 ? (this.dx < 0 ? this.dx : -this.dx) : (this.dx < 0 ? -this.dx : this.dx);
        } else {
            this.dy = rn.nextInt() % 2 == 0 ? (this.dy < 0 ? this.dy : -this.dy) : (this.dy < 0 ? -this.dy : this.dy);
        }
    }

    private int needResetDirect() {
        if (this.getLeftTopY() < 0) {
            return 1;
        }
        if (this.getX() < Util.screenWidth / 4) {
            return 3;
        }
        if (this.getX() > 3 * Util.screenWidth / 4) {
            return 2;
        }
        if (this.getY() < 5 * Util.screenHeight / 6) {
            return 0;
        }
        return -1;
    }

    public void move() {
        if (!this.canMove(25L)) {
            return;
        }
        this.moveTo(this.getDX(), this.getDY());
        this.end = System.currentTimeMillis();
        if (this.end - this.start2 > 1000L) {
            this.start2 = this.end;
            int direct = this.needResetDirect();
            if (direct < 0) {
                this.autoResetMoveDirect();
                return;
            }
            this.setMoveDirect(direct);
        }
    }

    public void draw(Graphics g) {
        if (this.getNeedDrawShadow()) {
            if (this.start3 == 0L) {
                this.start3 = System.currentTimeMillis();
            }
            if (System.currentTimeMillis() - this.start3 > 50L) {
                super.setNeedDrawShadow(false);
                this.start3 = 0L;
            }
            this.hitSprite.setPosition(this.getX() - this.hitSprite.getWidth() / 2, this.getY() - this.hitSprite.getHeight() / 2);
            this.hitSprite.paint(g);
        } else {
            this.sprite.setFrame(this.getCurrentFrame());
            this.sprite.setPosition(this.getLeftTopX(), this.getLeftTopY());
            this.sprite.paint(g);
        }
    }
}

