/*
 * Decompiled with CFR 0.152.
 */
public class Element {
    byte type;
    byte level;
    byte subLevel;
    byte maxLevel;
    boolean comFlag;
    boolean flag;
    byte lastPos;
    static int[] useCount = new int[8];
    static int[] comCount = new int[13];
    static int[] buyCount = new int[13];
    static int killCat;
    static int killFly;
    static int[] comTemp;
    public static final byte HOUSE = 0;
    public static final byte CAT = 1;
    public static final byte STONE = 2;
    public static final byte TOMB = 3;
    public static final byte BOMB = 4;
    public static final byte RAINBOW = 5;
    public static final byte LAKE = 6;
    public static final byte SHOVEL = 7;

    public Element(int type, int level) {
        this.setElement(type, level);
    }

    public void setElement(int type, int level) {
        this.type = (byte)type;
        this.level = (byte)level;
        this.comFlag = false;
        this.flag = false;
        this.maxLevel = (byte)Element.getMaxLevel(type);
    }

    public static int getMaxLevel(int type) {
        switch (type) {
            case 0: {
                return 10;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
        }
        return 0;
    }

    public static int getScore(Element src) {
        if (src == null) {
            return 0;
        }
        int[][] score = new int[][]{{5, 20, 100, 500, 1500, 4500, 15000, 50000, 250000, 2500000, 37500000}, {0, 0}, {50, 2000, 0}, {40, 1200, 3600, 0, 0}, {0, 0}, {200}, {0}, {0}};
        return score[src.type][src.level] * Engine.scoreRate / 100;
    }

    public int getNeedNum() {
        if (this.type == 0 && this.level >= 7 && this.level <= 9) {
            return this.level - 3;
        }
        return 3;
    }

    public int getImg() {
        int temp = this.level == 0 ? 0 : -1;
        switch (this.type) {
            case 0: {
                return 54 + this.level * 2 + this.subLevel + temp;
            }
            case 1: {
                return 98 + this.level;
            }
            case 2: {
                return 51 + this.level + this.subLevel;
            }
            case 3: {
                if (this.level < 3) {
                    return 75 + this.level * 2 + this.subLevel + temp;
                }
                return 77 + this.level;
            }
            case 4: {
                return 92;
            }
            case 5: {
                return 89;
            }
            case 7: {
                return 94;
            }
        }
        return -1;
    }

    public int getIcon() {
        switch (this.type) {
            case 0: {
                return Math.min(82 + this.level, 88);
            }
            case 1: {
                return 90 + this.level;
            }
            case 4: {
                return this.level == 0 ? 92 : 95;
            }
            case 5: {
                return 89;
            }
            case 7: {
                return 94;
            }
        }
        return -1;
    }

    public static void addUse(Element e) {
        if (Engine.gameMode == 6) {
            return;
        }
        byte task = -1;
        switch (e.type) {
            case 0: {
                if (e.level > 4) break;
                byte by = e.level;
                useCount[by] = useCount[by] + 1;
                break;
            }
            case 4: {
                int n = 5 + e.level;
                useCount[n] = useCount[n] + 1;
                if (e.level != 0) break;
                task = 9;
                break;
            }
            case 5: {
                useCount[7] = useCount[7] + 1;
                task = 8;
            }
        }
        if (!Engine.taskComplete && task >= 0) {
            int i = 0;
            while (i < Engine.taskID.length) {
                if (Engine.taskID[i] == task) {
                    Engine.taskState[i] = (byte)Math.min(Engine.taskState[i] + 1, GameUI.taskNum[task]);
                }
                ++i;
            }
        }
    }

    public static void addComTemp(Element e) {
        int i = 0;
        while (i < comTemp.length) {
            Element.comTemp[i] = 0;
            ++i;
        }
        switch (e.type) {
            case 0: {
                if (e.level < 3) break;
                int n = e.level - 3;
                comTemp[n] = comTemp[n] + 1;
                break;
            }
            case 3: {
                int n = 7 + e.level;
                comTemp[n] = comTemp[n] + 1;
                break;
            }
            case 2: {
                comTemp[12] = comTemp[12] + 1;
            }
        }
    }

    public static void addCom() {
        if (Engine.gameMode == 6) {
            return;
        }
        int i = 0;
        while (i < comTemp.length) {
            int n = i;
            comCount[n] = comCount[n] + comTemp[i];
            ++i;
        }
        if (!Engine.taskComplete) {
            int i2 = 0;
            while (i2 < Engine.taskID.length) {
                switch (Engine.taskID[i2]) {
                    case 0: {
                        Engine.taskState[i2] = (byte)Math.min(Engine.taskState[i2] + comTemp[0], GameUI.taskNum[0]);
                        break;
                    }
                    case 1: {
                        Engine.taskState[i2] = (byte)Math.min(Engine.taskState[i2] + comTemp[3], GameUI.taskNum[1]);
                        break;
                    }
                    case 2: {
                        Engine.taskState[i2] = (byte)Math.min(Engine.taskState[i2] + comTemp[4], GameUI.taskNum[2]);
                        break;
                    }
                    case 7: {
                        Engine.taskState[i2] = (byte)Math.min(Engine.taskState[i2] + comTemp[12], GameUI.taskNum[7]);
                    }
                }
                ++i2;
            }
        }
    }

    public static void addBuy(int type, int level) {
        switch (type) {
            case 0: {
                int n = level;
                buyCount[n] = buyCount[n] + 1;
                break;
            }
            case 4: {
                int n = 7 + level;
                buyCount[n] = buyCount[n] + 1;
                break;
            }
            case 5: {
                buyCount[9] = buyCount[9] + 1;
                break;
            }
            case 7: {
                buyCount[10] = buyCount[10] + 1;
                break;
            }
            case -1: {
                int n = level;
                buyCount[n] = buyCount[n] + 1;
            }
        }
    }

    static {
        comTemp = new int[13];
    }
}

