/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import java.util.Vector;

public class GMath {
    static Random rnd = new Random();
    private static final short[] SINES = new short[]{0, 44, 88, 128, 165, 196, 222, 241, 252, 256};

    public static boolean hit(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        return x1 < x2 + w2 && x2 < x1 + w1 && (y1 -= h1) < (y2 -= h2) + h2 && y2 < y1 + h1;
    }

    public static int random(int n) {
        return Math.abs(rnd.nextInt()) % (n + 1);
    }

    public static int random(int a, int b) {
        if (a == b) {
            return a;
        }
        if (a > b) {
            int temp = a;
            a = b;
            b = temp;
        }
        return Math.abs(rnd.nextInt()) % (b - a + 1) + a;
    }

    public static boolean percent(int per) {
        int rnd = GMath.random(0, 99);
        return rnd < per;
    }

    public static boolean probability(int n, int m) {
        if (m <= 0 || n <= 0) {
            return false;
        }
        int rnd = GMath.random(1, m);
        return n >= rnd;
    }

    static int power(int base, int exp) {
        int res = 1;
        int i = 0;
        while (i < exp) {
            res *= base;
            ++i;
        }
        return res;
    }

    public static int conversionRatio(int value, int rate) {
        return value * rate / 100;
    }

    public static int simpleFormula(int base, int delta, int level) {
        return base + (level - 1) * delta;
    }

    public static int simpleFormula100(int base, int delta100, int level) {
        return base + (level - 1) * delta100 / 100;
    }

    public static int getDigit(int num) {
        return Integer.toString(num).length();
    }

    public static int range100(int per) {
        if (per > 100) {
            return 100;
        }
        if (per < 0) {
            return 0;
        }
        return per;
    }

    public static final long sqrt2(long v) {
        if (v > 0L) {
            long c;
            long r = (v *= 10000L) / 10000L + 10000L;
            while ((r = v / r + r >> 1) < (c = r)) {
            }
            return c;
        }
        return -1L;
    }

    public static final int sqrt(int v) {
        if (v > 0) {
            int c;
            int r = (v + 1) / 2;
            while ((r = v / r + r >> 1) < (c = r)) {
            }
            return c;
        }
        return -1;
    }

    private static int sin90(int angle) {
        if (angle % 10 == 0) {
            return SINES[angle / 10];
        }
        short value1 = SINES[angle / 10];
        short value2 = SINES[angle / 10 + 1];
        int c = (value2 - value1) * (angle % 10) / 10;
        return value1 + c;
    }

    public static int sin256(int angle) {
        if ((angle %= 360) < 0) {
            angle += 360;
        }
        if (angle <= 90) {
            return GMath.sin90(angle);
        }
        if (angle <= 180) {
            return GMath.sin90(180 - angle);
        }
        if (angle <= 270) {
            return -GMath.sin90(angle - 180);
        }
        return -GMath.sin90(360 - angle);
    }

    public static int cos256(int angle) {
        return GMath.sin256(angle + 90);
    }

    public static int byte2Int(byte[] data, int start) {
        int temp = 0;
        int i = 0;
        while (i < 4) {
            temp = temp << 8 | data[start + i] & 0xFF;
            ++i;
        }
        return temp;
    }

    public static short byte2Short(byte[] data, int start) {
        return (short)(data[start] << 8 | data[start + 1] & 0xFF);
    }

    static String[] splitString(String src, String key) {
        Vector<String> vt = new Vector<String>();
        int w = 0;
        boolean end = false;
        while (!end) {
            String s;
            int pos = src.indexOf(key, w);
            if (pos == -1) {
                pos = src.length();
                end = true;
            }
            int endIndex = pos;
            if (pos > 0 && src.charAt(pos - 1) == '\r') {
                endIndex = pos - 1;
            }
            if (!(s = src.substring(w, endIndex).trim()).equals("")) {
                vt.addElement(s);
            }
            w = pos + key.length();
        }
        Object[] cs = new String[vt.size()];
        vt.copyInto(cs);
        vt = null;
        return cs;
    }
}

