/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Image;

public class Pack {
    static short[] names;
    static int[] offset;
    static int nameMax;
    public static final byte BOMB = 0;
    public static final byte DATABASE = 1;
    public static final byte DEC_IMG = 2;
    public static final byte DEC_OBJ = 3;
    public static final byte DEC_DAT = 4;
    public static final byte EFFECT_IMG = 5;
    public static final byte EFFECT_DAT = 6;
    public static final byte COMBOEFF = 7;
    public static final byte FIGHTER_IMG = 8;
    public static final byte FIGHTER_DAT = 9;
    public static final byte IMAGE_BATTLE = 10;
    public static final byte IMAGE_CG = 11;
    public static final byte IMAGE_HEAD = 12;
    public static final byte IMAGE_LOAD = 13;
    public static final byte IMAGE_MORE = 14;
    public static final byte IMAGE_OPEN = 15;
    public static final byte IMAGE_OTHER = 16;
    public static final byte IMAGE_UI = 17;
    public static final byte IMAGE_WEATHER = 18;
    public static final byte MAP = 20;
    public static final byte SCRIPT_G = 21;
    public static final byte SCRIPT_R = 22;
    public static final byte SKILL = 23;
    public static final byte SPRITE_IMG = 24;
    public static final byte SPRITE_DAT = 25;
    public static final byte TILE = 26;
    static final byte DAT_CLIP = 0;
    static final byte DAT_FRAME = 1;
    static final byte DAT_MOTION = 2;
    static final byte DAT_OFFSET = 3;

    public static DataInputStream openPack(String file) {
        InputStream is = "".getClass().getResourceAsStream(file);
        return is == null ? null : new DataInputStream(is);
    }

    public static String formatNum(int num, int format) {
        String str = Integer.toString(num);
        int zero = format - str.length();
        int i = 0;
        while (i < zero) {
            str = "0" + str;
            ++i;
        }
        return str;
    }

    public static int getContents(DataInputStream is) throws Exception {
        nameMax = 0;
        int len = is.readShort();
        names = new short[len];
        offset = new int[len];
        int i = 0;
        while (i < len) {
            Pack.names[i] = is.readShort();
            Pack.offset[i] = is.readInt();
            nameMax = Math.max(names[i] + 1, nameMax);
            ++i;
        }
        return len;
    }

    static short[] sort(short[] order, short[] data) {
        Vector<Short> v = new Vector<Short>();
        short i = 0;
        while (i < order.length) {
            int j = 0;
            while (j < data.length) {
                if (order[i] == data[j]) {
                    v.addElement(new Short(i));
                    break;
                }
                j = (short)(j + 1);
            }
            if (v.size() == data.length) break;
            i = (short)(i + 1);
        }
        short[] index = new short[v.size()];
        int i2 = 0;
        while (i2 < index.length) {
            index[i2] = (Short)v.elementAt(i2);
            ++i2;
        }
        return index;
    }

    public static int searchFile(DataInputStream is, int name) {
        try {
            Pack.getContents(is);
            int idx = -1;
            int i = 0;
            while (i < names.length) {
                if (names[i] == name) {
                    idx = i;
                    break;
                }
                ++i;
            }
            if (idx == -1) {
                return -1;
            }
            int off = idx == 0 ? 0 : offset[idx - 1];
            int len = offset[idx] - off;
            is.skip(off);
            return len;
        }
        catch (Exception e) {
            return -1;
        }
    }

    static short[][] readArray(String file, int name) {
        DataInputStream is = Pack.openPack(file);
        if (is == null) {
            return null;
        }
        int fileLen = Pack.searchFile(is, name);
        if (fileLen == -1) {
            return null;
        }
        short[][] dat = null;
        try {
            int len = is.readShort();
            dat = new short[len][];
            int i = 0;
            while (i < len) {
                int gLen = is.readByte();
                dat[i] = new short[gLen];
                int j = 0;
                while (j < gLen) {
                    dat[i][j] = is.readShort();
                    ++j;
                }
                ++i;
            }
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dat;
    }

    static short[][] readArray(String file) {
        DataInputStream dis = Pack.openPack(file);
        try {
            if (dis == null) {
                return null;
            }
            int row = dis.readByte();
            int col = dis.readByte();
            short[][] temp = new short[row][col];
            int i = 0;
            while (i < row) {
                int j = 0;
                while (j < col) {
                    temp[i][j] = dis.readShort();
                    ++j;
                }
                ++i;
            }
            dis.close();
            return temp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object[] getImageData(DataInputStream is) throws Exception {
        int len = is.readByte();
        Object[] obj = new Object[4];
        int i = 0;
        while (i < len) {
            byte type = is.readByte();
            switch (type) {
                case 0: 
                case 3: {
                    obj[type] = Pack.getClipData(is);
                    break;
                }
                case 1: {
                    obj[type] = Pack.getFrameData(is);
                    break;
                }
                case 2: {
                    obj[type] = Pack.getMotionData(is);
                }
            }
            ++i;
        }
        return obj;
    }

    static byte[][] getClipData(DataInputStream is) {
        byte[][] data = null;
        int len = 0;
        try {
            len = is.readShort();
            data = new byte[len][4];
            int i = 0;
            while (i < len) {
                int j = 0;
                while (j < 4) {
                    data[i][j] = is.readByte();
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("ClipData error");
            e.printStackTrace();
        }
        return data;
    }

    static byte[][] getFrameData(DataInputStream is) {
        byte[][] data = null;
        try {
            int len = is.readByte();
            data = new byte[len][];
            int i = 0;
            while (i < len) {
                int lenD = (is.readByte() - 4) * 5 + 4;
                data[i] = new byte[lenD];
                int j = 0;
                while (j < lenD) {
                    data[i][j] = is.readByte();
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("frameData error");
            e.printStackTrace();
        }
        return data;
    }

    static byte[][][] getMotionData(DataInputStream is) {
        byte[][][] data = null;
        int len = 0;
        try {
            len = is.readByte();
            data = new byte[20][][];
            int i = 0;
            while (i < len) {
                byte st = is.readByte();
                int zs = is.readByte();
                data[st] = new byte[zs][7];
                int j = 0;
                while (j < zs) {
                    int m = 0;
                    while (m < 7) {
                        data[st][j][m] = is.readByte();
                        ++m;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("motionData error");
            e.printStackTrace();
        }
        return data;
    }

    public static void freeData(Object[] obj) {
        if (obj == null) {
            return;
        }
        int i = 0;
        while (i < obj.length) {
            obj[i] = null;
            ++i;
        }
    }

    static void freeEffectData() {
        Pack.freeData((Object[])Effect.clipData);
        Pack.freeData((Object[])Effect.frameData);
        Pack.freeData((Object[])Effect.motionData);
    }

    public static boolean getBit(int value, int bit) {
        return (value >> bit & 1) == 1;
    }

    private static void initPng(byte[] img) {
        byte[] pngHead = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        byte[] pngEnd = new byte[]{73, 69, 78, 68, -82, 66, 96, -126};
        int i = 0;
        while (i < 8) {
            img[i] = pngHead[i];
            img[img.length - i - 1] = pngEnd[7 - i];
            ++i;
        }
    }

    public static void loadImages() {
        Pack.loadImages(-1);
    }

    public static void loadImages(int except) {
        DataInputStream dis = Pack.openPack("/images.dat");
        try {
            Pack.getContents(dis);
            if (Paint.images == null) {
                Paint.images = new Image[nameMax];
            }
            int i = 0;
            while (i < names.length) {
                int off = i == 0 ? 0 : offset[i - 1];
                int len = offset[i] - off;
                if (names[i] == except) {
                    dis.skip(len);
                } else {
                    byte[] imgData = new byte[len + 16];
                    Pack.initPng(imgData);
                    dis.read(imgData, 8, len);
                    Image img = Image.createImage((byte[])imgData, (int)0, (int)imgData.length);
                    short imgIndex = names[i];
                    Paint.images[imgIndex] = img;
                }
                ++i;
            }
            dis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean loadImages(short[] name) {
        return Pack.loadImages(name, false);
    }

    public static boolean loadImages(short[] name, boolean gray) {
        DataInputStream dis = Pack.openPack("/images.dat");
        if (dis == null) {
            return false;
        }
        int i = 0;
        try {
            short[] index;
            Pack.getContents(dis);
            if (Paint.images == null) {
                Paint.images = new Image[nameMax];
            }
            if ((index = Pack.sort(names, name)).length == 0) {
                return false;
            }
            int skip = 0;
            i = 0;
            while (i < index.length) {
                short idx = index[i];
                int off = idx == 0 ? 0 : offset[idx - 1];
                int len = offset[idx] - off;
                short imgIndex = names[idx];
                if (Paint.images[imgIndex] == null) {
                    Image img;
                    byte[] imgData = new byte[len + 16];
                    dis.skip(off - skip);
                    Pack.initPng(imgData);
                    dis.read(imgData, 8, len);
                    if (gray) {
                        Paint.setGrayPNG(imgData);
                    }
                    Paint.images[imgIndex] = img = Image.createImage((byte[])imgData, (int)0, (int)imgData.length);
                    skip = offset[idx];
                }
                ++i;
            }
            dis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static void cleanImage(int id) {
        if (id >= 0 && id < Paint.images.length) {
            Paint.images[id] = null;
        } else {
            System.out.println("cleanImage error!");
        }
    }

    public static void cleanImages() {
        Paint.images = null;
    }

    public static void cleanAllImages() {
        int i = 0;
        while (i < Paint.images.length) {
            Paint.images[i] = null;
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    static String loadTxt(String name) {
        InputStream is = "".getClass().getResourceAsStream(name);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        String strReturn = null;
        byte[] buffer = new byte[2048];
        try {
            int len;
            while ((len = is.read(buffer)) > 0) {
                void var6_6;
                dos.write(buffer, 0, (int)var6_6);
            }
            strReturn = new String(baos.toByteArray(), "UTF-8");
            is.close();
            dos.close();
            baos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strReturn;
    }
}

