/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Paint {
    static int screenX;
    static int screenY;
    static final short L_BG = 0;
    static final short L_ROLE = 1000;
    static final short L_EFECT = 2000;
    static final short L_FG = 3000;
    static final short L_MASK = 5000;
    static final short L_INTERFACE = 10000;
    static final short L_TALK = 11000;
    static final short L_INFO = 12000;
    static final short L_MAX = 20000;
    public static final byte L_T = 20;
    public static final byte L_VC = 6;
    public static final byte L_B = 36;
    public static final byte HC_T = 17;
    public static final byte HC_VC = 3;
    public static final byte HC_B = 33;
    public static final byte R_T = 24;
    public static final byte R_VC = 10;
    public static final byte R_B = 40;
    public static final byte NONE = 0;
    public static final byte HORIZONTAL = 1;
    public static final byte VERTICAL = 2;
    public static final byte CENTER = 3;
    public static Image[] images;
    public static final byte CLIP = -1;
    public static final byte LINE = 0;
    public static final byte RECT = 1;
    public static final byte ARC = 2;
    public static final byte ROUND_RECT = 3;
    public static final byte STRING = 4;
    public static final byte IMG = 5;
    public static final byte NUM = 6;
    public static final byte PANE = 7;
    public static final byte FRAME = 8;
    public static final byte BORDER_STRING = 9;
    public static final byte COMPLEX_STRING = 10;
    public static final byte TALK = 11;
    public static final byte MASK = 12;
    public static final byte EFFECT = 13;
    public static final byte PASS = 14;
    public static final byte SPEEDLINE = 15;
    public static final byte WEATHER = 16;
    public static final byte IMG_TEMP = 17;
    public static final byte IMG_DATA = 18;
    public static final byte CAPTURE = 19;
    public static final byte CUTLINE = 20;
    private static final int MAX = 400;
    private static int paintIndex;
    static short objCount;
    static short[] paintOrder;
    private static byte[] type;
    private static short[] posX;
    private static short[] posY;
    private static short[] layers;
    private static byte[] anchors;
    private static byte[] trans;
    private static String[] string;
    private static Vector array;
    private static short[] data_a;
    private static short[] data_b;
    private static short[] data_c;
    private static short[] data_d;
    private static int[] data_int;
    static int[] rgbData;
    public static int[] crcTable;
    static byte[] wave;
    static int posx;
    static int posy;
    public static final byte M_INDEX = 0;
    public static final byte M_DELAY = 1;
    public static final byte M_TRANS = 2;
    public static final byte M_LEFT = 3;
    public static final byte M_RIGHT = 4;
    public static final byte M_TOP = 5;
    public static final byte M_BOTTOM = 6;
    public static final byte FM_PLAIN = 0;
    public static final byte FM_BOLD = 1;
    public static final byte FM_STROKE = 2;
    public static final byte FM_SHADOW = 3;
    static byte fontMode;
    static int color1;
    static int color2;

    private static int addByteArray(byte[][] bytes) {
        array.addElement(bytes);
        return array.size() - 1;
    }

    private static int addCharArray(char[][] chars) {
        array.addElement(chars);
        return array.size() - 1;
    }

    static int getWidth(int id) {
        return images[id].getWidth();
    }

    static int getHeight(int id) {
        return images[id].getHeight();
    }

    static void paint(Graphics g) {
        int i = 0;
        while (i < objCount) {
            Paint.paint(g, paintOrder[i]);
            ++i;
        }
        objCount = 0;
        array.removeAllElements();
    }

    public static void paint(Graphics g, int index) {
        int sx = posX[index] - screenX;
        int sy = posY[index] - screenY;
        switch (type[index]) {
            case 0: {
                int x = data_a[index] - screenX;
                int y = data_b[index] - screenY;
                g.setColor(data_int[index]);
                g.drawLine(sx, sy, x, y);
                break;
            }
            case 20: {
                g.setColor(data_int[index]);
                int i = 0;
                while (i < data_a[index]) {
                    if (trans[index] == 0) {
                        g.fillRect(sx + 9 * i, sy, 6, 2);
                    } else {
                        g.fillRect(sx, sy + 9 * i, 2, 6);
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                short w = data_a[index];
                short h = data_b[index];
                short rw = data_c[index];
                short rh = data_d[index];
                boolean isFill = trans[index] > 0;
                Paint.changeAnchor(sx, sy, w, h, anchors[index]);
                g.setColor(data_int[index]);
                if (isFill) {
                    g.fillArc(posx, posy, (int)w, (int)h, (int)rw, (int)rh);
                    break;
                }
                g.drawArc(posx, posy, (int)w, (int)h, (int)rw, (int)rh);
                break;
            }
            case 5: {
                Paint.paintClipImage(g, data_int[index], sx, sy, (int)data_a[index], (int)data_b[index], (int)data_c[index], (int)data_d[index], anchors[index], (int)trans[index]);
                break;
            }
            case 1: {
                short w = data_a[index];
                short h = data_b[index];
                boolean isFill = trans[index] > 0;
                Paint.changeAnchor(sx, sy, w, h, anchors[index]);
                g.setColor(data_int[index]);
                if (isFill) {
                    g.fillRect(posx, posy, (int)w, (int)h);
                    break;
                }
                g.drawRect(posx, posy, (int)w, (int)h);
                break;
            }
            case 3: {
                short w = data_a[index];
                short h = data_b[index];
                short rw = data_c[index];
                short rh = data_d[index];
                boolean isFill = trans[index] > 0;
                Paint.changeAnchor(sx, sy, w, h, anchors[index]);
                g.setColor(data_int[index]);
                if (isFill) {
                    g.fillRoundRect(posx, posy, (int)w, (int)h, (int)rw, (int)rh);
                    break;
                }
                g.drawRoundRect(posx, posy, (int)w, (int)h, (int)rw, (int)rh);
                break;
            }
            case 4: {
                Paint.paintString(g, string[index], sx, sy, anchors[index], data_int[index]);
                Paint.string[index] = null;
                break;
            }
            case 6: {
                int number = data_int[index];
                short img = data_a[index];
                int row = data_b[index] >>> 8;
                int color = data_b[index] & 0xFF;
                int count = data_c[index] >>> 8;
                byte spacing = (byte)(data_c[index] & 0xFF);
                Paint.paintNum(g, number, img, sx, sy, row, color, count, spacing, anchors[index]);
                break;
            }
            case 7: {
                Paint.paintPane(g, data_int[index], sx, sy, data_a[index], data_b[index]);
                break;
            }
            case 8: {
                byte[][] clip = (byte[][])array.elementAt(data_a[index]);
                byte[][] frame = (byte[][])array.elementAt(data_b[index]);
                short idx = data_c[index];
                short fw = Paint.getFrameWidth(frame[idx]);
                short fh = Paint.getFrameHeight(frame[idx]);
                Paint.changeAnchor(sx, sy, fw, fh, anchors[index]);
                Paint.paintFrame(g, data_int[index], clip, frame, posx, posy, idx, trans[index]);
                break;
            }
            case 9: {
                int color = data_int[index];
                int color2 = Paint.getInt(data_a[index], data_b[index]);
                Paint.paintString(g, string[index], sx - 1, sy, anchors[index], color2);
                Paint.paintString(g, string[index], sx + 1, sy, anchors[index], color2);
                Paint.paintString(g, string[index], sx, sy - 1, anchors[index], color2);
                Paint.paintString(g, string[index], sx, sy + 1, anchors[index], color2);
                Paint.paintString(g, string[index], sx, sy, anchors[index], color);
                Paint.string[index] = null;
                break;
            }
            case 10: {
                String[] str = (String[])array.elementAt(data_d[index]);
                Paint.paintString(g, str, sx, sy, data_a[index], data_b[index], data_c[index], anchors[index]);
                break;
            }
            case 11: {
                String[] str = (String[])array.elementAt(data_int[index]);
                Paint.paintTalk(g, str, sx, sy, data_a[index], data_b[index], data_c[index], data_d[index]);
                break;
            }
            case -1: {
                g.setClip(sx, sy, (int)data_a[index], (int)data_b[index]);
                break;
            }
            case 12: {
                int i;
                if (rgbData[0] != data_int[index] || rgbData[data_a[index] - 1] != data_int[index]) {
                    i = 0;
                    while (i < data_a[index]) {
                        Paint.rgbData[i] = data_int[index];
                        ++i;
                    }
                }
                i = 0;
                while (i < data_b[index]) {
                    g.drawRGB(rgbData, 0, 0, sx, sy + i, (int)data_a[index], 1, true);
                    ++i;
                }
                break;
            }
            case 13: {
                Paint.paintEffect(g, data_a[index], sx, sy, data_b[index], trans[index]);
                break;
            }
            case 14: {
                Paint.paintPass(g, data_a[index], data_b[index], data_int[index], trans[index] > 0);
                break;
            }
            case 15: {
                short[][] data = (short[][])array.elementAt(data_a[index]);
                Paint.paintSpeedLine(g, data, trans[index]);
                break;
            }
            case 16: {
                byte[][] clip = (byte[][])array.elementAt(data_a[index]);
                short[][] data = (short[][])array.elementAt(data_b[index]);
                int i = 0;
                while (i < data.length) {
                    int id = data_int[index];
                    if (clip == null) {
                        int cw = images[id].getWidth();
                        int ch = images[id].getHeight();
                        Paint.paintClipImage(g, id, (int)data[i][0], (int)data[i][1], 0, 0, cw, ch, (byte)20, 0);
                    } else {
                        short t = data[i][0];
                        Paint.paintClipImage(g, id, (int)data[i][0], (int)data[i][1], (int)clip[t][2], (int)clip[t][1], (int)clip[t][2], (int)clip[t][3], (byte)20, 0);
                    }
                    ++i;
                }
                break;
            }
            case 17: {
                Image image = (Image)array.elementAt(data_int[index]);
                Paint.paintClipImage(g, image, sx, sy, 0, 0, image.getWidth(), image.getHeight(), anchors[index], (int)trans[index]);
                break;
            }
            case 18: {
                int[] rgbData = (int[])array.elementAt(data_int[index]);
                g.drawRGB(rgbData, 0, (int)data_a[index], sx, sy, (int)data_a[index], (int)data_b[index], trans[index] == 1);
                break;
            }
            case 19: {
                int[] rgbData = (int[])array.elementAt(data_int[index]);
                GCanvas.gameBuff.getRGB(rgbData, 0, (int)data_a[index], sx, sy, (int)data_a[index], (int)data_b[index]);
                if (data_c[index] <= 0) break;
                Paint.setGrayImage(rgbData, data_c[index]);
            }
        }
    }

    public static short getFrameWidth(byte[] frame) {
        return (short)(Paint.unsignedByte(frame[0]) << 8 | Paint.unsignedByte(frame[1]));
    }

    public static short getFrameHeight(byte[] frame) {
        return (short)(Paint.unsignedByte(frame[2]) << 8 | Paint.unsignedByte(frame[3]));
    }

    public static int unsignedByte(byte b) {
        return b >= 0 ? b : b + 256;
    }

    public static short getShort(byte[] b) {
        return (short)(b[1] & 0xFF | b[0] << 8 & 0xFF00);
    }

    public static byte[] toBytes(short s) {
        byte[] b = new byte[]{(byte)(s >>> 8 & 0xFF), (byte)(s & 0xFF)};
        return b;
    }

    public static int getInt(short s1, short s2) {
        return s1 << 16 | s2 & 0xFFFF;
    }

    public static short[] toShorts(int i) {
        short[] s = new short[]{(short)(i >>> 16 & 0xFFFF), (short)(i & 0xFFFF)};
        return s;
    }

    private static void insertObj() {
        int i = objCount - 1;
        while (i >= 0) {
            if (layers[paintIndex] >= layers[paintOrder[i]]) break;
            --i;
        }
        int j = objCount;
        while (j > i + 1) {
            Paint.paintOrder[j] = paintOrder[j - 1];
            --j;
        }
        Paint.paintOrder[i + 1] = (short)paintIndex;
        objCount = (short)(objCount + 1);
        paintIndex = (paintIndex + 1) % 400;
    }

    public static void setAlphaImage(int id, int alpha) {
        int w = images[id].getWidth();
        int h = images[id].getHeight();
        int[] imgData = new int[w * h];
        images[id].getRGB(imgData, 0, w, 0, 0, w, h);
        alpha <<= 24;
        int i = 0;
        while (i < imgData.length) {
            imgData[i] = (imgData[i] & 0xFFFFFF) == 0xFFFFFF || imgData[i] >>> 24 == 0 ? 0xFFFFFF : imgData[i] & 0xFFFFFF | alpha;
            ++i;
        }
        Paint.images[id] = Image.createRGBImage((int[])imgData, (int)w, (int)h, (boolean)true);
    }

    public static void setGrayImage(int[] rgbData, int grayScale) {
        int colorScale = 256 - grayScale;
        int i = 0;
        while (i < rgbData.length) {
            int red = (rgbData[i] & 0xFF0000) >> 16;
            int green = (rgbData[i] & 0xFF00) >> 8;
            int blue = rgbData[i] & 0xFF;
            int gray = red * 38 + green * 75 + blue * 15 >> 7;
            gray = gray * grayScale >> 8;
            red = (red * colorScale >> 8) + gray;
            green = (green * colorScale >> 8) + gray;
            blue = (blue * colorScale >> 8) + gray;
            rgbData[i] = red << 16 | green << 8 | blue;
            ++i;
        }
    }

    public static void initCrcTable() {
        crcTable = new int[256];
        int i = 0;
        while (i < crcTable.length) {
            int temp = i;
            int j = 0;
            while (j < 8) {
                temp = (temp & 1) == 1 ? 0xEDB88320 ^ temp >>> 1 : (temp >>>= 1);
                ++j;
            }
            Paint.crcTable[i] = temp;
            ++i;
        }
    }

    public static void setGrayPNG(byte[] pngData) {
        int offset = 8;
        while (offset < pngData.length) {
            int len = 0;
            int i = 0;
            while (i < 4) {
                len = len << 8 | Paint.unsignedByte(pngData[offset + i]);
                ++i;
            }
            if (pngData[offset + 4] == 80 && pngData[offset + 5] == 76 && pngData[offset + 6] == 84 && pngData[offset + 7] == 69) {
                int i2 = offset + 8;
                while (i2 < offset + 8 + len) {
                    int red = Paint.unsignedByte(pngData[i2]);
                    int green = Paint.unsignedByte(pngData[i2 + 1]);
                    int blue = Paint.unsignedByte(pngData[i2 + 2]);
                    int gray = red * 38 + green * 75 + blue * 15 >> 7;
                    pngData[i2] = (byte)gray;
                    byte by = pngData[i2];
                    pngData[i2 + 1] = by;
                    pngData[i2 + 2] = by;
                    i2 += 3;
                }
                int crc = -1;
                int i3 = offset + 4;
                while (i3 < offset + len + 8) {
                    crc = crcTable[(crc ^ pngData[i3]) & 0xFF] ^ crc >>> 8;
                    ++i3;
                }
                crc ^= 0xFFFFFFFF;
                int i4 = 0;
                while (i4 < 4) {
                    pngData[offset + len + 8 + i4] = (byte)(crc >>> 24);
                    crc <<= 8;
                    ++i4;
                }
                break;
            }
            offset += len + 12;
        }
    }

    public static void setClip(int x, int y, int w, int h, int layer) {
        Paint.type[Paint.paintIndex] = -1;
        Paint.layers[Paint.paintIndex] = (short)layer;
        Paint.posX[Paint.paintIndex] = (short)x;
        Paint.posY[Paint.paintIndex] = (short)y;
        Paint.data_a[Paint.paintIndex] = (short)w;
        Paint.data_b[Paint.paintIndex] = (short)h;
        Paint.insertObj();
    }

    public static void drawLine(int x1, int y1, int x2, int y2, int color, int layer) {
        if (Paint.inScreen(x1, y1, x2 - x1, y2 - y1, (byte)20)) {
            Paint.type[Paint.paintIndex] = 0;
            Paint.layers[Paint.paintIndex] = (short)layer;
            Paint.posX[Paint.paintIndex] = (short)x1;
            Paint.posY[Paint.paintIndex] = (short)y1;
            Paint.data_a[Paint.paintIndex] = (short)x2;
            Paint.data_b[Paint.paintIndex] = (short)y2;
            Paint.data_int[Paint.paintIndex] = color;
            Paint.insertObj();
        }
    }

    public static void drawCutLine(int x, int y, byte dir, int num, int color, int layer) {
        Paint.type[Paint.paintIndex] = 20;
        Paint.layers[Paint.paintIndex] = (short)layer;
        Paint.posX[Paint.paintIndex] = (short)x;
        Paint.posY[Paint.paintIndex] = (short)y;
        Paint.data_a[Paint.paintIndex] = (short)num;
        Paint.trans[Paint.paintIndex] = dir;
        Paint.data_int[Paint.paintIndex] = color;
        Paint.insertObj();
    }

    public static void drawRect(int x, int y, int w, int h, int color, byte anchor, int layer) {
        if (Paint.inScreen(x, y, w, h, anchor)) {
            Paint.type[Paint.paintIndex] = 1;
            Paint.layers[Paint.paintIndex] = (short)layer;
            Paint.posX[Paint.paintIndex] = (short)x;
            Paint.posY[Paint.paintIndex] = (short)y;
            Paint.anchors[Paint.paintIndex] = anchor;
            Paint.trans[Paint.paintIndex] = 0;
            Paint.data_a[Paint.paintIndex] = (short)w;
            Paint.data_b[Paint.paintIndex] = (short)h;
            Paint.data_int[Paint.paintIndex] = color;
            Paint.insertObj();
        }
    }

    public static void fillRect(int x, int y, int w, int h, int color, byte anchor, int layer) {
        if (Paint.inScreen(x, y, w, h, anchor)) {
            Paint.type[Paint.paintIndex] = 1;
            Paint.layers[Paint.paintIndex] = (short)layer;
            Paint.posX[Paint.paintIndex] = (short)x;
            Paint.posY[Paint.paintIndex] = (short)y;
            Paint.anchors[Paint.paintIndex] = anchor;
            Paint.trans[Paint.paintIndex] = 1;
            Paint.data_a[Paint.paintIndex] = (short)w;
            Paint.data_b[Paint.paintIndex] = (short)h;
            Paint.data_int[Paint.paintIndex] = color;
            Paint.insertObj();
        }
    }

    public static void drawARC(int x, int y, int w, int h, int rw, int rh, int color, byte anchor, int layer) {
        if (Paint.inScreen(x, y, w, h, anchor)) {
            Paint.type[Paint.paintIndex] = 2;
            Paint.layers[Paint.paintIndex] = (short)layer;
            Paint.posX[Paint.paintIndex] = (short)x;
            Paint.posY[Paint.paintIndex] = (short)y;
            Paint.anchors[Paint.paintIndex] = anchor;
            Paint.trans[Paint.paintIndex] = 0;
            Paint.data_a[Paint.paintIndex] = (short)w;
            Paint.data_b[Paint.paintIndex] = (short)h;
            Paint.data_c[Paint.paintIndex] = (short)rw;
            Paint.data_d[Paint.paintIndex] = (short)rh;
            Paint.data_int[Paint.paintIndex] = color;
            Paint.insertObj();
        }
    }

    public static void fillARC(int x, int y, int w, int h, int rw, int rh, int color, byte anchor, int layer) {
        if (Paint.inScreen(x, y, w, h, anchor)) {
            Paint.type[Paint.paintIndex] = 2;
            Paint.layers[Paint.paintIndex] = (short)layer;
            Paint.posX[Paint.paintIndex] = (short)x;
            Paint.posY[Paint.paintIndex] = (short)y;
            Paint.anchors[Paint.paintIndex] = anchor;
            Paint.trans[Paint.paintIndex] = 1;
            Paint.data_a[Paint.paintIndex] = (short)w;
            Paint.data_b[Paint.paintIndex] = (short)h;
            Paint.data_c[Paint.paintIndex] = (short)rw;
            Paint.data_d[Paint.paintIndex] = (short)rh;
            Paint.data_int[Paint.paintIndex] = color;
            Paint.insertObj();
        }
    }

    public static void drawRoundRect(int x, int y, int w, int h, int rw, int rh, int color, byte anchor, int layer) {
        if (Paint.inScreen(x, y, w, h, anchor)) {
            Paint.type[Paint.paintIndex] = 3;
            Paint.layers[Paint.paintIndex] = (short)layer;
            Paint.posX[Paint.paintIndex] = (short)x;
            Paint.posY[Paint.paintIndex] = (short)y;
            Paint.anchors[Paint.paintIndex] = anchor;
            Paint.trans[Paint.paintIndex] = 0;
            Paint.data_a[Paint.paintIndex] = (short)w;
            Paint.data_b[Paint.paintIndex] = (short)h;
            Paint.data_c[Paint.paintIndex] = (short)rw;
            Paint.data_d[Paint.paintIndex] = (short)rh;
            Paint.data_int[Paint.paintIndex] = color;
            Paint.insertObj();
        }
    }

    public static void fillRoundRect(int x, int y, int w, int h, int rw, int rh, int color, byte anchor, int layer) {
        if (Paint.inScreen(x, y, w, h, anchor)) {
            Paint.type[Paint.paintIndex] = 3;
            Paint.layers[Paint.paintIndex] = (short)layer;
            Paint.posX[Paint.paintIndex] = (short)x;
            Paint.posY[Paint.paintIndex] = (short)y;
            Paint.anchors[Paint.paintIndex] = anchor;
            Paint.trans[Paint.paintIndex] = 1;
            Paint.data_a[Paint.paintIndex] = (short)w;
            Paint.data_b[Paint.paintIndex] = (short)h;
            Paint.data_c[Paint.paintIndex] = (short)rw;
            Paint.data_d[Paint.paintIndex] = (short)rh;
            Paint.data_int[Paint.paintIndex] = color;
            Paint.insertObj();
        }
    }

    public static void drawString(String str, int x, int y, int color, byte anchor, int layer) {
        Paint.type[Paint.paintIndex] = 4;
        Paint.string[Paint.paintIndex] = str;
        Paint.layers[Paint.paintIndex] = (short)layer;
        Paint.posX[Paint.paintIndex] = (short)x;
        Paint.posY[Paint.paintIndex] = (short)y;
        Paint.anchors[Paint.paintIndex] = anchor;
        Paint.data_int[Paint.paintIndex] = color;
        Paint.insertObj();
    }

    public static void drawString(String str, int x, int y, int color, int colorBorder, byte anchor, int layer) {
        short[] temp = Paint.toShorts(colorBorder);
        Paint.type[Paint.paintIndex] = 9;
        Paint.layers[Paint.paintIndex] = (short)layer;
        Paint.posX[Paint.paintIndex] = (short)x;
        Paint.posY[Paint.paintIndex] = (short)y;
        Paint.anchors[Paint.paintIndex] = anchor;
        Paint.data_a[Paint.paintIndex] = temp[0];
        Paint.data_b[Paint.paintIndex] = temp[1];
        Paint.data_int[Paint.paintIndex] = color;
        Paint.string[Paint.paintIndex] = str;
        Paint.insertObj();
    }

    public static void drawString(String[] str, int x, int y, int startLine, int lines, int offY, byte anchor, int layer) {
        Paint.type[Paint.paintIndex] = 10;
        Paint.layers[Paint.paintIndex] = (short)layer;
        Paint.posX[Paint.paintIndex] = (short)x;
        Paint.posY[Paint.paintIndex] = (short)y;
        Paint.anchors[Paint.paintIndex] = anchor;
        Paint.data_a[Paint.paintIndex] = (short)startLine;
        Paint.data_b[Paint.paintIndex] = (short)lines;
        Paint.data_c[Paint.paintIndex] = (short)offY;
        Paint.data_d[Paint.paintIndex] = (short)array.size();
        array.addElement(str);
        Paint.insertObj();
    }

    public static void drawTalk(String[] str, int x, int y, int startLine, int endLine, int endIndex, int offY, int layer) {
        Paint.type[Paint.paintIndex] = 11;
        Paint.layers[Paint.paintIndex] = (short)layer;
        Paint.posX[Paint.paintIndex] = (short)x;
        Paint.posY[Paint.paintIndex] = (short)y;
        Paint.data_a[Paint.paintIndex] = (short)startLine;
        Paint.data_b[Paint.paintIndex] = (short)endLine;
        Paint.data_c[Paint.paintIndex] = (short)endIndex;
        Paint.data_d[Paint.paintIndex] = (short)offY;
        Paint.data_int[Paint.paintIndex] = (short)array.size();
        array.addElement(str);
        Paint.insertObj();
    }

    public static void drawNum(int num, int id, int x, int y, int row, int color, int length, int spacing, byte anchor, int layer) {
        Paint.type[Paint.paintIndex] = 6;
        Paint.layers[Paint.paintIndex] = (short)layer;
        Paint.posX[Paint.paintIndex] = (short)x;
        Paint.posY[Paint.paintIndex] = (short)y;
        Paint.anchors[Paint.paintIndex] = anchor;
        Paint.data_a[Paint.paintIndex] = (short)id;
        Paint.data_b[Paint.paintIndex] = (short)(row << 8 | color & 0xFF);
        Paint.data_c[Paint.paintIndex] = (short)(length << 8 | spacing & 0xFF);
        Paint.data_int[Paint.paintIndex] = num;
        Paint.insertObj();
    }

    public static void drawNum(int num, int id, int x, int y, int length, int spacing, byte anchor, int layer) {
        Paint.drawNum(num, id, x, y, 1, 0, length, spacing, anchor, layer);
    }

    public static void drawPane(int imgIndex, int x, int y, int w, int h, int layer) {
        Paint.type[Paint.paintIndex] = 7;
        Paint.layers[Paint.paintIndex] = (short)layer;
        Paint.posX[Paint.paintIndex] = (short)x;
        Paint.posY[Paint.paintIndex] = (short)y;
        Paint.anchors[Paint.paintIndex] = 20;
        Paint.data_a[Paint.paintIndex] = (short)w;
        Paint.data_b[Paint.paintIndex] = (short)h;
        Paint.data_int[Paint.paintIndex] = imgIndex;
        Paint.insertObj();
    }

    public static void drawFrame(int id, byte[][] clipData, byte[][] frameData, int x, int y, int index, byte tran, byte anchor, int layer) {
        short h;
        short w = Paint.getFrameHeight(frameData[index]);
        if (Paint.inScreen(x, y, w, h = Paint.getFrameWidth(frameData[index]), anchor)) {
            Paint.type[Paint.paintIndex] = 8;
            Paint.layers[Paint.paintIndex] = (short)layer;
            Paint.posX[Paint.paintIndex] = (short)x;
            Paint.posY[Paint.paintIndex] = (short)y;
            Paint.anchors[Paint.paintIndex] = anchor;
            Paint.trans[Paint.paintIndex] = tran;
            Paint.data_a[Paint.paintIndex] = (short)array.size();
            array.addElement(clipData);
            Paint.data_b[Paint.paintIndex] = (short)array.size();
            array.addElement(frameData);
            Paint.data_c[Paint.paintIndex] = (short)index;
            Paint.data_int[Paint.paintIndex] = id;
            Paint.insertObj();
        }
    }

    public static void drawImage(int id, int x, int y, int cx, int cy, int cw, int ch, byte anchor, byte tran, int layer) {
        if (Paint.inScreen(x, y, cw, ch, anchor)) {
            Paint.type[Paint.paintIndex] = 5;
            Paint.layers[Paint.paintIndex] = (short)layer;
            Paint.posX[Paint.paintIndex] = (short)x;
            Paint.posY[Paint.paintIndex] = (short)y;
            Paint.anchors[Paint.paintIndex] = anchor;
            Paint.trans[Paint.paintIndex] = tran;
            Paint.data_a[Paint.paintIndex] = (short)cx;
            Paint.data_b[Paint.paintIndex] = (short)cy;
            Paint.data_c[Paint.paintIndex] = (short)cw;
            Paint.data_d[Paint.paintIndex] = (short)ch;
            Paint.data_int[Paint.paintIndex] = id;
            Paint.insertObj();
        }
    }

    public static void drawImage(int id, int x, int y, byte anchor, byte trans, int layer) {
        int cw = images[id].getWidth();
        int ch = images[id].getHeight();
        Paint.drawImage(id, x, y, 0, 0, cw, ch, anchor, trans, layer);
    }

    public static void drawImage(int id, int x, int y, byte[] clip, byte anchor, byte trans, int layer) {
        Paint.drawImage(id, x, y, clip[0], clip[1], clip[2], clip[3], anchor, trans, layer);
    }

    public static void drawImage(int id, int x, int y, short[] clip, byte anchor, byte trans, int layer) {
        Paint.drawImage(id, x, y, clip[0], clip[1], clip[2], clip[3], anchor, trans, layer);
    }

    public static void drawImage(int id, int x, int y, int[] clip, byte anchor, byte trans, int layer) {
        Paint.drawImage(id, x, y, clip[0], clip[1], clip[2], clip[3], anchor, trans, layer);
    }

    public static void drawGridImage(int id, int x, int y, int colCount, int rowCount, int col, int row, byte anchor, byte trans, int layer) {
        int w = images[id].getWidth();
        int h = images[id].getHeight();
        int cw = w / colCount;
        int ch = h / rowCount;
        int cx = cw * col;
        int cy = ch * row;
        Paint.drawImage(id, x, y, cx, cy, cw, ch, anchor, trans, layer);
    }

    public static void drawImage(Image img, int x, int y, byte anchor, byte tran, int layer) {
        if (Paint.inScreen(x, y, img.getWidth(), img.getHeight(), anchor)) {
            Paint.type[Paint.paintIndex] = 17;
            Paint.layers[Paint.paintIndex] = (short)layer;
            Paint.posX[Paint.paintIndex] = (short)x;
            Paint.posY[Paint.paintIndex] = (short)y;
            Paint.anchors[Paint.paintIndex] = anchor;
            Paint.trans[Paint.paintIndex] = tran;
            Paint.data_int[Paint.paintIndex] = (short)array.size();
            array.addElement(img);
            Paint.insertObj();
        }
    }

    public static void drawImage(int[] rgbData, int x, int y, int w, int h, byte anchor, boolean processAlpha, int layer) {
        Paint.changeAnchor(x, y, w, h, anchor);
        if (Paint.inScreen(x, y, w, h, anchor)) {
            Paint.type[Paint.paintIndex] = 18;
            Paint.layers[Paint.paintIndex] = (short)layer;
            Paint.posX[Paint.paintIndex] = (short)posx;
            Paint.posY[Paint.paintIndex] = (short)posy;
            Paint.data_a[Paint.paintIndex] = (short)w;
            Paint.data_b[Paint.paintIndex] = (short)h;
            Paint.trans[Paint.paintIndex] = (byte)(processAlpha ? 1 : 0);
            Paint.data_int[Paint.paintIndex] = (short)array.size();
            array.addElement(rgbData);
            Paint.insertObj();
        }
    }

    public static void screenCapture(int[] rgbData, int x, int y, int w, int h, int grayScale, int layer) {
        Paint.type[Paint.paintIndex] = 19;
        Paint.layers[Paint.paintIndex] = (short)layer;
        Paint.posX[Paint.paintIndex] = (short)(screenX + x);
        Paint.posY[Paint.paintIndex] = (short)(screenY + y);
        Paint.data_a[Paint.paintIndex] = (short)w;
        Paint.data_b[Paint.paintIndex] = (short)h;
        Paint.data_c[Paint.paintIndex] = (short)grayScale;
        Paint.data_int[Paint.paintIndex] = (short)array.size();
        array.addElement(rgbData);
        Paint.insertObj();
    }

    public static void drawMask(int x, int y, int w, int h, int alpha, int layer) {
        if (Paint.inScreen(x, y, w, h, (byte)20)) {
            Paint.type[Paint.paintIndex] = 12;
            Paint.layers[Paint.paintIndex] = (short)layer;
            Paint.posX[Paint.paintIndex] = (short)x;
            Paint.posY[Paint.paintIndex] = (short)y;
            Paint.data_a[Paint.paintIndex] = (short)w;
            Paint.data_b[Paint.paintIndex] = (short)h;
            Paint.data_int[Paint.paintIndex] = alpha;
            Paint.insertObj();
        }
    }

    public static void drawEffect(int id, int x, int y, int index, byte tran, int layer) {
        Paint.type[Paint.paintIndex] = 13;
        Paint.layers[Paint.paintIndex] = (short)layer;
        Paint.posX[Paint.paintIndex] = (short)x;
        Paint.posY[Paint.paintIndex] = (short)y;
        Paint.trans[Paint.paintIndex] = tran;
        Paint.data_a[Paint.paintIndex] = (short)id;
        Paint.data_b[Paint.paintIndex] = (short)index;
        Paint.insertObj();
    }

    public static void drawPass(int id, int index, int color, boolean isOpen, int layer) {
        Paint.type[Paint.paintIndex] = 14;
        Paint.layers[Paint.paintIndex] = (short)layer;
        Paint.trans[Paint.paintIndex] = (byte)(isOpen ? 1 : 0);
        Paint.data_a[Paint.paintIndex] = (short)id;
        Paint.data_b[Paint.paintIndex] = (short)index;
        Paint.data_int[Paint.paintIndex] = color;
        Paint.insertObj();
    }

    public static void drawSpeedLine(short[][] data, int dir, int layer) {
        Paint.type[Paint.paintIndex] = 15;
        Paint.layers[Paint.paintIndex] = (short)layer;
        Paint.trans[Paint.paintIndex] = (byte)dir;
        Paint.data_a[Paint.paintIndex] = (short)array.size();
        array.addElement(data);
        Paint.insertObj();
    }

    public static void drawWeather(int id, byte[][] clip, short[][] data, int layer) {
        Paint.type[Paint.paintIndex] = 16;
        Paint.data_a[Paint.paintIndex] = (short)array.size();
        array.addElement(clip);
        Paint.data_b[Paint.paintIndex] = (short)array.size();
        array.addElement(data);
        Paint.layers[Paint.paintIndex] = (short)layer;
        Paint.data_int[Paint.paintIndex] = id;
        Paint.insertObj();
    }

    public static void drawWaveNum(int num, int imgid, int x, int y, int cilpW, int cilpH, int space, int waveInterval, int drawlever, int index) {
        int number = num;
        int seat = GMath.getDigit(number) - 1;
        int totalSeat = GMath.getDigit(number) - 1;
        int step = 0;
        while (seat >= 0) {
            byte addy = wave[Math.min(Math.max(index - (totalSeat - seat) * waveInterval, 0), wave.length - 1)];
            Paint.drawImage(imgid, x + step, y + addy, number / GMath.power(10, seat) * cilpW, 0, cilpW, cilpH, (byte)36, (byte)0, drawlever);
            number %= GMath.power(10, seat);
            --seat;
            step += cilpW + space;
        }
        ++index;
    }

    public static void paintClipImage(Graphics g, Image img, int x, int y, int clipX, int clipY, int clipW, int clipH, byte anchor, int trans) {
        if (img == null) {
            return;
        }
        int mode = 0;
        switch (trans) {
            case 1: {
                mode = 2;
                break;
            }
            case 2: {
                mode = 1;
                break;
            }
            case 3: {
                mode = 3;
            }
        }
        if (clipW <= 0 || clipH <= 0 || clipX < 0 || clipY < 0) {
            return;
        }
        if (clipX + clipW > img.getWidth()) {
            clipW = img.getWidth() - clipX;
        }
        if (clipY + clipH > img.getHeight()) {
            clipH = img.getHeight() - clipY;
        }
        g.drawRegion(img, clipX, clipY, clipW, clipH, mode, x, y, (int)anchor);
    }

    public static void paintClipImage(Graphics g, int id, int x, int y, int clipX, int clipY, int clipW, int clipH, byte anchor, int trans) {
        Paint.paintClipImage(g, images[id], x, y, clipX, clipY, clipW, clipH, anchor, trans);
    }

    public static void paintString(Graphics g, String string, int x, int y, byte anchor, int color) {
        if ((anchor & 2) != 0) {
            y += GCanvas.strHeight / 2 - 1;
            anchor = (byte)(anchor - 2 + 32);
        }
        g.setColor(color);
        g.drawString(string, x, y, (int)anchor);
    }

    public static void paintString(Graphics g, String[] str, int x, int y, int startL, int lines, int offY, byte anchor) {
        if (str == null) {
            return;
        }
        Paint.setFontStyle('A');
        int end = Math.min(startL + lines, str.length);
        int i = startL;
        while (i < end) {
            int sx = 0;
            int sy = 0;
            int strW = 0;
            StringBuffer sb = new StringBuffer();
            boolean isTop = true;
            if ((anchor & 2) != 0) {
                sy = -(offY * (lines - 1) - GCanvas.strHeight) / 2 - 1;
                isTop = false;
            } else if ((anchor & 0x20) != 0) {
                sy = -offY * (lines - 1);
                isTop = false;
            }
            if ((anchor & 4) == 0) {
                int lineW = Paint.getStringWidth(str[i]);
                if ((anchor & 1) != 0) {
                    sx = -lineW / 2;
                } else if ((anchor & 8) != 0) {
                    sx = -lineW;
                }
            }
            int j = 0;
            while (j < str[i].length()) {
                char c = str[i].charAt(j);
                if (c != '#') {
                    sb.append(c);
                    strW += GCanvas.FONT_SMALL.charWidth(c);
                } else if (str[i].charAt(j + 1) == '#') {
                    sb.append(c);
                    strW += GCanvas.FONT_SMALL.charWidth(c);
                    ++j;
                } else {
                    Paint.outString(g, sb, x + sx, y + sy + offY * (i - startL), isTop);
                    sb.setLength(0);
                    sx += strW;
                    strW = 0;
                    Paint.setFontStyle(str[i].charAt(j + 1));
                    ++j;
                }
                ++j;
            }
            Paint.outString(g, sb, x + sx, y + sy + offY * (i - startL), isTop);
            sb.setLength(0);
            ++i;
        }
    }

    public static int getStringWidth(String str) {
        int lineW = 0;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '#') {
                if (str.charAt(i + 1) == '#') {
                    lineW += GCanvas.FONT_SMALL.charWidth(c);
                }
                ++i;
            } else {
                lineW += GCanvas.FONT_SMALL.charWidth(c);
            }
            ++i;
        }
        return lineW;
    }

    private static void outString(Graphics g, StringBuffer sb, int x, int y, boolean isTop) {
        if (sb.length() <= 0) {
            return;
        }
        int anchor = isTop ? 20 : 36;
        String str = sb.toString();
        switch (fontMode) {
            case 1: {
                g.setColor(color1);
                g.drawString(str, x + 1, y, anchor);
                break;
            }
            case 2: {
                g.setColor(color2);
                g.drawString(str, x - 1, y, anchor);
                g.drawString(str, x, y - 1, anchor);
                g.drawString(str, x + 1, y, anchor);
                g.drawString(str, x, y + 1, anchor);
                break;
            }
            case 3: {
                g.setColor(color2);
                g.drawString(str, x + 1, y + 1, anchor);
            }
        }
        g.setColor(color1);
        g.drawString(str, x, y, anchor);
    }

    private static void paintFrame(Graphics g, int imgIndex, byte[][] clipData, byte[][] frameData, int x, int y, int index, byte tran) {
        byte[] data = frameData[index];
        int h = Paint.unsignedByte(data[2]) << 8 | Paint.unsignedByte(data[3]);
        int k = 4;
        while (k < data.length) {
            int cx = Paint.unsignedByte(clipData[data[k]][0]);
            int cy = Paint.unsignedByte(clipData[data[k]][1]);
            int cw = Paint.unsignedByte(clipData[data[k]][2]);
            int ch = Paint.unsignedByte(clipData[data[k]][3]);
            int offX = Paint.unsignedByte(data[k + (tran % 2 == 1 ? 3 : 1)]);
            int offY = tran / 2 == 0 ? Paint.unsignedByte(data[k + 2]) : h - Paint.unsignedByte(data[k + 2]) - ch;
            Paint.paintClipImage(g, imgIndex, x + offX, y + offY, cx, cy, cw, ch, (byte)20, tran ^ data[k + 4]);
            k += 5;
        }
    }

    public static void paintTalk(Graphics g, String[] str, int x, int y, int startL, int endL, int endI, int offY) {
        int line = Math.min(str.length - 1, endL);
        int i = startL;
        while (i <= line) {
            int sx = 0;
            int strW = 0;
            StringBuffer sb = new StringBuffer();
            int len = i == endL ? Math.min(endI, str[i].length()) : str[i].length();
            int j = 0;
            while (j < len) {
                char c = str[i].charAt(j);
                if (c == '#') {
                    Paint.outString(g, sb, x + sx, y + offY * (i - startL), true);
                    sb.setLength(0);
                    sx += strW;
                    strW = 0;
                    Paint.setFontStyle(str[i].charAt(j + 1));
                    ++j;
                } else {
                    sb.append(c);
                    strW += GCanvas.FONT_SMALL.charWidth(c);
                }
                ++j;
            }
            Paint.outString(g, sb, x + sx, y + offY * (i - startL), true);
            sb.setLength(0);
            ++i;
        }
    }

    public static final boolean inScreen(int x, int y, int w, int h, byte anchor) {
        Paint.changeAnchor(x, y, w, h, anchor);
        return posx - screenX > -w && posx - screenX < 240 || posy - screenY <= -h || posy - screenY >= 320;
    }

    private static void changeAnchor(int x, int y, int w, int h, int anchor) {
        posx = x;
        posy = y;
        if ((anchor & 8) != 0) {
            posx -= w;
        } else if ((anchor & 1) != 0) {
            posx -= w / 2;
        }
        if ((anchor & 0x20) != 0) {
            posy -= h;
        } else if ((anchor & 2) != 0) {
            posy -= h / 2;
        }
    }

    public static String[] setBr(String str, int w, char defalutColor) {
        return Paint.setBr(new String[]{str}, w, defalutColor);
    }

    public static String[] setBr(String[] str, int w, char defalutColor) {
        Vector<String> v = new Vector<String>();
        char color = defalutColor;
        StringBuffer line = new StringBuffer("");
        boolean pound = false;
        int i = 0;
        while (i < str.length) {
            int cw = 0;
            line.setLength(0);
            line.append('#');
            line.append(color);
            int j = 0;
            while (j < str[i].length()) {
                char c = str[i].charAt(j);
                if (c == '#' || pound) {
                    boolean bl = pound = !pound;
                    if (c != '#') {
                        color = c == 'A' ? defalutColor : c;
                        line.append(color);
                    } else {
                        line.append(c);
                    }
                } else if (c != '\r') {
                    if (c == '\\' || c == '\n') {
                        v.addElement(new String(line));
                        line.setLength(0);
                        line.append('#');
                        line.append(color);
                        cw = 0;
                    } else {
                        int width = GCanvas.FONT_SMALL.charWidth(c);
                        if (cw + width <= w) {
                            cw += width;
                            line.append(c);
                        } else {
                            v.addElement(new String(line));
                            line.setLength(0);
                            line.append('#');
                            line.append(color);
                            line.append(c);
                            cw = width;
                        }
                    }
                }
                ++j;
            }
            v.addElement(new String(line));
            ++i;
        }
        Object[] array = new String[v.size()];
        v.copyInto(array);
        return array;
    }

    static void paintEffect(Graphics g, int id, int x, int y, int index, int tran) {
        byte[][] clip = Effect.clipData[id];
        byte[][] frame = Effect.frameData[id];
        byte[][] motion = Effect.motionData[id];
        int mIndex = Paint.getMotionValue(motion[index %= motion.length], 0);
        int mTran = Paint.getMotionValue(motion[index], 2);
        byte trans = (byte)(mTran ^ tran);
        int left = Paint.getMotionValue(motion[index], 3);
        int right = Paint.getMotionValue(motion[index], 4);
        int top = Paint.getMotionValue(motion[index], 5);
        int bottom = Paint.getMotionValue(motion[index], 6);
        id = Effect.imgID[id];
        x -= tran % 2 == 0 ? left : right;
        y -= trans / 2 == 0 ? top : bottom;
        if (clip == null) {
            Paint.paintClipImage(g, id, x, y, 0, 0, images[id].getWidth(), images[id].getHeight(), (byte)36, (int)trans);
        } else if (frame == null) {
            Paint.paintClipImage(g, id, x, y, (int)clip[mIndex][0], (int)clip[mIndex][1], (int)clip[mIndex][2], (int)clip[mIndex][3], (byte)36, (int)trans);
        } else {
            Paint.paintFrame(g, id, clip, frame, x, y -= Paint.getFrameHeight(frame[mIndex]), mIndex, trans);
        }
    }

    private static void paintNum(Graphics g, int number, int id, int x, int y, int row, int color, int len, int spacing, byte anchor) {
        int cw = images[id].getWidth() / len;
        int ch = images[id].getHeight() / row;
        String num = Integer.toString(number);
        int count = num.length();
        int w = count * cw + (count - 1) * spacing;
        Paint.changeAnchor(x, y, w, ch, anchor);
        int i = 0;
        while (i < count) {
            int sx = posx + (cw + spacing) * i;
            int n = num.charAt(i) - 48;
            Paint.paintClipImage(g, id, sx, posy, n * cw, ch * color, cw, ch, (byte)20, 0);
            ++i;
        }
    }

    public static int getImageColor(Image img, int x, int y) {
        int[] p = new int[1];
        img.getRGB(p, 0, 1, x, y, 1, 1);
        return p[0];
    }

    private static void paintPane(Graphics g, int id, int x, int y, int w, int h) {
        int col = Paint.getImageColor(images[id], 0, 0);
        g.setColor(col);
        g.fillRect(x + 3, y + 3, w - 6, h - 6);
        int tileH = images[id].getHeight();
        int lenw = (w - tileH - 1) / tileH;
        int lenh = (h - tileH - 1) / tileH;
        int i = 0;
        while (i < lenw) {
            Paint.paintClipImage(g, id, x + tileH + i * tileH, y, tileH, 0, tileH, tileH, (byte)20, 0);
            Paint.paintClipImage(g, id, x + tileH + i * tileH, y + h - tileH, tileH, 0, tileH, tileH, (byte)20, 2);
            ++i;
        }
        int i2 = 0;
        while (i2 < lenh) {
            Paint.paintClipImage(g, id, x, y + tileH + i2 * tileH, tileH * 2, 0, tileH, tileH, (byte)20, 0);
            Paint.paintClipImage(g, id, x + w - tileH, y + tileH + i2 * tileH, tileH * 2, 0, tileH, tileH, (byte)20, 1);
            ++i2;
        }
        Paint.paintClipImage(g, id, x, y, 0, 0, tileH, tileH, (byte)20, 3);
        Paint.paintClipImage(g, id, x + w - tileH, y, 0, 0, tileH, tileH, (byte)20, 2);
        Paint.paintClipImage(g, id, x, y + h - tileH, 0, 0, tileH, tileH, (byte)20, 1);
        Paint.paintClipImage(g, id, x + w - tileH, y + h - tileH, 0, 0, tileH, tileH, (byte)20, 0);
    }

    private static void paintPass(Graphics g, int id, int index, int color, boolean isOpen) {
        g.setColor(color);
        switch (id) {
            case 0: {
                int size = 40;
                int w = 240 / size;
                int h = 320 / size;
                index = Math.min(index, 12);
                index = isOpen ? 12 - index : index;
                int i = 0;
                while (i < w) {
                    int j = 0;
                    while (j < h) {
                        g.setClip(i * size, j * size, size, size);
                        g.fillArc(i * size - size / 4, j * size - size / 4, size * 3 / 2, size * 3 / 2, 90, index * 30);
                        ++j;
                    }
                    ++i;
                }
                g.setClip(0, 0, 240, 320);
                break;
            }
            case 1: {
                int size = 20;
                int w = 240 / size + 1;
                int h = 320 / size;
                index = Math.min(index, 10);
                index = isOpen ? index : 10 - index;
                int i = 0;
                while (i < h) {
                    int j = 0;
                    while (j < w) {
                        if (j % 2 == 0) {
                            g.fillTriangle(j * size, i * size + index * 2, (j - 1) * size, (i + 1) * size, (j + 1) * size, (i + 1) * size);
                        } else {
                            g.fillTriangle((j - 1) * size, i * size, (j + 1) * size, i * size, j * size, (i + 1) * size - index * 2);
                        }
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                short max_y;
                short max_x;
                index = Math.min(index, 15);
                index = isOpen ? index : 15 - index;
                int size = 10 + index * 22;
                int angle = GCanvas.gameTime % 40 * 9;
                short sx = 120;
                short sy = 160;
                short[][] ang1 = new short[5][2];
                short[][] ang2 = new short[5][2];
                short min_x = max_x = sx;
                short min_y = max_y = sy;
                int i = 0;
                while (i < 5) {
                    ang1[i][0] = (short)(sx + size * GMath.sin256(i * 72 + angle) / 256);
                    ang1[i][1] = (short)(sy + size * GMath.cos256(i * 72 + angle) / 256);
                    min_x = (short)Math.min(ang1[i][0], min_x);
                    min_y = (short)Math.min(ang1[i][1], min_y);
                    max_x = (short)Math.max(ang1[i][0], max_x);
                    max_y = (short)Math.max(ang1[i][1], max_y);
                    ang2[i][0] = (short)(sx + size * GMath.sin256(i * 72 + angle + 36) / 256 / 2);
                    ang2[i][1] = (short)(sy + size * GMath.cos256(i * 72 + angle + 36) / 256 / 2);
                    ++i;
                }
                int i2 = 0;
                while (i2 < 5) {
                    short temp;
                    short x1 = ang1[i2][0];
                    short y1 = ang1[i2][1];
                    short x2 = ang1[(i2 + 1) % 5][0];
                    short y2 = ang1[(i2 + 1) % 5][1];
                    g.fillTriangle((int)x1, (int)y1, (int)x2, (int)y2, (int)ang2[i2][0], (int)ang2[i2][1]);
                    short rect_x = -1;
                    short rect_y = -1;
                    if (x1 == min_x || x2 == min_x) {
                        rect_x = min_x;
                    } else if (x1 == max_x || x2 == max_x) {
                        rect_x = max_x;
                    }
                    if (y1 == min_y || y2 == min_y) {
                        rect_y = min_y;
                    } else if (y1 == max_y || y2 == max_y) {
                        rect_y = max_y;
                    }
                    if (rect_x == -1) {
                        temp = y1 == rect_y ? x2 : x1;
                        rect_x = Math.abs(temp - min_x) < Math.abs(temp - max_x) ? min_x : max_x;
                    } else if (rect_y == -1) {
                        temp = x1 == rect_x ? y2 : y1;
                        rect_y = Math.abs(temp - min_y) < Math.abs(temp - max_y) ? min_y : max_y;
                    }
                    g.fillTriangle((int)x1, (int)y1, (int)x2, (int)y2, (int)rect_x, (int)rect_y);
                    ++i2;
                }
                g.fillRect(0, 0, 240, (int)min_y);
                g.fillRect(0, (int)min_y, (int)min_x, max_y - min_y);
                g.fillRect((int)max_x, (int)min_y, 240 - max_x, max_y - min_y);
                g.fillRect(0, (int)max_y, 240, 320 - max_y);
            }
        }
    }

    private static void paintSpeedLine(Graphics g, short[][] data, int dir) {
        int[][] color = new int[][]{{0x20FFFFFF, 0x40FFFFFF, 0x60FFFFFF, -2130706433, -1593835521, -1056964609, -520093697}, {-520093697, -1056964609, -1593835521, -2130706433, 0x60FFFFFF, 0x40FFFFFF, 0x20FFFFFF}};
        g.setColor(0xFFFFFF);
        int i = 1;
        while (i < data.length) {
            short len = data[i][2];
            short x = data[i][0];
            short y = data[i][1];
            if (dir == 0) {
                if (Engine.imageQuality) {
                    g.drawRGB(color[0], 0, 7, (int)x, (int)y, 7, 1, true);
                    g.drawLine(x + 7, (int)y, x + len - 14, (int)y);
                    g.drawRGB(color[1], 0, 7, x + len - 14, (int)y, 7, 1, true);
                } else {
                    g.drawLine((int)x, (int)y, x + len, (int)y);
                }
            } else if (Engine.imageQuality) {
                g.drawRGB(color[0], 0, 1, (int)x, (int)y, 1, 7, true);
                g.drawLine((int)x, y + 7, (int)x, y + len - 14);
                g.drawRGB(color[1], 0, 1, (int)x, y + len - 14, 1, 7, true);
            } else {
                g.drawLine((int)x, (int)y, (int)x, y + len);
            }
            ++i;
        }
    }

    public static int mixAlphaColor(int color1, int color2) {
        int alpha1 = color1 >>> 24;
        int alpha2 = color2 >>> 24;
        if (alpha2 == 0) {
            return color1;
        }
        if (alpha2 == 255) {
            return color2;
        }
        int alpha = 255 - (255 - alpha1) * (255 - alpha2) / 255;
        int c = alpha1 * (255 - alpha2) / 255;
        int red = (color1 >>> 16 & 0xFF) * c / 255 + (color2 >>> 16 & 0xFF) * alpha2 / 255;
        red = red * 255 / alpha;
        int green = (color1 >>> 8 & 0xFF) * c / 255 + (color2 >>> 8 & 0xFF) * alpha2 / 255;
        green = green * 255 / alpha;
        int blue = (color1 & 0xFF) * c / 255 + (color2 & 0xFF) * alpha2 / 255;
        blue = blue * 255 / alpha;
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    static int getMotionValue(byte[] mData, int type) {
        switch (type) {
            case 0: {
                return Paint.unsignedByte(mData[0]);
            }
            case 1: {
                return mData[1] >> 2 & 0x3F;
            }
            case 2: {
                return mData[1] & 3;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                int[] temp = new int[5];
                int i = 0;
                while (i < temp.length) {
                    temp[i] = Paint.unsignedByte(mData[i + 2]);
                    ++i;
                }
                int off = temp[type - 3] << 8 | temp[type - 2];
                off = ((off = off >> (6 - type) * 2 & 0x3FF) & 0x200) != 0 ? -(off & 0x1FF) : off;
                return off;
            }
        }
        System.out.println("motion value error!");
        return Integer.MAX_VALUE;
    }

    public static void setFontStyle(char c) {
        switch (c) {
            case 'A': {
                color1 = 15720599;
                break;
            }
            case 'B': {
                color1 = 4662022;
                break;
            }
            case 'C': {
                color1 = 0xFF0000;
                break;
            }
            case 'D': {
                color1 = 15256682;
                color2 = 8931841;
                break;
            }
            case 'E': {
                color1 = 5694531;
                color2 = 2392343;
                break;
            }
            case 'F': {
                color1 = 1825012;
                color2 = 26744;
                break;
            }
            case 'G': {
                color1 = 13402879;
                color2 = 7738809;
                break;
            }
            case 'H': {
                color1 = 16491302;
                color2 = 10446357;
                break;
            }
            case 'I': {
                color1 = 16063773;
                color2 = 8984343;
                break;
            }
            case 'J': {
                color1 = 0xFFF727;
                color2 = 10328067;
                break;
            }
            case 'W': {
                color1 = 6045999;
            }
        }
        fontMode = Paint.getFontMode(c);
    }

    public static byte getFontMode(char c) {
        switch (c) {
            case 'D': {
                return 3;
            }
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': {
                return 2;
            }
            case 'C': {
                return 1;
            }
        }
        return 0;
    }

    public static int getColor(char c, boolean main) {
        Paint.setFontStyle(c);
        return main ? color1 : color2;
    }

    static {
        paintIndex = 0;
        objCount = 0;
        paintOrder = new short[400];
        type = new byte[400];
        posX = new short[400];
        posY = new short[400];
        layers = new short[400];
        anchors = new byte[400];
        trans = new byte[400];
        string = new String[400];
        array = new Vector();
        data_a = new short[400];
        data_b = new short[400];
        data_c = new short[400];
        data_d = new short[400];
        data_int = new int[400];
        rgbData = new int[240];
        wave = new byte[]{0, -6, -10, -11, -12, -11, -10, -6, 0};
    }
}

