/*
 * Decompiled with CFR 0.152.
 */
public class Sprite {
    short mode;
    byte level;
    byte curStatus;
    byte nextStatus;
    byte curIndex;
    int index;
    int x;
    int y;
    int dir;
    int faceDir;
    int sx;
    int sy;
    int w;
    int h;
    boolean visible;
    boolean isGeneral;
    byte trans;
    byte frameTimes;
    boolean attackFrame;
    byte[] moveXY;
    byte moveType;
    int offDegrees;
    int[] degrees;
    int nextDegrees;
    int alf;
    byte flashMode;
    int scale;
    short shadowImg;
    final byte FRAME_W = (byte)40;
    final byte FRAME_H = (byte)40;
    final byte degreesSpeed = (byte)20;
    public static final byte FM_FLASH = 0;
    public static final byte FM_DEGREES = 1;
    public static final byte FM_TRANS = 2;
    public static final byte FM_CHANNELING = 3;
    public static final byte FM_DEGREESCHANNELING = 4;
    public static final byte ST_STOP = -1;
    public static final byte ST_MOVE = -2;
    public static final byte ST_ATTACK = -3;
    public static final byte ST_STOPTURN = -4;
    public static final byte ST_ATTACKTURN = -5;
    public static final byte ST_DEADTRUN = -6;
    public static final byte ST_INCURE = -7;
    public static final byte ST_STOP_DOWN = 0;
    public static final byte ST_STOP_UP = 1;
    public static final byte ST_STOP_LEFT = 2;
    public static final byte ST_STOP_RIGHT = 3;
    public static final byte ST_MOVE_DOWN = 4;
    public static final byte ST_MOVE_UP = 5;
    public static final byte ST_MOVE_LEFT = 6;
    public static final byte ST_MOVE_RIGHT = 7;
    public static final byte ST_ATTACK_DOWN = 8;
    public static final byte ST_ATTACK_UP = 9;
    public static final byte ST_ATTACK_LEFT = 10;
    public static final byte ST_ATTACK_RIGHT = 11;
    public static final byte ST_JUMP_RIGHT = 12;
    public static final byte ST_DEAD = 13;
    public static final byte ST_PUT = 14;
    public static final byte ST_CREATEING = 15;
    public static final byte ST_SHOW = 16;
    public static final byte ST_RUSH = 17;
    public static final byte ST_BACK = 18;
    public static final byte ST_CHANNELING = 19;
    public static final byte MT_NONE = 0;
    public static final byte M_CURINDEX = 0;
    public static final byte M_TRANS = 1;
    public static final byte M_FRAMETIMES = 2;
    public static final byte M_ADJUSTX = 3;
    public static final byte M_ADJUSTXDGX = 4;
    public static final byte M_ADJUSTY = 5;
    public static final byte M_ADJUSTYDGX = 6;
    public static final byte DIR_UP = 0;
    public static final byte DIR_RIGHT = 1;
    public static final byte DIR_DOWN = 2;
    public static final byte DIR_LEFT = 3;
    byte rushX;
    byte rushY;
    private int motionLen;
    byte upDownIndex = 0;
    static int[] upAndDown = new int[]{0, 2, 0, -2};

    public Sprite(short mode) {
        this.mode = mode;
        this.index = 0;
        this.frameTimes = 0;
    }

    void setRushXY(int rx, int ry) {
        this.rushX = (byte)rx;
        this.rushY = (byte)ry;
    }

    void run() {
        this.sx = 0;
        this.sy = 0;
        if (this.curStatus != this.nextStatus) {
            this.curStatus = this.nextStatus;
            this.frameTimes = 0;
            this.index = 0;
        }
        this.attackFrame = false;
        switch (this.curStatus) {
            case 14: {
                this.setMotionVaules((byte)0, false);
                this.frameTimes = (byte)(this.frameTimes - 1);
                if (this.frameTimes > 0 || ++this.index < this.motionLen) break;
                this.index = 0;
                this.frameTimes = 0;
                break;
            }
            case -1: 
            case 19: {
                switch (this.dir) {
                    case 2: {
                        this.setMotionVaules((byte)0, false);
                        break;
                    }
                    case 0: {
                        this.setMotionVaules((byte)1, false);
                        break;
                    }
                    case 3: {
                        this.setMotionVaules((byte)2, false);
                        break;
                    }
                    case 1: {
                        this.setMotionVaules((byte)3, false);
                    }
                }
                this.frameTimes = (byte)(this.frameTimes - 1);
                if (this.frameTimes > 0 || ++this.index < this.motionLen) break;
                this.index = 0;
                this.frameTimes = 0;
                break;
            }
            case -2: 
            case 16: {
                switch (this.dir) {
                    case 2: {
                        break;
                    }
                    case 0: {
                        this.setMotionVaules((byte)4, true);
                        break;
                    }
                    case 3: {
                        this.setMotionVaules((byte)4, true);
                        break;
                    }
                    case 1: {
                        this.setMotionVaules((byte)4, false);
                    }
                }
                this.frameTimes = (byte)(this.frameTimes - 1);
                if (this.frameTimes > 0 || ++this.index < this.motionLen) break;
                this.index = 0;
                this.frameTimes = 0;
                break;
            }
            case 17: {
                this.setMotionVaules((byte)9, false);
                this.frameTimes = (byte)(this.frameTimes - 1);
                if (this.frameTimes > 0) break;
                this.index += Rank.gameSpeed == 3 ? 2 : 1;
                if (this.index < this.motionLen) break;
                this.finishAttack();
                break;
            }
            case -3: {
                if (this.mode == 0 || this.mode == 1 || this.mode == 4 || this.mode == 10 || this.mode == 11 || this.mode == 12) {
                } else {
                    this.setMotionVaules((byte)8, false);
                }
                this.frameTimes = (byte)(this.frameTimes - 1);
                if (this.frameTimes > 0) break;
                this.index += Rank.gameSpeed == 3 ? 2 : 1;
                if (this.index < this.motionLen) break;
                this.finishAttack();
                break;
            }
        }
        this.sx += this.x;
        this.sy += this.y;
    }

    private void finishAttack() {
        switch (this.flashMode) {
            case 3: 
            case 4: {
                this.setStatus((byte)19);
                this.attackFrame = true;
                break;
            }
            default: {
                this.setStatus((byte)-1);
                this.attackFrame = true;
            }
        }
    }

    void setMotionVaules(byte status, boolean mir) {
        this.motionLen = 1;
    }

    private void setMotionVaulesZero(byte status, boolean mir) {
        this.curIndex = (byte)Engine.getMotinVaule(this.mode, status, (byte)0, 0);
        this.trans = (byte)(mir ? Engine.getMotinVaule(this.mode, status, (byte)1, 0) ^ 1 : Engine.getMotinVaule(this.mode, status, (byte)1, 0));
        this.sx += Engine.getMotinVaule(this.mode, status, mir ? (byte)4 : 3, 0) * -1;
        this.sy += Engine.getMotinVaule(this.mode, status, (byte)5, 0) * -1;
        if (this.frameTimes <= 0) {
            this.frameTimes = (byte)Engine.getMotinVaule(this.mode, status, (byte)2, 0);
        }
        this.motionLen = Engine.getMotionLength(this.mode, status);
    }

    void setStatus(byte st) {
        this.index = 0;
        this.nextStatus = st;
    }

    private int[] resiveDegrees(int[] degrees) {
        if (this.offDegrees == 0) {
            return degrees;
        }
        if (degrees == null) {
            return null;
        }
        return new int[]{(degrees[0] + this.offDegrees + 360) % 360, degrees[1], degrees[2]};
    }

    void paint(int drawLevel) {
        if (!this.visible) {
            return;
        }
        if (Tools.getImage(8, this.mode) == null) {
            Tools.loadImages(8, new String[]{String.valueOf(this.mode)});
        }
        if (this.mode == 50) {
            short[] size = Tools.getFrameSize(Data.spriteFrameData[this.mode][this.curIndex]);
            Tools.addFrame(8, this.mode, Data.spriteFrameData[this.mode], Data.spriteClipData[this.mode], this.sx + size[0] / 2, this.sy, this.curIndex, this.trans != 0, (byte)5, drawLevel, this.alf, this.scale, this.degrees);
            return;
        }
        byte by = this.upDownIndex;
        this.upDownIndex = (byte)(by + 1);
        Tools.addImage(8, this.mode, this.sx, this.sy + upAndDown[by % 4], (byte)5, 0, drawLevel);
        if (this.upDownIndex >= 19) {
            this.upDownIndex = 0;
        }
        this.drawShandow();
    }

    int getUpdateTowerIndex(int curIndex) {
        if (curIndex + this.level > 3) {
            System.out.println("Sprite[getUpdateTowerIndex] error!!! >> curIndex =  " + curIndex + ", level = " + this.level);
            return 0;
        }
        return Math.min(3, curIndex + this.level);
    }

    void paint(int level, int drawLevel) {
        int curIndex = this.getUpdateTowerIndex(this.curIndex);
        if (!this.visible) {
            return;
        }
        if (this.dir == 0 || this.dir == 2) {
            this.trans = this.dir == 0 ? (byte)2 : (byte)0;
            switch (this.mode) {
                case 0: 
                case 51: {
                    this.mode = 0;
                    break;
                }
                case 1: 
                case 52: {
                    this.mode = 1;
                    break;
                }
                case 4: 
                case 53: {
                    this.mode = (short)4;
                    break;
                }
                case 10: 
                case 54: {
                    this.mode = (short)10;
                    break;
                }
                case 11: 
                case 55: {
                    this.mode = (short)11;
                    break;
                }
                case 12: 
                case 56: {
                    this.mode = (short)12;
                    break;
                }
                default: {
                    this.trans = 0;
                }
            }
        }
        if (this.dir == 3 || this.dir == 1) {
            this.trans = this.dir == 1 ? (byte)1 : 0;
            switch (this.mode) {
                case 0: 
                case 51: {
                    this.mode = (short)51;
                    break;
                }
                case 1: 
                case 52: {
                    this.mode = (short)52;
                    break;
                }
                case 4: 
                case 53: {
                    this.mode = (short)53;
                    break;
                }
                case 10: 
                case 54: {
                    this.mode = (short)54;
                    break;
                }
                case 11: 
                case 55: {
                    this.mode = (short)55;
                    break;
                }
                case 12: 
                case 56: {
                    this.mode = (short)56;
                    break;
                }
                default: {
                    this.trans = 0;
                }
            }
        }
        if (Tools.getImage(8, this.mode) == null) {
            Tools.loadImages(8, new String[]{String.valueOf(this.mode)});
        }
        Tools.addImage(8, this.mode, this.x, this.y, (byte)4, this.trans, drawLevel);
    }

    void setFace(int ex, int ey) {
        switch (this.flashMode) {
            case 1: 
            case 4: {
                int[] nextDegrees = new int[]{Tools.getDegrees(this.x, this.y, ex, ey), this.x, this.y};
                this.setDegrees(nextDegrees);
            }
        }
        this.dir = this.getDir(this.x, this.y, ex, ey);
    }

    byte getDir(int x, int y, int aimX, int aimY) {
        int offY;
        int offX = Math.abs(aimX - x);
        if (offX <= (offY = Math.abs(aimY - y))) {
            return aimY < y ? (byte)0 : 2;
        }
        return aimX < x ? (byte)3 : 1;
    }

    private void setDegrees(int[] nextDegrees) {
        this.nextDegrees = nextDegrees[0];
        this.degrees[1] = nextDegrees[1];
        this.degrees[2] = nextDegrees[2];
        int off = nextDegrees[0] - this.degrees[0];
        this.getClass();
        int degreesSpeed = 20 * Rank.gameSpeed;
        if (Math.abs(off) <= degreesSpeed || Math.abs(off) >= 360 - degreesSpeed) {
            this.degrees[0] = nextDegrees[0];
        } else if (off < 0) {
            this.degrees[0] = off <= -180 ? this.degrees[0] + degreesSpeed : this.degrees[0] - degreesSpeed;
        } else if (off > 0) {
            this.degrees[0] = off > 180 ? this.degrees[0] - degreesSpeed : this.degrees[0] + degreesSpeed;
        }
        this.degrees[0] = (this.degrees[0] + 360) % 360;
    }

    void drawAttackEffect(int space, int drawLevel) {
        if (!this.isAttack()) {
            return;
        }
        int ex = 0;
        int ey = 0;
        int effID = -1;
        boolean trans = false;
        int dl = 2000;
        switch (this.mode) {
            case 3: {
                if (!this.isAttack()) break;
                ex = this.x;
                ey = this.y - 10;
                effID = 0;
                int[] index = new int[]{0, 1, 2, 1};
                if (Tools.getImage(3, 0) == null) {
                    Tools.loadImages(3, new String[]{String.valueOf(0)});
                }
                Tools.addGridImage(3, effID, ex, ey, 3, 1, index[GCanvas.gameTime % 4], 0, (byte)4, (byte)0, 2000);
                break;
            }
            case 4: {
                if (this.curStatus != 19) {
                    return;
                }
                int degrees = this.degrees == null ? 0 : this.degrees[0];
                int[] offXY = Tools.getDegreesXYOfSpace(degrees, space);
                if (!this.isAttack()) break;
                break;
            }
            case 11: {
                if (this.curStatus == -3 && this.index != 0) break;
            }
        }
    }

    void drawShandow() {
        if (this.shadowImg <= 0) {
            return;
        }
        Tools.addImage(0, 73, this.x, this.y, 0, this.scale, this.scale, (byte)4, (byte)0, 0, null);
    }

    boolean isAttack() {
        return this.curStatus == -3 || this.curStatus == 19 || this.curStatus == -5;
    }

    boolean degreesToAim() {
        switch (this.flashMode) {
            case 1: 
            case 4: {
                return this.degrees[0] == this.nextDegrees;
            }
        }
        return true;
    }

    boolean endThisState(byte state, byte mottionState) {
        if (this.curStatus != state) {
            return false;
        }
        int mottionLen = Engine.getMotionLength(this.mode, mottionState);
        return this.index >= mottionLen - 1;
    }
}

