/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public final class Variable {
    static final int SCRIPTVARMAX = 100;
    static int[] scriptVar = new int[100];
    static int temp;
    private static boolean isNot;
    private static boolean minus;
    private static final short T_IEXP = 0;
    private static final short T_BEXP = 1;
    private static final short T_STR = 2;
    private static final short T_ARRAY = 3;
    private static final short T_INT_B = 4;
    private static final short T_INT = 5;
    private static final short T_INT_M = 6;
    private static final short T_BOOL = 7;

    static boolean getBoolValue(String paramName) {
        String param = paramName.trim();
        if (param.equals("true")) {
            return true;
        }
        if (param.equals("false")) {
            return false;
        }
        if (param.equals("KEY_OK")) {
            return GCanvas.confirmKey;
        }
        return false;
    }

    static String getStrValue(String paramName) {
        String param = paramName.trim();
        return "!!!error string!!!";
    }

    static int getIntValue(String paramName) {
        String param = paramName.trim();
        try {
            return Integer.parseInt(paramName);
        }
        catch (NumberFormatException e) {
            String[] array = Variable.checkArray(param);
            if (array != null) {
                return Variable.getArrayValue(array);
            }
            if (param.equals("temp")) {
                return temp;
            }
            if (param.toLowerCase().equals("choice")) {
                return GCanvas.choice;
            }
            if (param.equals("money")) {
                return Engine.money;
            }
            System.out.println("get int value error !!!     " + paramName);
            return Integer.MAX_VALUE;
        }
    }

    static void set(String varName, String expression) {
        String[] array = Variable.checkArray(varName);
        int val = Variable.arithValue(expression);
        if (array != null) {
            Variable.setArrayValue(array, val);
            return;
        }
        if (varName.equals("temp")) {
            temp = Variable.arithValue(expression);
        }
    }

    private static int getArrayValue(String[] param) {
        String name = param[0];
        int id = Variable.getIntValue(param[1]);
        if (name.equals("event")) {
            return scriptVar[id];
        }
        if (name.equals("point")) {
            return Message.canSendAgian(id) ? 1 : 0;
        }
        System.out.println("get array value error !!!   " + name);
        return Integer.MAX_VALUE;
    }

    private static void setArrayValue(String[] param, int val) {
        String name = param[0];
        int id = Variable.getIntValue(param[1]);
        if (name.equals("event")) {
            Variable.scriptVar[id] = (byte)val;
        } else {
            System.out.println("set array value error !!!    " + name);
        }
    }

    static String[] splitString(String src, String key) {
        Vector<String> vt = new Vector<String>();
        int w = 0;
        boolean end = false;
        while (!end) {
            String s;
            int pos = src.indexOf(key, w);
            if (pos == -1) {
                pos = src.length();
                end = true;
            }
            int endIndex = pos;
            if (pos > 0 && src.charAt(pos - 1) == '\r') {
                endIndex = pos - 1;
            }
            if (!(s = src.substring(w, endIndex).trim()).equals("")) {
                vt.addElement(s);
            }
            w = pos + 1;
        }
        Object[] cs = new String[vt.size()];
        vt.copyInto(cs);
        vt = null;
        return cs;
    }

    static byte[] parseByteArray(String src, String key) {
        if (src == null) {
            return null;
        }
        String[] str = Variable.splitString(src, key);
        byte[] result = new byte[str.length];
        int i = 0;
        while (i < result.length) {
            result[i] = Byte.parseByte(str[i]);
            ++i;
        }
        return result;
    }

    static short[] parseShortArray(String src, String key) {
        if (src == null) {
            return null;
        }
        String[] str = Variable.splitString(src, key);
        short[] result = new short[str.length];
        int i = 0;
        while (i < result.length) {
            result[i] = Short.parseShort(str[i]);
            ++i;
        }
        return result;
    }

    private static String[] checkArray(String paramName) {
        int index = paramName.indexOf("[");
        if (index == -1) {
            return null;
        }
        String[] buff = new String[]{paramName.substring(0, index), paramName.substring(index + 1, paramName.indexOf("]"))};
        return buff;
    }

    private static String parseStr(String str) {
        StringBuffer buff = new StringBuffer();
        boolean isTxt = true;
        StringBuffer varName = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '{') {
                isTxt = false;
            } else if (c == '}') {
                isTxt = true;
                String[] s = Variable.splitString(varName.toString(), " ");
                if (s[0].equals("int")) {
                    buff.append(Variable.getIntValue(s[1]));
                } else if (s[0].equals("str")) {
                    buff.append(Variable.getStrValue(s[1]));
                }
                varName = new StringBuffer();
            } else if (isTxt) {
                buff.append(c);
            } else {
                varName.append(c);
            }
            ++i;
        }
        return buff.toString();
    }

    private static int getFlagIndex(String string) {
        int level = 0;
        int i = 0;
        while (i < string.length()) {
            char tempChar = string.charAt(i);
            if (tempChar == '(') {
                ++level;
            } else if (tempChar == ')') {
                --level;
            }
            if (i > 0 && level == 0 && (tempChar == '&' || tempChar == '@')) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static boolean getCompValue(String string) {
        int flagIndex = -1;
        int i = 0;
        while (i < string.length()) {
            char tempChar = string.charAt(i);
            if (tempChar == '>' || tempChar == '<' || tempChar == '=' || tempChar == '~') {
                flagIndex = i;
            }
            ++i;
        }
        if (flagIndex == -1) {
            boolean notIsExist;
            boolean bl = notIsExist = string.indexOf(33) != -1;
            return notIsExist ? !Variable.getBoolValue(string.substring(1, string.length())) : Variable.getBoolValue(string);
        }
        String first = string.substring(0, flagIndex);
        String second = string.substring(flagIndex + 1, string.length());
        boolean result = false;
        switch (string.charAt(flagIndex)) {
            case '>': {
                result = Variable.arithValue(first) > Variable.arithValue(second);
                break;
            }
            case '<': {
                result = Variable.arithValue(first) < Variable.arithValue(second);
                break;
            }
            case '=': {
                result = Variable.arithValue(first) == Variable.arithValue(second);
                break;
            }
            case '~': {
                result = Variable.arithValue(first) != Variable.arithValue(second);
            }
        }
        return result;
    }

    private static String getSubString(String string, int start, int end) {
        String tempString = string.substring(start, end);
        int level = 0;
        isNot = false;
        int flagStart = 0;
        int i = 0;
        while (i < tempString.length()) {
            if (tempString.charAt(i) != '!' || i != flagStart) break;
            ++flagStart;
            ++i;
        }
        if (tempString.charAt(flagStart) == '(') {
            ++level;
            int i2 = flagStart + 1;
            while (i2 < tempString.length()) {
                char tempChar = tempString.charAt(i2);
                if (tempChar == '(') {
                    ++level;
                } else if (tempChar == ')') {
                    --level;
                }
                if (level == 0 && i2 < tempString.length() - 1) {
                    return tempString;
                }
                ++i2;
            }
            boolean bl = isNot = flagStart % 2 != 0;
            if (isNot) {
                return tempString.substring(flagStart, tempString.length());
            }
            return tempString.substring(flagStart + 1, tempString.length() - 1);
        }
        return tempString;
    }

    static boolean conditionIsTrue(String condition) {
        int operator = 0;
        boolean result = false;
        int flag = 120;
        boolean isTmpNot = false;
        String allSub = condition;
        allSub = Variable.getSubString(allSub, 0, allSub.length());
        isTmpNot = isNot;
        operator = Variable.getFlagIndex(allSub);
        if (operator == -1) {
            boolean isExpression = false;
            int i = 0;
            while (i < allSub.length()) {
                char tempChar = allSub.charAt(i);
                if (tempChar == '&' || tempChar == '@' || tempChar == '(') {
                    isExpression = true;
                    break;
                }
                ++i;
            }
            if (isExpression) {
                if (isTmpNot) {
                    return !Variable.conditionIsTrue(allSub);
                }
                return Variable.conditionIsTrue(allSub);
            }
            if (isTmpNot) {
                return !Variable.getCompValue(allSub);
            }
            return Variable.getCompValue(allSub);
        }
        boolean first = Variable.conditionIsTrue(allSub.substring(0, operator));
        flag = allSub.charAt(operator);
        boolean second = Variable.conditionIsTrue(allSub.substring(operator + 1, allSub.length()));
        switch (flag) {
            case 38: {
                result = first && second;
                break;
            }
            case 64: {
                result = first || second;
            }
        }
        return result;
    }

    private static String getSubString_Var(String string, int start, int end) {
        String tempString = string.substring(start, end);
        int level = 0;
        minus = false;
        int flagStart = 0;
        int i = 0;
        while (i < tempString.length()) {
            if (tempString.charAt(i) != '^' || i != flagStart) break;
            ++flagStart;
            minus = true;
            ++i;
        }
        if (tempString.charAt(flagStart) == '(') {
            ++level;
            int i2 = flagStart + 1;
            while (i2 < tempString.length()) {
                char tempChar = tempString.charAt(i2);
                if (tempChar == '(') {
                    ++level;
                } else if (tempChar == ')') {
                    --level;
                }
                if (level == 0 && i2 < tempString.length() - 1) {
                    return tempString;
                }
                ++i2;
            }
            if (minus) {
                return tempString.substring(flagStart, tempString.length());
            }
            return tempString.substring(flagStart + 1, tempString.length() - 1);
        }
        if (minus) {
            return tempString.substring(flagStart, tempString.length());
        }
        return tempString;
    }

    private static int getFlag4Index(String string) {
        int level = 0;
        int i = 0;
        while (i < string.length()) {
            char tempChar = string.charAt(i);
            if (tempChar == '(') {
                ++level;
            } else if (tempChar == ')') {
                --level;
            }
            if (level == 0 && (tempChar == '+' || tempChar == '-' || tempChar == '*' || tempChar == '/' || tempChar == '%')) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int arithValue(String expression) {
        int operator = 0;
        int first = 0;
        int second = 0;
        int result = 0;
        int flag = 120;
        boolean isTmpminus = false;
        String allSub = expression;
        allSub = Variable.getSubString_Var(allSub, 0, allSub.length());
        isTmpminus = minus;
        operator = Variable.getFlag4Index(allSub);
        if (operator == -1) {
            boolean isExpression = false;
            int i = 0;
            while (i < allSub.length()) {
                char tempChar = allSub.charAt(i);
                if (tempChar == '+' || tempChar == '-' || tempChar == '*' || tempChar == '/' || tempChar == '%' || tempChar == '^' || tempChar == '(') {
                    isExpression = true;
                    break;
                }
                ++i;
            }
            if (isExpression) {
                if (isTmpminus) {
                    return -Variable.arithValue(allSub);
                }
                return Variable.arithValue(allSub);
            }
            if (isTmpminus) {
                return -Variable.getIntValue(allSub);
            }
            return Variable.getIntValue(allSub);
        }
        first = Variable.arithValue(allSub.substring(0, operator));
        flag = allSub.charAt(operator);
        second = Variable.arithValue(allSub.substring(operator + 1, allSub.length()));
        switch (flag) {
            case 43: {
                result = first + second;
                break;
            }
            case 45: {
                result = first - second;
                break;
            }
            case 42: {
                result = first * second;
                break;
            }
            case 47: {
                result = first / second;
                break;
            }
            case 37: {
                result = first % second;
            }
        }
        return result;
    }

    private static int getParamType(short param) {
        return param >> 13 & 7;
    }

    private static int getParamValue(short param) {
        return param & 0x1FFF;
    }

    static int getInt(short param, String[] exp, int[] bInt) {
        int type = Variable.getParamType(param);
        int value = Variable.getParamValue(param);
        switch (type) {
            case 5: {
                return value;
            }
            case 6: {
                return -value;
            }
            case 4: {
                return bInt[value];
            }
            case 0: {
                return Variable.getIntValue(exp[value]);
            }
        }
        return Integer.MAX_VALUE;
    }

    static boolean getBool(short param, String[] exp) {
        int type = Variable.getParamType(param);
        int value = Variable.getParamValue(param);
        switch (type) {
            case 7: {
                return value == 0;
            }
            case 1: {
                return Variable.conditionIsTrue(exp[value]);
            }
        }
        return false;
    }

    static String getString(short param, String[] exp) {
        int index = Variable.getParamValue(param);
        if (index == 8191) {
            return "null";
        }
        return Variable.parseStr(exp[index]);
    }

    static short[] getArray(short param, short[][] array) {
        int index = Variable.getParamValue(param);
        if (index == 8191) {
            return null;
        }
        return array[index];
    }

    static {
        isNot = false;
        minus = false;
    }
}

