/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class CtrlNumberEdit
extends CtrlBase {
    int nNumber;
    int nMaxWidth;
    int fRGB;
    int bRGB;
    boolean bReverse;
    int nMax;

    CtrlNumberEdit(int nDefault, int nMaxWidth, int fRGB, int bRGB) {
        this.bReverse = nDefault != 0;
        this.fRGB = fRGB;
        this.bRGB = bRGB;
        this.nMax = this.nNumber = nDefault;
        this.nMaxWidth = nMaxWidth;
    }

    public boolean keyPressed(int keyCode) {
        switch (keyCode) {
            case 8: 
            case 11: {
                this.codeNotify = 1;
                break;
            }
            case 1: 
            case 5: {
                ++this.nNumber;
                this.limitNumber();
                if (this.nNumber <= this.nMax) break;
                this.nNumber = this.nMax;
                break;
            }
            case 2: 
            case 6: {
                --this.nNumber;
                this.limitNumber();
                if (this.nNumber >= 1) break;
                this.nNumber = 0;
                break;
            }
            case 10: 
            case 12: {
                if (this.nNumber == 0) {
                    this.codeNotify = 32768;
                    return true;
                }
                this.nNumber /= 10;
                break;
            }
            default: {
                if (keyCode < 48 || keyCode > 57) break;
                if (this.bReverse) {
                    this.nNumber = 0;
                    this.bReverse = false;
                }
                this.nNumber = this.nNumber * 10 + (keyCode - 48);
                this.limitNumber();
            }
        }
        return true;
    }

    void limitNumber() {
        int nCount = 1;
        int n = this.nNumber;
        int nLimit = 1;
        while (n > 9) {
            ++nCount;
            n /= 10;
            nLimit *= 10;
        }
        if (nCount > this.nMaxWidth) {
            this.nNumber %= nLimit;
        }
    }

    public void paint(Graphics g, PNGList png) {
        g.setClip(this.x, this.y, this.width, this.height + 6);
        g.setColor(2115488);
        g.fillRect(this.x, this.y, this.width, this.height + 6);
        if (this.bReverse) {
            png.setFontColor(this.bRGB, this.fRGB);
        } else {
            png.setFontColor(this.fRGB, this.bRGB);
        }
        g.setColor(255, 255, 255);
        g.drawString(Integer.toString(this.nNumber), this.x + 2, this.y + 2, 20);
        if (this.focus) {
            // empty if block
        }
    }
}

