/*
 * Decompiled with CFR 0.152.
 */
public class ItemTable {
    int nMobType;
    int[] nItem = null;
    int[] nRate = null;
    TOB3 App;

    ItemTable(TOB3 App, int nMobType) {
        this.App = App;
        this.loadTable(nMobType);
    }

    ItemTable(TOB3 App, RMS rms) {
        this.App = App;
        this.load(rms);
    }

    void save(RMS rms) {
        rms.writeInt(this.nMobType);
        rms.writeInt(this.nItem.length);
        rms.writeIntArray(this.nItem);
        rms.writeIntArray(this.nRate);
    }

    void load(RMS rms) {
        this.nMobType = rms.readInt();
        int nLength = rms.readInt();
        this.nItem = new int[nLength];
        this.nRate = new int[nLength];
        rms.readIntArray(this.nItem);
        rms.readIntArray(this.nRate);
    }

    void loadTable(int nMobType) {
        this.nMobType = nMobType;
        if (nMobType < 0) {
            return;
        }
        this.App.txt.read(1, 0);
        this.App.txt.bQuickSearch = true;
        if (this.App.txt.readScene(nMobType + 100)) {
            this.generateTable(this.App.txt);
        }
        this.App.txt.bQuickSearch = false;
    }

    void generateTable(TextFile txt) {
        int nCount = 0;
        while (txt.getIntArg(nCount * 2 + 1) != 0) {
            ++nCount;
        }
        this.nItem = new int[nCount];
        this.nRate = new int[nCount];
        for (int i = 0; i < nCount; ++i) {
            this.nItem[i] = txt.getIntArg(i * 2);
            this.nRate[i] = txt.getIntArg(i * 2 + 1);
        }
    }

    void addTable(int nMobType, int item, int rate) {
        if (this.nMobType != nMobType) {
            return;
        }
        for (int i = 0; i < this.nItem.length; ++i) {
            if (item != this.nItem[i]) continue;
            return;
        }
        int[] newArray1 = new int[this.nItem.length + 1];
        int[] newArray2 = new int[this.nRate.length + 1];
        System.arraycopy(this.nItem, 0, newArray1, 0, this.nItem.length);
        System.arraycopy(this.nRate, 0, newArray2, 0, this.nRate.length);
        newArray1[this.nItem.length] = item;
        newArray2[this.nRate.length] = rate;
        this.nItem = newArray1;
        this.nRate = newArray2;
    }

    void pickOne(obj2D mob) {
        if (mob.nObjType != this.nMobType) {
            return;
        }
        int nSumRate = 0;
        for (int i = 0; i < this.nItem.length; ++i) {
            nSumRate += this.nRate[i];
        }
        int nPick = this.App.getRnd(nSumRate);
        int nAcc = 0;
        for (int i = 0; i < this.nItem.length; ++i) {
            if (nPick > (nAcc += this.nRate[i])) continue;
            mob.nDropItem = this.nItem[i];
            int r = this.nRate[i] * 100 / nSumRate;
            mob.nItemLevel = 0;
            if (r <= 20) {
                ++mob.nItemLevel;
            }
            if (r <= 5) {
                ++mob.nItemLevel;
            }
            if (mob.nObjType == 15) {
                mob.nItemLevel = 2;
            }
            if (this.nItem[i] >= 506) {
                mob.nItemLevel = 2;
            }
            if (this.nItem[i] > 300 && this.nItem[i] < 400) {
                this.nRate[i] = 0;
                this.nItem[i] = 0;
                mob.nItemLevel = 2;
            }
            return;
        }
    }

    int pickOne() {
        int nSumRate = 0;
        for (int i = 0; i < this.nItem.length; ++i) {
            nSumRate += this.nRate[i];
        }
        int nPick = this.App.getRnd(nSumRate);
        int nAcc = 0;
        for (int i = 0; i < this.nItem.length; ++i) {
            if (nPick > (nAcc += this.nRate[i])) continue;
            return this.nItem[i];
        }
        return 0;
    }
}

