/*
 * Decompiled with CFR 0.152.
 */
public class Maze {
    TOB3 App;
    static byte[] maze = new byte[4096];
    static final byte FILL = 0;
    static final byte WALL = 1;
    static final byte SPACE = 3;
    static final int NORTH = 0;
    static final int EAST = 1;
    static final int SOUTH = 2;
    static final int WEST = 3;
    static final byte EXPLORED = 64;
    int[] building = new int[3];
    int[] location = new int[60];
    int nTotalSpace = 0;
    int opened;
    int nSeed;
    int nVoidFactor;

    Maze(TOB3 App) {
        this.App = App;
    }

    static byte getMaze(int x, int y) {
        return maze[x + (y << 6)];
    }

    static void explore(obj2D hero) {
        int nPos = (hero.xLoc >> 6) + (hero.yLoc & 0xFFFFFFC0) - 65;
        int i = 0;
        while (i < 3) {
            for (int j = 0; j < 3; ++j) {
                int n = nPos++;
                maze[n] = (byte)(maze[n] | 0x40);
            }
            ++i;
            nPos += 61;
        }
    }

    void darkenMaze() {
        int i = 0;
        while (i < maze.length) {
            int n = i++;
            maze[n] = (byte)(maze[n] & 3);
        }
    }

    public void buildMaze(int nSeed, int nSize, int nVoidFactor) {
        this.nTotalSpace = nSize;
        this.initializeMaze();
        this.nSeed = nSeed;
        this.nVoidFactor = nVoidFactor;
    }

    void initializeMaze() {
        int i;
        for (i = 0; i < maze.length; ++i) {
            Maze.maze[i] = 0;
        }
        for (i = 0; i < 60; ++i) {
            this.location[i] = -1;
        }
    }

    void build2DMaze() {
        int ptrStack = 0;
        int avail = 0;
        int nPick = 0;
        boolean bTrigger = true;
        int[] direction = new int[4];
        byte[] stack = new byte[3600];
        this.opened = 1;
        this.App.rnd.setSeed(this.nSeed);
        int x = 30;
        int y = 30;
        while (this.nTotalSpace > this.opened) {
            avail = 0;
            int pos = x + (y << 6);
            if (y > 4 && maze[pos - 64] == 0) {
                direction[avail++] = 0;
            }
            if (x < 58 && maze[pos + 1] == 0) {
                direction[avail++] = 1;
            }
            if (x > 4 && maze[pos - 1] == 0) {
                direction[avail++] = 3;
            }
            if (y < 58 && maze[pos + 64] == 0) {
                direction[avail++] = 2;
            }
            if (avail > 0) {
                bTrigger = true;
                byte curDirection = (byte)direction[Math.abs(this.App.rnd.nextInt() % avail)];
                stack[ptrStack++] = curDirection;
                Maze.maze[pos] = 3;
                int key = Math.abs(this.App.rnd.nextInt());
                if (key % 100 >= this.nVoidFactor) {
                    int n = pos - 64;
                    maze[n] = (byte)(maze[n] | 1);
                    int n2 = pos + 64;
                    maze[n2] = (byte)(maze[n2] | 1);
                    int n3 = pos + 1;
                    maze[n3] = (byte)(maze[n3] | 1);
                    int n4 = pos - 1;
                    maze[n4] = (byte)(maze[n4] | 1);
                }
                ++this.opened;
                switch (curDirection) {
                    case 0: {
                        --y;
                        break;
                    }
                    case 1: {
                        ++x;
                        break;
                    }
                    case 2: {
                        ++y;
                        break;
                    }
                    case 3: {
                        --x;
                    }
                }
                continue;
            }
            if (bTrigger) {
                bTrigger = false;
                if (nPick < 60) {
                    this.location[nPick++] = x + y * 60;
                }
            }
            if (ptrStack == 0) break;
            switch (stack[--ptrStack]) {
                case 0: {
                    ++y;
                    break;
                }
                case 1: {
                    --x;
                    break;
                }
                case 2: {
                    --y;
                    break;
                }
                case 3: {
                    ++x;
                }
            }
        }
        stack = null;
        this.locateBuilding();
    }

    void locateBuilding() {
        int pos;
        int y;
        int x;
        int loc = 0;
        block0: for (x = 57; x >= 0; --x) {
            for (y = 0; y < 58; ++y) {
                pos = x + (y << 6);
                if (maze[pos] == 3 || maze[pos + 1] == 3 || maze[pos + 64] != 3 || maze[pos + 65] != 3) continue;
                if (loc > 59) break block0;
                this.location[loc++] = x * 2 + 1 + (y * 2 + 1 << 8);
                y += 2;
            }
        }
        this.building[0] = this.location[this.App.getRnd(loc)];
        loc = 0;
        block2: for (x = 0; x < 58; ++x) {
            for (y = 0; y < 58; ++y) {
                pos = x + (y << 6);
                if (maze[pos] == 3 || maze[pos + 1] != 3 || maze[pos + 64] == 3 || maze[pos + 65] != 3) continue;
                if (loc > 59) break block2;
                this.location[loc++] = x * 2 + 1 + (y * 2 + 1 << 8);
                y += 2;
            }
        }
        do {
            this.building[1] = this.location[this.App.getRnd(loc)];
            this.building[2] = this.location[this.App.getRnd(loc)];
        } while (this.building[1] == this.building[2]);
    }
}

