/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Graphics;

public class MovHit
extends MovBase {
    int keyRGB;
    int nSeed;
    int nDamage;
    int nLevel;
    int nSoundType;
    int nScale = 8;
    String strMsg;
    Random rnd;
    boolean bSoundPlayed = false;
    int frame;
    int BFrame;

    MovHit(TOB3 App, boolean bCascade) {
        super(App);
        this.nMovType = 1;
        this.nSeed = App.getRnd(0xFFFFFF);
        this.rnd = new Random(this.nSeed);
    }

    void initParam(boolean bCritical, int nDamage, obj2D mob) {
        this.bSoundPlayed = false;
        this.nScale = 8;
        this.nLevel = nDamage * 20 / mob.nHP + 1;
        if (this.nLevel > 10) {
            this.nLevel = 10;
        }
        if (nDamage > 0) {
            this.strMsg = null;
            this.keyRGB = 0xFFFF00;
            this.strMsg = Integer.toString(nDamage);
            int n = this.nSoundType = mob.nDP >= 300 ? 5 : 4;
        }
        if (bCritical) {
            this.keyRGB = 0xFF0000;
            this.nSoundType = 6;
            this.nScale = 11;
        }
    }

    boolean dispatch(Graphics g, obj2D mob, int xOrg, int yOrg) {
        int t = this.getTick() * 4;
        if (!this.bSoundPlayed && t > 0) {
            this.bSoundPlayed = true;
            this.App.playSonSound(this.nSoundType, false);
        }
        this.rnd.setSeed(this.nSeed);
        if (this.strMsg != null) {
            g.setColor(this.keyRGB);
            this.App.vs.setScale(this.nScale, this.nScale);
            this.App.vs.drawString(g, this.strMsg, xOrg, yOrg - t - 20, 33);
        }
        for (int i = 0; i < this.nLevel; ++i) {
            this.drawBloodLine(g, this.rnd.nextInt() + i * 120, xOrg, yOrg, t, t / 2);
        }
        if (mob instanceof objBoss) {
            // empty if block
        }
        if (!(mob instanceof objHero)) {
            this.frame = (this.frame + 1) % 2;
            try {
                g.drawImage(this.App.Ecffet[this.frame], xOrg - 20, yOrg - 15, 0);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        if (t >= 5) {
            mob.postMov = null;
        }
        return true;
    }

    void drawBloodLine(Graphics g, int deg, int cx, int cy, int rx, int ry) {
        int x = MathExt.cos(deg) * rx >> 10;
        int y = MathExt.sin(deg) * ry >> 10;
        for (int i = 0; i < 3; ++i) {
            int x1 = MathExt.cos(deg) * rx >> 10;
            int y1 = MathExt.sin(deg) * ry >> 10;
            g.setColor(this.png.getRGB(i * 100 / 3, 0, this.keyRGB));
            g.drawLine(x + cx, cy - y, x1 + cx, cy - y1);
            x = x1;
            y = y1;
            rx += 4;
            ry += 2;
        }
    }
}

