/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import lakoo.MainIntro;

public class MovMap
extends MovBase {
    int xDIM;
    int yDIM;
    Dungeon dg;
    int xOrg;
    int yOrg;
    int dx;
    int dy;
    boolean bEnlightened = false;
    int[] rgbBuilding = new int[]{0xFF00FF, 255, 65280};

    MovMap(Dungeon dg) {
        super(dg.App);
        this.dg = dg;
    }

    void prepare(Graphics g, int x, int y, int w, int h) {
        this._x = x;
        this._y = y;
        this._w = w;
        this._h = h;
        g.setColor(0);
        g.fillRect(x, y, w, h);
        this.xOrg = this.dg.hero.xLoc >> 6;
        this.yOrg = this.dg.hero.yLoc >> 6;
        this.dy = 0;
        this.dx = 0;
        this.syncAnimation(10);
    }

    void fulldraw(Graphics g, boolean bEnlightened) {
        g.setColor(0);
        g.fillRect(this._x, this._y, this._w + 1, this._h + 1);
        int oy = this.yOrg - 8;
        int y = this._y;
        int j = 0;
        while (j < 18) {
            if (oy >= 0 && oy < 60) {
                int x = this._x;
                int ox = this.xOrg - 8;
                int i = 0;
                while (i < 18) {
                    byte key;
                    if (ox >= 0 && ox < 60 && ((key = Maze.getMaze(ox, oy)) & 3) == 3 && (bEnlightened || (key & 0x40) > 0)) {
                        g.setColor(3684686);
                        g.fillRect(x, y, 4, 4);
                        g.setColor(0xBBBCCF);
                        if (this.isWall(ox - 1, oy)) {
                            g.drawLine(x, y, x, y + 3);
                        }
                        if (this.isWall(ox, oy - 1)) {
                            g.drawLine(x, y, x + 3, y);
                        }
                        if (this.isWall(ox + 1, oy)) {
                            g.drawLine(x + 3, y, x + 3, y + 3);
                        }
                        if (this.isWall(ox, oy + 1)) {
                            g.drawLine(x, y + 3, x + 3, y + 3);
                        }
                    }
                    ++i;
                    ++ox;
                    x += 4;
                }
            }
            ++j;
            ++oy;
            y += 4;
        }
    }

    boolean isWall(int ox, int oy) {
        Object var3_3 = null;
        if (MainIntro._a1()) {
            return false;
        }
        return (Maze.getMaze(ox, oy) & 3) != 3;
    }

    void drawBuilding(Graphics g, boolean bEnlightened) {
        Object var3_3 = null;
        if (MainIntro._a0()) {
            return;
        }
        int floor = this.dg.nFloor % 3 + 1;
        if (this.dg.nFloor == 14) {
            int x = (this.dg.map.building[0] & 0xFF) * 2 + 32 - this.xOrg * 4;
            int y = (this.dg.map.building[0] >> 7) + 32 - this.yOrg * 4;
            g.setColor(this.rgbBuilding[0]);
            if (x >= 0 && x < this._w && y >= 0 && y < this._h) {
                g.fillRect(x + this._x, y + this._y, 3, 3);
            } else {
                this.drawEdgeLine(g, x, y);
            }
            return;
        }
        if (floor == 2) {
            for (int i = 0; i < 2; ++i) {
                if (this.dg.map.building[i] == 0) continue;
                int x = (this.dg.map.building[i] & 0xFF) * 2 + 32 - this.xOrg * 4;
                int y = (this.dg.map.building[i] >> 7) + 32 - this.yOrg * 4;
                g.setColor(this.rgbBuilding[i]);
                if (x >= 0 && x < this._w && y >= 0 && y < this._h) {
                    g.fillRect(x + this._x, y + this._y, 3, 3);
                    continue;
                }
                this.drawEdgeLine(g, x, y);
            }
            return;
        }
        if (floor == 3) {
            int x = (this.dg.map.building[0] & 0xFF) * 2 + 32 - this.xOrg * 4;
            int y = (this.dg.map.building[0] >> 7) + 32 - this.yOrg * 4;
            g.setColor(this.rgbBuilding[0]);
            if (x >= 0 && x < this._w && y >= 0 && y < this._h) {
                g.fillRect(x + this._x, y + this._y, 3, 3);
            } else {
                this.drawEdgeLine(g, x, y);
            }
            x = (this.dg.map.building[2] & 0xFF) * 2 + 32 - this.xOrg * 4;
            y = (this.dg.map.building[2] >> 7) + 32 - this.yOrg * 4;
            g.setColor(this.rgbBuilding[2]);
            if (x >= 0 && x < this._w && y >= 0 && y < this._h) {
                g.fillRect(x + this._x, y + this._y, 3, 3);
            } else {
                this.drawEdgeLine(g, x, y);
            }
            return;
        }
        for (int i = 1; i < 3; ++i) {
            if (this.dg.map.building[i] == 0) continue;
            int x = (this.dg.map.building[i] & 0xFF) * 2 + 32 - this.xOrg * 4;
            int y = (this.dg.map.building[i] >> 7) + 32 - this.yOrg * 4;
            g.setColor(this.rgbBuilding[i]);
            if (x >= 0 && x < this._w && y >= 0 && y < this._h) {
                g.fillRect(x + this._x, y + this._y, 3, 3);
                continue;
            }
            this.drawEdgeLine(g, x, y);
        }
    }

    void drawMOB(Graphics g) {
        for (int i = 0; i < this.dg.cmd.objArray.length; ++i) {
            if (this.dg.cmd.objArray[i] == null) continue;
            int x = (this.dg.cmd.objArray[i].xLoc >> 4) + 32 - this.xOrg * 4;
            int y = (this.dg.cmd.objArray[i].yLoc >> 4) + 32 - this.yOrg * 4;
            if (x < 0 || x >= this._w - 1 || y < 0 || y >= this._h - 1 || this.dg.cmd.objArray[i] == this.dg.hero) continue;
            g.setColor(0xFF0000);
            g.drawRect(x + this._x, y + this._y, 2, 2);
        }
    }

    boolean dispatch(Graphics g) {
        int t = this.getRealTime() / 10;
        this.xOrg += this.dx;
        this.yOrg += this.dy;
        this.fulldraw(g, this.dg.isTriggered(450 + this.dg.nFloor));
        this.drawBuilding(g, this.dg.isTriggered(450 + this.dg.nFloor));
        if (this.dg.isOnBelt(203)) {
            this.drawMOB(g);
        }
        g.setColor(this.png.getRGB(t % 100, 16767232, 0));
        int x = (this.dg.hero.xLoc >> 4) + 32 - this.xOrg * 4;
        int y = (this.dg.hero.yLoc >> 4) + 32 - this.yOrg * 4;
        if (x >= 0 && x < this._w && y >= 0 && y < this._h) {
            g.fillRect(x + this._x, y + this._y, 2, 2);
        } else {
            this.drawEdgeLine(g, x, y);
        }
        this.dg.png.drawClipImage(g, this.dg.imgArrow, this._x + this._w / 2 - 4, this._y - 6, 0, 0, 9, 5);
        this.dg.png.drawClipImage(g, this.dg.imgArrow, this._x + this._w / 2 - 4, this._y + this._h + 2, 0, 4, 9, 5);
        this.dg.png.drawClipImage(g, this.dg.imgArrow, this._x - 6, this._y + this._h / 2 - 4, 0, 0, 5, 9);
        this.dg.png.drawClipImage(g, this.dg.imgArrow, this._x + this._w + 2, this._y + this._h / 2 - 4, 4, 0, 5, 9);
        return false;
    }

    void drawEdgeLine(Graphics g, int x1, int y1) {
        Object var4_4 = null;
        if (MainIntro._a1()) {
            return;
        }
        int ex = 0;
        int ey = 0;
        int dx = 36 - x1;
        int dy = 36 - y1;
        if (Math.abs(dx) > Math.abs(dy)) {
            ey = dy * 36 / dx;
            if (x1 <= 0) {
                ex = 0;
                ey = 36 - ey;
            }
            if (x1 >= this._w) {
                ex = this._w;
                ey = 36 + ey;
            }
        } else {
            ex = dx * 36 / dy;
            if (y1 <= 0) {
                ey = 0;
                ex = 36 - ex;
            }
            if (y1 >= this._h) {
                ey = this._h - 1;
                ex = 36 + ex;
            }
        }
        g.drawLine(ex + this._x, ey + this._y, this._x + 36, this._y + 36);
    }

    void keyPress(MainBase pocused, int keyCode) {
        Object var3_3 = null;
        if (MainIntro._a1()) {
            return;
        }
        System.out.println("MovMap.keyPress -------------> keyCode=" + keyCode + " pocused.nScene=" + pocused.nScene);
        switch (keyCode) {
            case 52: {
                this.dx = -1;
                break;
            }
            case 5: 
            case 54: {
                this.dx = 1;
                break;
            }
            case 1: 
            case 50: {
                this.dy = -1;
                break;
            }
            case 6: 
            case 56: {
                this.dy = 1;
                break;
            }
            case 8: 
            case 11: {
                this.xOrg = this.dg.hero.xLoc >> 6;
                this.yOrg = this.dg.hero.yLoc >> 6;
                break;
            }
            case 10: 
            case 12: {
                pocused.nScene = 999;
            }
        }
    }

    void keyReleased(MainBase pocused, int keyCode) {
        this.dy = 0;
        this.dx = 0;
    }
}

