/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MovPhantom
extends MovBase {
    int cx;
    int cy;
    int keyRGB;
    int nLevel;
    int nScene;
    int nSeed;
    int sDeg;
    Random rnd;
    int s = 0;
    int frame;

    MovPhantom(TOB3 App) {
        super(App);
        int[] RGB = new int[]{0, 32768, 65280, 32896, 255, 65535};
        this.nLevel = App.MainDungeon.nBerserkLevel[1];
        this.keyRGB = RGB[this.nLevel];
        this.nScene = 0;
        this.nSeed = App.getRnd(0xFFFFFF);
        this.rnd = new Random(this.nSeed);
        try {
            for (int i = 0; i < 12; ++i) {
                this.effectImage[i] = Image.createImage((String)("/res/Ecffet/" + (i + 20) + ".png"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void prepare(Graphics g, int x, int y, int w, int h) {
        this.cx = x + w / 2;
        this.cy = y + h - 16;
        this.syncAnimation(20);
    }

    boolean dispatch(Graphics g) {
        switch (this.nScene) {
            case 0: {
                int t = this.getRealTime();
                this.App.MainDungeon._drawTempMob(g);
                this.rnd.setSeed(this.nSeed);
                this.drawSphere(g, t / 2);
                if (t <= 1080) break;
                ++this.nScene;
                this.App.doVibration();
                this.syncAnimation(20);
                break;
            }
            case 1: {
                int t = this.getTick();
                this.s = t * t;
                int x = MathExt.cos(this.sDeg + 45) * this.s >> 10;
                int y = MathExt.sin(this.sDeg + 45) * this.s >> 11;
                this.frame = (this.frame + 1) % 3;
                if (x > 0 && y > 0) {
                    g.drawImage(this.effectImage[this.frame + 3], this.cx + x, this.cy + y + 20, 33);
                    g.drawImage(this.effectImage[this.frame + 3], this.cx + x, this.cy + y, 33);
                    g.drawImage(this.effectImage[this.frame + 3], this.cx + x - 20, this.cy + y + 20, 33);
                } else if (x > 0 && y < 0) {
                    g.drawImage(this.effectImage[this.frame + 9], this.cx + x - 20, this.cy + y - 15, 33);
                    g.drawImage(this.effectImage[this.frame + 9], this.cx + x, this.cy + y, 33);
                    g.drawImage(this.effectImage[this.frame + 9], this.cx + x + 20, this.cy + y + 25, 33);
                } else if (x < 0 && y < 0) {
                    g.drawImage(this.effectImage[this.frame + 6], this.cx + x - 10, this.cy + y + 30, 33);
                    g.drawImage(this.effectImage[this.frame + 6], this.cx + x, this.cy + y, 33);
                    g.drawImage(this.effectImage[this.frame + 6], this.cx + x + 30, this.cy + y - 20, 33);
                } else {
                    g.drawImage(this.effectImage[this.frame], this.cx + x - 15, this.cy + y - 20, 33);
                    g.drawImage(this.effectImage[this.frame], this.cx + x, this.cy + y, 33);
                    g.drawImage(this.effectImage[this.frame], this.cx + x + 25, this.cy + y, 33);
                }
                this.App.MainDungeon._drawTempMob(g);
                if (t <= 15) break;
                return true;
            }
        }
        return false;
    }

    void drawSphere(Graphics g, int t) {
        int a2 = 97;
        for (int i = 1; i < 12; ++i) {
            int r = MathExt.cos(a2) >> 6;
            this.drawLeadLine(g, t + this.rnd.nextInt(), 8, r, this.cy - i * 3);
            a2 += 15;
        }
    }

    void drawLeadLine(Graphics g, int deg, int a2, int r, int cy) {
        int x = MathExt.cos(deg) * r >> 10;
        int y = MathExt.sin(deg) * r >> 11;
        int RGB = this.png.getRGB(50 + y * 50 / r, 0xFFFFFF, this.keyRGB);
        for (int i = 0; i < a2; ++i) {
            int x1 = MathExt.cos(deg -= 4) * r >> 10;
            int y1 = MathExt.sin(deg) * r >> 11;
            g.setColor(this.png.getRGB(i * 100 / a2, RGB, 0));
            g.drawLine(x + this.cx, y + cy, x1 + this.cx, y1 + cy);
            x = x1;
            y = y1;
        }
    }

    void drawMoonLine(Graphics g, int deg, int cx, int cy, int t) {
        int k = 10 - this.nLevel;
        for (int i = 0; i < 90; i += k) {
            int x = MathExt.cos(deg) >> 5;
            int y = MathExt.sin(deg) >> 6;
            int d = Math.abs(i - 45);
            this.drawMarkLine(g, x + cx, y + cy, 1 + (d * t >> 5), this.png.getRGB(d * 2, 0xFFFFFF, this.keyRGB));
            deg += k;
        }
    }

    void drawMarkLine(Graphics g, int x, int y, int d, int sRGB) {
        int dy = 0;
        int dx = 0;
        int nLen = 0;
        for (int i = 0; i < 4; ++i) {
            g.setColor(this.png.getRGB(i * 25, sRGB, 0));
            int dx1 = MathExt.cos(this.sDeg + 225) * (nLen += d) >> 10;
            int dy1 = MathExt.sin(this.sDeg + 225) * nLen >> 11;
            g.drawLine(x + dx, y + dy, x + dx1, y + dy1);
            dx = dx1;
            dy = dy1;
        }
    }
}

