/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import lakoo.MainIntro;

public class PNGList {
    static final int HANFONT_WIDTH = 15;
    static final int HANFONT_HEIGHT = 15;
    static final int ENGFONT_WIDTH = 6;
    static final int EUFONT_WIDTH = 9;
    static final int EUFONT_HEIGHT = 8;
    int nFGType = 0;
    int nBGType = 0;
    int width;
    int height;
    int fcy;
    int tInt;
    Image imgBack = null;
    Image imgKeyInfo = null;
    Image imgMenuInfo = null;
    Image[] imgTmp = new Image[14];
    MSR msr;
    Graphics gHold;
    Vector imgCache = new Vector();
    static final String[] strMSR = new String[]{"imgMenu", "imgUI", "imgFace", "it0", "it0", "it0", "it3", "imgItem0", "imgItem1", "imgItem2", "imgItem3", "imgItem4", "imgItem5"};
    static final int MSR_MENU = 0;
    static final int MSR_UI = 1;
    static final int MSR_FACE = 2;
    static final int MSR_TOWN0 = 3;
    static final int MSR_TOWN1 = 4;
    static final int MSR_TOWN2 = 5;
    static final int MSR_TOWN3 = 6;
    static final int MSR_SWORD = 7;
    static final int MSR_SHIELD = 8;
    static final int MSR_EQUIP = 9;
    static final int MSR_QUEST = 10;
    static final int MSR_1TIME = 11;
    static final int MSR_MANASTONE = 12;
    static final int CLR_SHOW = 1;
    static final int OK_SHOW = 2;
    static final int CLR_ENABLE = 4;
    static final int OK_ENABLE = 8;
    static final int SKIP_SHOW = 22;
    int _rx;
    int _ty;
    int _bw;
    int _bh;
    int _cx;
    int _cy;
    int _cw;
    int _ch;
    int _savedX;
    int _savedY;
    Image _savedBG;
    static final Image[] fntEU = new Image[2];
    static final int DRAW_AND = 1;
    static final int DRAW_OR = 2;
    static final int FNTBG_TRANSPARENT = -1;
    int nfntColor = 0xFFFFFF;
    int nfntBgColor = 0;

    void initPNG(MSR msr) {
        Object var2_2 = null;
        if (MainIntro._a1()) {
            return;
        }
        this.msr = msr;
        this.fcy = (10 - Font.getDefaultFont().getHeight()) / 2;
    }

    void releaseTmp() {
        for (int i = 0; i < 14; ++i) {
            this.imgTmp[i] = null;
        }
        this.imgBack = null;
    }

    Image loadImage(MSR msr, int nIndex, int dwKey) {
        Image img = null;
        this.memoryControl();
        img = msr.loadChunkImage(nIndex);
        this.imgCache.addElement(new _img(dwKey, img));
        return img;
    }

    void releaseAllImage() {
        this.imgCache.removeAllElements();
        System.gc();
    }

    void memoryControl() {
        while (this.imgCache.size() > 0 && Runtime.getRuntime().freeMemory() < Math.max(Runtime.getRuntime().totalMemory() / 8L, 102400L)) {
            this.releaseSomeImage();
        }
    }

    boolean releaseSomeImage() {
        Object var1_1 = null;
        if (MainIntro._a1()) {
            return false;
        }
        int nMin = 65535;
        int nIndex = -1;
        if (this.imgCache.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.imgCache.size(); ++i) {
            _img img = (_img)this.imgCache.elementAt(i);
            if (nMin <= img.nUsed) continue;
            nIndex = i;
            nMin = img.nUsed;
        }
        this.imgCache.removeElementAt(nIndex);
        System.gc();
        return true;
    }

    boolean drawCachedImage(Graphics g, int dwKey, int x, int y, int anchor) {
        for (int i = 0; i < this.imgCache.size(); ++i) {
            if (((_img)this.imgCache.elementAt((int)i)).dwKey != dwKey) continue;
            Image img = ((_img)this.imgCache.elementAt(i)).getImage();
            g.drawImage(img, x, y, anchor);
            return true;
        }
        return false;
    }

    Image loadCachedImage(int dwKey) {
        for (int i = 0; i < this.imgCache.size(); ++i) {
            if (((_img)this.imgCache.elementAt((int)i)).dwKey != dwKey) continue;
            return ((_img)this.imgCache.elementAt(i)).getImage();
        }
        return null;
    }

    Image prepareImages(int nType, int nImageID) {
        int dwKey = nType << 16 | nImageID;
        Image img = this.loadCachedImage(dwKey);
        if (img == null) {
            this.msr.openChunkFile(strMSR[nType]);
            return this.loadImage(this.msr, nImageID, dwKey);
        }
        return img;
    }

    void drawGeneralImage(Graphics g, int nType, int nImageID, int x, int y, int anchor) {
        int dwKey = nType << 16 | nImageID;
        if (!this.drawCachedImage(g, dwKey, x, y, anchor)) {
            if (nType == 6) {
                try {
                    Image image = null;
                    image = Image.createImage((String)"/res/imgTown/town1.png");
                    g.drawImage(image, x, y, anchor);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (nType == 2) {
                try {
                    Image image = null;
                    image = Image.createImage((String)("/res/imgFace/" + nImageID + ".png"));
                    g.drawImage(image, x, y, anchor);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (nType == 3) {
                try {
                    Image image = null;
                    if (nImageID > 1) {
                        nImageID = 1;
                    }
                    image = Image.createImage((String)("/res/imgTown/town" + nImageID + ".png"));
                    g.drawImage(image, x, y, anchor);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.loadImage(this.msr, nImageID, dwKey, strMSR[nType]);
                this.drawCachedImage(g, dwKey, x, y, anchor);
            }
        }
    }

    Image loadImage(MSR msr, int nIndex, int dwKey, String str) {
        Image img = null;
        this.memoryControl();
        try {
            img = Image.createImage((String)("/res/" + str + "/" + nIndex + ".png"));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.imgCache.addElement(new _img(dwKey, img));
        return img;
    }

    void fillDarkenRect(Graphics g, int x, int y, int w, int h) {
        int i;
        int l = w + h;
        g.setColor(0);
        int n = i = (x & 1) == 0 ? 0 : 2;
        while (i < l) {
            int px = x + i;
            int py = y;
            if (px > x + w) {
                px = x + w;
                py = y + i - w;
            }
            int px1 = x;
            int py1 = y + i;
            if (py1 > y + h) {
                px1 = x + i - h;
                py1 = y + h;
            }
            g.drawLine(px, py, px1, py1);
            i += 2;
        }
    }

    public void drawClipImage(Graphics g, Image src, int x, int y, int k, int l, int w, int h) {
        int x1 = g.getClipX();
        int y1 = g.getClipY();
        int w1 = g.getClipWidth();
        int h1 = g.getClipHeight();
        g.clipRect(x, y, w, h);
        g.drawImage(src, x - k, y - l, 20);
        g.setClip(x1, y1, w1, h1);
    }

    public void drawSubFrame(Graphics g, Image src, int nIndex, int x, int y, int w, int h) {
        int x1 = g.getClipX();
        int y1 = g.getClipY();
        int w1 = g.getClipWidth();
        int h1 = g.getClipHeight();
        g.clipRect(x, y, w, h);
        g.drawImage(src, x - nIndex * w, y, 20);
        g.setClip(x1, y1, w1, h1);
    }

    public void drawSubFrame2(Graphics g, Image src, int nIndex, int x, int y, int w, int h) {
        int x1 = g.getClipX();
        int y1 = g.getClipY();
        int w1 = g.getClipWidth();
        int h1 = g.getClipHeight();
        g.clipRect(x, y, w, h);
        g.drawImage(src, x - nIndex, y, 20);
        g.setClip(x1, y1, w1, h1);
    }

    public void whitenRect(Graphics g, int x, int y, int w, int h, int nLevel) {
        g.setColor(0xFFFFFF);
        g.fillRect(x, y, w, h);
    }

    int getRGB(int nRate, int RGB1, int RGB2) {
        if (nRate < 0) {
            nRate = 0;
        }
        if (nRate > 100) {
            nRate = 100;
        }
        int r = (RGB1 & 0xFF0000) >> 16;
        int g = (RGB1 & 0xFF00) >> 8;
        int b2 = RGB1 & 0xFF;
        int r1 = (RGB2 & 0xFF0000) >> 16;
        int g1 = (RGB2 & 0xFF00) >> 8;
        int b1 = RGB2 & 0xFF;
        int mr = (r1 - r) * nRate / 100 + r;
        int mg = (g1 - g) * nRate / 100 + g;
        int mb = (b1 - b2) * nRate / 100 + b2;
        return (mr << 16) + (mg << 8) + mb;
    }

    public void drawGradientHLine(Graphics gd, int x, int y, int length, int height, int cColor, int eColor) {
        int r = (cColor & 0xFF0000) >> 16;
        int g = (cColor & 0xFF00) >> 8;
        int b2 = cColor & 0xFF;
        int r1 = (eColor & 0xFF0000) >> 16;
        int g1 = (eColor & 0xFF00) >> 8;
        int b1 = eColor & 0xFF;
        for (int i = 0; i < height; ++i) {
            int mr = (r1 - r) * i / height + r;
            int mg = (g1 - g) * i / height + g;
            int mb = (b1 - b2) * i / height + b2;
            int mc = (mr << 16) + (mg << 8) + mb;
            gd.setColor(mc);
            gd.drawLine(x, y + i, x + length, y + i);
            gd.drawLine(x, y - i, x + length, y - i);
        }
    }

    public void drawGradientVLine(Graphics gd, int x, int y, int w, int h, int cColor, int eColor) {
        this.drawGradientVLine(gd, x, y, w, h, cColor, eColor, 3);
    }

    public void drawGradientVLine(Graphics gd, int x, int y, int w, int h, int cColor, int eColor, int fPart) {
        int r = (cColor & 0xFF0000) >> 16;
        int g = (cColor & 0xFF00) >> 8;
        int b2 = cColor & 0xFF;
        int r1 = (eColor & 0xFF0000) >> 16;
        int g1 = (eColor & 0xFF00) >> 8;
        int b1 = eColor & 0xFF;
        for (int i = 0; i < w; ++i) {
            int mr = (r1 - r) * i / w + r;
            int mg = (g1 - g) * i / w + g;
            int mb = (b1 - b2) * i / w + b2;
            int mc = (mr << 16) + (mg << 8) + mb;
            gd.setColor(mc);
            if ((fPart & 1) == 1) {
                gd.drawLine(x + i, y, x + i, y + h);
            }
            if ((fPart & 2) != 2) continue;
            gd.drawLine(x - i, y, x - i, y + h);
        }
    }

    void drawHFlow(Graphics gd, int x, int y, int w, int h, int cLight, int cDark) {
        int r = (cLight & 0xFF0000) >> 16;
        int g = (cLight & 0xFF00) >> 8;
        int b2 = cLight & 0xFF;
        int r1 = (cDark & 0xFF0000) >> 16;
        int g1 = (cDark & 0xFF00) >> 8;
        int b1 = cDark & 0xFF;
        Object var21_14 = null;
        long l = 0L;
        Object var24_16 = null;
        l = MainIntro._n();
        int d = 64 - Math.abs((int)l >> 5 & 0x3F);
        for (int i = 0; i < w; ++i) {
            int dc = ((d &= 0x3F) & 0x20) == 0 ? d : 64 - d;
            int mr = ((r1 - r) * dc >> 5) + r;
            int mg = ((g1 - g) * dc >> 5) + g;
            int mb = ((b1 - b2) * dc >> 5) + b2;
            gd.setColor(mr << 16 | mg << 8 | mb);
            ++d;
            gd.drawLine(x + i, y, x + i, y + h);
        }
    }

    void setKeyInfoPos(int xRight, int yTop) {
        this._rx = xRight;
        this._ty = yTop;
        this._bw = 0;
        this._bh = 0;
    }

    void setKeyInfoPos(int xRight, int yTop, int w, int h) {
        this._rx = xRight;
        this._ty = yTop;
        this._bw = w;
        this._bh = h;
    }

    void drawIconMenu(Graphics g, int x, int y, int w) {
        int _rx = x;
        int _si = 2;
        g.setFont(Font.getFont((int)0, (int)0, (int)8));
        int color = g.getColor();
        g.setColor(255, 255, 255);
        g.drawString("\u7cfb\u7edf", _rx, y, 36);
        _rx = x + w;
        g.drawString("\u83dc\u5355", _rx, y, 40);
        g.setColor(color);
    }

    void drawKeyInfo(Graphics g, int nKeyInfo) {
        int color;
        int _rx = this._rx - this._bw;
        int _ty = this._ty + this._bh - 8 - 1;
        int _si = 0;
        if ((nKeyInfo & 1) == 1) {
            _rx = this._rx + this._bw - 30;
            _si = (nKeyInfo & 4) == 4 ? 2 : 0;
            color = g.getColor();
            g.setColor(255, 255, 255);
            g.setFont(Font.getFont((int)0, (int)0, (int)8));
            g.setColor(color);
        }
        if ((nKeyInfo & 2) == 2) {
            _rx = this._rx + 1;
            _si = (nKeyInfo & 8) == 8 ? 3 : 1;
            color = g.getColor();
            g.setColor(255, 255, 255);
            g.setFont(Font.getFont((int)0, (int)0, (int)8));
            g.setColor(color);
        }
    }

    void drawKeyInfoSkip(Graphics g, int nKeyInfo) {
        int _rx = this._rx - 34 - 1;
        int _ty = this._ty + this._bh - 8 - 1;
        boolean _si = false;
        if ((nKeyInfo & 0x16) == 22) {
            int color = g.getColor();
            g.setColor(255, 255, 255);
            g.drawString("\u8df3\u8fc7", _rx, _rx, 20);
            g.setColor(color);
        }
    }

    public void reserveClip(Graphics g) {
        Object var2_2 = null;
        if (MainIntro._a1()) {
            return;
        }
        this._cx = g.getClipX();
        this._cy = g.getClipY();
        this._cw = g.getClipWidth();
        this._ch = g.getClipHeight();
    }

    public void recoverClip(Graphics g) {
        g.setClip(this._cx, this._cy, this._cw, this._ch);
    }

    public void save(Graphics g) {
        this.save(g, g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight());
    }

    public void save(Graphics g, int xOrg, int yOrg, int w, int h) {
        this._savedX = xOrg;
        this._savedY = yOrg;
        int ax = xOrg + g.getTranslateX();
        int ay = yOrg + g.getTranslateY();
        if (ax < 0) {
            this._savedX -= ax;
            ax = 0;
        }
        if (ay < 0) {
            this._savedY -= ay;
            ay = 0;
        }
        System.gc();
        this.memoryControl();
    }

    public void restore(Graphics g) {
        this.restore(g, true);
    }

    public void restore(Graphics g, boolean bReset) {
        if (this._savedBG != null) {
            g.drawImage(this._savedBG, this._savedX, this._savedY, 20);
        }
        if (bReset) {
            this._savedBG = null;
        }
    }

    public void drawTitle(Graphics g, int sx, int sy, int ex, int ey) {
        g.setColor(0);
        g.fillRect(sx, sy, ex, ey);
        this.tInt = ey / 23;
        for (int i = 0; i <= this.tInt; ++i) {
            g.drawImage(this.imgTmp[i], ex / 2, ey - 23 - i * 23, 17);
        }
    }

    public void setFontColor(int fgRGB, int bgRGB) {
        this.nfntColor = fgRGB;
        this.nfntBgColor = bgRGB;
    }

    public void setFontFgColor(int fgRGB) {
        this.setFontColor(fgRGB, this.nfntBgColor);
    }

    public void setFontBgColor(int bgRGB) {
        this.setFontColor(this.nfntColor, bgRGB);
    }

    public void loadFont() {
        try {
            for (int i = 0; i < 2; ++i) {
                PNGList.fntEU[i] = Image.createImage((String)("/res/imgFont2/" + i + ".png"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unloadFont() {
        for (int i = 0; i < fntEU.length; ++i) {
            PNGList.fntEU[i] = null;
        }
    }

    void _drawFont(Graphics g, int nFntIndex, int nIndex, int x, int y, int w) {
        if (this.nfntColor == 0xFFFFFF) {
            this.drawOpFont(g, x, y, nFntIndex, nIndex, w, 2);
            return;
        }
        this.drawOpFont(g, x, y, nFntIndex, nIndex, w, 1);
    }

    void drawOpFont(Graphics g, int x, int y, int nFont, int nIndex, int w, int Op) {
        int p1 = g.getClipX();
        int p2 = g.getClipY();
        int p3 = g.getClipWidth();
        int p4 = g.getClipHeight();
        int euX = (nIndex & 0xFF) * w;
        int euY = (nIndex >> 8) * 8;
        g.clipRect(x, y, w, 8);
        switch (Op) {
            case 1: {
                g.drawImage(fntEU[1], x - euX, y - euY, 20);
                break;
            }
            case 2: {
                g.drawImage(fntEU[0], x - euX, y - euY, 20);
            }
        }
        g.setClip(p1, p2, p3, p4);
    }

    private void drawEng(Graphics g, int ch, int x, int y) {
        this._drawFont(g, 9, ch, x, y, 6);
    }

    public static final int getHanPixelLength(String strText) {
        int dx = 0;
        int nLen = strText.length();
        for (int i = 0; i < nLen; ++i) {
            char ch = strText.charAt(i);
            dx += 15;
        }
        return dx;
    }

    public void drawLineCus(Graphics g, int x, int y, int end_x, int end_y, int Color) {
        g.setColor(Color);
        g.drawLine(x, y, end_x, end_y);
    }

    public void drawHan(Graphics g, char ch, int x, int y) {
        int col = g.getColor();
        g.setColor(255, 255, 255);
        g.drawChar(ch, x, y, 20);
        g.setColor(col);
    }

    public int drawString(Graphics g, String strText, int x, int y, int anchor) {
        int i;
        g.setFont(Font.getFont((int)0, (int)0, (int)8));
        char ch = '\u0000';
        int nPixelWidth = 0;
        int nLen = strText.length();
        for (i = 0; i < nLen; ++i) {
            nPixelWidth += 15;
        }
        if ((anchor & 8) == 8) {
            x -= nPixelWidth;
        }
        if ((anchor & 1) == 1) {
            x -= nPixelWidth / 2;
        }
        if ((anchor & 2) == 2) {
            y -= 5;
        }
        if ((anchor & 0x20) == 32) {
            y -= 10;
        }
        if (this.nfntBgColor != -1) {
            g.setColor(this.nfntBgColor);
            g.fillRect(x, y, nPixelWidth, 15);
        }
        int offsetX = 0;
        int offsetY = 0;
        int offset = 0;
        for (i = 0; i < nLen; ++i) {
            ch = strText.charAt(i);
            char nX = '\u0000';
            int nY = 0;
            if (ch > '\u00a0') {
                this.drawHan(g, ch, x, y);
                x += 15;
                continue;
            }
            offsetX = (ch + nX - 32) % 32;
            offsetY = nY + (ch + nX - 32 >> 5);
            offset = offsetY << 8;
            int matchIndex = offset + offsetX;
            int color = g.getColor();
            g.setColor(255, 255, 255);
            g.drawChar(ch, x, y, 20);
            g.setColor(color);
            x += 9;
        }
        return nPixelWidth;
    }

    public String FLString(int n, int FL) {
        String strN = Integer.toString(n);
        int nL = strN.length();
        if (nL < FL) {
            for (int i = 0; i < FL - nL; ++i) {
                strN = "0" + strN;
            }
        }
        return new String(strN);
    }

    void drawDecoString(Graphics g, String strText, int x, int y, int anchor) {
        int nLastFntColor = this.nfntColor;
        this.setFontColor(0, -1);
        this.drawString(g, strText, x - 1, y, anchor);
        this.drawString(g, strText, x, y + 1, anchor);
        this.drawString(g, strText, x, y - 1, anchor);
        this.drawString(g, strText, x + 1, y, anchor);
        this.setFontColor(nLastFntColor, -1);
        this.drawString(g, strText, x, y, anchor);
    }

    class _img {
        private Image img;
        public int dwKey;
        int nUsed;

        _img(int dwKey, Image img) {
            this.img = img;
            this.dwKey = dwKey;
            this.nUsed = 0;
        }

        Image getImage() {
            ++this.nUsed;
            return this.img;
        }
    }
}

