/*
 * Decompiled with CFR 0.152.
 */
package json;

import json.JSONArray;
import json.JSONObject;

public class JSONTokener {
    private int a = 0;
    private String b;

    public JSONTokener(String string) {
        this.b = string;
    }

    public void back() {
        if (this.a > 0) {
            --this.a;
        }
    }

    public char next() {
        if (this.a < this.b.length()) {
            char c = this.b.charAt(this.a);
            ++this.a;
            return c;
        }
        return '\u0000';
    }

    public String next(int n) {
        int n2 = this.a;
        int n3 = n2 + n;
        if (n3 >= this.b.length()) {
            throw this.syntaxError("Substring bounds error");
        }
        this.a += n;
        return this.b.substring(n2, n3);
    }

    public char nextClean() {
        char c;
        block4: while (true) {
            if ((c = this.next()) == '/') {
                switch (this.next()) {
                    case '/': {
                        while ((c = this.next()) != '\n' && c != '\r' && c != '\u0000') {
                        }
                        continue block4;
                    }
                    case '*': {
                        while (true) {
                            if ((c = this.next()) == '\u0000') {
                                throw this.syntaxError("Unclosed comment.");
                            }
                            if (c != '*') continue;
                            if (this.next() == '/') continue block4;
                            this.back();
                        }
                    }
                }
                this.back();
                return '/';
            }
            if (c == '#') {
                while ((c = this.next()) != '\n' && c != '\r' && c != '\u0000') {
                }
                continue;
            }
            if (c == '\u0000' || c > ' ') break;
        }
        return c;
    }

    public String nextString(char c) {
        StringBuffer stringBuffer = new StringBuffer();
        block13: while (true) {
            char c2 = this.next();
            switch (c2) {
                case '\u0000': 
                case '\n': 
                case '\r': {
                    throw this.syntaxError("Unterminated string");
                }
                case '\\': {
                    c2 = this.next();
                    switch (c2) {
                        case 'b': {
                            stringBuffer.append('\b');
                            continue block13;
                        }
                        case 't': {
                            stringBuffer.append('\t');
                            continue block13;
                        }
                        case 'n': {
                            stringBuffer.append('\n');
                            continue block13;
                        }
                        case 'f': {
                            stringBuffer.append('\f');
                            continue block13;
                        }
                        case 'r': {
                            stringBuffer.append('\r');
                            continue block13;
                        }
                        case 'u': {
                            stringBuffer.append((char)Integer.parseInt(this.next(4), 16));
                            continue block13;
                        }
                        case 'x': {
                            stringBuffer.append((char)Integer.parseInt(this.next(2), 16));
                            continue block13;
                        }
                    }
                    stringBuffer.append(c2);
                    continue block13;
                }
            }
            if (c2 == c) {
                return stringBuffer.toString();
            }
            stringBuffer.append(c2);
        }
    }

    public Object nextValue() {
        char c = this.nextClean();
        switch (c) {
            case '\"': 
            case '\'': {
                return this.nextString(c);
            }
            case '{': {
                this.back();
                return new JSONObject(this);
            }
            case '[': {
                this.back();
                return new JSONArray(this);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (c >= ' ' && ",:]}/\\\"[{;=#".indexOf(c) < 0) {
            stringBuffer.append(c);
            c = this.next();
        }
        this.back();
        String string = stringBuffer.toString().trim();
        if (string.equals("")) {
            throw this.syntaxError("Missing value.");
        }
        if (string.toLowerCase().equals("null")) {
            return JSONObject.NULL;
        }
        return string;
    }

    public Exception syntaxError(String string) {
        return new Exception(string + this.toString());
    }
}

