/*
 * Decompiled with CFR 0.152.
 */
package Default;

import animation.Actor;
import animation.Animation;
import data.MathTool;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Snow {
    private int iGameWidth = 0;
    private int iGameHeight = 0;
    private int iTimes = 0;
    private int winddirect = 0;
    private int downspeed = 0;
    private int SnowNum = 0;
    private int[] snowX = null;
    private int[] snowY = null;
    private int[] snowR = null;
    private int[] type = null;
    private final int ChangeDirectTime;
    private final int STARTPOSITION;
    private Actor[] actor;
    Image snow_img;
    Animation snow_animation;
    Image[] small_snow_img;
    boolean issnow = true;

    public Snow(int sw, int sh, int t) {
        this.ChangeDirectTime = 500;
        this.STARTPOSITION = -30;
        this.setSnowScrenn(sw, sh);
        this.downspeed = sh / 300;
        if (t == 1) {
            this.SnowNum = sw * sh / 6000;
            this.initsnow();
        }
        if (t == 2) {
            this.SnowNum = sw * sh / 1000;
            this.initsmallsnow();
        }
        this.snowX = new int[this.SnowNum];
        this.snowY = new int[this.SnowNum];
        this.snowR = new int[this.SnowNum];
        for (int i = 0; i < this.SnowNum; ++i) {
            this.reset(i);
        }
    }

    public void initsnow() {
        this.issnow = true;
        this.actor = new Actor[this.SnowNum];
        try {
            this.snow_img = Image.createImage((String)"/snow.png");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.snow_animation = Animation.initAnimation("snow", this.snow_img);
    }

    public void initsmallsnow() {
        this.issnow = false;
        this.type = new int[this.SnowNum];
        this.small_snow_img = new Image[6];
        for (int i = 0; i < 6; ++i) {
            try {
                this.small_snow_img[i] = Image.createImage((String)("/" + i + ".png"));
                continue;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void setSnowScrenn(int sw, int sh) {
        this.iGameWidth = sw;
        this.iGameHeight = sh;
    }

    public void draw(Graphics g) {
        this.update();
        if (this.issnow) {
            for (int i = 0; i < this.SnowNum; ++i) {
                this.actor[i].nextFrame_Cyc();
                this.actor[i].set_x(this.snowX[i]);
                this.actor[i].set_y(this.snowY[i]);
                this.actor[i].draw(g, 0, 0);
            }
        } else {
            for (int i = 0; i < this.SnowNum; ++i) {
                g.drawImage(this.small_snow_img[this.type[i]], this.snowX[i], this.snowY[i], 3);
            }
        }
    }

    public void update() {
        ++this.iTimes;
        if (this.iTimes % 500 == 0) {
            this.winddirect = MathTool.GetRandomNum(0, 2);
        }
        this.snowMove();
    }

    private void snowMove() {
        for (int i = 0; i < this.SnowNum; ++i) {
            switch (this.winddirect) {
                case 0: {
                    int n = i;
                    this.snowX[n] = this.snowX[n] + MathTool.GetRandomNum(-1, 3);
                    break;
                }
                case 1: {
                    int n = i;
                    this.snowX[n] = this.snowX[n] - MathTool.GetRandomNum(-1, 3);
                    break;
                }
                case 2: {
                    int n = i;
                    this.snowX[n] = this.snowX[n] - MathTool.GetRandomNum(-2, 2);
                }
            }
            int n = i;
            this.snowY[n] = this.snowY[n] + this.downspeed;
            if (this.snowX[i] >= -30 && this.snowX[i] <= this.iGameWidth + 10 && this.snowY[i] <= this.iGameHeight + 5) continue;
            this.reset(i);
        }
    }

    private void reset(int id) {
        if (this.issnow) {
            this.actor[id] = new Actor(this.snow_animation);
            this.actor[id].set_indexAnimate(MathTool.GetRandomNum(1, 3));
        } else {
            this.type[id] = MathTool.GetRandomNum(0, 5);
        }
        this.snowX[id] = MathTool.GetRandomNum(-30, this.iGameWidth);
        this.snowY[id] = MathTool.GetRandomNum(-30, this.iGameHeight);
        this.snowR[id] = MathTool.GetRandomNum(1, 4);
    }

    public void destroy() {
        this.snowX = null;
        this.snowY = null;
        this.snowR = null;
    }
}

