/*
 * Decompiled with CFR 0.152.
 */
package animation;

import Default.MyCanvas;
import animation.Actor;
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Animation {
    static final int MASK = 65535;
    static final int EXTEND_PER_ACTION = 2;
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROT90 = 5;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR_ROT270 = 4;
    int m_imageID;
    public Image s_images;
    public Image s_image_mirror;
    public String m_imagepath;
    public int simaWidth;
    public int simaHeight;
    short[] Modules;
    public short[][] Frames;
    public byte[][] cBoxHit;
    public byte[][] cBoxAtt;
    public short[][] Actions;
    short[][] Delay;
    public short nowDelay;
    public int indexAnimate;
    public int indexFrame;
    public boolean isFaceX;
    public boolean isFaceY;
    public int x;
    public int y;
    short[] numFrames_inActions;
    short[] m_mechModels;
    byte[] m_mechModelFlag;
    short m_clipx = 0;
    short m_clipy = 0;
    short m_clipw = (short)4000;
    short m_cliph = (short)4000;
    short m_curclipx = this.m_clipx;
    short m_curclipy = this.m_clipy;

    public void loadAnimation(DataInputStream is) throws Exception {
        int num;
        int i;
        is.readShort();
        this.m_imageID = is.readShort();
        is.readInt();
        this.m_imagepath = is.readUTF();
        int count = is.readShort();
        this.Modules = new short[count * 4];
        Animation.readDataShort(is, this.Modules, 0, this.Modules.length);
        count = is.readShort();
        this.Frames = new short[count][];
        for (i = 0; i < count; ++i) {
            num = is.readUnsignedShort();
            this.Frames[i] = new short[num * 4];
            Animation.readDataShort(is, this.Frames[i], 0, this.Frames[i].length);
        }
        this.cBoxHit = new byte[count][4];
        this.cBoxAtt = new byte[count][4];
        for (i = 0; i < count; ++i) {
            this.cBoxHit[i] = Animation.readDataByte(is, 4);
            byte[] byArray = this.cBoxHit[i];
            byArray[2] = (byte)(byArray[2] - this.cBoxHit[i][0]);
            byte[] byArray2 = this.cBoxHit[i];
            byArray2[3] = (byte)(byArray2[3] - this.cBoxHit[i][1]);
        }
        for (i = 0; i < count; ++i) {
            this.cBoxAtt[i] = Animation.readDataByte(is, 4);
            byte[] byArray = this.cBoxAtt[i];
            byArray[2] = (byte)(byArray[2] - this.cBoxAtt[i][0]);
            byte[] byArray3 = this.cBoxAtt[i];
            byArray3[3] = (byte)(byArray3[3] - this.cBoxAtt[i][1]);
        }
        count = is.readUnsignedShort();
        this.numFrames_inActions = new short[count];
        this.Actions = new short[count][];
        this.Delay = new short[count][];
        this.m_mechModels = new short[count * 4];
        for (i = 0; i < count; ++i) {
            num = is.readUnsignedShort();
            this.numFrames_inActions[i] = (short)num;
            this.Actions[i] = new short[num];
            this.Delay[i] = new short[num];
            for (int ii = 0; ii < num; ++ii) {
                this.Actions[i][ii] = is.readShort();
                this.Delay[i][ii] = is.readShort();
            }
        }
        this.m_mechModelFlag = Animation.readDataByte(is, count);
        Animation.readDataShort(is, this.m_mechModels, 0, this.m_mechModels.length);
        this.initAnimation();
    }

    public void initAnimation() {
        this.set_indexAnimate(0);
        this.isFaceX = false;
    }

    public void setImage(Image img) {
        this.s_images = img;
        this.simaWidth = img.getWidth();
        this.simaHeight = img.getHeight();
    }

    public static Animation initAnimation(String animFile, Image img_a) {
        animFile = "/" + animFile + ".dat";
        System.out.println(animFile);
        Animation a = null;
        try {
            a = new Animation();
            DataInputStream is = new DataInputStream("".getClass().getResourceAsStream(animFile));
            a.loadAnimation(is);
            is.close();
            a.s_images = img_a;
            a.simaWidth = a.s_images.getWidth();
            a.simaHeight = a.s_images.getHeight();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return a;
    }

    public final void reSetFrame() {
        this.indexFrame = 0;
        this.nowDelay = this.Delay[this.indexAnimate][this.indexFrame];
    }

    public final void set_indexAnimate(int id) {
        if (this.indexAnimate == id) {
            return;
        }
        this.indexAnimate = id;
        this.indexFrame = 0;
        this.nowDelay = this.Delay[this.indexAnimate][this.indexFrame];
    }

    public int getNowFrame() {
        short nowFrame = this.Actions[this.indexAnimate][this.indexFrame];
        return nowFrame;
    }

    public final boolean nextFrame_Cyc() {
        this.nowDelay = (short)(this.nowDelay - 1);
        if (this.nowDelay <= 0) {
            if (++this.indexFrame >= this.Actions[this.indexAnimate].length) {
                this.indexFrame = 0;
                this.nowDelay = this.Delay[this.indexAnimate][this.indexFrame];
                return true;
            }
            this.nowDelay = this.Delay[this.indexAnimate][this.indexFrame];
        }
        return false;
    }

    public final boolean nextFrame_toEnd() {
        this.nowDelay = (short)(this.nowDelay - 1);
        if (this.nowDelay <= 0) {
            if (this.indexFrame < this.Actions[this.indexAnimate].length - 1) {
                ++this.indexFrame;
            } else {
                return true;
            }
            this.nowDelay = this.Delay[this.indexAnimate][this.indexFrame];
        }
        return false;
    }

    public final boolean is_nextFrame_toEnd() {
        return this.nowDelay - 1 <= 0 && this.indexFrame >= this.Actions[this.indexAnimate].length - 1;
        {
        }
    }

    public boolean get_isFaceX() {
        return this.isFaceX;
    }

    public void set_isFaceX(boolean faceX) {
        this.isFaceX = faceX;
    }

    public int get_x() {
        return this.x;
    }

    public int get_y() {
        return this.y;
    }

    public void set_x(int x1) {
        this.x = x1;
    }

    public void set_y(int y1) {
        this.y = y1;
    }

    public int get_cBoxHit_x() {
        boolean faceX = this.isFaceX;
        return faceX ? -this.cBoxHit[this.getNowFrame()][0] - this.cBoxHit[this.getNowFrame()][2] : this.cBoxHit[this.getNowFrame()][0];
    }

    public int get_cBoxHit_y() {
        boolean faceY = this.isFaceY;
        return faceY ? -this.cBoxHit[this.getNowFrame()][1] - this.cBoxHit[this.getNowFrame()][3] : this.cBoxHit[this.getNowFrame()][1];
    }

    public int get_cBoxHit_w() {
        return this.cBoxHit[this.getNowFrame()][2];
    }

    public int get_cBoxHit_h() {
        return this.cBoxHit[this.getNowFrame()][3];
    }

    public int get_cBoxAtt_x() {
        boolean faceX = this.isFaceX;
        return faceX ? -this.cBoxAtt[this.getNowFrame()][0] - this.cBoxAtt[this.getNowFrame()][2] : this.cBoxAtt[this.getNowFrame()][0];
    }

    public int get_cBoxAtt_y() {
        boolean faceY = this.isFaceY;
        return faceY ? -this.cBoxAtt[this.getNowFrame()][1] - this.cBoxAtt[this.getNowFrame()][3] : this.cBoxAtt[this.getNowFrame()][1];
    }

    public int get_cBoxAtt_w() {
        return this.cBoxAtt[this.getNowFrame()][2];
    }

    public int get_cBoxAtt_h() {
        return this.cBoxAtt[this.getNowFrame()][3];
    }

    public int get_cBoxAtt_x_noFace() {
        return this.cBoxAtt[this.getNowFrame()][0];
    }

    public int get_cBoxAtt_y_noFace() {
        return this.cBoxAtt[this.getNowFrame()][1];
    }

    public int get_cBoxHit_x_noFace() {
        return this.cBoxHit[this.getNowFrame()][0];
    }

    public int get_cBoxHit_y_noFace() {
        return this.cBoxHit[this.getNowFrame()][1];
    }

    public void setMirrorImage(Image image) {
        this.s_image_mirror = image;
    }

    public void draw_cBox(Graphics g) {
        g.setClip(0, 0, 400, 400);
        g.setColor(0xFF0000);
        g.drawRect(this.x + this.get_cBoxAtt_x(), this.y + this.get_cBoxAtt_y(), this.get_cBoxAtt_w() + 4, this.get_cBoxAtt_h() + 4);
        g.setColor(65280);
        g.drawRect(this.x + this.get_cBoxHit_x(), this.y + this.get_cBoxHit_y(), this.get_cBoxHit_w(), this.get_cBoxHit_h());
    }

    public void setNowData(Actor actor) {
        this.x = actor.get_x();
        this.y = actor.get_y();
        this.indexAnimate = actor.get_indexAnimate();
        this.isFaceX = actor.get_isFaceX();
        this.nowDelay = actor.get_nowDelay();
        this.indexFrame = actor.get_indexFrame();
    }

    public void draw(Graphics g, int mapX, int mapY) {
        int x_copy = this.x;
        int y_copy = this.y;
        this.x -= mapX;
        this.y -= mapY;
        this.draw(g);
        this.x = x_copy;
        this.y = y_copy;
    }

    public void draw(Graphics g, Actor actor, int _x, int _y, boolean facing) {
        this.indexAnimate = actor.get_indexAnimate();
        this.isFaceX = actor.get_isFaceX();
        this.nowDelay = actor.get_nowDelay();
        this.indexFrame = actor.get_indexFrame();
        if (this.indexFrame < 0) {
            return;
        }
        if (this.indexFrame > this.Actions[this.indexAnimate].length) {
            return;
        }
        int screenX = _x;
        int screenY = _y;
        boolean flipX = this.isFaceX;
        boolean flipY = this.isFaceY;
        short frameIndex = this.Actions[this.indexAnimate][this.indexFrame];
        short[] s = this.Frames[frameIndex];
        int dgflag = 0;
        this.m_curclipx = this.m_clipx;
        this.m_curclipy = this.m_clipy;
        for (int i = 0; i < s.length; i += 4) {
            int modID = (s[i] & 0xFFFF) << 2;
            int flag = s[i + 1] & 0xFFFF;
            short modX = this.Modules[modID];
            short modY = this.Modules[modID + 1];
            short modW = this.Modules[modID + 2];
            short modH = this.Modules[modID + 3];
            boolean flipXs = flipX ^ (flag & 1) != 0;
            boolean flipYs = flipY ^ (flag & 2) != 0;
            int posX = screenX;
            int posY = screenY;
            posX = flipX ? (posX -= s[i + 2]) : (posX += s[i + 2]);
            posY = flipY ? (posY -= s[i + 3]) : (posY += s[i + 3]);
            short s2 = flipYs ? modH : (short)0;
            dgflag = Animation.trans(flipXs, flipYs);
            MyCanvas.drawRegion(g, this.s_images, modX, modY, modW, modH, dgflag, posX -= flipXs ? modW : (short)0, posY -= s2, 20);
        }
    }

    public void draw(Graphics g) {
        if (this.indexFrame < 0) {
            return;
        }
        if (this.indexFrame > this.Actions[this.indexAnimate].length) {
            return;
        }
        int screenX = this.x;
        int screenY = this.y;
        boolean flipX = this.isFaceX;
        boolean flipY = this.isFaceY;
        short frameIndex = this.Actions[this.indexAnimate][this.indexFrame];
        short[] s = this.Frames[frameIndex];
        int dgflag = 0;
        this.m_curclipx = this.m_clipx;
        this.m_curclipy = this.m_clipy;
        for (int i = 0; i < s.length; i += 4) {
            int modID = (s[i] & 0xFFFF) << 2;
            int flag = s[i + 1] & 0xFFFF;
            short modX = this.Modules[modID];
            short modY = this.Modules[modID + 1];
            short modW = this.Modules[modID + 2];
            short modH = this.Modules[modID + 3];
            boolean flipXs = flipX ^ (flag & 1) != 0;
            boolean flipYs = flipY ^ (flag & 2) != 0;
            int posX = screenX;
            int posY = screenY;
            posX = flipX ? (posX -= s[i + 2]) : (posX += s[i + 2]);
            posY = flipY ? (posY -= s[i + 3]) : (posY += s[i + 3]);
            short s2 = flipYs ? modH : (short)0;
            dgflag = Animation.trans(flipXs, flipYs);
            Animation.drawRegion(g, this.s_images, this.s_image_mirror, modX, modY, modW, modH, dgflag, posX -= flipXs ? modW : (short)0, posY -= s2, 20);
        }
    }

    public static void drawRegion(Graphics g, Image image, Image imageMirror, int x_src, int y_src, int width, int height, int type, int x_dest, int y_dest, int anchor) {
        int[] xy = Animation.anchorTranslate(anchor, x_dest, y_dest, width, height);
        x_dest = xy[0];
        y_dest = xy[1];
        anchor = 20;
        if (type < 4) {
            g.setClip(x_dest, y_dest, width, height);
            g.clipRect(x_dest, y_dest, width, height);
        } else {
            g.setClip(x_dest, y_dest, height, width);
            g.clipRect(x_dest, y_dest, height, width);
        }
        MyCanvas.drawRegion(g, image, x_src, y_src, width, height, type, x_dest, y_dest, 20);
        g.setClip(0, 0, 240, 320);
    }

    public static int[] anchorTranslate(int anchor, int x, int y, int w, int h) {
        int[] xy = new int[]{0, 0};
        if ((8 & anchor) != 0) {
            x -= w;
        } else if ((1 & anchor) != 0) {
            x -= w / 2;
        }
        if ((0x20 & anchor) != 0) {
            y -= h;
        } else if ((2 & anchor) != 0) {
            y -= h / 2;
        }
        xy[0] = x;
        xy[1] = y;
        return xy;
    }

    static int trans(boolean flipX, boolean flipY) {
        if (!flipX && !flipY) {
            return 0;
        }
        if (flipX && !flipY) {
            return 2;
        }
        if (!flipX && flipY) {
            return 1;
        }
        return 3;
    }

    public static final byte[] readDataByte(DataInputStream dis, int length) throws Exception {
        byte[] data = new byte[length];
        dis.read(data, 0, length);
        return data;
    }

    public static final void readDataShort(DataInputStream dis, short[] data, int off, int length) throws Exception {
        for (int i = 0; i < length; ++i) {
            data[i + off] = dis.readShort();
        }
    }
}

