/*
 * Decompiled with CFR 0.152.
 */
package animation;

import Default.Map;
import Default.Tile;
import data.Data;
import java.io.DataInputStream;

public class ReadMap {
    public byte number_x;
    public byte number_y;
    public byte[] mapData;
    public short building_number;
    public byte[] building_id;
    public byte[] building_x;
    public byte[] building_y;
    public byte genius_number;
    public byte[] genius_id;
    public byte[] genius_x;
    public byte[] genius_y;
    public byte[] genius_type;
    public byte[] genius_attributes;
    public int wap_number;
    public byte[] wap_x;
    public byte[] wap_y;
    Map map = null;

    public ReadMap(Map _map) {
        this.map = _map;
    }

    public void LoadMap(String res) {
        try {
            int i;
            DataInputStream dis = this.loadBinaryFile(res);
            if (dis == null) {
                return;
            }
            this.number_x = dis.readByte();
            this.number_y = dis.readByte();
            this.mapData = new byte[this.number_x * this.number_y];
            this.map.map = new Tile[this.number_x][this.number_y];
            Data.n_x = this.number_x;
            Data.n_y = this.number_y;
            Data.map_width = Data.n_x * 32;
            Data.map_height = Data.n_y * 32;
            for (i = 0; i < this.mapData.length; ++i) {
                this.map.map[i % this.number_x][i / this.number_x] = new Tile(this.map);
                this.map.map[i % this.number_x][i / this.number_x].setinit();
                if (Data.iswuxian) {
                    byte wuxian_temp = dis.readByte();
                    if (wuxian_temp == 2) {
                        this.map.map[i % this.number_x][i / this.number_x].setTile(wuxian_temp);
                        continue;
                    }
                    if (wuxian_temp == -1) {
                        this.map.map[i % this.number_x][i / this.number_x].setTile(wuxian_temp);
                        continue;
                    }
                    switch ((Data.wuxian_level - 1) % 5) {
                        case 0: {
                            this.map.map[i % this.number_x][i / this.number_x].setTile(wuxian_temp);
                            break;
                        }
                        case 1: {
                            this.map.map[i % this.number_x][i / this.number_x].setTile(wuxian_temp - 1);
                            break;
                        }
                        case 2: {
                            this.map.map[i % this.number_x][i / this.number_x].setTile(wuxian_temp - 3);
                            break;
                        }
                        case 3: {
                            this.map.map[i % this.number_x][i / this.number_x].setTile(wuxian_temp + 1);
                            break;
                        }
                        case 4: {
                            this.map.map[i % this.number_x][i / this.number_x].setTile(wuxian_temp - 4);
                        }
                    }
                    continue;
                }
                this.map.map[i % this.number_x][i / this.number_x].setTile(dis.readByte());
            }
            this.building_number = dis.readShort();
            this.building_id = new byte[this.getBuilding_number()];
            for (i = 0; i < this.getBuilding_number(); ++i) {
                this.building_id[i] = dis.readByte();
            }
            this.building_x = new byte[this.getBuilding_number()];
            for (i = 0; i < this.getBuilding_number(); ++i) {
                this.building_x[i] = dis.readByte();
            }
            this.building_y = new byte[this.getBuilding_number()];
            for (i = 0; i < this.getBuilding_number(); ++i) {
                this.building_y[i] = dis.readByte();
            }
            this.genius_number = dis.readByte();
            this.genius_id = new byte[this.getGenius_number()];
            for (i = 0; i < this.getGenius_number(); ++i) {
                this.genius_id[i] = dis.readByte();
            }
            this.genius_x = new byte[this.getGenius_number()];
            for (i = 0; i < this.getGenius_number(); ++i) {
                this.genius_x[i] = dis.readByte();
            }
            this.genius_y = new byte[this.getGenius_number()];
            for (i = 0; i < this.getGenius_number(); ++i) {
                this.genius_y[i] = dis.readByte();
            }
            this.genius_type = new byte[this.getGenius_number()];
            this.genius_attributes = new byte[this.getGenius_number()];
            for (i = 0; i < this.getGenius_number(); ++i) {
                this.genius_type[i] = dis.readByte();
                switch (this.genius_type[i]) {
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: {
                        this.genius_attributes[i] = dis.readByte();
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 18: {
                        this.genius_attributes[i] = dis.readByte();
                    }
                }
                byte pNums = dis.readByte();
                for (int j = 0; j < 3; ++j) {
                    dis.readByte();
                }
            }
            dis.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final DataInputStream loadBinaryFile(String str) {
        return new DataInputStream(this.getClass().getResourceAsStream(str));
    }

    public byte getNumber_x() {
        return this.number_x;
    }

    public byte getNumber_y() {
        return this.number_y;
    }

    public byte[][] getMapData() {
        byte[][] map = new byte[this.number_x][this.number_y];
        for (int i = 0; i < this.mapData.length; ++i) {
            int x = 0;
            int y = 0;
            if (y == this.number_y - 1) {
                ++y;
                x = 0;
            }
            map[y][++x] = this.mapData[i];
        }
        return map;
    }

    public short getBuilding_number() {
        return this.building_number;
    }

    public byte[] getBuilding_id() {
        return this.building_id;
    }

    public byte[] getBuilding_x() {
        return this.building_x;
    }

    public byte[] getBuilding_y() {
        return this.building_y;
    }

    public byte getGenius_number() {
        return this.genius_number;
    }

    public byte[] getGenius_id() {
        return this.genius_id;
    }

    public byte[] getGenius_x() {
        return this.genius_x;
    }

    public byte[] getGenius_y() {
        return this.genius_y;
    }

    public byte[] getGenius_type() {
        return this.genius_type;
    }

    public byte[] getGenius_attributes() {
        return this.genius_attributes;
    }

    public int getWap_number() {
        return this.wap_number;
    }

    public byte[] getWap_x() {
        return this.wap_x;
    }

    public byte[] getWap_y() {
        return this.wap_y;
    }
}

