/*
 * Decompiled with CFR 0.152.
 */
package data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public abstract class KEngine
extends Canvas
implements Runnable,
CommandListener {
    public static boolean DEBUG_MIDP2_ENABLE = false;
    public static boolean DEBUG_NOKIAUI_ENABLE = true;
    public static boolean DEBUG_SHOW_FPS = false;
    public static boolean DEBUG_SHOW_KEYCODE = false;
    public static boolean DEBUG_SHOW_MEMORY = false;
    public static boolean DEBUG_SHOW_MESSAGE = false;
    public static boolean FONT_EDGED_SHADOW = true;
    public static boolean MAP_CARMACK_BUFFER = true;
    public static byte FLIP_MSEL = (byte)70;
    public static short SCREEN_WIDTH = (short)240;
    public static short SCREEN_HEIGHT = (short)320;
    public static byte TILE_HEIGHT = (byte)16;
    public static byte TILE_WIDTH = (byte)16;
    public static final int BIT_BLOCK = 8;
    public static final int IMAGE_BLOCK = 50;
    public static final int STRING_BLOCK = 30;
    public static final int STATE_LOADING = -1;
    public static final byte TRANS_NONE = 0;
    public static final byte TRANS_MIRROR_ROT180 = 1;
    public static final byte TRANS_MIRROR = 2;
    public static final byte TRANS_ROT180 = 3;
    public static final byte TRANS_MIRROR_ROT270 = 4;
    public static final byte TRANS_ROT90 = 5;
    public static final byte TRANS_ROT270 = 6;
    public static final byte TRANS_MIRROR_ROT90 = 7;
    public static final byte ROTATE_ANTICLOCKWISE_90 = 0;
    public static final byte ROTATE_DEASIL_90 = 1;
    public static final byte ROTATE_HORIZONTAL = 2;
    public static final byte ROTATE_VERTICAL = 3;
    public static final int ANC_TCENTER = 17;
    public static final int ANC_TLEFT = 20;
    public static final int ANC_TRIGHT = 24;
    public static final int ANC_BCENTER = 33;
    public static final int ANC_BLEFT = 36;
    public static final int ANC_BRIGHT = 40;
    public static final int ANC_LVCENTER = 6;
    public static final int ANC_RVCENTER = 10;
    public static final int ANC_HVCENTER = 3;
    public static final byte EFFECT_END = -1;
    public static final byte EFFECT_SHUTTER_HORIZONTAL = 0;
    public static final byte EFFECT_SHUTTER_VERTICAL = 1;
    public static final byte EFFECT_SHUTTER_COMPLEX = 2;
    public static final byte EFFECT_CONVERGE = 3;
    public static final byte EFFECT_DIFFUSE = 4;
    public static final byte EFFECT_ELICIT_LEFT = 5;
    public static final byte EFFECT_ELICIT_RIGHT = 6;
    public static final byte EFFECT_ELICIT_UP = 7;
    public static final byte EFFECT_ELICIT_DOWN = 8;
    public static final byte EFFECT_CURTAIN_UD2CENTER = 9;
    public static final byte EFFECT_CURTAIN_CENTER2UD = 10;
    public static final byte EFFECT_CURTAIN_LR2CENTER = 11;
    public static final byte EFFECT_CURTAIN_CENTER2LR = 12;
    public static final byte EFFECT_CROSS_INNER = 13;
    public static final byte EFFECT_CROSS_OUTTER = 14;
    public static final byte EFFECT_ENTRY_NORTHEAST = 15;
    public static final byte EFFECT_ENTRY_NORTHWEST = 16;
    public static final byte EFFECT_ENTRY_SOUTHEAST = 17;
    public static final byte EFFECT_ENTRY_SOUTHWEST = 18;
    public static final byte EFFECT_HACKLE_HORIZONTAL = 19;
    public static final byte EFFECT_HACKLE_VERTICAL = 20;
    public static final byte EFFECT_FADE = 21;
    public static final int KEY_NULL = 0;
    public static final int KEY_0 = 2;
    public static final int KEY_1 = 4;
    public static final int KEY_2 = 8;
    public static final int KEY_3 = 16;
    public static final int KEY_4 = 32;
    public static final int KEY_5 = 64;
    public static final int KEY_6 = 128;
    public static final int KEY_7 = 256;
    public static final int KEY_8 = 512;
    public static final int KEY_9 = 1024;
    public static final int KEY_STAR = 2048;
    public static final int KEY_POUND = 4096;
    public static final int KEY_UP = 8192;
    public static final int KEY_DOWN = 16384;
    public static final int KEY_LEFT = 32768;
    public static final int KEY_RIGHT = 65536;
    public static final int KEY_OK = 131072;
    public static final int KEY_SELECT = 262144;
    public static final int KEY_BACK = 524288;
    public static final byte KEY_0_BIT = 0;
    public static final byte KEY_1_BIT = 1;
    public static final byte KEY_2_BIT = 2;
    public static final byte KEY_3_BIT = 3;
    public static final byte KEY_4_BIT = 4;
    public static final byte KEY_5_BIT = 5;
    public static final byte KEY_6_BIT = 6;
    public static final byte KEY_7_BIT = 7;
    public static final byte KEY_8_BIT = 8;
    public static final byte KEY_9_BIT = 9;
    public static final byte KEY_STAR_BIT = 10;
    public static final byte KEY_POUND_BIT = 11;
    public static final byte KEY_UP_BIT = 12;
    public static final byte KEY_DOWN_BIT = 13;
    public static final byte KEY_LEFT_BIT = 14;
    public static final byte KEY_RIGHT_BIT = 15;
    public static final byte KEY_OK_BIT = 16;
    public static final byte KEY_SELECT_BIT = 17;
    public static final byte KEY_BACK_BIT = 18;
    public static final byte DIRECT_NULL = 0;
    public static final byte DIRECT_UP = 1;
    public static final byte DIRECT_RIGHT = 2;
    public static final byte DIRECT_DOWN = 3;
    public static final byte DIRECT_LEFT = 4;
    public static final Font FONT = Font.getFont((int)64, (int)0, (int)8);
    public static final int FONT_HEIGHT = FONT.getHeight();
    public static final int COLOR_TRANSPARENT = -1;
    public static final int COLOR_SILVER = 0xC0C0C0;
    public static final int COLOR_BROWN = 0x804000;
    public static final int COLOR_ORANGE = 0xFF8000;
    public static final int COLOR_WHITE = 0xFEFEFE;
    public static final int COLOR_LT_GRAY = 0xAAAAAA;
    public static final int COLOR_DK_GRAY = 0x555555;
    public static final int COLOR_BLACK = 0;
    public static final int COLOR_LT_RED = 0xFFAAAA;
    public static final int COLOR_DK_RED = 0x550000;
    public static final int COLOR_RED = 0xFF0000;
    public static final int COLOR_LT_GREEN = 0xAAFFAA;
    public static final int COLOR_DK_GREEN = 21760;
    public static final int COLOR_GREEN = 65280;
    public static final int COLOR_LT_BLUE = 0xAAAAFF;
    public static final int COLOR_DK_BLUE = 85;
    public static final int COLOR_BLUE = 255;
    public static final int COLOR_LT_YELLOW = 0xFFFFAA;
    public static final int COLOR_YELLOW = 0xFFFF00;
    public static final int COLOR_LT_CYAN = 0xAAFFFF;
    public static final int COLOR_CYAN = 65535;
    public static final int COLOR_LT_MAGENTA = 0xFFAAFF;
    public static final int COLOR_MAGENTA = 0xFF00FF;
    private static final Random RANDOM = new Random();
    private static final short[] SINES = new short[]{0, 4, 8, 13, 17, 22, 26, 31, 35, 40, 44, 48, 53, 57, 61, 66, 70, 74, 79, 83, 87, 91, 95, 100, 104, 108, 112, 116, 120, 124, 127, 131, 135, 139, 143, 146, 150, 154, 157, 161, 164, 167, 171, 174, 177, 181, 184, 187, 190, 193, 196, 198, 201, 204, 207, 209, 212, 214, 217, 219, 221, 223, 226, 228, 230, 232, 233, 235, 237, 238, 240, 242, 243, 244, 246, 247, 248, 249, 250, 251, 252, 252, 253, 254, 254, 255, 255, 255, 256, 256, 256};
    private static final int[] ZIP_DISTANCE_EXTRA_BITS = new int[]{0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13};
    private static final int[] ZIP_DISTANCE_VALUES = new int[]{1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577};
    private static final int[] ZIP_DYNAMIC_LENGTH_ORDER = new int[]{16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};
    private static final int[] ZIP_LENGTH_EXTRA_BITS = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0, 99, 99};
    private static final int[] ZIP_LENGTH_VALUES = new int[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31, 35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258, 0, 0};
    private static final int ZIPTAG_BTYPE_DYNAMIC = 2;
    private static final int ZIPTAG_BTYPE_NONE = 0;
    private static final int ZIPTAG_EOB_CODE = 256;
    private static final int ZIPTAG_FCOMMENT_MASK = 16;
    private static final int ZIPTAG_FEXTRA_MASK = 4;
    private static final int ZIPTAG_FHCRC_MASK = 2;
    private static final int ZIPTAG_FNAME_MASK = 8;
    private static final int ZIPTAG_MAX_BITS = 16;
    private static final int ZIPTAG_MAX_CODE_DISTANCES = 31;
    private static final int ZIPTAG_MAX_CODE_LENGTHS = 18;
    private static final int ZIPTAG_MAX_CODE_LITERALS = 287;
    private static final int MAX_THREAD_SIZE = 5;
    private static final byte versionH = 1;
    private static final byte versionL = 1;
    private static final int DEFAULT_STACK_SIZE = 512;
    private static final String HEAD_BLOCK = "SNAKE_SSE";
    private static final String MAIN_ENTRY = "_Main";
    private static final byte RETVAL_SIZE = 2;
    private static final byte POPVAL_SIZE = 2;
    private static final int CONTEXT_FORMAT_SIZE = 7;
    public static final byte INSTR_MOV = 0;
    public static final byte INSTR_ADD = 1;
    public static final byte INSTR_SUB = 2;
    public static final byte INSTR_MUL = 3;
    public static final byte INSTR_DIV = 4;
    public static final byte INSTR_MOD = 5;
    public static final byte INSTR_EXP = 6;
    public static final byte INSTR_NEG = 7;
    public static final byte INSTR_INC = 8;
    public static final byte INSTR_DEC = 9;
    public static final byte INSTR_AND = 10;
    public static final byte INSTR_OR = 11;
    public static final byte INSTR_XOR = 12;
    public static final byte INSTR_NOT = 13;
    public static final byte INSTR_SHL = 14;
    public static final byte INSTR_SHR = 15;
    public static final byte INSTR_CONCAT = 16;
    public static final byte INSTR_GETCHAR = 17;
    public static final byte INSTR_SETCHAR = 18;
    public static final byte INSTR_JMP = 19;
    public static final byte INSTR_JE = 20;
    public static final byte INSTR_JNE = 21;
    public static final byte INSTR_JG = 22;
    public static final byte INSTR_JL = 23;
    public static final byte INSTR_JGE = 24;
    public static final byte INSTR_JLE = 25;
    public static final byte INSTR_PUSH = 26;
    public static final byte INSTR_POP = 27;
    public static final byte INSTR_CALL = 28;
    public static final byte INSTR_RET = 29;
    public static final byte INSTR_CALLHOST = 30;
    public static final byte INSTR_PAUSE = 31;
    public static final byte INSTR_EXIT = 32;
    public static final byte INSTR_DAP = 33;
    public static final byte INSTR_LOAD = 34;
    public static final byte INSTR_START = 35;
    public static final byte INSTR_RESET = 36;
    public static final byte INSTR_STOP = 37;
    public static final byte INSTR_FREE = 38;
    public static final byte INSTR_UNPAUSE = 39;
    public static final byte INSTR_INVOKE = 40;
    public static final byte INSTR_INVOKESYNC = 41;
    public static final byte INSTR_MEM_ALLOC = 42;
    public static final byte INSTR_MEM_FREE = 43;
    public static final byte INSTR_MEM_LOCK = 44;
    public static final byte INSTR_MEM_UNLOCK = 45;
    public static final byte INSTR_MEM_GET = 46;
    public static final byte INSTR_MEM_SET = 47;
    public static final byte INSTR_MEM_CREATE = 48;
    public static final byte INSTR_MEM_DESTROY = 49;
    public static final byte OP_TYPE_INT = 0;
    public static final byte OP_TYPE_STRING_INDEX = 2;
    public static final byte OP_TYPE_ABS_STACK_INDEX = 3;
    public static final byte OP_TYPE_REL_STACK_INDEX = 4;
    public static final byte OP_TYPE_INSTR_INDEX = 5;
    public static final byte OP_TYPE_FUNC_INDEX = 6;
    public static final byte OP_TYPE_HOST_API_CALL = 7;
    public static final byte OP_TYPE_REG = 8;
    public static final byte TRUE = 1;
    public static final byte FALSE = 0;
    private static final byte MASK_ISDAP = 1;
    private static final byte MASK_ISRET = 2;
    private static final int HANDLE_MASK = 65535;
    private static final int MEMORY_HANDLE = -983040;
    private static final int THREAD_HANDLE = -917504;
    private static final String ERROR_SUPPORT_VERSION = "SVM only can support script version is 1.1";
    private static final String ERROR_FILE_NOT_SUPPORT = "SVM can not support this file";
    private static final String ERROR_HEAP_OVERFLOW = "Stack is overflow";
    private static final String ERROR_STACK_EMPTY = "Stack is Empty!";
    private static final String ERROR_TYPE_INVAILD = "type is invalid to be run";
    private static final String ERROR_TYPE_CONVERT_FAULT = "type convert fault";
    private static final String ERROR_STACK_INDEX_NEGATIVE = "stack ref index is negative";
    private static final String ERROR_NO_MEMORY = "SVM only support five script ";
    private static final String ERROR_PARAM_BOUND = "Main-Engine'paramters invoke more count";
    private static final String ERROR_PARAM_NEGATIVE = "Main-Engine'paramers count is negative";
    private static final String ERROR_INVOKE = "invoke: funcID out of bound";
    protected static short FPS;
    protected static int KEYCODE;
    protected static int frameTimer;
    protected static int gameState;
    protected static int targetGS;
    protected static Graphics g;
    protected static MIDlet gameApp;
    protected static KEngine instance;
    protected static boolean exit;
    private static Thread gameThread;
    private static int[] CRC_TABLE;
    private static int zipIndex;
    private static int zipByte;
    private static int zipBit;
    protected static Image[] imgPool;
    protected static String[] strPool;
    private static byte effectType;
    private static byte effectNum;
    private static byte effectTimer;
    private static int[] fadeColorArray;
    private static short gridWidth;
    private static short curGridWidth;
    private static short gridHeight;
    private static short curGridHeight;
    private static short deltaWidth;
    private static short deltaHeight;
    private static short effectRow;
    private static short effectCol;
    private static String[] _MethodNames;
    private static byte _VM_STATUS;
    private static int[][] _PDA;
    private static int[] _DynamicParam;
    private static String[][] _StrTable;
    private static int[][] _FuncTable;
    private static String[][] _HostAPICallTable;
    private static int[][] _RunTimeStack;
    private static int[] _RetVal;
    private static int[] _PopVal;
    private static byte[][][] _Instructions;
    private static int _currThread;
    private static int _currThreadActiveTime;
    private static boolean[] _ThreadActive;
    private static boolean[] _ThreadRunning;
    private static boolean[] _ThreadIsPause;
    private static boolean[] _ThreadMainPresent;
    private static int[] _ThreadPauseEndTime;
    private static int[] _ThreadContext;
    private static int _type_;
    private static int _value_;
    private static int _retFuncCount_;
    protected static String mapName;
    protected static short mapID;
    protected static int tileID;
    protected static short mapWidth;
    protected static short mapHeight;
    protected static short[] mapTilesL1;
    protected static short[] mapTilesL2;
    protected static byte mapColNum;
    protected static byte mapRowNum;
    protected static byte mapLayerNum;
    private static Graphics mapBG;
    private static Image mapBuf;
    private static boolean updateBG;
    private static int prevX0;
    private static int prevX1;
    private static int prevY0;
    private static int prevY1;
    protected static short screenX;
    protected static short screenY;
    protected static int STAGE_WIDTH;
    protected static int STAGE_HEIGHT;
    public static long calTime;

    public static final void Array_BubbleSort(int[] data, boolean smallToBig) {
        int high = data.length;
        for (int i = 0; i < high; ++i) {
            for (int j = i; j < high; ++j) {
                if (smallToBig) {
                    if (data[i] <= data[j]) continue;
                    KEngine.Array_SwapData(data, i, j);
                    continue;
                }
                if (data[i] >= data[j]) continue;
                KEngine.Array_SwapData(data, i, j);
            }
        }
    }

    public static final Image[] Array_Expand(Image[] oldArray, int expandBy) {
        Image[] newArray = new Image[oldArray.length + expandBy];
        System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
        return newArray;
    }

    public static final int[] Array_Expand(int[] oldArray, int expandBy) {
        int[] newArray = new int[oldArray.length + expandBy];
        System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
        return newArray;
    }

    public static final String[] Array_Expand(String[] oldArray, int expandBy) {
        String[] newArray = new String[oldArray.length + expandBy];
        System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
        return newArray;
    }

    private static final int Array_Partition(int[] data, int low, int high, boolean smallToBig) {
        int pos = low;
        int pivot = data[pos];
        for (int i = low + 1; i <= high; ++i) {
            if (smallToBig) {
                if (data[i] >= pivot) continue;
                KEngine.Array_SwapData(data, ++pos, i);
                continue;
            }
            if (data[i] <= pivot) continue;
            KEngine.Array_SwapData(data, ++pos, i);
        }
        KEngine.Array_SwapData(data, low, pos);
        return pos;
    }

    public static final void Array_QuickSort(int[] data, boolean smallToBig) {
        int low = 0;
        int high = data.length - 1;
        KEngine.Array_QuickSort(data, low, high, smallToBig);
    }

    private static final void Array_QuickSort(int[] data, int low, int high, boolean smallToBig) {
        if (low < high) {
            int pivot = KEngine.Array_Partition(data, low, high, smallToBig);
            KEngine.Array_QuickSort(data, low, pivot - 1, smallToBig);
            KEngine.Array_QuickSort(data, pivot + 1, high, smallToBig);
        }
    }

    private static final void Array_SwapData(int[] data, int i, int j) {
        int tmp = data[i];
        data[i] = data[j];
        data[j] = tmp;
    }

    private static final void CarmackMap_CopyFromBackImage(int modX, int modY, int w, int h, int screenX, int screenY) {
        g.setClip(screenX, screenY, w, h);
        g.clipRect(screenX, screenY, w, h);
        g.drawImage(mapBuf, screenX - modX, screenY - modY, 20);
    }

    private static final void CarmackMap_Init() {
        STAGE_WIDTH = SCREEN_WIDTH + TILE_WIDTH * 2 & ~(TILE_WIDTH - 1);
        STAGE_HEIGHT = SCREEN_HEIGHT + TILE_HEIGHT * 2 & ~(TILE_HEIGHT - 1);
        mapBuf = Image.createImage((int)STAGE_WIDTH, (int)STAGE_HEIGHT);
        mapBG = mapBuf.getGraphics();
    }

    private static final void CarmackMap_MappedDraw(Image tileImage, int tileX0, int tileY0, int tileX1, int tileY1) {
        int posY = tileY0 * TILE_HEIGHT % STAGE_HEIGHT;
        for (int j = tileY0; j <= tileY1; ++j) {
            int posX = tileX0 * TILE_WIDTH % STAGE_WIDTH;
            for (int i = tileX0; i <= tileX1; ++i) {
                mapBG.setClip(posX, posY, (int)TILE_WIDTH, (int)TILE_HEIGHT);
                mapBG.clipRect(posX, posY, (int)TILE_WIDTH, (int)TILE_HEIGHT);
                short id = (short)KEngine.Map_GetTile(i, j);
                if (id != -1) {
                    KEngine.Map_DrawTile(tileImage, posX, posY, id, (byte)0);
                    KEngine.Map_DrawTile(tileImage, posX, posY, id, (byte)1);
                }
                if ((posX += TILE_WIDTH) < STAGE_WIDTH) continue;
                posX -= STAGE_WIDTH;
            }
            if ((posY += TILE_HEIGHT) < STAGE_HEIGHT) continue;
            posY -= STAGE_HEIGHT;
        }
    }

    protected static void CarmackMap_Show(Image mapTile) {
        int end;
        int start;
        int alignedX0 = screenX / TILE_WIDTH;
        int alignedX1 = alignedX0 + SCREEN_WIDTH / TILE_WIDTH + 1;
        int alignedY0 = screenY / TILE_HEIGHT;
        int alignedY1 = alignedY0 + SCREEN_HEIGHT / TILE_HEIGHT + 1;
        if (updateBG) {
            updateBG = false;
            KEngine.CarmackMap_MappedDraw(mapTile, alignedX0, alignedY0, alignedX1, alignedY1);
            prevX0 = alignedX0;
            prevY0 = alignedY0;
            prevX1 = alignedX1;
            prevY1 = alignedY1;
        }
        if (prevX0 != alignedX0) {
            if (prevX0 < alignedX0) {
                start = prevX1 + 1;
                end = alignedX1;
            } else {
                start = alignedX0;
                end = prevX0 - 1;
            }
            KEngine.CarmackMap_MappedDraw(mapTile, start, alignedY0, end, alignedY1);
            prevX0 = alignedX0;
            prevX1 = alignedX1;
        }
        if (prevY0 != alignedY0) {
            if (prevY0 < alignedY0) {
                start = prevY1 + 1;
                end = alignedY1;
            } else {
                start = alignedY0;
                end = prevY0 - 1;
            }
            KEngine.CarmackMap_MappedDraw(mapTile, alignedX0, start, alignedX1, end);
            prevY0 = alignedY0;
            prevY1 = alignedY1;
        }
        int modX0 = screenX % STAGE_WIDTH;
        int modY0 = screenY % STAGE_HEIGHT;
        int modX1 = (screenX + SCREEN_WIDTH) % STAGE_WIDTH;
        int modY1 = (screenY + SCREEN_HEIGHT) % STAGE_HEIGHT;
        if (modX1 > modX0) {
            if (modY1 > modY0) {
                KEngine.CarmackMap_CopyFromBackImage(modX0, modY0, SCREEN_WIDTH, SCREEN_HEIGHT, 0, 0);
            } else {
                KEngine.CarmackMap_CopyFromBackImage(modX0, modY0, SCREEN_WIDTH, SCREEN_HEIGHT - modY1, 0, 0);
                KEngine.CarmackMap_CopyFromBackImage(modX0, 0, SCREEN_WIDTH, modY1, 0, 0 + SCREEN_HEIGHT - modY1);
            }
        } else if (modY1 > modY0) {
            KEngine.CarmackMap_CopyFromBackImage(modX0, modY0, SCREEN_WIDTH - modX1, SCREEN_HEIGHT, 0, 0);
            KEngine.CarmackMap_CopyFromBackImage(0, modY0, modX1, SCREEN_HEIGHT, SCREEN_WIDTH - modX1, 0);
        } else {
            KEngine.CarmackMap_CopyFromBackImage(modX0, modY0, SCREEN_WIDTH - modX1, SCREEN_HEIGHT - modY1, 0, 0);
            KEngine.CarmackMap_CopyFromBackImage(modX0, 0, SCREEN_WIDTH - modX1, modY1, 0, 0 + SCREEN_HEIGHT - modY1);
            KEngine.CarmackMap_CopyFromBackImage(0, modY0, modX1, SCREEN_HEIGHT - modY1, SCREEN_WIDTH - modX1, 0);
            KEngine.CarmackMap_CopyFromBackImage(0, 0, modX1, modY1, SCREEN_WIDTH - modX1, 0 + SCREEN_HEIGHT - modY1);
        }
    }

    private static final void Effect_Center2LeftRight() {
        if (curGridWidth < gridWidth) {
            short s = deltaWidth;
            deltaWidth = (short)(s + 1);
            curGridWidth = (short)(curGridWidth + s);
            g.setClip(gridWidth - curGridWidth, 0, curGridWidth << 1, (int)SCREEN_HEIGHT);
            instance.OnShow(gameState);
            g.setClip(0, 0, (int)SCREEN_WIDTH, (int)SCREEN_HEIGHT);
        } else {
            effectType = (byte)-1;
        }
    }

    private static final void Effect_Center2UpDown() {
        if (curGridHeight < gridHeight) {
            short s = deltaHeight;
            deltaHeight = (short)(s + 1);
            curGridHeight = (short)(curGridHeight + s);
            g.setClip(0, gridHeight - curGridHeight, (int)SCREEN_WIDTH, curGridHeight << 1);
            instance.OnShow(gameState);
            g.setClip(0, 0, (int)SCREEN_WIDTH, (int)SCREEN_HEIGHT);
        } else {
            effectType = (byte)-1;
        }
    }

    private static final void Effect_Converge() {
        if (curGridHeight < gridHeight) {
            short s = deltaHeight;
            deltaHeight = (short)(s + 1);
            curGridHeight = (short)(curGridHeight + s);
            short s2 = deltaWidth;
            deltaWidth = (short)(s2 + 1);
            curGridWidth = (short)(curGridWidth + s2);
            g.setClip(0, 0, (int)SCREEN_WIDTH, (int)curGridHeight);
            instance.OnShow(gameState);
            g.setClip(0, 0, (int)SCREEN_WIDTH, (int)SCREEN_HEIGHT);
            g.setClip(0, SCREEN_HEIGHT - curGridHeight, (int)SCREEN_WIDTH, (int)curGridHeight);
            instance.OnShow(gameState);
            g.setClip(0, 0, (int)SCREEN_WIDTH, (int)SCREEN_HEIGHT);
            g.setClip(0, (int)curGridHeight, (int)curGridWidth, SCREEN_HEIGHT - curGridHeight << 1);
            instance.OnShow(gameState);
            g.setClip(0, 0, (int)SCREEN_WIDTH, (int)SCREEN_HEIGHT);
            g.setClip(SCREEN_WIDTH - curGridWidth, (int)curGridHeight, (int)curGridWidth, SCREEN_HEIGHT - curGridHeight << 1);
            instance.OnShow(gameState);
            g.setClip(0, 0, (int)SCREEN_WIDTH, (int)SCREEN_HEIGHT);
        } else {
            effectType = (byte)-1;
        }
    }

    private static final void Effect_CrossInner() {
        if (curGridHeight < gridHeight) {
            short s = deltaHeight;
            deltaHeight = (short)(s + 1);
            curGridHeight = (short)(curGridHeight + s);
            short s2 = deltaWidth;
            deltaWidth = (short)(s2 + 1);
            curGridWidth = (short)(curGridWidth + s2);
            g.setClip(0, gridHeight - curGridHeight, (int)SCREEN_WIDTH, curGridHeight << 1);
            instance.OnShow(gameState);
            g.setClip(0, 0, (int)SCREEN_WIDTH, (int)SCREEN_HEIGHT);
            g.setClip(gridWidth - curGridWidth, 0, curGridWidth << 1, gridHeight - curGridHeight);
            instance.OnShow(gameState);
            g.setClip(0, 0, (int)SCREEN_WIDTH, (int)SCREEN_HEIGHT);
            g.setClip(gridWidth - curGridWidth, gridHeight + curGridHeight, curGridWidth << 1, gridHeight - curGridHeight);
            instance.OnShow(gameState);
            g.setClip(0, 0, (int)SCREEN_WIDTH, (int)SCREEN_HEIGHT);
        } else {
            effectType = (byte)-1;
        }
    }

    private static final void Effect_CrossOut() {
        if (curGridWidth < gridWidth) {
            short s = deltaHeight;
            deltaHeight = (short)(s + 1);
            curGridHeight = (short)(curGridHeight + s);
            short s2 = deltaWidth;
            deltaWidth = (short)(s2 + 1);
            curGridWidth = (short)(curGridWidth + s2);
            g.setClip(0, 0, (int)curGridWidth, (int)curGridHeight);
            instance.OnShow(gameState);
            g.setClip(0, 0, (int)SCREEN_WIDTH, (int)SCREEN_HEIGHT);
            g.setClip(0, SCREEN_HEIGHT - curGridHeight, (int)curGridWidth, (int)curGridHeight);
            instance.OnShow(gameState);
            g.setClip(0, 0, (int)SCREEN_WIDTH, (int)SCREEN_HEIGHT);
            g.setClip(SCREEN_WIDTH - curGridWidth, 0, (int)curGridWidth, (int)curGridHeight);
            instance.OnShow(gameState);
            g.setClip(0, 0, (int)SCREEN_WIDTH, (int)SCREEN_HEIGHT);
            g.setClip(SCREEN_WIDTH - curGridWidth, SCREEN_HEIGHT - curGridHeight, (int)curGridWidth, (int)curGridHeight);
            instance.OnShow(gameState);
            g.setClip(0, 0, (int)SCREEN_WIDTH, (int)SCREEN_HEIGHT);
        } else {
            effectType = (byte)-1;
        }
    }

    private static final void Effect_Diffuse() {
        if (curGridHeight < gridHeight) {
            short s = deltaHeight;
            deltaHeight = (short)(s + 1);
            curGridHeight = (short)(curGridHeight + s);
            short s2 = deltaWidth;
            deltaWidth = (short)(s2 + 1);
            curGridWidth = (short)(curGridWidth + s2);
            g.setClip(SCREEN_WIDTH / 2 - curGridWidth, SCREEN_HEIGHT / 2 - curGridHeight, curGridWidth << 1, curGridHeight << 1);
            instance.OnShow(gameState);
            g.setClip(0, 0, (int)SCREEN_WIDTH, (int)SCREEN_HEIGHT);
        } else {
            effectType = (byte)-1;
        }
    }

    private static final void Effect_ElicitDown() {
        if (curGridHeight < gridHeight) {
            short s = deltaHeight;
            deltaHeight = (short)(s + 1);
            curGridHeight = (short)(curGridHeight + s);
            g.setClip(0, SCREEN_HEIGHT - curGridHeight, (int)SCREEN_WIDTH, (int)curGridHeight);
            instance.OnShow(gameState);
            g.setClip(0, 0, (int)SCREEN_WIDTH, (int)SCREEN_HEIGHT);
        } else {
            effectType = (byte)-1;
        }
    }

    private static final void Effect_ElicitLeft() {
        if (curGridWidth < gridWidth) {
            short s = deltaWidth;
            deltaWidth = (short)(s + 1);
            curGridWidth = (short)(curGridWidth + s);
            g.setClip(0, 0, (int)curGridWidth, (int)SCREEN_HEIGHT);
            instance.OnShow(gameState);
            g.setClip(0, 0, (int)SCREEN_WIDTH, (int)SCREEN_HEIGHT);
        } else {
            effectType = (byte)-1;
        }
    }

    private static final void Effect_ElicitRight() {
        if (curGridWidth < gridWidth) {
            short s = deltaWidth;
            deltaWidth = (short)(s + 1);
            curGridWidth = (short)(curGridWidth + s);
            g.setClip(SCREEN_WIDTH - curGridWidth, 0, (int)curGridWidth, (int)SCREEN_HEIGHT);
            instance.OnShow(gameState);
            g.setClip(0, 0, (int)SCREEN_WIDTH, (int)SCREEN_HEIGHT);
        } else {
            effectType = (byte)-1;
        }
    }

    private static final void Effect_ElicitUp() {
        if (curGridHeight < gridHeight) {
            short s = deltaHeight;
            deltaHeight = (short)(s + 1);
            curGridHeight = (short)(curGridHeight + s);
            g.setClip(0, 0, (int)SCREEN_WIDTH, (int)curGridHeight);
            instance.OnShow(gameState);
            g.setClip(0, 0, (int)SCREEN_WIDTH, (int)SCREEN_HEIGHT);
        } else {
            effectType = (byte)-1;
        }
    }

    private static final void Effect_EntryNorthEast() {
        if (curGridHeight < gridHeight) {
            short s = deltaHeight;
            deltaHeight = (short)(s + 1);
            curGridHeight = (short)(curGridHeight + s);
            short s2 = deltaWidth;
            deltaWidth = (short)(s2 + 1);
            curGridWidth = (short)(curGridWidth + s2);
            g.setClip(0, SCREEN_HEIGHT - curGridHeight, (int)curGridWidth, (int)curGridHeight);
            instance.OnShow(gameState);
            g.setClip(0, 0, (int)SCREEN_WIDTH, (int)SCREEN_HEIGHT);
        } else {
            effectType = (byte)-1;
        }
    }

    private static final void Effect_EntryNorthWest() {
        if (curGridHeight < gridHeight) {
            short s = deltaHeight;
            deltaHeight = (short)(s + 1);
            curGridHeight = (short)(curGridHeight + s);
            short s2 = deltaWidth;
            deltaWidth = (short)(s2 + 1);
            curGridWidth = (short)(curGridWidth + s2);
            g.setClip(gridWidth - curGridWidth, gridHeight - curGridHeight, (int)curGridWidth, (int)curGridHeight);
            instance.OnShow(gameState);
            g.setClip(0, 0, (int)SCREEN_WIDTH, (int)SCREEN_HEIGHT);
        } else {
            effectType = (byte)-1;
        }
    }

    private static final void Effect_EntrySouthEast() {
        if (curGridHeight < gridHeight) {
            short s = deltaHeight;
            deltaHeight = (short)(s + 1);
            curGridHeight = (short)(curGridHeight + s);
            short s2 = deltaWidth;
            deltaWidth = (short)(s2 + 1);
            curGridWidth = (short)(curGridWidth + s2);
            g.setClip(0, 0, (int)curGridWidth, (int)curGridHeight);
            instance.OnShow(gameState);
            g.setClip(0, 0, (int)SCREEN_WIDTH, (int)SCREEN_HEIGHT);
        } else {
            effectType = (byte)-1;
        }
    }

    private static final void Effect_EntrySouthWest() {
        if (curGridHeight < gridHeight) {
            short s = deltaHeight;
            deltaHeight = (short)(s + 1);
            curGridHeight = (short)(curGridHeight + s);
            short s2 = deltaWidth;
            deltaWidth = (short)(s2 + 1);
            curGridWidth = (short)(curGridWidth + s2);
            g.setClip(SCREEN_WIDTH - curGridWidth, 0, (int)curGridWidth, (int)curGridHeight);
            instance.OnShow(gameState);
            g.setClip(0, 0, (int)SCREEN_WIDTH, (int)SCREEN_HEIGHT);
        } else {
            effectType = (byte)-1;
        }
    }

    private static final void Effect_FadeIn() {
        if (frameTimer >= effectTimer) {
            for (int i = 0; i < SCREEN_WIDTH; ++i) {
                KEngine.fadeColorArray[i] = -16777216;
            }
        } else if (frameTimer >= effectTimer / 2 && frameTimer < effectTimer) {
            int i = 0;
            while (i < SCREEN_WIDTH) {
                int n = i++;
                fadeColorArray[n] = fadeColorArray[n] - 0x22000000;
            }
        } else {
            int i = 0;
            while (i < SCREEN_WIDTH) {
                int n = i++;
                fadeColorArray[n] = fadeColorArray[n] + 0x11000000;
            }
        }
        g.drawRGB(fadeColorArray, 0, 0, 0, 0, (int)SCREEN_WIDTH, (int)SCREEN_HEIGHT, true);
    }

    private static final void Effect_HackleHorizontal() {
        if (curGridWidth < gridWidth) {
            short s = deltaWidth;
            deltaWidth = (short)(s + 1);
            curGridWidth = (short)(curGridWidth + s);
            int i = effectRow;
            while (--i >= 0) {
                if ((i & 1) == 0) {
                    g.setClip(0, i * gridHeight, (int)curGridWidth, (int)gridHeight);
                } else {
                    g.setClip(SCREEN_WIDTH - curGridWidth, i * gridHeight, (int)curGridWidth, (int)gridHeight);
                }
                instance.OnShow(gameState);
                g.setClip(0, 0, (int)SCREEN_WIDTH, (int)SCREEN_HEIGHT);
            }
        } else {
            effectType = (byte)-1;
        }
    }

    private static final void Effect_HackleVertical() {
        if (curGridHeight < gridHeight) {
            short s = deltaHeight;
            deltaHeight = (short)(s + 1);
            curGridHeight = (short)(curGridHeight + s);
            int i = effectCol;
            while (--i >= 0) {
                if ((i & 1) == 0) {
                    g.setClip(i * gridWidth, 0, (int)gridWidth, (int)curGridHeight);
                } else {
                    g.setClip(i * gridWidth, gridHeight - curGridHeight, (int)gridWidth, (int)curGridHeight);
                }
                instance.OnShow(gameState);
                g.setClip(0, 0, (int)SCREEN_WIDTH, (int)SCREEN_HEIGHT);
            }
        } else {
            effectType = (byte)-1;
        }
    }

    private static final void Effect_LeftRight2Center() {
        if (curGridWidth < gridWidth) {
            short s = deltaWidth;
            deltaWidth = (short)(s + 1);
            curGridWidth = (short)(curGridWidth + s);
            g.setClip(0, 0, (int)curGridWidth, (int)SCREEN_HEIGHT);
            instance.OnShow(gameState);
            g.setClip(0, 0, (int)SCREEN_WIDTH, (int)SCREEN_HEIGHT);
            g.setClip(SCREEN_WIDTH - curGridWidth, 0, (int)curGridWidth, (int)SCREEN_HEIGHT);
            instance.OnShow(gameState);
            g.setClip(0, 0, (int)SCREEN_WIDTH, (int)SCREEN_HEIGHT);
        } else {
            effectType = (byte)-1;
        }
    }

    private static final void Effect_OnShow() {
        switch (effectType) {
            case -1: {
                return;
            }
            case 0: {
                KEngine.Effect_Shutter(frameTimer, effectTimer, true, false);
                break;
            }
            case 1: {
                KEngine.Effect_Shutter(frameTimer, effectTimer, false, true);
                break;
            }
            case 2: {
                KEngine.Effect_Shutter(frameTimer, effectTimer, true, true);
                break;
            }
            case 21: {
                KEngine.Effect_FadeIn();
                break;
            }
            case 4: {
                KEngine.Effect_Diffuse();
                break;
            }
            case 3: {
                KEngine.Effect_Converge();
                break;
            }
            case 5: {
                KEngine.Effect_ElicitLeft();
                break;
            }
            case 6: {
                KEngine.Effect_ElicitRight();
                break;
            }
            case 7: {
                KEngine.Effect_ElicitUp();
                break;
            }
            case 8: {
                KEngine.Effect_ElicitDown();
                break;
            }
            case 9: {
                KEngine.Effect_UpDown2Center();
                break;
            }
            case 10: {
                KEngine.Effect_Center2UpDown();
                break;
            }
            case 11: {
                KEngine.Effect_LeftRight2Center();
                break;
            }
            case 12: {
                KEngine.Effect_Center2LeftRight();
                break;
            }
            case 13: {
                KEngine.Effect_CrossInner();
                break;
            }
            case 14: {
                KEngine.Effect_CrossOut();
                break;
            }
            case 15: {
                KEngine.Effect_EntryNorthEast();
                break;
            }
            case 16: {
                KEngine.Effect_EntryNorthWest();
                break;
            }
            case 17: {
                KEngine.Effect_EntrySouthEast();
                break;
            }
            case 18: {
                KEngine.Effect_EntrySouthWest();
                break;
            }
            case 19: {
                KEngine.Effect_HackleHorizontal();
                break;
            }
            case 20: {
                KEngine.Effect_HackleVertical();
            }
        }
        if (frameTimer > effectTimer) {
            effectType = (byte)-1;
        }
    }

    private static final void Effect_Shutter(int currStep, int stepTotal, boolean hor, boolean ver) {
        int i;
        if (currStep < 0) {
            return;
        }
        g.setColor(0);
        int iFillStep = 16 / stepTotal;
        if (ver) {
            for (i = effectNum; i >= 0; --i) {
                g.fillRect(i * 16, 0, currStep * iFillStep, (int)SCREEN_HEIGHT);
            }
        }
        if (hor) {
            for (i = effectNum; i >= 0; --i) {
                g.fillRect(0, i * 16, (int)SCREEN_WIDTH, currStep * iFillStep);
            }
        }
    }

    public static final void Effect_Switch(int _effectType) {
        effectType = (byte)_effectType;
        effectTimer = (byte)10;
        frameTimer = 0;
        fadeColorArray = null;
        switch (_effectType) {
            case 0: 
            case 1: 
            case 2: {
                effectNum = (byte)(Math.max(SCREEN_WIDTH, SCREEN_HEIGHT) / 16 + 1);
                break;
            }
            case 21: {
                fadeColorArray = new int[SCREEN_WIDTH];
                effectTimer = (byte)20;
                break;
            }
            case 3: 
            case 4: {
                gridWidth = (short)(SCREEN_WIDTH >> 1);
                curGridWidth = 0;
                gridHeight = (short)(SCREEN_HEIGHT >> 1);
                curGridHeight = 0;
                deltaWidth = (short)(SCREEN_WIDTH == 128 ? 4 : 9);
                deltaHeight = (short)(SCREEN_WIDTH == 128 ? 4 : 11);
                break;
            }
            case 5: 
            case 6: {
                curGridWidth = 0;
                gridWidth = SCREEN_WIDTH;
                deltaWidth = (short)16;
                break;
            }
            case 7: 
            case 8: {
                curGridHeight = 0;
                gridHeight = SCREEN_HEIGHT;
                deltaHeight = (short)16;
                break;
            }
            case 9: 
            case 10: {
                curGridHeight = 0;
                gridHeight = (short)(SCREEN_HEIGHT / 2);
                deltaHeight = (short)8;
                break;
            }
            case 11: 
            case 12: {
                curGridWidth = 0;
                gridWidth = (short)(SCREEN_WIDTH / 2);
                deltaWidth = (short)8;
                break;
            }
            case 13: 
            case 14: {
                curGridWidth = 0;
                curGridHeight = 0;
                gridWidth = (short)(SCREEN_WIDTH / 2);
                gridHeight = (short)(SCREEN_HEIGHT / 2);
                deltaWidth = (short)(SCREEN_WIDTH == 128 ? 8 : 11);
                deltaHeight = (short)(SCREEN_HEIGHT == 128 ? 8 : 13);
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                curGridWidth = 0;
                curGridHeight = 0;
                gridWidth = SCREEN_WIDTH;
                gridHeight = SCREEN_HEIGHT;
                deltaWidth = (short)(SCREEN_WIDTH == 128 ? 8 : 11);
                deltaHeight = (short)(SCREEN_WIDTH == 128 ? 8 : 13);
                break;
            }
            case 19: {
                curGridWidth = 0;
                gridWidth = SCREEN_WIDTH;
                gridHeight = (short)(SCREEN_HEIGHT >> 2);
                effectRow = (short)4;
                deltaWidth = (short)(SCREEN_WIDTH == 176 ? 22 : 8);
                break;
            }
            case 20: {
                curGridHeight = 0;
                gridHeight = SCREEN_HEIGHT;
                gridWidth = (short)(SCREEN_WIDTH >> 2);
                effectCol = (short)4;
                deltaHeight = (short)(SCREEN_WIDTH == 176 ? 26 : 8);
            }
        }
    }

    private static final void Effect_UpDown2Center() {
        if (curGridHeight < gridHeight) {
            short s = deltaHeight;
            deltaHeight = (short)(s + 1);
            curGridHeight = (short)(curGridHeight + s);
            g.setClip(0, 0, (int)SCREEN_WIDTH, (int)curGridHeight);
            instance.OnShow(gameState);
            g.setClip(0, 0, (int)SCREEN_WIDTH, (int)SCREEN_HEIGHT);
            g.setClip(0, SCREEN_WIDTH - curGridHeight, (int)SCREEN_WIDTH, (int)curGridHeight);
            instance.OnShow(gameState);
            g.setClip(0, 0, (int)SCREEN_WIDTH, (int)SCREEN_HEIGHT);
        } else {
            effectType = (byte)-1;
        }
    }

    public static final void Effect_Wobble(int current, int sum, Image img, boolean horOrVer, int x, int y, int circle) {
        int width = img.getWidth();
        int height = img.getHeight();
        int halfWidth = width / 2;
        int wholeHeight = height / 1;
        int currentWidth = width * current / sum;
        int l3 = width * (sum - current) / (sum * 4);
        int currentAngle = 360 * current / sum;
        int angle = 360 * circle / wholeHeight;
        for (int i = 0; i < wholeHeight; ++i) {
            int moveX = l3 * KEngine.Math_Cos(currentAngle) >> 10;
            if (horOrVer) {
                g.setClip(x + halfWidth - currentWidth / 2 + moveX, y + i * 1, currentWidth, 1);
                g.drawImage(img, x + moveX, y, 20);
            } else {
                g.setClip(x + i * 1, y + halfWidth - currentWidth / 2 + moveX, 1, currentWidth);
                g.drawImage(img, x, y + moveX, 20);
            }
            currentAngle += angle;
        }
    }

    public static final int[] Flag_Create() {
        return new int[8];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int[] Flag_Create(byte[] dataFrom) {
        ByteArrayInputStream bais = new ByteArrayInputStream(dataFrom);
        DataInputStream dis = new DataInputStream(bais);
        try {
            int[] bitsWorkOn = new int[dis.readInt()];
            for (int i = 0; i < bitsWorkOn.length; ++i) {
                bitsWorkOn[i] = dis.readInt();
            }
            int[] nArray = bitsWorkOn;
            return nArray;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                dis.close();
                bais.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static final int[] Flag_Create(int initSize) {
        if (initSize > 0) {
            int size = initSize / 32;
            if (initSize % 32 != 0) {
                ++size;
            }
            return new int[size];
        }
        return null;
    }

    private static final int[] Flag_Expand(int[] bitsWorkOn, int index) {
        int oldSize = bitsWorkOn.length * 32;
        if (index >= oldSize) {
            int tmpSize = index - oldSize;
            int expandSize = tmpSize / 32;
            if (expandSize % 32 != 0) {
                ++expandSize;
            }
            if (expandSize < 8) {
                expandSize = 8;
            }
            bitsWorkOn = KEngine.Array_Expand(bitsWorkOn, expandSize);
        }
        return bitsWorkOn;
    }

    private static final int Flag_GetOffset(int[] bitsWorkOn, int index) {
        if (index >= 0 && index < bitsWorkOn.length * 32) {
            int offset = index % 32;
            return offset;
        }
        return -1;
    }

    private static final int Flag_GetValue(int[] bitsWorkOn, int index) {
        if (index >= 0 && index < bitsWorkOn.length * 32) {
            int target = index / 32;
            int value = bitsWorkOn[target];
            return value;
        }
        return -1;
    }

    public static final boolean Flag_Is(int[] bitsWorkOn, int index) {
        if (index >= 0 && index < bitsWorkOn.length * 32) {
            int offset;
            int value = KEngine.Flag_GetValue(bitsWorkOn, index);
            return (value >> (offset = KEngine.Flag_GetOffset(bitsWorkOn, index)) & 1) == 1;
        }
        return false;
    }

    public static final int[] Flag_MarkFalse(int[] bitsWorkOn, int index) {
        bitsWorkOn = KEngine.Flag_Expand(bitsWorkOn, index);
        int offset = KEngine.Flag_GetOffset(bitsWorkOn, index);
        int value = KEngine.Flag_GetValue(bitsWorkOn, index);
        int tmp = ~value;
        value = ~(tmp |= 1 << offset);
        bitsWorkOn = KEngine.Flag_SetValue(bitsWorkOn, index, value);
        return bitsWorkOn;
    }

    public static final int[] Flag_MarkTrue(int[] bitsWorkOn, int index) {
        bitsWorkOn = KEngine.Flag_Expand(bitsWorkOn, index);
        int offset = KEngine.Flag_GetOffset(bitsWorkOn, index);
        int value = KEngine.Flag_GetValue(bitsWorkOn, index);
        bitsWorkOn = KEngine.Flag_SetValue(bitsWorkOn, index, value |= 1 << offset);
        return bitsWorkOn;
    }

    public static final void Flag_Print(int[] bitsWorkOn) {
        StringBuffer sb = new StringBuffer("[KBitManager] ");
        for (int i = 0; i < bitsWorkOn.length; ++i) {
            for (int j = 0; j < 32; ++j) {
                int index = i * 32 + j;
                sb.append("[").append(index).append("-").append(KEngine.Flag_Is(bitsWorkOn, index)).append("]");
                if (index >= bitsWorkOn.length * 32 - 1) continue;
                sb.append(",");
            }
        }
        System.out.println(sb.toString());
    }

    private static final int[] Flag_SetValue(int[] bitsWorkOn, int index, int value) {
        if (index >= 0 && index < bitsWorkOn.length * 32) {
            int target = index / 32;
            bitsWorkOn[target] = value;
            return bitsWorkOn;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] Flag_ToByteArrays(int[] bitsWorkOn) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeInt(bitsWorkOn.length);
            for (int i = 0; i < bitsWorkOn.length; ++i) {
                dos.writeInt(bitsWorkOn[i]);
            }
            dos.flush();
            baos.flush();
            byte[] i = baos.toByteArray();
            return i;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                dos.close();
                baos.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static final boolean Geo_ArcCollisize(int x1, int y1, int r1, int x2, int y2, int r2) {
        return false;
    }

    public static final int Geo_GetDistance(int x1, int y1, int x2, int y2) {
        return KEngine.Math_Sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    public static final boolean Geo_IsPointInLine(int px, int py, int linex1, int liney1, int linex2, int liney2) {
        return false;
    }

    public static final boolean Geo_IsPointInRect(int px, int py, int rectX, int rectY, int rectW, int rectH) {
        return false;
    }

    public static final boolean Geo_RectColliside(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        return false;
    }

    public static final void GUI_Clear(Graphics g, int color, int x, int y, int width, int height) {
        g.setColor(color);
        g.fillRect(x, y, width, height);
    }

    public static final void GUI_DrawAlphaArc(Graphics g, int posX, int posY, int radius, int alpha) {
        int[] colorArray = new int[4 * radius * radius];
        for (int i = 0; i < 4 * radius * radius; ++i) {
            int x = i / (2 * radius);
            int y = i % (2 * radius);
            int distance = (radius - x) * (radius - x) + (radius - y) * (radius - y);
            colorArray[i] = distance > radius * radius ? 0xFF0000 : alpha;
        }
        g.drawRGB(colorArray, 0, radius * 2, posX, posY, radius * 2, radius * 2, true);
    }

    public static final void GUI_DrawAlphaRect(Graphics g, int x, int y, int width, int height, int alpha) {
        int[] colorArray = new int[width];
        for (int i = 0; i < colorArray.length; ++i) {
            colorArray[i] = alpha;
        }
        g.drawRGB(colorArray, 0, 0, x, y, width, height, true);
    }

    public static final void GUI_DrawAlphaRoundRect(Graphics g, int x, int y, int width, int height, int arcWidth, int arcHeight, int alpha) {
        KEngine.GUI_DrawAlphaRect(g, x, y, width, height, alpha);
        g.setColor(alpha & 0xFFFFFF);
        g.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    public static final void GUI_DrawImage(Graphics g, Image img, int srcX, int srcY, int width, int height, int transform, int destX, int destY, int anchor) {
        int n;
        boolean right;
        if (DEBUG_MIDP2_ENABLE && !DEBUG_NOKIAUI_ENABLE) {
            g.drawRegion(img, srcX, srcY, width, height, transform, destX, destY, anchor);
            return;
        }
        if (g == null || img == null) {
            throw new NullPointerException();
        }
        if (transform < 0 || transform > 7) {
            throw new IllegalArgumentException();
        }
        if (width < 0 || height < 0 || srcX < 0 || srcY < 0 || srcX + width > img.getWidth() || srcY + height > img.getHeight()) {
            throw new IllegalArgumentException();
        }
        if (anchor == 0) {
            anchor = 20;
        }
        boolean bl = right = anchor > 0 && anchor < 128 && (anchor & 0x40) == 0;
        if (right) {
            n = anchor & 0x72;
            boolean bl2 = right = n != 0 && (n & n - 1) == 0;
        }
        if (right) {
            n = anchor & 0xD;
            boolean bl3 = right = n != 0 && (n & n - 1) == 0;
        }
        if (!right) {
            throw new IllegalArgumentException();
        }
        int INVERTED_AXES = 4;
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        if ((INVERTED_AXES & transform) != 0) {
            if (anchor != 0) {
                if ((anchor & 0x20) != 0) {
                    destY -= width;
                }
                if ((anchor & 8) != 0) {
                    destX -= height;
                }
                if ((anchor & 1) != 0) {
                    destX -= height / 2;
                }
                if ((anchor & 2) != 0) {
                    destY -= width / 2;
                }
            }
            g.clipRect(destX, destY, height, width);
        } else {
            if (anchor != 0) {
                if ((anchor & 0x20) != 0) {
                    destY -= height;
                }
                if ((anchor & 8) != 0) {
                    destX -= width;
                }
                if ((anchor & 1) != 0) {
                    destX -= width / 2;
                }
                if ((anchor & 2) != 0) {
                    destY -= height / 2;
                }
            }
            g.clipRect(destX, destY, width, height);
        }
        int flipX = KEngine.GUI_GetFlipPosX(img, srcX, srcY, width, height, transform, destX, destY);
        int flipY = KEngine.GUI_GetFlipPosY(img, srcX, srcY, width, height, transform, destX, destY);
    }

    public static final void GUI_DrawPicNum(Image imgNum, int number, int x, int y, int anchor) {
        anchor = anchor == 0 ? 20 : anchor;
        int len = 1;
        int _number = Math.abs(number);
        while (_number > 9) {
            _number /= 10;
            ++len;
        }
        int width = imgNum.getWidth() / 10;
        int height = imgNum.getHeight();
        x = (anchor & 8) != 0 ? x - width * len : x;
        y = (anchor & 0x20) != 0 ? y - height : y;
        for (int i = 0; i < len; ++i) {
            int ext = Math.abs(number % 10);
            number /= 10;
            KEngine.GUI_DrawImage(g, imgNum, ext * width, 0, width, height, 0, x + (len - 1 - i) * width, y, anchor);
        }
    }

    public static final void GUI_DrawString(Graphics g, Font font, String str, int x, int y, int colorBody, int colorEdge, int anchor, boolean showShadow) {
        if (g != null) {
            g.setFont(font);
            if (showShadow) {
                g.setColor(colorEdge);
                g.drawString(str, x - 1, y, anchor);
                g.drawString(str, x + 1, y, anchor);
                g.drawString(str, x, y - 1, anchor);
                g.drawString(str, x, y + 1, anchor);
            }
            g.setColor(colorBody);
            g.drawString(str, x, y, anchor);
        }
    }

    public static final void GUI_DrawTab(Graphics g, Class instance, Vector tabs, int highLight, int x, int y, int width, int height) {
    }

    private static final int GUI_GetFlipPosX(Image img, int srcX, int srcY, int width, int height, int transform, int destX, int destY) {
        switch (transform) {
            case 5: {
                return destX - (img.getHeight() - (srcY + height));
            }
            case 3: {
                return destX - (img.getWidth() - (srcX + width));
            }
            case 6: {
                return destX - srcY;
            }
            case 2: {
                return destX - (img.getWidth() - (srcX + width));
            }
            case 7: {
                return destX - (img.getHeight() - (srcY + height));
            }
            case 1: {
                return destX - srcX;
            }
            case 4: {
                return destX - srcY;
            }
        }
        return destX - srcX;
    }

    private static final int GUI_GetFlipPosY(Image src, int srcX, int srcY, int width, int height, int transform, int destX, int destY) {
        switch (transform) {
            case 5: {
                return destY - srcX;
            }
            case 3: {
                return destY - (src.getHeight() - (srcY + height));
            }
            case 6: {
                return destY - (src.getWidth() - (srcX + width));
            }
            case 2: {
                return destY - srcY;
            }
            case 7: {
                return destY - (src.getWidth() - (srcX + width));
            }
            case 1: {
                return destY - (src.getHeight() - (srcY + height));
            }
            case 4: {
                return destY - srcX;
            }
        }
        return destY - srcY;
    }

    private static final int[] GZIP_CreateHuffmanTree(byte[] bits, int maxCode) {
        int[] bl_count = new int[17];
        for (int i = 0; i < bits.length; ++i) {
            byte by = bits[i];
            bl_count[by] = bl_count[by] + 1;
        }
        int code = 0;
        bl_count[0] = 0;
        int[] next_code = new int[17];
        for (int i = 1; i <= 16; ++i) {
            next_code[i] = code = code + bl_count[i - 1] << 1;
        }
        int[] tree = new int[(maxCode << 1) + 16];
        int treeInsert = 1;
        for (int i = 0; i <= maxCode; ++i) {
            byte len = bits[i];
            if (len == 0) continue;
            byte by = len;
            next_code[by] = next_code[by] + 1;
            int node = 0;
            for (int bit = len - 1; bit >= 0; --bit) {
                int value = code & 1 << bit;
                if (value == 0) {
                    int left = tree[node] >> 16;
                    if (left == 0) {
                        int n = node;
                        tree[n] = tree[n] | treeInsert << 16;
                        node = treeInsert++;
                        continue;
                    }
                    node = left;
                    continue;
                }
                int right = tree[node] & 0xFFFF;
                if (right == 0) {
                    int n = node;
                    tree[n] = tree[n] | treeInsert;
                    node = treeInsert++;
                    continue;
                }
                node = right;
            }
            tree[node] = Integer.MIN_VALUE | i;
        }
        return tree;
    }

    private static final byte[] GZIP_DecodeCodeLengths(byte[] gzip, int[] lengthTree, int count) {
        byte[] bits = new byte[count];
        int i = 0;
        int code = 0;
        int last = 0;
        while (i < count) {
            code = KEngine.GZIP_ReadCode(gzip, lengthTree);
            if (code >= 16) {
                int repeat = 0;
                if (code == 16) {
                    repeat = 3 + KEngine.GZIP_ReadBits(gzip, 2);
                    code = last;
                } else {
                    repeat = code == 17 ? 3 + KEngine.GZIP_ReadBits(gzip, 3) : 11 + KEngine.GZIP_ReadBits(gzip, 7);
                    code = 0;
                }
                while (repeat-- > 0) {
                    bits[i++] = (byte)code;
                }
            } else {
                bits[i++] = (byte)code;
            }
            last = code;
        }
        return bits;
    }

    public static final byte[] GZIP_Inflate(byte[] gzip) throws IOException {
        zipBit = 0;
        zipByte = 0;
        zipIndex = 0;
        if (KEngine.GZIP_ReadBits(gzip, 16) != 35615 || KEngine.GZIP_ReadBits(gzip, 8) != 8) {
            throw new IOException("Invalid GZIP format");
        }
        int flg = KEngine.GZIP_ReadBits(gzip, 8);
        zipIndex += 6;
        if ((flg & 4) != 0) {
            zipIndex += KEngine.GZIP_ReadBits(gzip, 16);
        }
        if ((flg & 8) != 0) {
            while (gzip[zipIndex++] != 0) {
            }
        }
        if ((flg & 0x10) != 0) {
            while (gzip[zipIndex++] != 0) {
            }
        }
        if ((flg & 2) != 0) {
            zipIndex += 2;
        }
        int index = zipIndex;
        zipIndex = gzip.length - 4;
        byte[] uncompressed = new byte[KEngine.GZIP_ReadBits(gzip, 16) | KEngine.GZIP_ReadBits(gzip, 16) << 16];
        int uncompressedIndex = 0;
        zipIndex = index;
        int bfinal = 0;
        int btype = 0;
        do {
            int[] distanceTree;
            int[] literalTree;
            bfinal = KEngine.GZIP_ReadBits(gzip, 1);
            btype = KEngine.GZIP_ReadBits(gzip, 2);
            if (btype == 0) {
                zipBit = 0;
                int len = KEngine.GZIP_ReadBits(gzip, 16);
                KEngine.GZIP_ReadBits(gzip, 16);
                System.arraycopy(gzip, zipIndex, uncompressed, uncompressedIndex, len);
                zipIndex += len;
                uncompressedIndex += len;
                continue;
            }
            if (btype == 2) {
                int hlit = KEngine.GZIP_ReadBits(gzip, 5) + 257;
                int hdist = KEngine.GZIP_ReadBits(gzip, 5) + 1;
                int hclen = KEngine.GZIP_ReadBits(gzip, 4) + 4;
                byte[] lengthBits = new byte[19];
                for (int i = 0; i < hclen; ++i) {
                    lengthBits[KEngine.ZIP_DYNAMIC_LENGTH_ORDER[i]] = (byte)KEngine.GZIP_ReadBits(gzip, 3);
                }
                int[] lengthTree = KEngine.GZIP_CreateHuffmanTree(lengthBits, 18);
                literalTree = KEngine.GZIP_CreateHuffmanTree(KEngine.GZIP_DecodeCodeLengths(gzip, lengthTree, hlit), hlit - 1);
                distanceTree = KEngine.GZIP_CreateHuffmanTree(KEngine.GZIP_DecodeCodeLengths(gzip, lengthTree, hdist), hdist - 1);
            } else {
                int i;
                byte[] literalBits = new byte[288];
                for (i = 0; i < 144; ++i) {
                    literalBits[i] = 8;
                }
                for (i = 144; i < 256; ++i) {
                    literalBits[i] = 9;
                }
                for (i = 256; i < 280; ++i) {
                    literalBits[i] = 7;
                }
                for (i = 280; i < 288; ++i) {
                    literalBits[i] = 8;
                }
                literalTree = KEngine.GZIP_CreateHuffmanTree(literalBits, 287);
                byte[] distanceBits = new byte[32];
                for (int i2 = 0; i2 < distanceBits.length; ++i2) {
                    distanceBits[i2] = 5;
                }
                distanceTree = KEngine.GZIP_CreateHuffmanTree(distanceBits, 31);
            }
            int code = 0;
            int leb = 0;
            int deb = 0;
            while ((code = KEngine.GZIP_ReadCode(gzip, literalTree)) != 256) {
                if (code > 256) {
                    int length = ZIP_LENGTH_VALUES[code -= 257];
                    leb = ZIP_LENGTH_EXTRA_BITS[code];
                    if (leb > 0) {
                        length += KEngine.GZIP_ReadBits(gzip, leb);
                    }
                    code = KEngine.GZIP_ReadCode(gzip, distanceTree);
                    int distance = ZIP_DISTANCE_VALUES[code];
                    deb = ZIP_DISTANCE_EXTRA_BITS[code];
                    if (deb > 0) {
                        distance += KEngine.GZIP_ReadBits(gzip, deb);
                    }
                    int offset = uncompressedIndex - distance;
                    while (distance < length) {
                        System.arraycopy(uncompressed, offset, uncompressed, uncompressedIndex, distance);
                        uncompressedIndex += distance;
                        length -= distance;
                        distance <<= 1;
                    }
                    System.arraycopy(uncompressed, offset, uncompressed, uncompressedIndex, length);
                    uncompressedIndex += length;
                    continue;
                }
                uncompressed[uncompressedIndex++] = (byte)code;
            }
        } while (bfinal == 0);
        return uncompressed;
    }

    private static final int GZIP_ReadBits(byte[] gzip, int n) {
        int data = zipBit == 0 ? (zipByte = gzip[zipIndex++] & 0xFF) : zipByte >> zipBit;
        for (int i = 8 - zipBit; i < n; i += 8) {
            zipByte = gzip[zipIndex++] & 0xFF;
            data |= zipByte << i;
        }
        zipBit = zipBit + n & 7;
        return data & (1 << n) - 1;
    }

    private static final int GZIP_ReadCode(byte[] gzip, int[] tree) {
        int node = tree[0];
        while (node >= 0) {
            if (zipBit == 0) {
                zipByte = gzip[zipIndex++] & 0xFF;
            }
            node = (zipByte & 1 << zipBit) == 0 ? tree[node >> 16] : tree[node & 0xFFFF];
            zipBit = zipBit + 1 & 7;
        }
        return node & 0xFFFF;
    }

    public static final Image Image_Alpha(Image img, int alf) {
        if (img == null) {
            return null;
        }
        if (alf < 0) {
            alf = 0;
        } else if (alf > 10) {
            alf = 10;
        }
        int imgW = img.getWidth();
        int imgH = img.getHeight();
        int[] RGBData = new int[imgW * imgH];
        img.getRGB(RGBData, 0, imgW, 0, 0, imgW, imgH);
        int tmp = alf * 255 / 10 << 24 | 0xFFFFFF;
        int i = 0;
        while (i < RGBData.length) {
            int n = i++;
            RGBData[n] = RGBData[n] & tmp;
        }
        Image o_Img = Image.createRGBImage((int[])RGBData, (int)imgW, (int)imgH, (boolean)true);
        return o_Img;
    }

    private static final byte[] Image_CreateChunk(String id, byte[] raw) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(raw.length + 12);
        DataOutputStream chunk = new DataOutputStream(baos);
        chunk.writeInt(raw.length);
        byte[] bid = new byte[4];
        for (int i = 0; i < 4; ++i) {
            bid[i] = (byte)id.charAt(i);
        }
        chunk.write(bid);
        chunk.write(raw);
        int crc = -1;
        crc = KEngine.Image_UpdateCRC(crc, bid);
        crc = KEngine.Image_UpdateCRC(crc, raw);
        chunk.writeInt(~crc);
        return baos.toByteArray();
    }

    private static final byte[] Image_CreateDataChunk(int width, int height, byte[] alpha, byte[] red, byte[] green, byte[] blue) throws IOException {
        int source = 0;
        int dest = 0;
        byte[] raw = new byte[4 * (width * height) + height];
        for (int y = 0; y < height; ++y) {
            raw[dest++] = 0;
            for (int x = 0; x < width; ++x) {
                raw[dest++] = red[source];
                raw[dest++] = green[source];
                raw[dest++] = blue[source];
                raw[dest++] = alpha[source++];
            }
        }
        return KEngine.Image_CreateChunk("IDAT", KEngine.Image_ToZLIB(raw));
    }

    private static final byte[] Image_CreateEndChunk() throws IOException {
        return KEngine.Image_CreateChunk("IEND", new byte[0]);
    }

    private static final byte[] Image_CreateHeaderChunk(int width, int height) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(13);
        DataOutputStream chunk = new DataOutputStream(baos);
        chunk.writeInt(width);
        chunk.writeInt(height);
        chunk.writeByte(8);
        chunk.writeByte(6);
        chunk.writeByte(0);
        chunk.writeByte(0);
        chunk.writeByte(0);
        return KEngine.Image_CreateChunk("IHDR", baos.toByteArray());
    }

    public static final Image Image_CreateImage(int width, int height, byte[] alpha, byte[] red, byte[] green, byte[] blue) {
        try {
            byte[] png = KEngine.Image_CreatePNG(width, height, alpha, red, green, blue);
            return Image.createImage((byte[])png, (int)0, (int)png.length);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static final byte[] Image_CreatePNG(int width, int height, byte[] alpha, byte[] red, byte[] green, byte[] blue) throws IOException {
        byte[] signature = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        byte[] header = KEngine.Image_CreateHeaderChunk(width, height);
        byte[] data = KEngine.Image_CreateDataChunk(width, height, alpha, red, green, blue);
        byte[] trailer = KEngine.Image_CreateEndChunk();
        ByteArrayOutputStream png = new ByteArrayOutputStream(signature.length + header.length + data.length + trailer.length);
        png.write(signature);
        png.write(header);
        png.write(data);
        png.write(trailer);
        return png.toByteArray();
    }

    public static final Image Image_Gray(Image img) {
        if (img == null) {
            return null;
        }
        int imgW = img.getWidth();
        int imgH = img.getHeight();
        int[] imgRGBData = new int[imgW * imgH];
        img.getRGB(imgRGBData, 0, imgW, 0, 0, imgW, imgH);
        int ALF = 0;
        int R = 0;
        int G = 0;
        int B = 0;
        int GRAY = 0;
        for (int i = 0; i < imgRGBData.length; ++i) {
            ALF = imgRGBData[i] >> 24 & 0xFF;
            R = imgRGBData[i] >> 16 & 0xFF;
            G = imgRGBData[i] >> 8 & 0xFF;
            B = imgRGBData[i] & 0xFF;
            GRAY = R * 77 + G * 151 + B * 28 + 128 >> 8;
            imgRGBData[i] = ALF << 24 | GRAY << 16 | GRAY << 8 | GRAY;
        }
        return Image.createRGBImage((int[])imgRGBData, (int)imgW, (int)imgH, (boolean)true);
    }

    public static final Image Image_Load(String file) {
        try {
            return Image.createImage((String)("/" + file));
        }
        catch (Exception ex) {
            System.out.println(file);
            ex.printStackTrace();
            return null;
        }
    }

    public static final Image Image_Scale(Image imgSrc, int scale100) {
        int width = imgSrc.getWidth();
        int height = imgSrc.getHeight();
        width *= scale100;
        height *= scale100;
        return KEngine.Image_Scale(imgSrc, width /= 100, height /= 100);
    }

    public static final Image Image_Scale(Image src, int dstW, int dstH) {
        int srcW = src.getWidth();
        int srcH = src.getHeight();
        Image tmp = Image.createImage((int)dstW, (int)srcH);
        Graphics g = tmp.getGraphics();
        int delta = (srcW << 16) / dstW;
        int pos = delta >> 1;
        for (int x = 0; x < dstW; ++x) {
            g.setClip(x, 0, 1, srcH);
            g.drawImage(src, x - (pos >> 16), 0, 20);
            pos += delta;
        }
        Image dst = Image.createImage((int)dstW, (int)dstH);
        g = dst.getGraphics();
        delta = (srcH << 16) / dstH;
        pos = delta >> 1;
        for (int y = 0; y < dstH; ++y) {
            g.setClip(0, y, dstW, 1);
            g.drawImage(tmp, 0, y - (pos >> 16), 20);
            pos += delta;
        }
        tmp = null;
        return dst;
    }

    private static final int Image_ToAdler32(byte[] raw) {
        int s1 = 1;
        int s2 = 0;
        for (int i = 0; i < raw.length; ++i) {
            s1 = (s1 + raw[i]) % 65521;
            s2 = (s2 + s1) % 65521;
        }
        return (s2 << 16) + s1;
    }

    private static final byte[] Image_ToZLIB(byte[] raw) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(raw.length + 5 + 6);
        DataOutputStream zlib = new DataOutputStream(baos);
        int tmp = 8;
        zlib.writeByte(tmp);
        zlib.writeByte((31 - (tmp << 8) % 31) % 31);
        zlib.writeByte(1);
        char length = (char)raw.length;
        zlib.writeChar(length);
        zlib.writeChar(~length);
        zlib.write(raw);
        zlib.writeInt(KEngine.Image_ToAdler32(raw));
        return baos.toByteArray();
    }

    private static final int Image_UpdateCRC(int crc, byte[] raw) {
        if (CRC_TABLE == null) {
            KEngine.Math_CreateCrcTable();
        }
        for (int i = 0; i < raw.length; ++i) {
            crc = CRC_TABLE[(crc ^ raw[i]) & 0xFF] ^ crc >>> 8;
        }
        return crc;
    }

    public static final byte IO_ReadByte(byte[] data, int off) {
        return data[off];
    }

    public static final byte IO_ReadByte(InputStream is) throws Exception {
        return (byte)is.read();
    }

    public static final int IO_ReadInt(byte[] data, int off) {
        if (data == null || data.length < 4) {
            return -1;
        }
        return KEngine.IO_ReadNumber(data, off, 4);
    }

    public static final int IO_ReadInt(InputStream is) throws Exception {
        byte[] tmp = new byte[4];
        is.read(tmp);
        return KEngine.IO_ReadInt(tmp, 0);
    }

    private static final int IO_ReadNumber(byte[] data, int off, int num) {
        int value = 0;
        for (int i = 0; i < num; ++i) {
            int skip = (num - 1 - i) * 8;
            value |= (data[off + i] < 0 ? data[off + i] + 256 : data[off + i]) << skip;
        }
        return value;
    }

    public static final short IO_ReadShort(byte[] data, int off) {
        return (short)KEngine.IO_ReadUnsignedShort(data, off);
    }

    public static final short IO_ReadShort(InputStream is) throws Exception {
        byte[] tmp = new byte[2];
        is.read(tmp);
        return KEngine.IO_ReadShort(tmp, 0);
    }

    public static final short IO_ReadUnsignedByte(byte[] data, int off) {
        return (short)(data[off] < 0 ? data[off] + 256 : data[off]);
    }

    public static final short IO_ReadUnsignedByte(InputStream is) throws Exception {
        short tmp = (byte)is.read();
        if (tmp < 0) {
            tmp = (short)(tmp + 256);
        }
        return tmp;
    }

    public static final int IO_ReadUnsignedShort(byte[] data, int off) {
        if (data == null || data.length < 2) {
            return -1;
        }
        return KEngine.IO_ReadNumber(data, off, 2);
    }

    public static final int IO_ReadUnsignedShort(InputStream is) throws Exception {
        byte[] tmp = new byte[2];
        is.read(tmp);
        return KEngine.IO_ReadUnsignedShort(tmp, 0);
    }

    public static final String IO_ReadUTF(byte[] data, int off) {
        short length = KEngine.IO_ReadShort(data, off);
        return KEngine.UTF_Decode(data, off += 2, length);
    }

    public static final void IO_WriteByte(byte[] data, byte value, int off) {
        data[off] = value;
    }

    public static final void IO_WriteInt(byte[] data, int value, int off) {
        KEngine.IO_WriteNumber(data, value, off, 4);
    }

    private static final void IO_WriteNumber(byte[] data, int value, int off, int num) {
        int cursor = 0;
        for (int i = num - 1; i >= 0; --i) {
            data[cursor++] = (byte)(value >> i * 8 & 0xFF);
        }
    }

    public static final void IO_WriteShort(byte[] data, short value, int off) {
        KEngine.IO_WriteNumber(data, value, off, 2);
    }

    public static final void IO_WriteUTF(byte[] data, String value, int off) {
        byte[] utfData = KEngine.UTF_Encode(value);
        KEngine.IO_WriteShort(data, (short)utfData.length, off);
        off += 2;
        for (int i = 0; i < utfData.length; ++i) {
            KEngine.IO_WriteByte(data, utfData[i], off + i);
        }
    }

    private static final void Map_DrawTile(Image img, int x, int y, short mapItemIdx, byte layer) {
        ++frameTimer;
        if (mapLayerNum == 1 && layer == 1) {
            return;
        }
        short[] temp = null;
        int flip = 0;
        temp = layer == 0 ? mapTilesL1 : mapTilesL2;
        if ((temp[mapItemIdx] & 0x3FF) != 0) {
            int tmp = (temp[mapItemIdx] & 0x200) >> 9;
            if (tmp == 0) {
                tileID = temp[mapItemIdx] & 0x1FF;
                flip = 0;
            } else {
                tileID = temp[mapItemIdx] & 0x3F;
                int sw = (temp[mapItemIdx] & 0x1C0) >> 6;
                flip = KEngine.Map_GetReserval(sw);
            }
            KEngine.GUI_DrawImage(mapBG, img, (tileID - 1) * TILE_WIDTH, 0, TILE_WIDTH, TILE_HEIGHT, flip, x, y, 0);
        }
    }

    private static final int Map_GetReserval(int sw) {
        int flip = 0;
        switch (sw) {
            case 1: {
                flip = 5;
                break;
            }
            case 2: {
                flip = 3;
                break;
            }
            case 3: {
                flip = 6;
                break;
            }
            case 4: {
                flip = 2;
                break;
            }
            case 5: {
                flip = 1;
                break;
            }
            case 6: {
                flip = 0;
                if (frameTimer % 3 == 0) {
                    --tileID;
                }
                flip = 0;
                break;
            }
            case 7: {
                flip = 0;
                --tileID;
                break;
            }
            default: {
                flip = 0;
            }
        }
        return flip;
    }

    private static final int Map_GetTile(int x, int y) {
        if (x < 0 || x >= mapColNum || y < 0 || y >= mapRowNum) {
            return -1;
        }
        return y * mapColNum + x;
    }

    public static final void Map_Reset(short[] mapTilesL1, short[] mapTilesL2) {
        KEngine.mapTilesL1 = mapTilesL1;
        KEngine.mapTilesL2 = mapTilesL2;
        if (MAP_CARMACK_BUFFER) {
            KEngine.CarmackMap_Init();
        }
    }

    public static final void Map_Scroll() {
    }

    public static final void Map_Show() {
    }

    public static final int Math_Adler32(byte[] buf, int off, int len) {
        int s1 = 1;
        int s2 = 0;
        while (len > 0) {
            int k = len < 5552 ? len : 5552;
            len -= k;
            while (k-- > 0) {
                s2 += (s1 += buf[off++] & 0xFF);
            }
            s1 %= 65521;
            s2 %= 65521;
        }
        return s2 << 16 | s1;
    }

    public static final byte[] Math_Base64(String base64String) {
        byte[] map = new byte[123];
        for (int i = 0; i < 123; ++i) {
            int value = 0;
            if (i == 43) {
                value = 62;
            } else if (i == 47) {
                value = 63;
            } else if (i >= 48) {
                if (i < 58) {
                    value = (byte)(52 + (i - 48));
                } else if (i >= 65) {
                    if (i < 91) {
                        value = (byte)(i - 65);
                    } else if (i >= 97) {
                        value = (byte)(26 + (i - 97));
                    }
                }
            }
            map[i] = value;
        }
        byte[] buffer = null;
        try {
            int base64StringLength = base64String.length();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(3 * base64StringLength / 4);
            block3: for (int i = 0; i < base64StringLength / 4; ++i) {
                for (int j = 0; j < 3; ++j) {
                    char charFirst = base64String.charAt(4 * i + j);
                    byte paddedHextetFirst = map[charFirst];
                    char charSecond = base64String.charAt(4 * i + (j + 1));
                    if (charSecond == '=') continue block3;
                    byte paddedHextetSecond = map[charSecond];
                    int byteAsInt = paddedHextetFirst << 2 * (j + 1) | paddedHextetSecond >>> (2 - j) * 2;
                    baos.write(byteAsInt);
                }
            }
            buffer = baos.toByteArray();
            baos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buffer;
    }

    public static final int Math_Cos(int angle) {
        return KEngine.Math_Sin(angle + 90);
    }

    public static final int Math_CRC32(byte[] buf, int start, int end) {
        if (buf == null) {
            CRC_TABLE = null;
            return 0;
        }
        if (CRC_TABLE == null) {
            KEngine.Math_CreateCrcTable();
        }
        long c = 0xFFFFFFFFL;
        for (int i = start; i < end; ++i) {
            c = (long)CRC_TABLE[(int)((c ^ (long)buf[i]) & 0xFFL)] ^ c >> 8;
        }
        return (int)(c ^ 0xFFFFFFFFL);
    }

    private static final void Math_CreateCrcTable() {
        CRC_TABLE = new int[256];
        for (int n = 0; n < 256; ++n) {
            int c = n;
            for (int k = 0; k < 8; ++k) {
                if ((c & 1) == 1) {
                    c = 0xEDB88320 ^ c >> 1;
                    continue;
                }
                c >>= 1;
            }
            KEngine.CRC_TABLE[n] = c;
        }
    }

    public static final int Math_GetBitCount(int x) {
        int result = 0;
        if (x > 0) {
            x -= x >> 1 & 0x55555555;
            x = (x & 0x33333333) + (x >> 2 & 0x33333333);
            x = x + (x >> 4) & 0xF0F0F0F;
            x += x >> 8;
            x += x >> 16;
            result = x & 0x3F;
        }
        return result;
    }

    public static final int Math_GetRandom(int min, int max) {
        return min + Math.abs(RANDOM.nextInt()) / (Integer.MAX_VALUE / (max - min + 1) + 1);
    }

    public static final int Math_Pow(int v, int exp) {
        int t = exp >> 1;
        int m = exp - (exp >> 1 << 1);
        int r = v;
        int i = -1;
        while (++i < t) {
            r *= v;
        }
        return m == 0 ? r : r * v;
    }

    public static final int Math_Sin(int angle) {
        if ((angle %= 360) < 0) {
            angle = 360 + angle;
        }
        if (angle <= 90) {
            return SINES[angle];
        }
        if (angle <= 180) {
            return SINES[180 - angle];
        }
        if (angle <= 270) {
            return -SINES[angle - 180];
        }
        return -SINES[360 - angle];
    }

    public static final int Math_Sqrt(int value) {
        int sqrt = 0;
        for (int k = 0x100000; k != 0; k >>= 2) {
            int tmp = sqrt + k;
            sqrt >>= 1;
            if (tmp > value) continue;
            value -= tmp;
            sqrt += k;
        }
        return sqrt;
    }

    public static final void print(String message) {
        System.out.println(message);
    }

    protected static final void printDebug() {
        StringBuffer sb;
        if (!(DEBUG_SHOW_FPS || DEBUG_SHOW_MEMORY || DEBUG_SHOW_KEYCODE)) {
            return;
        }
        g.setColor(0xFFFF00);
        g.setFont(FONT);
        int posY = 0;
        if (DEBUG_SHOW_FPS) {
            sb = new StringBuffer().append("FPS:").append(FPS);
            g.drawString(sb.toString(), 5, posY, 20);
            posY += FONT_HEIGHT;
        }
        if (DEBUG_SHOW_MEMORY) {
            System.gc();
            long memoryTotal = Runtime.getRuntime().totalMemory();
            long memoryFree = Runtime.getRuntime().freeMemory();
            long memoryUsed = memoryTotal - memoryFree;
            StringBuffer sb2 = new StringBuffer();
            sb2.append("\u603b:").append(memoryTotal / 1024L).append("/");
            sb2.append("\u7528:").append(memoryUsed / 1024L).append("/");
            sb2.append("\u4f59:").append(memoryFree / 1024L);
            g.drawString(sb2.toString(), 5, posY, 20);
            posY += FONT_HEIGHT;
        }
        if (DEBUG_SHOW_KEYCODE) {
            sb = new StringBuffer().append("KEY:").append(KEYCODE);
            g.drawString(sb.toString(), 5, posY, 20);
        }
    }

    public static final void printf(String message) {
    }

    public static final Hashtable Properties_Load(InputStream in, char delim, String encoding) throws IOException, UnsupportedEncodingException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        InputStreamReader rin = new InputStreamReader(in, encoding);
        int c = 0;
        StringBuffer strBuf = new StringBuffer();
        while (c != -1) {
            int idx;
            strBuf.delete(0, strBuf.length());
            while ((c = rin.read()) != -1 && c != 10) {
                strBuf.append((char)c);
            }
            String line = strBuf.toString().trim();
            if (line.length() == 0 || line.startsWith("#") || (idx = line.indexOf(delim)) == -1) continue;
            result.put(line.substring(0, idx), line.substring(idx + 1));
        }
        return result;
    }

    public static final byte[] Properties_Serialize(Hashtable properties, char delim, String encoding) throws IOException, UnsupportedEncodingException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)bout, encoding);
        Enumeration keys = properties.keys();
        while (keys.hasMoreElements()) {
            String k = (String)keys.nextElement();
            String v = (String)properties.get(k);
            out.write(k + delim + v + '\n');
        }
        return bout.toByteArray();
    }

    public static final void RMS_Close(RecordStore rs) {
        try {
            rs.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean RMS_Exist(String name) {
        RecordStore rs = null;
        try {
            rs = RecordStore.openRecordStore((String)name, (boolean)true);
            if (rs.getNumRecords() > 0) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                rs.closeRecordStore();
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public static final int RMS_GetNextRecordID(RecordStore rs) {
        int num = -1;
        try {
            num = rs.getNextRecordID();
        }
        catch (Exception ex) {
            num = -1;
        }
        return num;
    }

    public static final int RMS_GetNumRecords(RecordStore rs) {
        int num = -1;
        try {
            num = rs.getNumRecords();
        }
        catch (Exception ex) {
            num = -1;
        }
        return num;
    }

    public static final byte[] RMS_Load(String name) {
        byte[] data = null;
        try {
            RecordStore rs = RecordStore.openRecordStore((String)name, (boolean)true);
            data = rs.getRecord(1);
            rs.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return data;
    }

    public static final void RMS_Save(String name, byte[] data) {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)name, (boolean)true);
            if (rs.getNumRecords() == 0) {
                rs.addRecord(data, 0, data.length);
            } else {
                rs.setRecord(1, data, 0, data.length);
            }
            if (rs != null) {
                rs.closeRecordStore();
                rs = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final int Script_CoerceValueToInt(int type, int value) {
        switch (type) {
            case 0: {
                return value;
            }
            case 2: {
                return Integer.parseInt(_StrTable[_currThread][value]);
            }
        }
        KEngine.Script_ExitOnCodeError(_currThread, ERROR_TYPE_CONVERT_FAULT);
        return 0;
    }

    private static final String Script_CoerceValueToString(int type, int value) {
        switch (type) {
            case 0: {
                return String.valueOf(value);
            }
            case 2: {
                return _StrTable[_currThread][value];
            }
        }
        KEngine.Script_ExitOnCodeError(_currThread, ERROR_TYPE_CONVERT_FAULT);
        return "";
    }

    private static final int Script_ConvertRefStackIndex(int pos) {
        int ip = _ThreadContext[_currThread * 7];
        int _index = 2 + pos * 5;
        byte a0 = _Instructions[_currThread][ip][_index + 1];
        byte a1 = _Instructions[_currThread][ip][_index + 2];
        byte a2 = _Instructions[_currThread][ip][_index + 3];
        byte a3 = _Instructions[_currThread][ip][_index + 4];
        short base = (short)((a0 & 0xFF) << 8 | a1 & 0xFF);
        short offset = (short)((a2 & 0xFF) << 8 | a3 & 0xFF);
        int index = KEngine.Script_ConvertStackIndex(offset) & 0xFFFF;
        int value = _RunTimeStack[_currThread][index];
        if (value < 0) {
            KEngine.Script_ExitOnCodeError(_currThread, ERROR_STACK_INDEX_NEGATIVE);
        }
        if (base < 0) {
            return base - value;
        }
        return base + value;
    }

    private static final int Script_ConvertStackIndex(int stackIndex) {
        int _stackIndex = 0;
        if (stackIndex < 0) {
            _stackIndex = _ThreadContext[_currThread * 7 + 3] - (-stackIndex << 1);
            return _stackIndex + 1 << 16 | _stackIndex;
        }
        _stackIndex = 2 * stackIndex;
        return _stackIndex << 16 | _stackIndex + 1;
    }

    private static final void Script_CopyTypeData(int pos, int type, int value) {
        byte _type = _Instructions[_currThread][_ThreadContext[_currThread * 7]][2 + ((pos << 2) + pos)];
        switch (_type) {
            case 3: {
                int ip = _ThreadContext[_currThread * 7];
                int index = 2 + pos * 5;
                byte a0 = _Instructions[_currThread][ip][index + 1];
                byte a1 = _Instructions[_currThread][ip][index + 2];
                byte a2 = _Instructions[_currThread][ip][index + 3];
                byte a3 = _Instructions[_currThread][ip][index + 4];
                int stackIndex = (a0 & 0xFF) << 24 | (a1 & 0xFF) << 16 | (a2 & 0xFF) << 8 | a3 & 0xFF;
                stackIndex = KEngine.Script_ConvertStackIndex(stackIndex);
                if (type != -1) {
                    KEngine._RunTimeStack[KEngine._currThread][stackIndex >> 16] = type;
                }
                KEngine._RunTimeStack[KEngine._currThread][stackIndex & 0xFFFF] = value;
                break;
            }
            case 4: {
                int stackIndex = KEngine.Script_ConvertRefStackIndex(pos);
                stackIndex = KEngine.Script_ConvertStackIndex(stackIndex);
                if (type != -1) {
                    KEngine._RunTimeStack[KEngine._currThread][stackIndex >> 16] = type;
                }
                KEngine._RunTimeStack[KEngine._currThread][stackIndex & 0xFFFF] = value;
                break;
            }
            case 8: {
                if (type != -1) {
                    KEngine._RetVal[KEngine._currThread * 2] = type;
                }
                KEngine._RetVal[KEngine._currThread * 2 + 1] = value;
            }
        }
    }

    private static final void Script_ExitOnCodeError(int threadID, String msg) {
        System.out.println("SVM ERROR: " + msg);
        System.out.println("Could not run thread: " + threadID);
        System.out.println("==========================================================");
        System.exit(1);
    }

    public static final void Script_Free(int threadIndex) {
        KEngine._RunTimeStack[threadIndex] = null;
        KEngine._ThreadActive[threadIndex] = false;
        KEngine._ThreadRunning[threadIndex] = false;
        int i = -1;
        while (++i < _Instructions[threadIndex].length) {
            KEngine._Instructions[threadIndex][i] = null;
        }
        KEngine._Instructions[threadIndex] = null;
        KEngine._StrTable[threadIndex] = null;
        KEngine._HostAPICallTable[threadIndex] = null;
        KEngine._FuncTable[threadIndex] = null;
        System.gc();
    }

    private static final int Script_GetMethodID(String name) {
        if (_MethodNames != null) {
            for (int i = 0; i < _MethodNames.length; ++i) {
                if (!name.equals(_MethodNames[i].toUpperCase())) continue;
                return i;
            }
        }
        return -1;
    }

    public static final int Script_GetParamAsInt(int paramIndex) {
        int stackTop = _ThreadContext[_currThread * 7 + 2];
        int frameTop = _ThreadContext[_currThread * 7 + 3] + 2;
        int paras = stackTop - frameTop >> 1;
        if (paramIndex >= paras) {
            KEngine.Script_ExitOnCodeError(_currThread, ERROR_PARAM_BOUND);
        } else if (paramIndex < 0) {
            KEngine.Script_ExitOnCodeError(_currThread, ERROR_PARAM_NEGATIVE);
        }
        int type = _RunTimeStack[_currThread][frameTop + ((paramIndex << 1) + 1)];
        int value = _RunTimeStack[_currThread][frameTop + (paramIndex << 1)];
        switch (type) {
            case 0: {
                return value;
            }
            case 2: {
                return Integer.parseInt(_StrTable[_currThread][value]);
            }
        }
        return 0;
    }

    public static final String Script_GetParamAsString(int paramIndex) {
        int stackTop = _ThreadContext[_currThread * 7 + 2];
        int frameTop = _ThreadContext[_currThread * 7 + 3] + 2;
        int paras = stackTop - frameTop >> 1;
        if (paramIndex >= paras) {
            KEngine.Script_ExitOnCodeError(_currThread, ERROR_PARAM_BOUND);
        } else if (paramIndex < 0) {
            KEngine.Script_ExitOnCodeError(_currThread, ERROR_PARAM_NEGATIVE);
        }
        int type = _RunTimeStack[_currThread][frameTop + ((paramIndex << 1) + 1)];
        int value = _RunTimeStack[_currThread][frameTop + (paramIndex << 1)];
        switch (type) {
            case 0: {
                return String.valueOf(value);
            }
            case 2: {
                return _StrTable[_currThread][value];
            }
        }
        return "";
    }

    public static final int Script_GetReturnAsInt(int iHandle) {
        int type = _RetVal[iHandle * 2 + 2];
        int value = _RetVal[iHandle * 2 + 3];
        switch (type) {
            case 0: {
                return value;
            }
            case 2: {
                return Integer.parseInt(_StrTable[iHandle][value]);
            }
        }
        return 0;
    }

    public static final void Script_Init() {
        _currThread = 0;
        _currThreadActiveTime = 0;
        _VM_STATUS = 0;
        _RetVal = new int[10];
        _PopVal = new int[10];
        _Instructions = new byte[5][][];
        _ThreadActive = new boolean[5];
        _ThreadRunning = new boolean[5];
        _ThreadIsPause = new boolean[5];
        _ThreadMainPresent = new boolean[5];
        _ThreadPauseEndTime = new int[5];
        _ThreadContext = new int[35];
        _RunTimeStack = new int[5][];
        _StrTable = new String[5][];
        _HostAPICallTable = new String[5][];
        _FuncTable = new int[5][];
        _MethodNames = instance.OnRegisterLib();
    }

    public static final boolean Script_InvokeFunc(int iHandle, int funcID) {
        if (!_ThreadActive[iHandle]) {
            return false;
        }
        if (_currThread == iHandle) {
            return false;
        }
        if (funcID >= _FuncTable[iHandle].length / 3) {
            KEngine.Script_ExitOnCodeError(_currThread, ERROR_INVOKE);
            return false;
        }
        int entry = _FuncTable[iHandle][3 * funcID];
        short func_top = (short)_ThreadContext[iHandle * 7 + 3];
        if (_DynamicParam[0] != 0) {
            int i = -1;
            while (++i < _DynamicParam[0]) {
                KEngine.Script_Push(iHandle, _DynamicParam[1 + i * 2], _DynamicParam[1 + i * 2 + 1]);
            }
        }
        KEngine.Script_Push(iHandle, 0, _ThreadContext[iHandle * 7]);
        KEngine.Script_PushFrame(iHandle, _FuncTable[iHandle][3 * funcID + 2] << 1);
        KEngine.Script_Push(iHandle, funcID, func_top);
        KEngine._ThreadContext[iHandle * 7] = entry;
        _retFuncCount_ = 1;
        _VM_STATUS = (byte)(_VM_STATUS | 2);
        int currThread = _currThread;
        _currThread = iHandle;
        do {
            int curInstrIndex = _ThreadContext[iHandle * 7];
            KEngine.Script_RunInstr();
            if (curInstrIndex != _ThreadContext[iHandle * 7]) continue;
            int n = iHandle * 7;
            _ThreadContext[n] = _ThreadContext[n] + 1;
        } while (_retFuncCount_ != 0);
        _VM_STATUS = (byte)(_VM_STATUS & 0xFFFFFFFD);
        KEngine._RetVal[currThread * 2] = _RetVal[iHandle * 2];
        KEngine._RetVal[currThread * 2 + 1] = _RetVal[iHandle * 2 + 1];
        _currThread = currThread;
        return true;
    }

    public static final boolean Script_InvokeFuncSync(int iHandle, int funcID) {
        if (!_ThreadActive[iHandle]) {
            return false;
        }
        if (funcID >= _FuncTable[iHandle].length / 3) {
            KEngine.Script_ExitOnCodeError(_currThread, ERROR_INVOKE);
            return false;
        }
        int entry = _FuncTable[iHandle][3 * funcID];
        short func_top = (short)_ThreadContext[iHandle * 7 + 3];
        KEngine.Script_Push(iHandle, 0, _ThreadContext[iHandle * 7]);
        KEngine.Script_PushFrame(iHandle, _FuncTable[iHandle][3 * funcID + 2] << 1);
        KEngine.Script_Push(iHandle, funcID, func_top);
        KEngine._ThreadContext[iHandle * 7] = entry;
        KEngine._ThreadRunning[iHandle] = true;
        return true;
    }

    public static final boolean Script_IsRunning(int iThreadIndex) {
        return _ThreadRunning[iThreadIndex];
    }

    public static final int Script_Load(String file) {
        if (file == null || file != null && file.length() == 0) {
            return -1;
        }
        boolean isRoom = false;
        int retThreadIndex = -1;
        int i = -1;
        while (++i < 5) {
            if (_ThreadActive[i]) continue;
            retThreadIndex = i;
            isRoom = true;
            break;
        }
        if (!isRoom) {
            KEngine.Script_ExitOnCodeError(_currThread, ERROR_NO_MEMORY);
            return -1;
        }
        try {
            DataInputStream dis = new DataInputStream(gameApp.getClass().getResourceAsStream(file));
            KEngine.Script_ReadHead(retThreadIndex, dis);
            KEngine.Script_ReadInstrs(retThreadIndex, dis);
            KEngine.Script_ReadData(retThreadIndex, dis);
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
            KEngine.Script_ExitOnCodeError(_currThread, ioe.getMessage());
            return -1;
        }
        KEngine._ThreadActive[retThreadIndex] = true;
        KEngine.Script_Reset(retThreadIndex);
        return retThreadIndex;
    }

    public static final void Script_Pause(int iHandle, int iDur) {
        if (!_ThreadActive[iHandle]) {
            return;
        }
        KEngine._ThreadIsPause[iHandle] = true;
        KEngine._ThreadPauseEndTime[iHandle] = _currThreadActiveTime + iDur;
    }

    private static final void Script_Pop(int threadIndex, boolean checkEmpty) {
        if (checkEmpty) {
            if (_ThreadContext[threadIndex * 7 + 3] <= _ThreadContext[threadIndex * 7 + 2] - 2) {
                int n = threadIndex * 7 + 2;
                int n2 = _ThreadContext[n] - 1;
                _ThreadContext[n] = n2;
                KEngine._PopVal[threadIndex * 2] = _RunTimeStack[threadIndex][n2];
                int n3 = threadIndex * 7 + 2;
                int n4 = _ThreadContext[n3] - 1;
                _ThreadContext[n3] = n4;
                KEngine._PopVal[threadIndex * 2 + 1] = _RunTimeStack[threadIndex][n4];
            } else {
                KEngine.Script_ExitOnCodeError(_currThread, ERROR_STACK_EMPTY);
            }
        } else {
            int n = threadIndex * 7 + 2;
            int n5 = _ThreadContext[n] - 1;
            _ThreadContext[n] = n5;
            KEngine._PopVal[threadIndex * 2] = _RunTimeStack[threadIndex][n5];
            int n6 = threadIndex * 7 + 2;
            int n7 = _ThreadContext[n6] - 1;
            _ThreadContext[n6] = n7;
            KEngine._PopVal[threadIndex * 2 + 1] = _RunTimeStack[threadIndex][n7];
        }
    }

    private static final void Script_PopFrame(int threadIndex, int size) {
        int n = threadIndex * 7 + 2;
        _ThreadContext[n] = _ThreadContext[n] - size;
    }

    private static final void Script_Push(int threadIndex, int type, int value) {
        if (_ThreadContext[threadIndex * 7 + 2] + 2 >= _RunTimeStack[threadIndex].length) {
            KEngine.Script_ExitOnCodeError(_currThread, ERROR_HEAP_OVERFLOW);
        } else {
            int n = threadIndex * 7 + 2;
            int n2 = _ThreadContext[n];
            _ThreadContext[n] = n2 + 1;
            KEngine._RunTimeStack[threadIndex][n2] = value;
            int n3 = threadIndex * 7 + 2;
            int n4 = _ThreadContext[n3];
            _ThreadContext[n3] = n4 + 1;
            KEngine._RunTimeStack[threadIndex][n4] = type;
        }
    }

    private static final void Script_PushFrame(int threadIndex, int size) {
        int n = threadIndex * 7 + 2;
        _ThreadContext[n] = _ThreadContext[n] + size;
        if (_ThreadContext[threadIndex * 7 + 2] >= _RunTimeStack[threadIndex].length) {
            KEngine.Script_ExitOnCodeError(_currThread, ERROR_HEAP_OVERFLOW);
        }
        KEngine._ThreadContext[threadIndex * 7 + 3] = _ThreadContext[threadIndex * 7 + 2];
    }

    private static final void Script_ReadData(int threadIndex, DataInputStream dis) throws IOException {
        int size = dis.readShort();
        KEngine._StrTable[threadIndex] = new String[size];
        int i = -1;
        while (++i < size) {
            KEngine._StrTable[threadIndex][i] = dis.readUTF();
        }
        size = dis.readShort();
        KEngine._FuncTable[threadIndex] = new int[size * 3];
        i = -1;
        while (++i < size) {
            KEngine._FuncTable[threadIndex][i * 3] = dis.readInt();
            KEngine._FuncTable[threadIndex][i * 3 + 1] = dis.readByte();
            KEngine._FuncTable[threadIndex][i * 3 + 2] = dis.readInt();
        }
        size = dis.readShort();
        size = dis.readShort();
        KEngine._HostAPICallTable[threadIndex] = new String[size];
        i = -1;
        while (++i < size) {
            KEngine._HostAPICallTable[threadIndex][i] = dis.readUTF();
        }
    }

    private static final void Script_ReadHead(int threadIndex, DataInputStream dis) throws IOException, Exception {
        String id = dis.readUTF();
        if (!id.equals(HEAD_BLOCK)) {
            KEngine.Script_ExitOnCodeError(_currThread, ERROR_FILE_NOT_SUPPORT);
        }
        byte versionH_f = dis.readByte();
        byte versionL_f = dis.readByte();
        if (versionH_f != 1 || versionL_f != 1) {
            KEngine.Script_ExitOnCodeError(_currThread, ERROR_SUPPORT_VERSION);
            throw new Exception("this script version is " + versionH_f + "." + versionL_f + "\n" + ERROR_SUPPORT_VERSION);
        }
        int size = dis.readInt();
        KEngine._RunTimeStack[threadIndex] = size == 0 ? new int[512] : new int[size];
        dis.skipBytes(1);
        KEngine._ThreadContext[threadIndex * 7 + 6] = 30;
        KEngine._ThreadContext[threadIndex * 7 + 4] = dis.readInt();
        boolean bl = KEngine._ThreadMainPresent[threadIndex] = dis.readByte() == 1;
        if (!_ThreadMainPresent[threadIndex]) {
            dis.close();
            throw new IOException("Err: \u6b64\u811a\u672c\u6ca1\u6709\u53ef\u6267\u884c\u7684_Main\u51fd\u6570");
        }
        KEngine._ThreadContext[threadIndex * 7 + 1] = dis.readInt();
    }

    private static final void Script_ReadInstrs(int threadIndex, DataInputStream dis) throws IOException {
        int size = dis.readInt();
        KEngine._Instructions[threadIndex] = new byte[size][];
        int i = -1;
        while (++i < size) {
            byte op = dis.readByte();
            byte opdc = dis.readByte();
            KEngine._Instructions[threadIndex][i] = new byte[opdc * 5 + 2];
            KEngine._Instructions[threadIndex][i][0] = op;
            KEngine._Instructions[threadIndex][i][1] = opdc;
            byte j = -1;
            while (++j < opdc) {
                KEngine._Instructions[threadIndex][i][2 + j * 5] = dis.readByte();
                KEngine._Instructions[threadIndex][i][2 + j * 5 + 1] = dis.readByte();
                KEngine._Instructions[threadIndex][i][2 + j * 5 + 2] = dis.readByte();
                KEngine._Instructions[threadIndex][i][2 + j * 5 + 3] = dis.readByte();
                KEngine._Instructions[threadIndex][i][2 + j * 5 + 4] = dis.readByte();
            }
        }
    }

    public static final void Script_Reset(int threadIndex) {
        if (_ThreadMainPresent[threadIndex]) {
            KEngine._ThreadContext[threadIndex * 7] = _FuncTable[threadIndex][_ThreadContext[threadIndex * 7 + 1] * 3];
        }
        KEngine._ThreadPauseEndTime[threadIndex] = 0;
        KEngine._ThreadIsPause[threadIndex] = false;
        KEngine._ThreadContext[threadIndex * 7 + 2] = 0;
        KEngine._ThreadContext[threadIndex * 7 + 5] = 0;
        KEngine._ThreadContext[threadIndex * 7 + 3] = 0;
        KEngine.Script_PushFrame(threadIndex, _ThreadContext[threadIndex * 7 + 4] << 1);
        int size = _FuncTable[threadIndex][_ThreadContext[threadIndex * 7 + 1] * 3 + 2];
        KEngine.Script_PushFrame(threadIndex, size << 1);
        KEngine.Script_Push(threadIndex, -1, _ThreadContext[threadIndex * 7 + 3]);
        KEngine._ThreadActive[threadIndex] = true;
    }

    private static final void Script_ResolveOpDataTypeValue(int pos) {
        int type = _Instructions[_currThread][_ThreadContext[_currThread * 7]][2 + ((pos << 2) + pos)];
        switch (type) {
            case 3: {
                int ip = _ThreadContext[_currThread * 7];
                int index = 2 + pos * 5;
                byte a0 = _Instructions[_currThread][ip][index + 1];
                byte a1 = _Instructions[_currThread][ip][index + 2];
                byte a2 = _Instructions[_currThread][ip][index + 3];
                byte a3 = _Instructions[_currThread][ip][index + 4];
                int stackIndex = (a0 & 0xFF) << 24 | (a1 & 0xFF) << 16 | (a2 & 0xFF) << 8 | a3 & 0xFF;
                stackIndex = KEngine.Script_ConvertStackIndex(stackIndex);
                _type_ = _RunTimeStack[_currThread][stackIndex >> 16];
                _value_ = _RunTimeStack[_currThread][stackIndex & 0xFFFF];
                return;
            }
            case 4: {
                int stackIndex = KEngine.Script_ConvertRefStackIndex(pos);
                stackIndex = KEngine.Script_ConvertStackIndex(stackIndex);
                _type_ = _RunTimeStack[_currThread][stackIndex >> 16];
                _value_ = _RunTimeStack[_currThread][stackIndex & 0xFFFF];
                return;
            }
            case 8: {
                _type_ = _RetVal[_currThread * 2];
                _value_ = _RetVal[_currThread * 2 + 1];
                return;
            }
        }
        int ip = _ThreadContext[_currThread * 7];
        int index = 2 + pos * 5;
        byte a0 = _Instructions[_currThread][ip][index + 1];
        byte a1 = _Instructions[_currThread][ip][index + 2];
        byte a2 = _Instructions[_currThread][ip][index + 3];
        byte a3 = _Instructions[_currThread][ip][index + 4];
        int value = (a0 & 0xFF) << 24 | (a1 & 0xFF) << 16 | (a2 & 0xFF) << 8 | a3 & 0xFF;
        _type_ = type;
        _value_ = value;
    }

    public static final void Script_ReturnResult(int value) {
        KEngine._RetVal[KEngine._currThread * 2] = 0;
        KEngine._RetVal[KEngine._currThread * 2 + 1] = value;
    }

    public static final void Script_ReturnResult(String value) {
        KEngine._StrTable[KEngine._currThread] = KEngine.Array_Expand(_StrTable[_currThread], 1);
        int size = _StrTable[_currThread].length;
        KEngine._StrTable[KEngine._currThread][size - 1] = value;
        int index = size - 1;
        KEngine._RetVal[KEngine._currThread * 2] = 2;
        KEngine._RetVal[KEngine._currThread * 2 + 1] = index;
    }

    public static final void Script_Run(int iTimesliceDur) {
        ++_currThreadActiveTime;
        long iMainTimesliceStartTime = System.currentTimeMillis();
        int iCurrTime = 0;
        long iRunTime = 0L;
        int run = 0;
        while (iTimesliceDur == -1 || iRunTime < iMainTimesliceStartTime + (long)iTimesliceDur) {
            boolean iIsStillActive = false;
            int i = -1;
            while (++i < 5) {
                if (!_ThreadActive[i] || !_ThreadRunning[i]) continue;
                iIsStillActive = true;
                break;
            }
            if (!iIsStillActive) break;
            iCurrTime = (short)(iCurrTime + 1);
            iRunTime = System.currentTimeMillis();
            if (iCurrTime > _ThreadContext[_currThread * 7 + 6] || !_ThreadRunning[_currThread] || (_VM_STATUS & 1) != 0) {
                int tmpCurrThread = _currThread;
                boolean isHaveActiveThread = false;
                do {
                    if (++_currThread >= 5) {
                        _currThread = 0;
                    }
                    if (!_ThreadActive[_currThread] || !_ThreadRunning[_currThread]) continue;
                    isHaveActiveThread = true;
                    break;
                } while (_currThread != tmpCurrThread);
                if (!isHaveActiveThread) break;
                iCurrTime = 0;
            }
            if (_ThreadIsPause[_currThread]) {
                if (_currThreadActiveTime <= _ThreadPauseEndTime[_currThread]) continue;
                KEngine._ThreadIsPause[KEngine._currThread] = false;
            }
            int curInstrIndex = _ThreadContext[_currThread * 7];
            _VM_STATUS = (byte)(_VM_STATUS & 0xFFFFFFFE);
            KEngine.Script_RunInstr();
            ++run;
            if (curInstrIndex != _ThreadContext[_currThread * 7]) continue;
            int n = _currThread * 7;
            _ThreadContext[n] = _ThreadContext[n] + 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void Script_RunInstr() {
        int type = 0;
        int type1 = 0;
        int type2 = 0;
        int type_d = 0;
        int type_s = 0;
        int value = 0;
        int value1 = 0;
        int value2 = 0;
        int value_d = 0;
        int value_s = 0;
        String strTmp1 = null;
        String strTmp2 = null;
        byte[] instr = _Instructions[_currThread][_ThreadContext[_currThread * 7]];
        byte op = instr[0];
        switch (op) {
            case 26: {
                KEngine.Script_ResolveOpDataTypeValue(0);
                type = _type_;
                value = _value_;
                KEngine.Script_Push(_currThread, type, value);
                return;
            }
            case 27: {
                KEngine.Script_Pop(_currThread, true);
                KEngine.Script_CopyTypeData(0, _PopVal[_currThread * 2], _PopVal[_currThread * 2 + 1]);
                return;
            }
            case 28: {
                KEngine.Script_ResolveOpDataTypeValue(0);
                value = _value_;
                value1 = _FuncTable[_currThread][3 * value];
                value2 = _ThreadContext[_currThread * 7 + 3];
                int n = _currThread * 7;
                int n2 = _ThreadContext[n] + 1;
                _ThreadContext[n] = n2;
                KEngine.Script_Push(_currThread, 0, n2);
                KEngine.Script_PushFrame(_currThread, _FuncTable[_currThread][3 * value + 2] << 1);
                KEngine.Script_Push(_currThread, value, value2);
                KEngine._ThreadContext[KEngine._currThread * 7] = value1;
                if ((_VM_STATUS & 2) == 0) return;
                ++_retFuncCount_;
                return;
            }
            case 29: {
                KEngine.Script_Pop(_currThread, true);
                value = _PopVal[_currThread * 2];
                value1 = _PopVal[_currThread * 2 + 1];
                value2 = _FuncTable[_currThread][value * 3 + 2];
                KEngine._ThreadContext[KEngine._currThread * 7] = value_s = _RunTimeStack[_currThread][_ThreadContext[_currThread * 7 + 2] - ((value2 << 1) + 2)];
                value2 = value2 + _FuncTable[_currThread][3 * value + 1] + 1 << 1;
                KEngine.Script_PopFrame(_currThread, value2);
                KEngine._ThreadContext[KEngine._currThread * 7 + 3] = value1;
                if ((_VM_STATUS & 2) == 0) return;
                --_retFuncCount_;
                return;
            }
            case 30: {
                value = _ThreadContext[_currThread * 7];
                byte a0 = _Instructions[_currThread][value][3];
                byte a1 = _Instructions[_currThread][value][4];
                byte a2 = _Instructions[_currThread][value][5];
                byte a3 = _Instructions[_currThread][value][6];
                value = (a0 & 0xFF) << 24 | (a1 & 0xFF) << 16 | (a2 & 0xFF) << 8 | a3 & 0xFF;
                strTmp1 = _HostAPICallTable[_currThread][value];
                value = strTmp1.indexOf(35);
                strTmp2 = strTmp1.substring(0, value);
                value = Integer.parseInt(strTmp1.substring(value + 1));
                value1 = KEngine.Script_GetMethodID(strTmp2);
                instance.OnScriptCall(_currThread, value1);
                int n = _currThread * 7 + 2;
                _ThreadContext[n] = _ThreadContext[n] - (value << 1);
                return;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                KEngine.Script_ResolveOpDataTypeValue(0);
                type_d = _type_;
                value_d = _value_;
                KEngine.Script_ResolveOpDataTypeValue(1);
                type_s = _type_;
                value_s = _value_;
                switch (op) {
                    case 0: {
                        KEngine.Script_CopyTypeData(0, type_s, value_s);
                        return;
                    }
                    case 1: {
                        switch (type_d) {
                            case 0: {
                                KEngine.Script_CopyTypeData(0, -1, value_d += KEngine.Script_CoerceValueToInt(type_s, value_s));
                                return;
                            }
                            case 2: {
                                KEngine.Script_UpdateStringTable(value_d, KEngine.Script_CoerceValueToString(type_d, value_d).concat(KEngine.Script_CoerceValueToString(type_s, value_s)));
                                return;
                            }
                        }
                        KEngine.Script_ExitOnCodeError(_currThread, ERROR_TYPE_INVAILD);
                        return;
                    }
                    case 2: {
                        switch (type_d) {
                            case 0: {
                                KEngine.Script_CopyTypeData(0, -1, value_d -= KEngine.Script_CoerceValueToInt(type_s, value_s));
                                return;
                            }
                        }
                        KEngine.Script_ExitOnCodeError(_currThread, ERROR_TYPE_INVAILD);
                        return;
                    }
                    case 3: {
                        switch (type_d) {
                            case 0: {
                                KEngine.Script_CopyTypeData(0, -1, value_d *= KEngine.Script_CoerceValueToInt(type_s, value_s));
                                return;
                            }
                        }
                        KEngine.Script_ExitOnCodeError(_currThread, ERROR_TYPE_INVAILD);
                        return;
                    }
                    case 4: {
                        switch (type_d) {
                            case 0: {
                                KEngine.Script_CopyTypeData(0, -1, value_d /= KEngine.Script_CoerceValueToInt(type_s, value_s));
                                return;
                            }
                        }
                        KEngine.Script_ExitOnCodeError(_currThread, ERROR_TYPE_INVAILD);
                        return;
                    }
                    case 5: {
                        switch (type_d) {
                            case 0: {
                                KEngine.Script_CopyTypeData(0, -1, value_d %= KEngine.Script_CoerceValueToInt(type_s, value_s));
                                return;
                            }
                        }
                        KEngine.Script_ExitOnCodeError(_currThread, ERROR_TYPE_INVAILD);
                        return;
                    }
                    case 6: {
                        switch (type_d) {
                            case 0: {
                                value_d = KEngine.Math_Pow(value_d, KEngine.Script_CoerceValueToInt(type_s, value_s));
                                KEngine.Script_CopyTypeData(0, -1, value_d);
                                return;
                            }
                        }
                        KEngine.Script_ExitOnCodeError(_currThread, ERROR_TYPE_INVAILD);
                        return;
                    }
                    case 10: {
                        KEngine.Script_CopyTypeData(0, -1, value_d &= KEngine.Script_CoerceValueToInt(type_s, value_s));
                        return;
                    }
                    case 11: {
                        KEngine.Script_CopyTypeData(0, -1, value_d |= KEngine.Script_CoerceValueToInt(type_s, value_s));
                        return;
                    }
                    case 12: {
                        KEngine.Script_CopyTypeData(0, -1, value_d ^= KEngine.Script_CoerceValueToInt(type_s, value_s));
                        return;
                    }
                    case 14: {
                        KEngine.Script_CopyTypeData(0, -1, value_d <<= KEngine.Script_CoerceValueToInt(type_s, value_s));
                        return;
                    }
                    case 15: {
                        KEngine.Script_CopyTypeData(0, -1, value_d >>= KEngine.Script_CoerceValueToInt(type_s, value_s));
                        return;
                    }
                }
                return;
            }
            case 13: {
                KEngine.Script_ResolveOpDataTypeValue(0);
                KEngine.Script_CopyTypeData(0, -1, ~KEngine.Script_CoerceValueToInt(_type_, _value_));
                return;
            }
            case 7: {
                KEngine.Script_ResolveOpDataTypeValue(0);
                type = _type_;
                value = _value_;
                switch (type) {
                    case 0: {
                        KEngine.Script_CopyTypeData(0, -1, -KEngine.Script_CoerceValueToInt(type, value));
                        return;
                    }
                }
                KEngine.Script_ExitOnCodeError(_currThread, ERROR_TYPE_INVAILD);
                return;
            }
            case 8: {
                KEngine.Script_ResolveOpDataTypeValue(0);
                type = _type_;
                value = _value_;
                switch (type) {
                    case 0: {
                        value1 = KEngine.Script_CoerceValueToInt(type, value);
                        KEngine.Script_CopyTypeData(0, -1, ++value1);
                        return;
                    }
                }
                KEngine.Script_ExitOnCodeError(_currThread, ERROR_TYPE_INVAILD);
                return;
            }
            case 9: {
                KEngine.Script_ResolveOpDataTypeValue(0);
                type = _type_;
                value = _value_;
                switch (type) {
                    case 0: {
                        value1 = KEngine.Script_CoerceValueToInt(type, value);
                        KEngine.Script_CopyTypeData(0, -1, --value1);
                        return;
                    }
                }
                KEngine.Script_ExitOnCodeError(_currThread, ERROR_TYPE_INVAILD);
                return;
            }
            case 19: {
                KEngine.Script_ResolveOpDataTypeValue(0);
                KEngine._ThreadContext[KEngine._currThread * 7] = value = _value_;
                return;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                boolean isJump = false;
                KEngine.Script_ResolveOpDataTypeValue(2);
                value = _value_;
                KEngine.Script_ResolveOpDataTypeValue(0);
                type_d = _type_;
                value_d = _value_;
                KEngine.Script_ResolveOpDataTypeValue(1);
                type_s = _type_;
                value_s = _value_;
                switch (op) {
                    case 20: {
                        switch (type_d) {
                            case 0: {
                                value1 = KEngine.Script_CoerceValueToInt(type_d, value_d);
                                value2 = KEngine.Script_CoerceValueToInt(type_s, value_s);
                                if (value1 != value2) break;
                                isJump = true;
                                break;
                            }
                            case 2: {
                                strTmp1 = KEngine.Script_CoerceValueToString(type_d, value_d);
                                strTmp2 = KEngine.Script_CoerceValueToString(type_s, value_s);
                                if (!strTmp1.equals(strTmp2)) break;
                                isJump = true;
                                break;
                            }
                        }
                        break;
                    }
                    case 21: {
                        switch (type_d) {
                            case 0: {
                                value1 = KEngine.Script_CoerceValueToInt(type_d, value_d);
                                value2 = KEngine.Script_CoerceValueToInt(type_s, value_s);
                                if (value1 == value2) break;
                                isJump = true;
                                break;
                            }
                            case 2: {
                                strTmp1 = KEngine.Script_CoerceValueToString(type_d, value_d);
                                strTmp2 = KEngine.Script_CoerceValueToString(type_s, value_s);
                                if (strTmp1.equals(strTmp2)) break;
                                isJump = true;
                                break;
                            }
                        }
                        break;
                    }
                    case 22: {
                        switch (type_d) {
                            case 0: {
                                value1 = KEngine.Script_CoerceValueToInt(type_d, value_d);
                                value2 = KEngine.Script_CoerceValueToInt(type_s, value_s);
                                if (value1 <= value2) break;
                                isJump = true;
                                break;
                            }
                            case 2: {
                                strTmp1 = KEngine.Script_CoerceValueToString(type_d, value_d);
                                strTmp2 = KEngine.Script_CoerceValueToString(type_s, value_s);
                                if (strTmp1.length() <= strTmp2.length()) break;
                                isJump = true;
                                break;
                            }
                        }
                        break;
                    }
                    case 23: {
                        switch (type_d) {
                            case 0: {
                                value1 = KEngine.Script_CoerceValueToInt(type_d, value_d);
                                value2 = KEngine.Script_CoerceValueToInt(type_s, value_s);
                                if (value1 >= value2) break;
                                isJump = true;
                                break;
                            }
                            case 2: {
                                strTmp1 = KEngine.Script_CoerceValueToString(type_d, value_d);
                                strTmp2 = KEngine.Script_CoerceValueToString(type_s, value_s);
                                if (strTmp1.length() >= strTmp2.length()) break;
                                isJump = true;
                                break;
                            }
                        }
                        break;
                    }
                    case 24: {
                        switch (type_d) {
                            case 0: {
                                value1 = KEngine.Script_CoerceValueToInt(type_d, value_d);
                                value2 = KEngine.Script_CoerceValueToInt(type_s, value_s);
                                if (value1 < value2) break;
                                isJump = true;
                                break;
                            }
                            case 2: {
                                strTmp1 = KEngine.Script_CoerceValueToString(type_d, value_d);
                                strTmp2 = KEngine.Script_CoerceValueToString(type_s, value_s);
                                if (strTmp1.length() < strTmp2.length()) break;
                                isJump = true;
                                break;
                            }
                        }
                        break;
                    }
                    case 25: {
                        switch (type_d) {
                            case 0: {
                                value1 = KEngine.Script_CoerceValueToInt(type_d, value_d);
                                value2 = KEngine.Script_CoerceValueToInt(type_s, value_s);
                                if (value1 > value2) break;
                                isJump = true;
                                break;
                            }
                            case 2: {
                                strTmp1 = KEngine.Script_CoerceValueToString(type_d, value_d);
                                strTmp2 = KEngine.Script_CoerceValueToString(type_s, value_s);
                                if (strTmp1.length() > strTmp2.length()) break;
                                isJump = true;
                            }
                        }
                        break;
                    }
                }
                if (!isJump) return;
                KEngine._ThreadContext[KEngine._currThread * 7] = value;
                return;
            }
            case 31: {
                KEngine.Script_ResolveOpDataTypeValue(0);
                value = KEngine.Script_CoerceValueToInt(_type_, _value_);
                if ((value & 0xFFF20000) == 0) {
                    KEngine.Script_ExitOnCodeError(_currThread, "\u4e0d\u662f\u6709\u6548\u7684\u7ebf\u7a0b\u53e5\u67c4<" + value + ">");
                    return;
                }
                KEngine.Script_ResolveOpDataTypeValue(1);
                value1 = KEngine.Script_CoerceValueToInt(_type_, _value_);
                if ((value &= 0xFFFF) < 0) {
                    KEngine._ThreadPauseEndTime[KEngine._currThread] = _currThreadActiveTime + value1;
                    KEngine._ThreadIsPause[KEngine._currThread] = true;
                    return;
                }
                if (value < 5 && _ThreadActive[value]) {
                    KEngine._ThreadIsPause[value] = true;
                    KEngine._ThreadPauseEndTime[value] = _currThreadActiveTime + value1;
                    return;
                }
                KEngine.Script_ExitOnCodeError(_currThread, "\u9700\u8981\u88ab\u6682\u505c\u7684\u811a\u672c\u7ebf\u7a0b<" + value + ">\u4e0d\u5b58\u5728");
                return;
            }
            case 32: {
                KEngine._ThreadRunning[KEngine._currThread] = false;
                return;
            }
            case 33: {
                _VM_STATUS = (byte)(_VM_STATUS | 1);
                return;
            }
            case 34: {
                KEngine.Script_ResolveOpDataTypeValue(0);
                strTmp1 = KEngine.Script_CoerceValueToString(_type_, _value_);
                value = KEngine.Script_Load(strTmp1);
                if (value == -1) {
                    KEngine.Script_ExitOnCodeError(_currThread, "\u8f7d\u5165\u811a\u672c\u6587\u4ef6<" + value + ">\u51fa\u9519");
                }
                KEngine._RetVal[0] = 0;
                KEngine._RetVal[1] = 0xFFF20000 | value;
                return;
            }
            case 35: {
                KEngine.Script_ResolveOpDataTypeValue(0);
                value = KEngine.Script_CoerceValueToInt(_type_, _value_);
                if ((value & 0xFFF20000) == 0) {
                    KEngine.Script_ExitOnCodeError(_currThread, "\u4e0d\u662f\u6709\u6548\u7684\u7ebf\u7a0b\u53e5\u67c4<" + value + ">");
                    return;
                }
                if ((value &= 0xFFFF) < 5 && value >= 0 && _ThreadActive[value]) {
                    KEngine.Script_ResolveOpDataTypeValue(1);
                    value1 = KEngine.Script_CoerceValueToInt(_type_, _value_);
                    KEngine.Script_Start(value, value1);
                    return;
                }
                KEngine.Script_ExitOnCodeError(_currThread, "\u5f00\u542f\u7684\u811a\u672c\u7ebf\u7a0b<" + value + ">\u4e0d\u5b58\u5728");
                return;
            }
            case 37: {
                KEngine.Script_ResolveOpDataTypeValue(0);
                value = KEngine.Script_CoerceValueToInt(_type_, _value_);
                if ((value & 0xFFF20000) == 0) {
                    KEngine.Script_ExitOnCodeError(_currThread, "\u4e0d\u662f\u6709\u6548\u7684\u7ebf\u7a0b\u53e5\u67c4<" + value + ">");
                    return;
                }
                if ((value &= 0xFFFF) < 0) {
                    KEngine._ThreadRunning[KEngine._currThread] = false;
                    return;
                }
                if (value < 5 && _ThreadActive[value]) {
                    KEngine._ThreadRunning[value] = false;
                    return;
                }
                KEngine.Script_ExitOnCodeError(_currThread, "\u505c\u6b62\u7684\u811a\u672c\u7ebf\u7a0b<" + value + ">\u4e0d\u5b58\u5728");
                return;
            }
            case 39: {
                KEngine.Script_ResolveOpDataTypeValue(0);
                value = KEngine.Script_CoerceValueToInt(_type_, _value_);
                if ((value & 0xFFF20000) == 0) {
                    KEngine.Script_ExitOnCodeError(_currThread, "\u4e0d\u662f\u6709\u6548\u7684\u7ebf\u7a0b\u53e5\u67c4<" + value + ">");
                    return;
                }
                if ((value &= 0xFFFF) < 0) {
                    KEngine._ThreadIsPause[KEngine._currThread] = false;
                    return;
                }
                if (value < 5 && _ThreadActive[value]) {
                    KEngine._ThreadIsPause[value] = false;
                    return;
                }
                KEngine.Script_ExitOnCodeError(_currThread, "\u9700\u8981\u6062\u590d\u7684\u811a\u672c\u7ebf\u7a0b<" + value + ">\u4e0d\u5b58\u5728");
                return;
            }
            case 38: {
                KEngine.Script_ResolveOpDataTypeValue(0);
                value = KEngine.Script_CoerceValueToInt(_type_, _value_);
                if ((value & 0xFFF20000) == 0) {
                    KEngine.Script_ExitOnCodeError(_currThread, "\u4e0d\u662f\u6709\u6548\u7684\u7ebf\u7a0b\u53e5\u67c4<" + value + ">");
                    return;
                }
                if ((value &= 0xFFFF) < 0) {
                    KEngine.Script_Free(_currThread);
                    return;
                }
                if (value < 5 && _ThreadActive[value]) {
                    KEngine.Script_Free(value);
                    return;
                }
                KEngine.Script_ExitOnCodeError(_currThread, "\u9700\u8981\u88ab\u91ca\u653e\u7684\u811a\u672c\u7ebf\u7a0b<" + value + ">\u4e0d\u5b58\u5728");
                return;
            }
            case 36: {
                KEngine.Script_ResolveOpDataTypeValue(0);
                value = KEngine.Script_CoerceValueToInt(_type_, _value_);
                if ((value & 0xFFF20000) == 0) {
                    KEngine.Script_ExitOnCodeError(_currThread, "\u4e0d\u662f\u6709\u6548\u7684\u7ebf\u7a0b\u53e5\u67c4<" + value + ">");
                    return;
                }
                if ((value &= 0xFFFF) < 0) {
                    KEngine.Script_Reset(_currThread);
                    return;
                }
                if (value < 5 && _ThreadActive[value]) {
                    KEngine.Script_Reset(value);
                    return;
                }
                KEngine.Script_ExitOnCodeError(_currThread, "\u9700\u8981\u88ab\u91cd\u7f6e\u7684\u811a\u672c\u7ebf\u7a0b<" + value + ">\u4e0d\u5b58\u5728");
                return;
            }
            case 40: {
                KEngine.Script_Pop(_currThread, false);
                type = _PopVal[_currThread * 2];
                type1 = _PopVal[_currThread * 2 + 1];
                KEngine.Script_Pop(_currThread, false);
                type2 = _PopVal[_currThread * 2 + 1];
                KEngine.Script_Pop(_currThread, false);
                value1 = _PopVal[_currThread * 2 + 1];
                if ((value1 & 0xFFF20000) == 0) {
                    KEngine.Script_ExitOnCodeError(_currThread, "\u4e0d\u662f\u6709\u6548\u7684\u7ebf\u7a0b\u53e5\u67c4<" + value + ">");
                    return;
                }
                if (_currThread == (value1 &= 0xFFFF)) {
                    KEngine.Script_ExitOnCodeError(_currThread, "\u4e0d\u652f\u6301\u5bf9\u81ea\u8eab\u811a\u672c\u7684\u5f02\u6b65\u8c03\u7528<" + value1 + ">");
                    return;
                }
                if (!_ThreadActive[value1]) {
                    KEngine.Script_ExitOnCodeError(_currThread, "\u5f02\u6b65\u8c03\u7528\u7684\u811a\u672c\u672a\u6fc0\u6d3b\uff08\u52a0\u8f7d\uff09<" + value + ">");
                    return;
                }
                KEngine.Script_Pop(_currThread, false);
                value = _PopVal[_currThread * 2 + 1];
                if (value < 0 || value >= _FuncTable[value1].length / 3) {
                    KEngine.Script_ExitOnCodeError(_currThread, "\u5f02\u6b65\u8c03\u7528\u7684\u65b9\u6cd5ID\u6709\u8bef<" + value + ">");
                    return;
                }
                KEngine.Script_Pop(_currThread, false);
                value2 = _PopVal[_currThread * 2 + 1];
                type_s = _FuncTable[value1][value * 3 + 1];
                if (value2 < 0 || value2 >= _DynamicParam.length - 1) {
                    KEngine.Script_ExitOnCodeError(_currThread, "\u5f02\u6b65\u8c03\u7528\u53c2\u6570\u4e2a\u6570\u8d8a\u754c<" + value2 + ">\u53ef\u4ee5\u5728\u865a\u62df\u673a\u8bbe\u7f6e\u91cc\u8c03\u8282\u52a8\u6001\u53c2\u6570\u4e2a\u6570");
                    return;
                }
                if (value2 != type_s) {
                    KEngine.Script_ExitOnCodeError(_currThread, "\u5f02\u6b65\u8c03\u7528\u53c2\u6570\u4e2a\u6570\u548c\u88ab\u8c03\u7528\u51fd\u6570\u4e0d\u5339\u914d<" + value2 + ">");
                    return;
                }
                KEngine._DynamicParam[0] = value2;
                value_s = value2;
                while (true) {
                    if (--value_s < 0) {
                        KEngine.Script_InvokeFunc(value1, value);
                        KEngine.Script_Push(_currThread, 0, type2);
                        KEngine.Script_Push(_currThread, type, type1);
                        int n = _currThread * 7 + 3;
                        _ThreadContext[n] = _ThreadContext[n] - (3 + value2 << 1);
                        return;
                    }
                    KEngine.Script_Pop(_currThread, false);
                    KEngine._DynamicParam[1 + value_s * 2] = _PopVal[_currThread * 2];
                    KEngine._DynamicParam[1 + value_s * 2 + 1] = _PopVal[_currThread * 2 + 1];
                }
            }
            case 41: {
                KEngine.Script_ResolveOpDataTypeValue(0);
                value = KEngine.Script_CoerceValueToInt(_type_, _value_);
                if ((value & 0xFFF20000) == 0) {
                    KEngine.Script_ExitOnCodeError(_currThread, "\u4e0d\u662f\u6709\u6548\u7684\u7ebf\u7a0b\u53e5\u67c4<" + value + ">");
                    return;
                }
                if ((value &= 0xFFFF) < 5 && value >= 0 && _ThreadActive[value]) {
                    KEngine.Script_ResolveOpDataTypeValue(1);
                    value1 = KEngine.Script_CoerceValueToInt(_type_, _value_);
                    KEngine.Script_InvokeFuncSync(value, value1);
                    return;
                }
                KEngine.Script_ExitOnCodeError(_currThread, "\u88ab\u540c\u6b65\u8c03\u7528\u7684\u811a\u672c\u7ebf\u7a0b<" + value + ">\u4e0d\u5b58\u5728");
                return;
            }
            case 48: {
                if (_PDA != null) {
                    KEngine.Script_ExitOnCodeError(_currThread, "\u516c\u5171\u6570\u636e\u533a\u5df2\u7ecf\u521b\u5efa");
                    return;
                }
                KEngine.Script_ResolveOpDataTypeValue(0);
                value = KEngine.Script_CoerceValueToInt(_type_, _value_);
                _PDA = new int[value][];
                return;
            }
            case 49: {
                if (_PDA == null) {
                    KEngine.Script_ExitOnCodeError(_currThread, "\u516c\u5171\u6570\u636e\u533a\u672a\u521b\u5efa");
                    return;
                }
                int i = -1;
                while (true) {
                    if (++i >= _PDA.length) {
                        _PDA = null;
                        System.gc();
                        return;
                    }
                    KEngine._PDA[i] = null;
                }
            }
            case 42: {
                if (_PDA == null) {
                    KEngine.Script_ExitOnCodeError(_currThread, "\u516c\u5171\u6570\u636e\u533a\u672a\u521b\u5efa");
                    return;
                }
                value_s = -1;
                type_s = -1;
                while (++type_s < _PDA.length) {
                    if (_PDA[type_s] != null) continue;
                    value_s = type_s;
                    break;
                }
                if (value_s != -1) {
                    KEngine.Script_ResolveOpDataTypeValue(0);
                    value = KEngine.Script_CoerceValueToInt(_type_, _value_);
                    KEngine._PDA[value_s] = new int[value];
                    KEngine._RetVal[0] = 0;
                    KEngine._RetVal[1] = 0xFFF10000 | value_s;
                    return;
                }
                KEngine.Script_ExitOnCodeError(_currThread, "\u516c\u5171\u6570\u636e\u533a\u5185\u5b58\u4e0d\u8db3,\u5206\u914d\u5931\u8d25");
                return;
            }
            case 43: {
                if (_PDA == null) {
                    KEngine.Script_ExitOnCodeError(_currThread, "\u516c\u5171\u6570\u636e\u533a\u672a\u521b\u5efa");
                    return;
                }
                KEngine.Script_ResolveOpDataTypeValue(0);
                value = KEngine.Script_CoerceValueToInt(_type_, _value_);
                if ((value & 0xFFF10000) == 0) {
                    KEngine.Script_ExitOnCodeError(_currThread, "\u4e0d\u662f\u6709\u6548\u7684\u5185\u5b58\u53e5\u67c4<" + value + ">");
                    return;
                }
                if ((value &= 0xFFFF) >= 0 && value < _PDA.length) {
                    KEngine._PDA[value] = null;
                    System.gc();
                    return;
                }
                KEngine.Script_ExitOnCodeError(_currThread, "\u5185\u5b58\u53e5\u67c4\u5730\u5740<" + value + ">\u4e0d\u5b58\u5728");
                return;
            }
            case 44: {
                KEngine.Script_ResolveOpDataTypeValue(0);
                value = KEngine.Script_CoerceValueToInt(_type_, _value_);
                if ((value & 0xFFF10000) != 0) {
                    value &= 0xFFFF;
                    return;
                }
                KEngine.Script_ExitOnCodeError(_currThread, "\u4e0d\u662f\u6709\u6548\u7684\u5185\u5b58\u53e5\u67c4<" + value + ">");
                return;
            }
            case 45: {
                KEngine.Script_ResolveOpDataTypeValue(0);
                value = KEngine.Script_CoerceValueToInt(_type_, _value_);
                if ((value & 0xFFF10000) != 0) {
                    value &= 0xFFFF;
                    return;
                }
                KEngine.Script_ExitOnCodeError(_currThread, "\u4e0d\u662f\u6709\u6548\u7684\u5185\u5b58\u53e5\u67c4<" + value + ">");
                return;
            }
            case 47: {
                KEngine.Script_ResolveOpDataTypeValue(0);
                value = KEngine.Script_CoerceValueToInt(_type_, _value_);
                if ((value & 0xFFF10000) == 0) {
                    KEngine.Script_ExitOnCodeError(_currThread, "\u4e0d\u662f\u6709\u6548\u7684\u5185\u5b58\u53e5\u67c4<" + value + ">");
                    return;
                }
                KEngine.Script_ResolveOpDataTypeValue(1);
                value1 = KEngine.Script_CoerceValueToInt(_type_, _value_);
                if (value1 >= 0 && value1 < _PDA[value &= 0xFFFF].length) {
                    KEngine.Script_ResolveOpDataTypeValue(2);
                    KEngine._PDA[value][value1] = value2 = KEngine.Script_CoerceValueToInt(_type_, _value_);
                    return;
                }
                KEngine.Script_ExitOnCodeError(_currThread, "\u65e0\u6548\u5185\u5b58\u5730\u5740<" + value1 + ">");
                return;
            }
            case 46: {
                KEngine.Script_ResolveOpDataTypeValue(0);
                value = KEngine.Script_CoerceValueToInt(_type_, _value_);
                if ((value & 0xFFF10000) == 0) {
                    KEngine.Script_ExitOnCodeError(_currThread, "\u4e0d\u662f\u6709\u6548\u7684\u5185\u5b58\u53e5\u67c4<" + value + ">");
                    return;
                }
                KEngine.Script_ResolveOpDataTypeValue(1);
                value1 = KEngine.Script_CoerceValueToInt(_type_, _value_);
                if (value1 >= 0 && value1 < _PDA[value &= 0xFFFF].length) {
                    KEngine._RetVal[KEngine._currThread << 1] = 0;
                    KEngine._RetVal[(KEngine._currThread << 1) + 1] = _PDA[value][value1];
                    return;
                }
                KEngine.Script_ExitOnCodeError(_currThread, "\u65e0\u6548\u5185\u5b58\u5730\u5740<" + value1 + ">");
                return;
            }
            case 16: {
                KEngine.Script_ResolveOpDataTypeValue(0);
                type = _type_;
                value = _value_;
                KEngine.Script_ResolveOpDataTypeValue(1);
                type2 = _type_;
                value2 = _value_;
                if (type != 2 && type2 != 2) {
                    return;
                }
                strTmp1 = _StrTable[_currThread][value];
                strTmp2 = _StrTable[_currThread][value2];
                strTmp1 = strTmp1 + strTmp2;
                KEngine.Script_UpdateStringTable(value, strTmp1);
                return;
            }
            case 17: {
                return;
            }
        }
    }

    public static final void Script_SetPriority(int iHandle, int priority) {
        if (!_ThreadActive[iHandle]) {
            return;
        }
        priority = priority > 5 ? 5 : priority;
        priority = priority < 1 ? 1 : priority;
        KEngine._ThreadContext[iHandle * 7 + 6] = priority * 10;
    }

    public static final void Script_Start(int iHandle, int priority) {
        if (!_ThreadActive[iHandle]) {
            return;
        }
        KEngine._ThreadRunning[iHandle] = true;
        priority = priority > 5 ? 5 : priority;
        priority = priority < 1 ? 1 : priority;
        KEngine._ThreadContext[iHandle * 7 + 6] = priority * 10;
    }

    public static final void Script_Stop(int iHandle) {
        if (!_ThreadActive[iHandle]) {
            return;
        }
        KEngine._ThreadRunning[iHandle] = false;
    }

    public static final void Script_Unpause(int iHandle) {
        if (!_ThreadActive[iHandle]) {
            return;
        }
        KEngine._ThreadIsPause[iHandle] = false;
    }

    private static final void Script_UpdateStringTable(int index, String s) {
        KEngine._StrTable[KEngine._currThread][index] = s;
    }

    public static final boolean Str_Contains(char c, char[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (c != array[i]) continue;
            return true;
        }
        return false;
    }

    public static final String Str_Divide(String value, Font font, int width) {
        if (font.stringWidth(value) < width) {
            return value;
        }
        char[] ch = value.toCharArray();
        StringBuffer sb = new StringBuffer();
        int w = 0;
        for (int i = 0; i < ch.length; ++i) {
            sb.append(ch[i]);
            if ((w += font.charWidth(ch[i])) < width) continue;
            return sb.toString();
        }
        return sb.toString();
    }

    public static final String[] Str_Split(Font font, String strSrc, int width) {
        Object[] result = new String[1];
        if (font.stringWidth(strSrc) < width) {
            result[0] = strSrc;
            return result;
        }
        char[] ch = strSrc.toCharArray();
        Vector<String> lines = new Vector<String>();
        StringBuffer sb = new StringBuffer();
        int w = 0;
        for (int i = 0; i < ch.length; ++i) {
            sb.append(ch[i]);
            if ((w += font.charWidth(ch[i])) < width - 12) continue;
            lines.addElement(sb.toString());
            sb = null;
            sb = new StringBuffer();
            w = 0;
        }
        lines.addElement(sb.toString());
        result = new String[lines.size()];
        lines.copyInto(result);
        lines.removeAllElements();
        lines = null;
        return result;
    }

    public static final String[] Str_Split(String value, String regex) {
        if (value == null) {
            return null;
        }
        Vector<String> split = new Vector<String>();
        while (true) {
            int index;
            if ((index = value.indexOf(regex)) == -1) {
                if (value == null || value.equals("")) break;
                split.addElement(value);
                break;
            }
            split.addElement(value.substring(0, index));
            value = value.substring(index + 1, value.length());
        }
        Object[] s = new String[split.size()];
        split.copyInto(s);
        return s;
    }

    public static final String Time_CurrentDate() {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        StringBuffer sb = new StringBuffer();
        sb.append(year).append("-").append(month).append("-").append(day);
        return sb.toString();
    }

    public static final String Time_CurrentTime() {
        Calendar calendar = Calendar.getInstance();
        int hour = calendar.get(10);
        int min = calendar.get(12);
        int sec = calendar.get(13);
        int pm = calendar.get(9);
        hour = pm == 1 ? hour + 12 : hour;
        StringBuffer sb = new StringBuffer();
        sb.append(hour < 10 ? "0" : "").append(hour).append(":");
        sb.append(min < 10 ? "0" : "").append(min).append(":");
        sb.append(sec < 10 ? "0" : "").append(sec);
        return sb.toString();
    }

    private static final String URL_ByteArrayToHexString(byte[] in) {
        byte ch = 0;
        if (in == null || in.length <= 0) {
            return null;
        }
        String[] pseudo = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        StringBuffer out = new StringBuffer(in.length * 2);
        for (int i = 0; i < in.length; ++i) {
            ch = (byte)(in[i] & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(pseudo[ch]);
            ch = (byte)(in[i] & 0xF);
            out.append(pseudo[ch]);
        }
        String rslt = new String(out);
        return rslt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String URL_Decode(String url) {
        char[] chars = url.toCharArray();
        int cursor = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = null;
        try {
            String text;
            dos = new DataOutputStream(baos);
            while (cursor < chars.length) {
                int curr;
                if ((curr = chars[cursor++]) == 37) {
                    StringBuffer tmp = new StringBuffer();
                    char cr = chars[cursor++];
                    char lf = chars[cursor++];
                    tmp.append(cr).append(lf);
                    Integer result = Integer.valueOf(tmp.toString(), 16);
                    curr = result;
                }
                dos.writeByte(curr);
            }
            dos.flush();
            baos.flush();
            byte[] data = baos.toByteArray();
            String string = text = KEngine.UTF_Decode(data, 0, data.length);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (dos != null) {
                    dos.close();
                }
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception e) {}
        }
        return null;
    }

    public static final String URL_Encode(String url) {
        try {
            int strlen = url.length();
            StringBuffer out = new StringBuffer();
            for (int i = 0; i < strlen; ++i) {
                char t = url.charAt(i);
                int c = 0;
                if ((c |= t & 0xFFFF) >= 0 && c < 128) {
                    switch (t) {
                        case '=': {
                            out.append("%3d");
                            break;
                        }
                        case ' ': {
                            out.append("%20");
                            break;
                        }
                        case '+': {
                            out.append("%2b");
                            break;
                        }
                        case '\'': {
                            out.append("%27");
                            break;
                        }
                        case '/': {
                            out.append("%2F");
                            break;
                        }
                        case '.': {
                            out.append("%2E");
                            break;
                        }
                        case '<': {
                            out.append("%3c");
                            break;
                        }
                        case '>': {
                            out.append("%3e");
                            break;
                        }
                        case '#': {
                            out.append("%23");
                            break;
                        }
                        case '%': {
                            out.append("%25");
                            break;
                        }
                        case '&': {
                            out.append("%26");
                            break;
                        }
                        case '{': {
                            out.append("%7b");
                            break;
                        }
                        case '}': {
                            out.append("%7d");
                            break;
                        }
                        case '\\': {
                            out.append("%5c");
                            break;
                        }
                        case '^': {
                            out.append("%5e");
                            break;
                        }
                        case '~': {
                            out.append("%73");
                            break;
                        }
                        case '[': {
                            out.append("%5b");
                            break;
                        }
                        case ']': {
                            out.append("%5d");
                            break;
                        }
                        default: {
                            out.append(t);
                            break;
                        }
                    }
                    continue;
                }
                if (c > 127 && c < 2048) {
                    out.append("%").append(KEngine.URL_ByteArrayToHexString(new byte[]{(byte)(c >>> 6 & 0x1F | 0xC0)}));
                    out.append("%").append(KEngine.URL_ByteArrayToHexString(new byte[]{(byte)(c >>> 0 & 0x3F | 0x80)}));
                    continue;
                }
                if (c > 2047 && c < 65536) {
                    out.append("%").append(KEngine.URL_ByteArrayToHexString(new byte[]{(byte)(c >>> 12 & 0xF | 0xE0)}));
                    out.append("%").append(KEngine.URL_ByteArrayToHexString(new byte[]{(byte)(c >>> 6 & 0x3F | 0x80)}));
                    out.append("%").append(KEngine.URL_ByteArrayToHexString(new byte[]{(byte)(c >>> 0 & 0x3F | 0x80)}));
                    continue;
                }
                if (c <= 65535 || c >= 1048575) continue;
                out.append("%").append(KEngine.URL_ByteArrayToHexString(new byte[]{(byte)(c >>> 18 & 7 | 0xF0)}));
                out.append("%").append(KEngine.URL_ByteArrayToHexString(new byte[]{(byte)(c >>> 12 & 0x3F | 0x80)}));
                out.append("%").append(KEngine.URL_ByteArrayToHexString(new byte[]{(byte)(c >>> 6 & 0x3F | 0x80)}));
                out.append("%").append(KEngine.URL_ByteArrayToHexString(new byte[]{(byte)(c >>> 0 & 0x3F | 0x80)}));
            }
            return out.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public static final String UTF_Decode(byte[] in, int offset, int length) {
        StringBuffer buff = new StringBuffer();
        int max = offset + length;
        for (int i = offset; i < max; ++i) {
            char c = '\u0000';
            if ((in[i] & 0x80) == 0) {
                c = (char)in[i];
            } else if ((in[i] & 0xE0) == 192) {
                c = (char)(c | (in[i++] & 0x1F) << 6);
                c = (char)(c | (in[i] & 0x3F) << 0);
            } else if ((in[i] & 0xF0) == 224) {
                c = (char)(c | (in[i++] & 0xF) << 12);
                c = (char)(c | (in[i++] & 0x3F) << 6);
                c = (char)(c | (in[i] & 0x3F) << 0);
            } else if ((in[i] & 0xF8) == 240) {
                c = (char)(c | (in[i++] & 7) << 18);
                c = (char)(c | (in[i++] & 0x3F) << 12);
                c = (char)(c | (in[i++] & 0x3F) << 6);
                c = (char)(c | (in[i] & 0x3F) << 0);
            } else {
                c = (char)63;
            }
            buff.append(c);
        }
        return buff.toString();
    }

    public static final String UTF_Decode(byte[] in) {
        return KEngine.UTF_Decode(in, 0, in.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] UTF_Encode(String value) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            int strlen = value.length();
            for (int i = 0; i < strlen; ++i) {
                char t = value.charAt(i);
                int c = 0;
                if ((c |= t & 0xFFFF) >= 0 && c < 128) {
                    bos.write((byte)(c & 0xFF));
                    continue;
                }
                if (c > 127 && c < 2048) {
                    bos.write((byte)(c >>> 6 & 0x1F | 0xC0));
                    bos.write((byte)(c >>> 0 & 0x3F | 0x80));
                    continue;
                }
                if (c > 2047 && c < 65536) {
                    bos.write((byte)(c >>> 12 & 0xF | 0xE0));
                    bos.write((byte)(c >>> 6 & 0x3F | 0x80));
                    bos.write((byte)(c >>> 0 & 0x3F | 0x80));
                    continue;
                }
                if (c <= 65535 || c >= 1048575) continue;
                bos.write((byte)(c >>> 18 & 7 | 0xF0));
                bos.write((byte)(c >>> 12 & 0x3F | 0x80));
                bos.write((byte)(c >>> 6 & 0x3F | 0x80));
                bos.write((byte)(c >>> 0 & 0x3F | 0x80));
            }
            bos.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public KEngine(MIDlet gameApp) {
        this.setFullScreenMode(true);
        gameThread = new Thread(this);
        KEngine.gameApp = gameApp;
        instance = this;
        this.OnCreate();
    }

    public final void Clear(int color) {
        KEngine.GUI_Clear(g, color, 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);
    }

    public final void commandAction(Command cmd, Displayable display) {
    }

    public void DrawImage(int imgIndex, int x, int y, int flip, int anchor) {
        Image img = this.GetImage(imgIndex);
        if (img != null) {
            KEngine.GUI_DrawImage(g, img, 0, 0, img.getWidth(), img.getHeight(), flip, x, y, anchor);
        }
    }

    public void DrawImage(Image img, int x, int y, int flip, int anchor) {
        if (img != null) {
            KEngine.GUI_DrawImage(g, img, 0, 0, img.getWidth(), img.getHeight(), flip, x, y, anchor);
        }
    }

    public final void DrawImage(int imgIndex, int srcX, int srcY, int width, int height, int transform, int destX, int destY, int anchor) {
        Image img = this.GetImage(imgIndex);
        if (img != null) {
            KEngine.GUI_DrawImage(g, img, srcX, srcY, width, height, transform, destX, destY, anchor);
        }
    }

    public final void DrawImage(Image img, int srcX, int srcY, int width, int height, int transform, int destX, int destY, int anchor) {
        if (img != null) {
            KEngine.GUI_DrawImage(g, img, srcX, srcY, width, height, transform, destX, destY, anchor);
        }
    }

    public final void DrawString(int strIndex, int x, int y, int color, int anchor) {
        String str = this.GetString(strIndex);
        this.DrawString(str, x, y, color, anchor);
    }

    public final void DrawString(String str, int x, int y, int color, int anchor) {
        if (str != null) {
            KEngine.GUI_DrawString(g, FONT, str, x, y, color, color, anchor, false);
        }
    }

    public Image GetImage(int imgIndex) {
        if (imgIndex >= 0 && imgIndex < imgPool.length) {
            return imgPool[imgIndex];
        }
        return null;
    }

    protected final int GetKey(int keyCode, int keyActionCode) {
        switch (keyCode) {
            case 48: {
                return 2;
            }
            case 49: {
                return 4;
            }
            case 50: {
                return 8;
            }
            case 51: {
                return 16;
            }
            case 52: {
                return 32;
            }
            case 53: {
                return 64;
            }
            case 54: {
                return 128;
            }
            case 55: {
                return 256;
            }
            case 56: {
                return 512;
            }
            case 57: {
                return 1024;
            }
            case 42: {
                return 2048;
            }
            case 35: {
                return 4096;
            }
        }
        switch (keyActionCode) {
            case 1: {
                return 8192;
            }
            case 6: {
                return 16384;
            }
            case 2: {
                return 32768;
            }
            case 5: {
                return 65536;
            }
            case 8: {
                return 131072;
            }
        }
        switch (keyCode) {
            case -202: 
            case -21: 
            case -10: 
            case -6: 
            case 21: {
                return 262144;
            }
            case -203: 
            case -22: 
            case -11: 
            case -7: 
            case 22: {
                return 524288;
            }
        }
        return 0;
    }

    public String GetString(int strIndex) {
        if (strIndex >= 0 && strIndex < strPool.length) {
            return strPool[strIndex];
        }
        return null;
    }

    protected final void keyPressed(int keyCode) {
        int scanCode = this.GetKey(keyCode, this.getGameAction(keyCode));
        this.OnKeyDown(gameState, scanCode);
    }

    protected final void keyReleased(int keyCode) {
        int scanCode = this.GetKey(keyCode, this.getGameAction(keyCode));
        this.OnKeyUp(gameState, scanCode);
    }

    protected final void keyRepeated(int keyCode) {
        int scanCode = this.GetKey(keyCode, this.getGameAction(keyCode));
        this.OnKeyRepeat(gameState, scanCode);
    }

    protected abstract void OnCreate();

    protected abstract void OnKeyDown(int var1, int var2);

    protected abstract void OnKeyRepeat(int var1, int var2);

    protected abstract void OnKeyUp(int var1, int var2);

    protected abstract void OnLoading();

    protected abstract void OnPointerDown(int var1, int var2, int var3);

    protected abstract void OnPointerUp(int var1, int var2, int var3);

    protected abstract String[] OnRegisterLib();

    protected abstract void OnRelease();

    protected abstract void OnScriptCall(int var1, int var2);

    protected abstract void OnShow(int var1);

    protected abstract void updateLeftRightandSound();

    protected abstract void OnSwitch(int var1);

    public void paint(Graphics g) {
        KEngine.g = g;
        if (effectType == -1) {
            this.Clear(0);
            this.OnShow(gameState);
        } else {
            KEngine.Effect_OnShow();
        }
        KEngine.printDebug();
    }

    protected final void pointerPressed(int x, int y) {
        this.OnPointerDown(gameState, x, y);
    }

    protected final void pointerReleased(int x, int y) {
        this.OnPointerUp(gameState, x, y);
    }

    public final void PutImage(int imgIndex, Image image) {
        if (imgIndex < 0 || imgIndex >= 127) {
            KEngine.print("\u56fe\u50cf\u6c60\u6700\u591a\u53ea\u80fd\u52a0\u8f7d 127 \u4e2a\u56fe\u50cf\uff01");
            return;
        }
        if (imgIndex >= imgPool.length) {
            imgPool = KEngine.Array_Expand(imgPool, 50);
        }
        KEngine.imgPool[imgIndex] = image;
    }

    public final void PutImage(int imgIndex, String imgPath) {
        Image image = KEngine.Image_Load(imgPath);
        this.PutImage(imgIndex, image);
    }

    public final void PutString(int strIndex, String str) {
        if (strIndex < 0 || strIndex >= 1024) {
            KEngine.print("\u5b57\u7b26\u4e32\u6c60\u6700\u591a\u53ea\u80fd\u52a0\u8f7d 1024 \u4e2a\u5b57\u7b26\u4e32\uff01");
            return;
        }
        if (strIndex >= strPool.length) {
            strPool = KEngine.Array_Expand(strPool, 30);
        }
        KEngine.strPool[strIndex] = str;
    }

    public final void PutString(int startIndex, String[] strs) {
        if (strs != null) {
            for (int i = 0; i < strs.length; ++i) {
                this.PutString(startIndex + i, strs[i]);
            }
        }
    }

    public final void ResetImagePool() {
        if (imgPool != null) {
            for (int i = 0; i < imgPool.length; ++i) {
                KEngine.imgPool[i] = null;
            }
            imgPool = null;
            imgPool = new Image[50];
        }
    }

    public final void ResetStringPool() {
        if (strPool != null) {
            for (int i = 0; i < strPool.length; ++i) {
                KEngine.strPool[i] = null;
            }
            strPool = null;
            strPool = new String[30];
        }
    }

    public final void run() {
        try {
            calTime = System.currentTimeMillis();
            while (!exit && Thread.currentThread() == gameThread) {
                long timeStart = System.currentTimeMillis();
                if (++frameTimer > Integer.MAX_VALUE) {
                    frameTimer = 0;
                }
                instance.updateLeftRightandSound();
                this.repaint();
                this.serviceRepaints();
                calTime = System.currentTimeMillis();
                long now = System.currentTimeMillis();
                long timeTaken = now - timeStart;
                if (timeTaken > 0L) {
                    FPS = (short)(1000L / timeTaken);
                }
                if (timeTaken < (long)FLIP_MSEL) {
                    Thread.sleep((long)FLIP_MSEL - timeTaken);
                    continue;
                }
                Thread.sleep(5L);
            }
            if (exit) {
                this.OnRelease();
                gameThread = null;
                gameApp.notifyDestroyed();
                return;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final void StartGame() {
        gameThread.start();
        Display.getDisplay((MIDlet)gameApp).setCurrent((Displayable)instance);
    }

    public final void StopGame() {
        exit = true;
        this.OnRelease();
        gameThread = null;
        gameApp.notifyDestroyed();
    }

    public final void Switch(int targetGameState) {
        this.Switch(targetGameState, false);
    }

    public final void Switch(int targetGameState, boolean showLoading) {
        instance.OnSwitch(targetGameState);
        gameState = targetGameState;
        frameTimer = 0;
    }

    public String[] splitMsg(String msg, int width) {
        String[] lines = new String[this.getMsgLines(msg, width)];
        int startIndex = 0;
        int line = 0;
        int msgLength = msg.length();
        for (int endIndex = 0; endIndex <= msgLength; endIndex = (int)((short)(endIndex + 1))) {
            while (endIndex <= msgLength && FONT.stringWidth(msg.substring(startIndex, endIndex)) <= width) {
                endIndex = (short)(endIndex + 1);
            }
            int n = line;
            line = (byte)(line + 1);
            endIndex = (short)(endIndex - 1);
            lines[n] = msg.substring(startIndex, endIndex);
            int n2 = endIndex;
            startIndex = n2;
        }
        return lines;
    }

    public byte getMsgLines(String msg, int width) {
        int startIndex = 0;
        byte line = 0;
        for (int endIndex = 0; endIndex <= msg.length(); endIndex = (int)((short)(endIndex + 1))) {
            while (endIndex <= msg.length() && FONT.stringWidth(msg.substring(startIndex, endIndex)) <= width) {
                endIndex = (short)(endIndex + 1);
            }
            line = (byte)(line + 1);
            int n = endIndex = (int)((short)(endIndex - 1));
            startIndex = n;
        }
        return line;
    }

    static {
        gameState = -1;
        targetGS = -1;
        imgPool = new Image[50];
        strPool = new String[30];
        effectType = (byte)-1;
        effectTimer = (byte)10;
        _VM_STATUS = 0;
        _PDA = null;
        _DynamicParam = new int[21];
        tileID = 0;
        calTime = 0L;
    }
}

