/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.Utility;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;

public class Sound {
    private boolean SoundOn = true;
    private Player m_singlesound = null;
    private int m_cursoundID = -1;
    private final String[] sound_name = new String[]{"/0.mid"};

    private void createPlayer(int _id) {
        if (_id == -1) {
            return;
        }
        InputStream is = null;
        is = this.getClass().getResourceAsStream(this.sound_name[_id]);
        if (is == null) {
            return;
        }
        try {
            this.m_singlesound = Manager.createPlayer((InputStream)is, (String)"audio/midi");
            this.m_singlesound.realize();
            this.m_singlesound.prefetch();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (MediaException ex) {
            this.m_singlesound = null;
            ex.printStackTrace();
        }
    }

    public void playSound(int _id) {
        System.out.println(_id);
        try {
            if (!this.SoundOn) {
                return;
            }
            if (this.m_cursoundID != _id || this.m_singlesound == null) {
                if (this.m_singlesound != null) {
                    this.m_singlesound.stop();
                    this.m_singlesound.deallocate();
                }
                this.createPlayer(_id);
                this.m_singlesound.setLoopCount(-1);
                this.m_singlesound.start();
                this.m_cursoundID = _id;
            } else if (this.m_singlesound.getState() != 400) {
                this.m_singlesound.stop();
                this.m_singlesound.deallocate();
                this.createPlayer(_id);
                this.m_singlesound.setLoopCount(-1);
                this.m_singlesound.start();
                this.m_cursoundID = _id;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void stopSound() {
        try {
            if (this.m_singlesound == null) {
                return;
            }
            this.m_singlesound.stop();
            this.m_singlesound.deallocate();
            this.m_singlesound = null;
            Utility.doGc();
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
    }
}

