/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.game.Sprite;

public class EnemyHelicopterPlane
extends BasicPlane {
    private boolean fromLeftToRight = false;
    Random rn = new Random();
    private long start = 0L;
    private long end = 0L;

    public EnemyHelicopterPlane(Sprite sprite, int x, int y, boolean fromLeftToRight) {
        try {
            this.sprite = sprite;
            this.x = x;
            this.y = y;
            this.w = sprite.getWidth();
            this.h = sprite.getHeight();
            this.life = 20;
            this.attach = 2;
            this.dx = -3;
            this.dy = 0;
            this.currentFrame = 0;
            this.endFrame = sprite.getRawFrameCount() - 1;
            this.fromLeftToRight = fromLeftToRight;
            this.bulletType = 7;
            if (this.fromLeftToRight) {
                this.dx = 2;
            }
        }
        catch (Exception e) {
            Util.debug("EnemyHelicopterPlane---------------init die!");
        }
    }

    public boolean canDestroySelf() {
        return this.fromLeftToRight ? this.getLeftTopX() > Util.screenWidth : this.getRightBottomX() < 0;
    }

    public boolean canSendBullet() {
        this.end = System.currentTimeMillis();
        if (this.end - this.start > (long)(1200 + this.rn.nextInt(5000))) {
            this.start = this.end;
            return true;
        }
        return false;
    }

    public void move() {
        if (!this.canMove(35L)) {
            return;
        }
        this.moveTo(this.getDX(), this.getDY());
        ++this.currentFrame;
        if (this.currentFrame > this.endFrame) {
            this.currentFrame = 0;
        }
    }
}

