/*
 * Decompiled with CFR 0.152.
 */
package com.bsg.nss.nokiaseries30;

import com.bsg.nss.nokiaseries30.Monster;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class LineMonster
extends Monster {
    int[][] nodes;
    int currentNode;
    int nextNode;
    int speed;
    int move;
    int moveCounter;

    public LineMonster(Image image, int[][] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        super(image, n / 10, n2 / 10, 0, 0, n6);
        this.nodes = nArray;
        this.currentNode = 0;
        this.nextNode = 0;
        this.speed = n5;
        this.move = 0;
        this.moveCounter = -1;
    }

    public void reset() {
        if (!this.dying && !this.dead) {
            super.reset();
            this.currentNode = 0;
            this.nextNode = 0;
            this.move = 0;
            this.moveCounter = -1;
        }
    }

    public void move() {
        if (this.active && !this.dying && !this.dead) {
            this.xPos += this.dx;
            this.yPos += this.dy;
            ++this.moveCounter;
            if (this.moveCounter == this.move) {
                this.moveCounter = 0;
                this.currentNode = this.nextNode++;
                if (this.nextNode == this.nodes.length) {
                    this.nextNode = 0;
                }
                this.xPos = this.nodes[this.currentNode][0];
                this.yPos = this.nodes[this.currentNode][1];
                int n = this.nodes[this.nextNode][0] - this.nodes[this.currentNode][0];
                int n2 = this.nodes[this.nextNode][1] - this.nodes[this.currentNode][1];
                this.dx = n > 0 ? this.speed : (n < 0 ? -this.speed : 0);
                this.dy = n2 > 0 ? this.speed : (n2 < 0 ? -this.speed : 0);
                this.move = Math.abs((n + n2) / Math.max(Math.abs(this.dx), Math.abs(this.dy)));
            }
            if (this.dx > 0) {
                this.currentMove = 3;
            } else if (this.dx < 0) {
                this.currentMove = 2;
            } else if (this.dy > 0) {
                this.currentMove = 1;
            } else if (this.dy < 0) {
                this.currentMove = 0;
            }
            ++this.currentFrame;
            if (this.currentFrame == 2) {
                this.currentFrame = 0;
            }
        } else if (this.dying && !this.dead) {
            this.xPos += this.dx;
            this.yPos += this.dy;
            if (this.dy < 8) {
                ++this.dy;
            }
            if (this.yPos > this.levelHeight) {
                this.dead = true;
            }
        }
    }

    public void paint(Graphics graphics, int n, int n2) {
        if (!this.dying) {
            int n3;
            graphics.setColor(0x404040);
            graphics.setStrokeStyle(1);
            int n4 = 0;
            int n5 = 0;
            for (n3 = 0; n3 < this.nodes.length; ++n3) {
                if (this.nodes[n3][0] + 10 > n4) {
                    n4 = this.nodes[n3][0] + 6;
                }
                if (this.nodes[n3][1] + 10 <= n5) continue;
                n5 = this.nodes[n3][1] + 6;
            }
            graphics.setClip(0, 0, n + n4, n2 + n5);
            for (n3 = 0; n3 < this.nodes.length - 1; ++n3) {
                graphics.drawLine(n + this.nodes[n3][0] + 4, n2 + this.nodes[n3][1] + 4, n + this.nodes[n3 + 1][0] + 4, n2 + this.nodes[n3 + 1][1] + 4);
            }
            graphics.drawLine(n + this.nodes[n3][0] + 4, n2 + this.nodes[n3][1] + 4, n + this.nodes[0][0] + 4, n2 + this.nodes[0][1] + 4);
            graphics.setStrokeStyle(0);
        }
        if (this.active) {
            graphics.setClip(n + this.xPos, n2 + this.yPos, this.width, this.height);
            graphics.drawImage(this.monsterImages, n + this.xPos - this.currentFrame * 10, n2 + this.yPos - this.currentMove * 10, 20);
        }
    }
}

