/*
 * Decompiled with CFR 0.152.
 */
package com.bsg.nss.nokiaseries30;

import com.bsg.nokiacolor.BSCanvas;
import com.bsg.nss.nokiaseries30.FlyingMonster;
import com.bsg.nss.nokiaseries30.JumpingMonster;
import com.bsg.nss.nokiaseries30.LineMonster;
import com.bsg.nss.nokiaseries30.Monster;
import com.nokia.mid.sound.Sound;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class NewSkoolSkaterCanvas
extends BSCanvas
implements Runnable {
    private Image statusBarImage;
    private Image[] tiles;
    private Image playerImages;
    private Image optionsImage;
    private Image[] digits;
    private Image livesImage;
    private Image coinsImage;
    private Image timerImage;
    private Image clockImage;
    private Image shotImage;
    private Image jumpingMonsterImages;
    private Image flyingMonsterImages;
    private Image lineMonsterImages;
    private Image invincibilityImages;
    private Image scoreImages;
    private Image endGameImage;
    private Graphics statusBarSurface;
    private Graphics timerGraphics;
    private int screenHeight;
    private int halfScreenHeight;
    private int screenWidth;
    private int halfScreenWidth;
    private int statusBarHeight = 7;
    private int backBufferWidth;
    private int backBufferHeight;
    private int xOffSet;
    private int xOffSetAdjust;
    private int xOffSetCounter;
    private int yOffSet;
    private int yOffSetCounter;
    private int totalCoins;
    private int currentLevel;
    private int pWidth = 10;
    private int pHalfWidth;
    private int pHeight = 10;
    private int pHalfHeight;
    private int pXPos;
    private int pOrigXPos;
    private int pYPos;
    private int pOrigYPos;
    private int pOldYPos;
    private int pDX;
    private int pMaxDX;
    private int pDY;
    private int pMaxDY;
    private int pAngle;
    private int pAngleOffSet;
    private int pSlowDown;
    private int pAccelerate;
    private int pCurrentMove;
    private int pLives;
    private int pCoins;
    private int pTotalCoins;
    private int[] scores;
    private int invincibilityCounter;
    private int invincibilityFrame;
    private int invincibilityScoreAdjust;
    private int pDXLeft;
    private int pDYLeft;
    private int pDXT;
    private int pDYT;
    private int pUpTileX1;
    private int pUpTileX2;
    private int pUpTileY;
    private int pDownTileX1;
    private int pDownTileX2;
    private int pDownTileY;
    private int pLeftTileX;
    private int pLeftTileY1;
    private int pLeftTileY2;
    private int pRightTileX;
    private int pRightTileY1;
    private int pRightTileY2;
    private boolean left;
    private boolean right;
    private boolean up;
    private boolean down;
    private boolean fire;
    private boolean jumping;
    private boolean falling;
    private boolean onLeftRamp;
    private boolean onRightRamp;
    private boolean running;
    private boolean levelClear;
    private boolean gameover;
    private boolean won;
    private boolean dead;
    private boolean finishedGame;
    private boolean start;
    private boolean keyPressed;
    private boolean updateStatus;
    private boolean invincible;
    private long startTime;
    private long pausedTime;
    private int timer;
    private int lastTime;
    private int totalTime;
    private Thread instance;
    private Monster[] monsters;
    private byte[][] level;
    private int[][] shots;
    private Vector scoreAnims;
    private final int P_LEFT;
    private final int P_RIGHT;
    private final int P_DEAD;
    private Sound[] sounds;
    private final byte[][] soundBytes = new byte[][]{{2, 74, 58, 81, -47, -107, -51, -48, 4, 0, 27, 24, 70, 4, -32, 86, 5, -96, 98, 0, 0}, {2, 74, 58, 81, -47, -107, -51, -48, 4, 0, 27, 24, 98, 5, -96, 86, 4, -32, 70, 0, 0}, {2, 74, 58, 81, -47, -107, -51, -48, 4, 0, 27, 24, 69, -123, 96, 90, 6, 32, -94, 44, 65, 22, 0, 0}, {2, 74, 58, 81, -47, -107, -51, -48, 4, 0, 27, 20, -125, 12, 0, 0}, {2, 74, 58, 81, -47, -107, -51, -48, 4, 0, 27, 32, 86, 0, 0}, {2, 74, 58, 81, -47, -107, -51, -48, 4, 0, 27, 20, -94, -84, 0, 0}};
    private final int WONMELODY;
    private final int DEADMELODY;
    private final int BONUSMELODY;
    private final int BEEP_LOW;
    private final int BEEP_MED;
    private final int BEEP_HIGH;
    public static Command GAME_FINISHED = new Command("", 1, 0);
    private final int[] sin = new int[]{0, 4, 8, 13, 17, 22, 26, 31, 35, 40, 44, 48, 53, 57, 61, 66, 70, 74, 79, 83, 87, 91, 95, 100, 104, 108, 112, 116, 120, 124, 127, 131, 135, 139, 143, 146, 150, 154, 157, 161, 164, 167, 171, 174, 177, 181, 184, 187, 190, 193, 196, 198, 201, 204, 207, 209, 212, 214, 217, 219, 221, 223, 226, 228, 230, 232, 233, 235, 237, 238, 240, 242, 243, 244, 246, 247, 248, 249, 250, 251, 252, 252, 253, 254, 254, 255, 255, 255, 255, 255, 256};
    private final int[] cos = new int[]{256, 255, 255, 255, 255, 255, 254, 254, 253, 252, 252, 251, 250, 249, 248, 247, 246, 244, 243, 242, 240, 238, 237, 235, 233, 232, 230, 228, 226, 223, 221, 219, 217, 214, 212, 209, 207, 204, 201, 198, 196, 193, 190, 187, 184, 181, 177, 174, 171, 167, 164, 161, 157, 154, 150, 146, 143, 139, 135, 131, 128, 124, 120, 116, 112, 108, 104, 100, 95, 91, 87, 83, 79, 74, 70, 66, 61, 57, 53, 48, 44, 40, 35, 31, 26, 22, 17, 13, 8, 4, 0};
    public static final byte[][] heightMaps = new byte[][]{new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], {1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, {1, 1, 2, 2, 3, 3, 4, 4, 5, 5}, {6, 6, 7, 7, 8, 8, 9, 9, 10, 10}, {1, 1, 1, 1, 2, 2, 2, 2, 3, 3}, {4, 4, 5, 6, 7, 8, 10, 12, 16, 20}, {0, 0, 0, 0, 0, 0, 0, 2, 6, 10}, new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], {10, 9, 8, 7, 6, 5, 4, 3, 2, 1}, {5, 5, 4, 4, 3, 3, 2, 2, 1, 1}, {10, 10, 9, 9, 8, 8, 7, 7, 6, 6}, {3, 3, 2, 2, 2, 2, 1, 1, 1, 1}, {20, 16, 12, 10, 8, 7, 6, 5, 4, 4}, {10, 6, 2, 0, 0, 0, 0, 0, 0, 0}};
    public static final int[][] angles = new int[][]{new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], {45, 45, 45, 45, 45, 45, 45, 45, 45, 45}, {27, 27, 27, 27, 27, 27, 27, 27, 27, 27}, {27, 27, 27, 27, 27, 27, 27, 27, 27, 27}, {0, 0, 0, 0, 0, 0, 0, 0, 27, 27}, {27, 27, 45, 45, 45, 45, 63, 63, 90, 90}, {0, 0, 0, 0, 0, 0, 0, 63, 90, 90}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], {315, 315, 315, 315, 315, 315, 315, 315, 315, 315}, {333, 333, 333, 333, 333, 333, 333, 333, 333, 333}, {333, 333, 333, 333, 333, 333, 333, 333, 333, 333}, {333, 333, 0, 0, 0, 0, 0, 0, 0, 0}, {270, 270, 297, 297, 315, 315, 315, 315, 333, 333}, {270, 270, 297, 0, 0, 0, 0, 0, 0, 0}};

    public NewSkoolSkaterCanvas() {
        this.P_LEFT = 1;
        this.P_RIGHT = 2;
        this.P_DEAD = 0;
        this.WONMELODY = 0;
        this.DEADMELODY = 1;
        this.BONUSMELODY = 2;
        this.BEEP_LOW = 3;
        this.BEEP_MED = 4;
        this.BEEP_HIGH = 5;
        this.screenWidth = this.getWidth();
        this.halfScreenWidth = this.screenWidth / 2;
        this.screenHeight = this.getHeight() - this.statusBarHeight;
        this.halfScreenHeight = this.screenHeight / 2;
        this.pHalfWidth = this.pWidth / 2;
        this.pHalfHeight = this.pHeight / 2;
        this.scores = new int[]{100, 200, 500, 1000, 2000, 5000};
        this.sounds = new Sound[this.soundBytes.length];
        for (int i = 0; i < this.sounds.length; ++i) {
            this.sounds[i] = new Sound(this.soundBytes[i], 1);
            this.sounds[i].init(this.soundBytes[i], 1);
        }
        System.gc();
        try {
            this.playerImages = Image.createImage((String)"/PlayerImages.png");
            this.jumpingMonsterImages = Image.createImage((String)"/JumpingMonsterImages.png");
            this.flyingMonsterImages = Image.createImage((String)"/FlyingMonsterImages.png");
            this.lineMonsterImages = Image.createImage((String)"/LineMonsterImages.png");
            this.invincibilityImages = Image.createImage((String)"/InvincibilityImages.png");
            this.shotImage = Image.createImage((String)"/ShotImage.png");
            this.scoreImages = Image.createImage((String)"/Scores.png");
            Image image = Image.createImage((String)"/Status.png");
            this.livesImage = this.getImage(image, 7, 7, -33, 0);
            this.coinsImage = this.getImage(image, 7, 7, -40, 0);
            this.clockImage = this.getImage(image, 7, 7, -47, 0);
            this.optionsImage = this.getImage(image, image.getWidth() - 54, 7, -54, 0);
            this.digits = new Image[11];
            for (int i = 0; i < this.digits.length; ++i) {
                this.digits[i] = this.getImage(image, 3, 5, -3 * i, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.statusBarImage = Image.createImage((int)this.screenWidth, (int)this.statusBarHeight);
        this.statusBarSurface = this.statusBarImage.getGraphics();
        this.timerImage = Image.createImage((int)27, (int)7);
        this.timerGraphics = this.timerImage.getGraphics();
        this.pMaxDX = 3072;
        this.pMaxDY = 3072;
        System.gc();
    }

    public Image getImage(Image image, int n, int n2, int n3, int n4) {
        Image image2 = Image.createImage((int)n, (int)n2);
        image2.getGraphics().drawImage(image, n3, n4, 20);
        return image2;
    }

    public void startGame(int n, Gauge gauge) {
        this.currentLevel = 0;
        try {
            this.loadLevel(gauge);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        gauge.setValue(100);
        this.score = 0;
        this.pLives = 5;
        this.pTotalCoins = 0;
        this.totalTime = 0;
        this.commandListener.commandAction(BSCanvas.DISPLAY_CANVAS, (Displayable)this);
    }

    public void loadLevel(Gauge gauge) throws IOException {
        int n;
        int n2;
        Object object;
        System.gc();
        if (this.tiles == null) {
            object = Image.createImage((String)"/Tiles.png");
            this.tiles = new Image[100];
            for (int i = 1; i < 100; ++i) {
                this.tiles[i] = this.getImage((Image)object, 10, 10, -(i - i / 10 * 10) * 10, -(i / 10) * 10);
            }
        }
        System.gc();
        object = this.getClass().getResourceAsStream(String.valueOf(String.valueOf(new StringBuffer("/Levels/level").append(this.currentLevel).append(".txt"))));
        DataInputStream dataInputStream = new DataInputStream((InputStream)object);
        gauge.setValue(20);
        int n3 = dataInputStream.readInt();
        int n4 = dataInputStream.readInt();
        this.backBufferWidth = n3 * 10;
        this.backBufferHeight = n4 * 10;
        this.pXPos = dataInputStream.readInt() * 10;
        this.pYPos = dataInputStream.readInt() * 10 + 10;
        this.pOrigXPos = this.pXPos;
        this.pOrigYPos = this.pYPos;
        this.level = new byte[n4][n3];
        gauge.setValue(30);
        this.totalCoins = 0;
        for (n2 = 0; n2 < this.level[0].length; ++n2) {
            for (n = 0; n < this.level.length; ++n) {
                this.level[n][n2] = dataInputStream.readByte();
                if (this.level[n][n2] == 0 || this.level[n][n2] != 99) continue;
                ++this.totalCoins;
            }
        }
        this.monsters = new Monster[dataInputStream.readByte()];
        block8: for (n2 = 0; n2 < this.monsters.length; ++n2) {
            n = dataInputStream.readByte();
            switch (n) {
                case 1: {
                    this.monsters[n2] = new JumpingMonster(this.jumpingMonsterImages, this.level, dataInputStream.readByte(), dataInputStream.readByte(), dataInputStream.readByte(), dataInputStream.readByte(), dataInputStream.readByte(), this.backBufferHeight);
                    continue block8;
                }
                case 2: {
                    this.monsters[n2] = new FlyingMonster(this.flyingMonsterImages, dataInputStream.readByte(), dataInputStream.readByte(), dataInputStream.readByte(), dataInputStream.readByte(), dataInputStream.readByte(), this.backBufferHeight);
                    continue block8;
                }
                case 3: {
                    int[][] nArray = new int[dataInputStream.readByte()][2];
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray[i][0] = dataInputStream.readByte() * 10;
                        nArray[i][1] = dataInputStream.readByte() * 10;
                    }
                    this.monsters[n2] = new LineMonster(this.lineMonsterImages, nArray, nArray[0][0], nArray[0][1], 0, 0, dataInputStream.readByte(), this.backBufferHeight);
                }
            }
        }
        this.shots = new int[3][];
        gauge.setValue(70);
        dataInputStream.close();
        this.xOffSet = 0;
        this.yOffSet = 0;
        this.falling = false;
        this.jumping = false;
        this.dead = false;
        this.gameover = false;
        this.levelClear = false;
        this.won = false;
        this.finishedGame = false;
        this.start = true;
        this.keyPressed = false;
        this.updateStatus = true;
        this.onRightRamp = false;
        this.onLeftRamp = false;
        this.pDX = 0;
        this.pDY = 0;
        this.pAngle = 0;
        this.pAngleOffSet = 4;
        this.pCurrentMove = 2;
        this.xOffSetAdjust = -33;
        this.pCoins = 0;
        this.invincibilityCounter = 0;
        this.invincible = false;
        this.invincibilityScoreAdjust = 0;
        this.scoreAnims = new Vector(5);
        this.startTime = 0L;
        this.pausedTime = 0L;
        this.timer = 0;
        this.lastTime = 0;
        this.resetCollisionPoints();
        this.xOffSetCounter = 0;
        this.yOffSetCounter = 0;
    }

    public void nextLevel(Gauge gauge) {
        ++this.currentLevel;
        try {
            this.loadLevel(gauge);
        }
        catch (Exception exception) {
            // empty catch block
        }
        gauge.setValue(100);
        this.commandListener.commandAction(BSCanvas.DISPLAY_CANVAS, (Displayable)this);
    }

    public void loadGame(byte[] byArray, Gauge gauge) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this.currentLevel = dataInputStream.readByte();
            this.pLives = dataInputStream.readByte();
            this.score = dataInputStream.readInt();
            this.totalTime = dataInputStream.readInt();
            this.loadLevel(gauge);
            gauge.setValue(100);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] saveGame(Gauge gauge) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(this.currentLevel);
            dataOutputStream.writeByte(this.pLives);
            dataOutputStream.writeInt(this.score);
            dataOutputStream.writeInt(this.totalTime);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception exception) {
            byte[] byArray = null;
            return byArray;
        }
    }

    public int getTotalTime() {
        return this.totalTime;
    }

    public void paint(Graphics graphics) {
        this.unifiedMethod(graphics);
    }

    public void start() {
        if (this.instance == null || !this.running && !this.paused && !this.instance.isAlive()) {
            this.instance = new Thread(this);
            this.running = true;
            this.instance.start();
        } else if (this.instance.isAlive()) {
            this.running = true;
        }
    }

    public void pause() {
        if (this.pausedTime == (long)0) {
            this.pausedTime = new Date().getTime();
        }
        this.running = false;
        if (!this.dead && !this.won) {
            this.keyPressed = false;
        }
    }

    public void hideNotify() {
        this.pause();
    }

    public void showNotify() {
        this.start();
    }

    public void collect(int n, int n2, int n3) {
        if (n3 == 90) {
            this.level[n2][n] = 0;
            if (this.pLives < 99) {
                ++this.pLives;
            }
            this.score += this.scores[5];
            this.scoreAnims.addElement(new int[]{5, n * 10 + 8, n2 * 10, 0});
            BSCanvas.playSound(this.sounds[2]);
            this.updateStatus = true;
        } else if (n3 == 91) {
            this.level[n2][n] = 0;
            this.pOrigXPos = n * 10;
            this.pOrigYPos = n2 * 10 + 9;
        } else if (n3 == 92) {
            this.level[n2][n] = 0;
            BSCanvas.playSound(this.sounds[2]);
            this.invincible = true;
            this.invincibilityCounter = 0;
            this.invincibilityScoreAdjust = 0;
        } else if (!this.won && n3 >= 93 && n3 <= 95) {
            this.won = true;
            this.totalTime += this.timer;
            this.pDXLeft = 0;
            this.pDYLeft = 0;
            this.pause();
        } else if (n3 == 99) {
            this.level[n2][n] = 0;
            ++this.pCoins;
            ++this.pTotalCoins;
            this.score += 5;
            this.updateStatus = true;
            if (this.pTotalCoins == 100) {
                this.pTotalCoins = 0;
                if (this.pLives != 99) {
                    ++this.pLives;
                }
                this.score += this.scores[5];
                this.scoreAnims.addElement(new int[]{5, n * 10 + 8, n2 * 10, 0});
                BSCanvas.playSound(this.sounds[2]);
            }
        }
    }

    public void dead() {
        this.pDY = -1280;
        --this.pLives;
        this.dead = true;
        this.jumping = true;
        this.falling = false;
        this.updateStatus = true;
        this.left = false;
        this.right = false;
        this.down = false;
        this.pCurrentMove = 0;
        this.pAngleOffSet = 4;
        this.repaint();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        BSCanvas.playSound(this.sounds[1]);
        BSCanvas.vibrate(50, 500);
    }

    public void setUpCollisionLoop() {
        this.pDXLeft = this.pDX >> 8;
        this.pDYLeft = this.pDY >> 8;
        this.pDXT = 0;
        this.pDYT = 0;
        if (this.pDX > 0) {
            this.pDXT = 1;
        } else if (this.pDX < 0) {
            this.pDXT = -1;
        }
        if (this.pDY > 0) {
            this.pDYT = 1;
        } else if (this.pDY < 0) {
            this.pDYT = -1;
        }
    }

    public void resetCollisionPoints() {
        this.pUpTileX1 = (this.pXPos + 2) / 10;
        this.pUpTileX2 = (this.pXPos + this.pWidth - 2) / 10;
        this.pUpTileY = (this.pYPos - this.pHeight) / 10;
        this.pDownTileX1 = (this.pXPos + 1) / 10;
        this.pDownTileX2 = (this.pXPos + this.pWidth - 1) / 10;
        this.pDownTileY = this.pYPos / 10;
        this.pLeftTileX = this.pXPos / 10;
        this.pLeftTileY1 = (this.pYPos - this.pHeight + 2) / 10;
        this.pLeftTileY2 = (this.pYPos - 1) / 10;
        this.pRightTileX = (this.pXPos + this.pWidth) / 10;
        this.pRightTileY1 = (this.pYPos - this.pHeight + 2) / 10;
        this.pRightTileY2 = (this.pYPos - 1) / 10;
    }

    public void setAngle(int n) {
        this.pAngle = n;
        this.pAngleOffSet = this.pDX > 0 ? (this.pAngle >= 270 && this.pAngle < 288 ? 0 : (this.pAngle >= 288 && this.pAngle < 306 ? 1 : (this.pAngle >= 306 && this.pAngle < 324 ? 2 : (this.pAngle >= 324 && this.pAngle < 342 ? 3 : (this.pAngle >= 342 ? 4 : (this.pAngle < 18 ? 4 : (this.pAngle >= 18 && this.pAngle < 36 ? 5 : (this.pAngle >= 36 && this.pAngle < 54 ? 6 : (this.pAngle >= 54 && this.pAngle < 72 ? 7 : 8))))))))) : (this.pDX < 0 ? (this.pAngle >= 270 && this.pAngle < 288 ? 8 : (this.pAngle >= 288 && this.pAngle < 306 ? 7 : (this.pAngle >= 306 && this.pAngle < 324 ? 6 : (this.pAngle >= 324 && this.pAngle < 342 ? 5 : (this.pAngle >= 342 ? 4 : (this.pAngle < 18 ? 4 : (this.pAngle >= 18 && this.pAngle < 36 ? 3 : (this.pAngle >= 36 && this.pAngle < 54 ? 2 : (this.pAngle >= 54 && this.pAngle < 72 ? 1 : 0))))))))) : 4);
    }

    public synchronized void unifiedMethod(Graphics graphics) {
        if (graphics == null) {
            try {
                this.setUpCollisionLoop();
                while (!(this.dead || this.pDXLeft == 0 && this.pDYLeft == 0)) {
                    int n;
                    int n2;
                    if (this.pDXLeft != 0) {
                        this.pXPos += this.pDXT;
                        this.pDXLeft -= this.pDXT;
                    }
                    if (this.pDYLeft != 0) {
                        this.pYPos += this.pDYT;
                        this.pDYLeft -= this.pDYT;
                    }
                    if (this.pXPos >= 0) {
                        this.pLeftTileX = this.pXPos / 10;
                        if (this.pYPos >= this.pHeight) {
                            this.pLeftTileY1 = (this.pYPos - this.pHeight + 2) / 10;
                            this.pLeftTileY2 = (this.pYPos - 1) / 10;
                            if (this.level[this.pLeftTileY1][this.pLeftTileX] > 34 || this.level[this.pLeftTileY2][this.pLeftTileX] > 34) {
                                if (this.level[this.pLeftTileY2][this.pLeftTileX] >= 50 && this.level[this.pLeftTileY2][this.pLeftTileX] < 65) {
                                    n2 = this.pXPos - this.pLeftTileX * 10;
                                    n = this.pLeftTileY2 * 10 + 11 - heightMaps[this.level[this.pLeftTileY2][this.pLeftTileX]][n2];
                                    if (this.pYPos > n || this.onLeftRamp) {
                                        this.pYPos = n;
                                        this.setAngle(angles[this.level[this.pLeftTileY2][this.pLeftTileX]][n2]);
                                        if (this.falling) {
                                            this.pDYLeft = 0;
                                            this.pDY = 0;
                                            this.falling = false;
                                        }
                                        this.onLeftRamp = true;
                                    }
                                } else if (this.level[this.pLeftTileY2][this.pLeftTileX] >= 35 && this.level[this.pLeftTileY2][this.pLeftTileX] < 50) {
                                    n2 = this.pXPos - this.pLeftTileX * 10;
                                    n = this.pLeftTileY2 * 10 + 11 - heightMaps[this.level[this.pLeftTileY2][this.pLeftTileX]][n2];
                                    if (this.pYPos >= n) {
                                        this.pDXLeft = 0;
                                        this.pXPos = this.pLeftTileX * 10 + 10;
                                        this.pDX = 0;
                                    }
                                } else if (this.level[this.pLeftTileY1][this.pLeftTileX] >= 90 && this.level[this.pLeftTileY1][this.pLeftTileX] <= 99) {
                                    this.collect(this.pLeftTileX, this.pLeftTileY1, this.level[this.pLeftTileY1][this.pLeftTileX]);
                                } else if (this.level[this.pLeftTileY2][this.pLeftTileX] >= 90 && this.level[this.pLeftTileY2][this.pLeftTileX] <= 99) {
                                    this.collect(this.pLeftTileX, this.pLeftTileY2, this.level[this.pLeftTileY2][this.pLeftTileX]);
                                } else if (!this.invincible && this.level[this.pLeftTileY1][this.pLeftTileX] >= 86 && this.level[this.pLeftTileY1][this.pLeftTileX] <= 87 && this.level[this.pLeftTileY2][this.pLeftTileX] >= 86 && this.level[this.pLeftTileY2][this.pLeftTileX] <= 87) {
                                    this.dead();
                                } else if (this.onLeftRamp) {
                                    if (this.pDX < 0) {
                                        this.pDY = -(this.pDX * this.getSin(this.pAngle)) >> 8;
                                        this.pDXLeft = 0;
                                        this.pXPos = this.pLeftTileX * 10 + 10;
                                        this.pDX = 0;
                                        this.jumping = true;
                                        this.falling = false;
                                        this.setUpCollisionLoop();
                                    }
                                    this.onLeftRamp = false;
                                } else if (this.level[this.pLeftTileY1][this.pLeftTileX] >= 30 || this.level[this.pLeftTileY1][this.pLeftTileX] < 30 && this.pYPos % 10 >= 2) {
                                    this.pDXLeft = 0;
                                    this.pXPos = this.pLeftTileX * 10 + 10;
                                    this.pDX = 0;
                                }
                            }
                        }
                    } else {
                        this.pLeftTileX = 0;
                        this.pDXLeft = 0;
                        this.pXPos = 0;
                        this.pDX = 0;
                    }
                    if (this.pXPos + this.pWidth < this.level[0].length * 10) {
                        this.pRightTileX = (this.pXPos + this.pWidth) / 10;
                        if (this.pYPos >= this.pHeight) {
                            this.pRightTileY1 = (this.pYPos - this.pHeight + 2) / 10;
                            this.pRightTileY2 = (this.pYPos - 1) / 10;
                            if (this.level[this.pRightTileY1][this.pRightTileX] > 34 || this.level[this.pRightTileY2][this.pRightTileX] > 34) {
                                if (this.level[this.pRightTileY2][this.pRightTileX] >= 35 && this.level[this.pRightTileY2][this.pRightTileX] < 50) {
                                    n2 = this.pXPos + this.pWidth - this.pRightTileX * 10;
                                    n = this.pRightTileY2 * 10 + 11 - heightMaps[this.level[this.pRightTileY2][this.pRightTileX]][n2];
                                    if (this.pYPos > n || this.onRightRamp) {
                                        this.pYPos = n;
                                        this.setAngle(angles[this.level[this.pRightTileY2][this.pRightTileX]][n2]);
                                        if (this.falling) {
                                            this.pDYLeft = 0;
                                            this.pDY = 0;
                                            this.falling = false;
                                        }
                                        this.onRightRamp = true;
                                    }
                                } else if (this.level[this.pRightTileY2][this.pRightTileX] >= 50 && this.level[this.pRightTileY2][this.pRightTileX] < 65) {
                                    n2 = this.pXPos + this.pWidth - this.pRightTileX * 10;
                                    n = this.pRightTileY2 * 10 + 11 - heightMaps[this.level[this.pRightTileY2][this.pRightTileX]][n2];
                                    if (this.pYPos > n) {
                                        this.pDXLeft = 0;
                                        this.pXPos = this.pRightTileX * 10 - this.pWidth;
                                        this.pDX = 0;
                                    }
                                } else if (this.level[this.pRightTileY1][this.pRightTileX] >= 90 && this.level[this.pRightTileY1][this.pRightTileX] <= 99) {
                                    this.collect(this.pRightTileX, this.pRightTileY1, this.level[this.pRightTileY1][this.pRightTileX]);
                                } else if (this.level[this.pRightTileY2][this.pRightTileX] >= 90 && this.level[this.pRightTileY2][this.pRightTileX] <= 99) {
                                    this.collect(this.pRightTileX, this.pRightTileY2, this.level[this.pRightTileY2][this.pRightTileX]);
                                } else if (!this.invincible && this.level[this.pRightTileY1][this.pRightTileX] >= 84 && this.level[this.pRightTileY1][this.pRightTileX] <= 85 && this.level[this.pRightTileY2][this.pRightTileX] >= 84 && this.level[this.pRightTileY2][this.pRightTileX] <= 85) {
                                    this.dead();
                                } else if (this.onRightRamp) {
                                    if (this.pDX > 0) {
                                        this.pDY = -(this.pDX * this.getSin(this.pAngle)) >> 8;
                                        this.pDXLeft = 0;
                                        this.pXPos = this.pRightTileX * 10 - this.pWidth;
                                        this.pDX = 0;
                                        this.jumping = true;
                                        this.falling = false;
                                        this.setUpCollisionLoop();
                                    }
                                    this.onRightRamp = false;
                                } else if (this.level[this.pRightTileY1][this.pRightTileX] >= 30 || this.level[this.pRightTileY1][this.pRightTileX] < 30 && this.pYPos % 10 >= 2) {
                                    this.pDXLeft = 0;
                                    this.pXPos = this.pRightTileX * 10 - this.pWidth;
                                    this.pDX = 0;
                                }
                            }
                        }
                    } else {
                        this.pDXLeft = 0;
                        this.pXPos = this.level[0].length * 10 - this.pWidth - 1;
                        this.pDX = 0;
                    }
                    if (this.pYPos >= this.pHeight) {
                        this.pUpTileX1 = (this.pXPos + 2) / 10;
                        this.pUpTileX2 = (this.pXPos + this.pWidth - 2) / 10;
                        this.pUpTileY = (this.pYPos - this.pHeight) / 10;
                        if (this.level[this.pUpTileY][this.pUpTileX1] > 64 || this.level[this.pUpTileY][this.pUpTileX2] > 64) {
                            if (this.level[this.pUpTileY][this.pUpTileX1] >= 90 && this.level[this.pUpTileY][this.pUpTileX1] <= 99) {
                                this.collect(this.pUpTileX1, this.pUpTileY, this.level[this.pUpTileY][this.pUpTileX1]);
                            } else if (this.level[this.pUpTileY][this.pUpTileX2] >= 90 && this.level[this.pUpTileY][this.pUpTileX2] <= 99) {
                                this.collect(this.pUpTileX2, this.pUpTileY, this.level[this.pUpTileY][this.pUpTileX2]);
                            } else if (!this.invincible && this.level[this.pUpTileY][this.pUpTileX1] >= 82 && this.level[this.pUpTileY][this.pUpTileX1] <= 83 && this.level[this.pUpTileY][this.pUpTileX2] >= 82 && this.level[this.pUpTileY][this.pUpTileX2] <= 83) {
                                this.dead();
                            } else if (this.jumping) {
                                this.pDYLeft = 0;
                                this.pYPos = (this.pUpTileY + 1) * 10 + this.pHeight;
                                if (this.pDY < 0) {
                                    this.pDY = 0;
                                }
                                this.setAngle(0);
                                this.falling = true;
                                this.jumping = false;
                            }
                        }
                    }
                    if (this.pYPos >= 0) {
                        this.pDownTileX1 = (this.pXPos + 1) / 10;
                        this.pDownTileX2 = (this.pXPos + this.pWidth - 1) / 10;
                        this.pDownTileY = this.pYPos / 10;
                        if (this.level[this.pDownTileY][this.pDownTileX1] > 29 || this.level[this.pDownTileY][this.pDownTileX2] > 29) {
                            if (this.level[this.pDownTileY][this.pDownTileX2] >= 35 && this.level[this.pDownTileY][this.pDownTileX2] < 50) {
                                n2 = this.pXPos + this.pWidth - this.pDownTileX2 * 10;
                                if (n2 > 9) {
                                    n2 = 9;
                                }
                                n = this.pDownTileY * 10 + 10 - heightMaps[this.level[this.pDownTileY][this.pDownTileX2]][n2];
                                if (!this.jumping && (this.pYPos >= n || this.onRightRamp)) {
                                    this.pYPos = n;
                                    this.setAngle(angles[this.level[this.pDownTileY][this.pDownTileX2]][n2]);
                                    if (this.falling) {
                                        this.pDX -= this.pDY * this.getSin(this.pAngle) >> 8;
                                        this.pDXLeft = this.pDX >> 8;
                                        if (this.pDX > 0) {
                                            this.pDXT = 1;
                                        } else if (this.pDX < 0) {
                                            this.pDXT = -1;
                                        }
                                        this.pDYLeft = 0;
                                        this.pDY = 0;
                                        this.falling = false;
                                    }
                                    this.onRightRamp = true;
                                } else if (!this.jumping) {
                                    this.falling = true;
                                }
                            } else if (this.level[this.pDownTileY][this.pDownTileX1] >= 50 && this.level[this.pDownTileY][this.pDownTileX1] < 65) {
                                n2 = this.pXPos - this.pDownTileX1 * 10;
                                if (n2 < 0) {
                                    n2 = 0;
                                }
                                n = this.pDownTileY * 10 + 10 - heightMaps[this.level[this.pDownTileY][this.pDownTileX1]][n2];
                                if (!this.jumping && (this.pYPos >= n || this.onLeftRamp)) {
                                    this.pYPos = n;
                                    this.setAngle(angles[this.level[this.pDownTileY][this.pDownTileX1]][n2]);
                                    if (this.falling) {
                                        this.pDX -= this.pDY * this.getSin(this.pAngle) >> 8;
                                        this.pDXLeft = this.pDX >> 8;
                                        if (this.pDX > 0) {
                                            this.pDXT = 1;
                                        } else if (this.pDX < 0) {
                                            this.pDXT = -1;
                                        }
                                        this.pDYLeft = 0;
                                        this.pDY = 0;
                                        this.falling = false;
                                    }
                                    this.onLeftRamp = true;
                                } else if (!this.jumping) {
                                    this.falling = true;
                                }
                            } else if (!this.onLeftRamp && !this.onRightRamp) {
                                if (this.level[this.pDownTileY][this.pDownTileX1] >= 90 && this.level[this.pDownTileY][this.pDownTileX1] <= 99) {
                                    this.collect(this.pDownTileX1, this.pDownTileY, this.level[this.pDownTileY][this.pDownTileX1]);
                                } else if (this.level[this.pDownTileY][this.pDownTileX2] >= 90 && this.level[this.pDownTileY][this.pDownTileX2] <= 99) {
                                    this.collect(this.pDownTileX2, this.pDownTileY, this.level[this.pDownTileY][this.pDownTileX2]);
                                } else if (!this.invincible && this.level[this.pDownTileY][this.pDownTileX1] >= 80 && this.level[this.pDownTileY][this.pDownTileX1] <= 81 && this.level[this.pDownTileY][this.pDownTileX2] >= 80 && this.level[this.pDownTileY][this.pDownTileX2] <= 81) {
                                    this.dead();
                                } else if (this.falling && this.pYPos % 10 <= 2) {
                                    this.pDYLeft = 0;
                                    this.pYPos = this.pDownTileY * 10;
                                    this.pDY = 0;
                                    this.setAngle(0);
                                    this.falling = false;
                                }
                            }
                        }
                    }
                    if (!(!this.onRightRamp || this.level[this.pRightTileY2][this.pRightTileX] >= 35 && this.level[this.pRightTileY2][this.pRightTileX] <= 49 || this.level[this.pDownTileY][this.pDownTileX2] >= 35 && this.level[this.pDownTileY][this.pDownTileX2] <= 49)) {
                        if (this.pDX > 0) {
                            if (this.pAngle == 90) {
                                this.pXPos -= 2;
                            }
                            this.pDY = -(this.pDX * this.getSin(this.pAngle)) >> 8;
                            this.pDX = this.pDX * this.getCos(this.pAngle) >> 8;
                            this.jumping = true;
                            this.falling = false;
                            this.setUpCollisionLoop();
                        } else {
                            this.setAngle(0);
                        }
                        this.onRightRamp = false;
                    }
                    if (!this.onLeftRamp || this.level[this.pLeftTileY2][this.pLeftTileX] >= 50 && this.level[this.pLeftTileY2][this.pLeftTileX] <= 64 || this.level[this.pDownTileY][this.pDownTileX1] >= 50 && this.level[this.pDownTileY][this.pDownTileX1] <= 64) continue;
                    if (this.pDX < 0) {
                        if (this.pAngle == 270) {
                            this.pXPos += 2;
                        }
                        this.pDY = -(this.pDX * this.getSin(this.pAngle)) >> 8;
                        this.pDX = this.pDX * this.getCos(this.pAngle) >> 8;
                        this.jumping = true;
                        this.falling = false;
                        this.setUpCollisionLoop();
                    } else {
                        this.setAngle(0);
                    }
                    this.onLeftRamp = false;
                }
                if (this.pYPos >= 0 && !this.jumping && this.level[this.pRightTileY2][this.pRightTileX] < 35 && this.level[this.pDownTileY][this.pDownTileX1] < 30 && this.level[this.pDownTileY][this.pDownTileX2] < 30 && this.level[this.pLeftTileY2][this.pLeftTileX] < 35) {
                    this.falling = true;
                }
            }
            catch (Exception exception) {}
        } else if (!this.finishedGame) {
            int n;
            int n3;
            int n4;
            int n5;
            int n6;
            if (this.updateStatus) {
                this.statusBarSurface.setColor(0xFFFFFF);
                this.statusBarSurface.fillRect(0, 0, this.screenWidth, this.statusBarHeight);
                this.statusBarSurface.drawImage(this.optionsImage, this.screenWidth - this.optionsImage.getWidth(), 0, 20);
                n6 = 0;
                n5 = 100000;
                for (n4 = 6; n4 > 0; --n4) {
                    this.statusBarSurface.drawImage(this.digits[this.score / n5 % 10], n6, 1, 20);
                    n5 /= 10;
                    n6 += this.digits[0].getWidth() + 1;
                }
                this.statusBarSurface.drawImage(this.livesImage, n6 += 5, 0, 20);
                this.statusBarSurface.drawImage(this.digits[this.pLives / 10 % 10], n6 += this.livesImage.getWidth() + 1, 1, 20);
                this.statusBarSurface.drawImage(this.digits[this.pLives % 10], n6 += this.digits[0].getWidth() + 1, 1, 20);
                this.statusBarSurface.drawImage(this.coinsImage, n6 += this.digits[0].getWidth() + 5, 0, 20);
                this.statusBarSurface.drawImage(this.digits[this.pTotalCoins / 10 % 10], n6 += this.coinsImage.getWidth() + 1, 1, 20);
                this.statusBarSurface.drawImage(this.digits[this.pTotalCoins % 10], n6 += this.digits[0].getWidth() + 1, 1, 20);
                this.timerGraphics.setColor(0xFFFFFF);
                this.timerGraphics.fillRect(0, 0, 27, 7);
                n4 = this.timer / 60;
                n3 = this.timer - n4 * 60;
                n6 = 0;
                this.timerGraphics.drawImage(this.clockImage, n6, 0, 20);
                this.timerGraphics.drawImage(this.digits[n4 / 10 % 10], n6 += this.clockImage.getWidth() + 1, 1, 20);
                this.timerGraphics.drawImage(this.digits[n4 % 10], n6 += this.digits[0].getWidth() + 1, 1, 20);
                this.timerGraphics.drawImage(this.digits[10], n6 += this.digits[0].getWidth(), 1, 20);
                this.timerGraphics.drawImage(this.digits[n3 / 10 % 10], n6 += this.digits[0].getWidth(), 1, 20);
                this.timerGraphics.drawImage(this.digits[n3 % 10], n6 += this.digits[0].getWidth() + 1, 1, 20);
                this.updateStatus = false;
            }
            if (this.pXPos + this.pHalfWidth > this.halfScreenWidth + this.xOffSetAdjust - this.xOffSetCounter && this.backBufferWidth + this.xOffSet > this.screenWidth || this.pXPos + this.pHalfWidth < this.halfScreenWidth + this.xOffSetAdjust - this.xOffSetCounter - this.xOffSet && this.xOffSet < 0) {
                this.xOffSet = this.halfScreenWidth + this.xOffSetAdjust - this.xOffSetCounter - (this.pXPos + this.pHalfWidth);
                if (this.backBufferWidth + this.xOffSet < this.screenWidth) {
                    this.xOffSet = -(this.backBufferWidth - this.screenWidth);
                } else if (this.xOffSet > 0) {
                    this.xOffSet = 0;
                }
            }
            if (this.xOffSetCounter > 0) {
                this.xOffSetCounter -= this.xOffSetCounter / 5 + 1;
            } else if (this.xOffSetCounter < 0) {
                this.xOffSetCounter += -this.xOffSetCounter / 5 + 1;
            }
            if (this.down) {
                if (this.yOffSetCounter < 30) {
                    this.yOffSetCounter += 10;
                }
            } else if (this.pDY > 0 || this.pCurrentMove == 1 && this.pAngle > 0 && this.pAngle <= 90 || this.pCurrentMove == 2 && this.pAngle > 270) {
                if (this.yOffSetCounter < 30) {
                    this.yOffSetCounter += this.yOffSetCounter / 5 + 1;
                }
            } else if (this.yOffSetCounter != 0) {
                this.yOffSetCounter -= this.yOffSetCounter / 5 + 1;
            }
            if (this.pYPos - this.pHalfHeight > this.halfScreenHeight + 15 - this.yOffSetCounter && this.backBufferHeight + this.yOffSet > this.screenHeight || this.pYPos - this.pHalfHeight < this.halfScreenHeight + 15 - this.yOffSetCounter - this.yOffSet && this.yOffSet < 0) {
                this.yOffSet = this.halfScreenHeight + 15 - this.yOffSetCounter - (this.pYPos - this.pHalfHeight);
                if (this.backBufferHeight + this.yOffSet < this.screenHeight) {
                    this.yOffSet = -(this.backBufferHeight - this.screenHeight);
                } else if (this.yOffSet > 0) {
                    this.yOffSet = 0;
                }
            }
            graphics.setClip(0, 0, this.screenWidth, this.screenHeight);
            graphics.setColor(0xCCEEFF);
            graphics.fillRect(0, 0, this.screenWidth, this.screenHeight);
            n6 = this.screenWidth / 10 + 1;
            n5 = this.screenHeight / 10 + 1;
            n4 = -this.xOffSet / 10;
            n3 = -this.yOffSet / 10;
            for (n = n4; n <= n4 + n6; ++n) {
                for (int i = n3; i <= n3 + n5; ++i) {
                    if (n < 0 || i < 0 || i >= this.level.length || n >= this.level[i].length || this.level[i][n] <= 0 || this.tiles == null) continue;
                    graphics.drawImage(this.tiles[this.level[i][n]], this.xOffSet + n * 10, this.yOffSet + i * 10, 20);
                }
            }
            graphics.setClip(this.xOffSet + this.pXPos, this.yOffSet + this.pYPos - this.pHeight, this.pWidth, this.pHeight + 5);
            graphics.drawImage(this.playerImages, this.xOffSet + this.pXPos - this.pWidth * this.pAngleOffSet, this.yOffSet + this.pYPos + (this.pHeight + 5) * this.pCurrentMove + 5, 36);
            if (this.invincible) {
                graphics.setClip(this.xOffSet + this.pXPos - 2, this.yOffSet + this.pYPos - this.pHeight - 2, 14, 14);
                graphics.drawImage(this.invincibilityImages, this.xOffSet + this.pXPos - 2 - this.invincibilityFrame * 14, this.yOffSet + this.pYPos - this.pHeight - 2, 20);
            }
            for (n = 0; n < this.monsters.length; ++n) {
                if (this.monsters[n] == null) continue;
                this.monsters[n].paint(graphics, this.xOffSet, this.yOffSet);
            }
            graphics.setClip(0, 0, this.screenWidth, this.screenHeight);
            for (n = 0; n < this.scoreAnims.size(); ++n) {
                int[] nArray = (int[])this.scoreAnims.elementAt(n);
                graphics.setClip(this.xOffSet + nArray[1] - 11, this.yOffSet + nArray[2] - nArray[3], 22, 7);
                graphics.drawImage(this.scoreImages, this.xOffSet + nArray[1] - 11, this.yOffSet + nArray[2] - nArray[3] - nArray[0] * 7, 20);
                nArray[3] = nArray[3] + 2;
                if (nArray[3] != 40) continue;
                this.scoreAnims.removeElementAt(n);
                --n;
            }
            graphics.setClip(0, 0, this.screenWidth, this.screenHeight + this.statusBarHeight);
            for (n = 0; n < this.shots.length; ++n) {
                if (this.shots[n] == null) continue;
                graphics.drawImage(this.shotImage, this.xOffSet + (this.shots[n][0] >> 8), this.yOffSet + (this.shots[n][2] >> 8), 3);
            }
            graphics.drawImage(this.timerImage, 0, 0, 20);
            graphics.drawImage(this.statusBarImage, 0, this.screenHeight, 20);
            if (this.levelClear) {
                this.drawText(graphics, this.parseString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.langT[1]))).append(",").append(this.langT[2]).append(this.score).append(",").append(this.langT[3]).append(this.getTimeString(this.totalTime))))), new Font[]{this.getFont(this.langA[1]), this.getFont(this.langA[2]), this.getFont(this.langA[3])}, true, this.halfScreenWidth, 10);
            } else if (this.gameover) {
                this.drawText(graphics, this.parseString(this.langT[4]), this.getFont(this.langA[4]), true, this.halfScreenWidth, this.halfScreenHeight);
            }
            if (this.start) {
                this.drawText(graphics, this.parseString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.langT[5]))).append(this.currentLevel + 1)))), this.getFont(this.langA[5]), true, this.halfScreenWidth, this.halfScreenHeight);
            }
            if (this.paused) {
                this.drawText(graphics, this.parseString(this.langT[6]), this.getFont(this.langA[6]), true, this.halfScreenWidth, this.halfScreenHeight);
            }
        } else if (this.endGameImage != null) {
            graphics.drawImage(this.endGameImage, 0, 0, 20);
        }
    }

    public void run() {
        while (this.running) {
            try {
                if (this.start) {
                    this.repaint();
                    Thread.sleep(2000L);
                    this.start = false;
                    this.repaint();
                }
                if (this.invincible) {
                    ++this.invincibilityCounter;
                    if (this.invincibilityCounter % (this.invincibilityCounter / 20 + 1) == 0) {
                        ++this.invincibilityFrame;
                        if (this.invincibilityFrame == 2) {
                            this.invincibilityFrame = 0;
                        }
                    }
                    if (this.invincibilityCounter >= 150) {
                        this.invincibilityCounter = 0;
                        this.invincible = false;
                        this.invincibilityScoreAdjust = 0;
                    }
                }
                if (this.levelClear || this.gameover || !this.keyPressed) continue;
                if (this.startTime == (long)0) {
                    this.startTime = new Date().getTime();
                }
                if (this.pausedTime > (long)0) {
                    this.startTime += new Date().getTime() - this.pausedTime;
                    this.pausedTime = 0L;
                }
                this.lastTime = this.timer;
                this.timer = (int)((new Date().getTime() - this.startTime) / (long)1000);
                if (this.timer > this.lastTime) {
                    this.updateStatus = true;
                }
                if (this.up) {
                    this.jump();
                    this.up = false;
                }
                if (this.left) {
                    ++this.pAccelerate;
                    if (!this.jumping && !this.falling && this.pAccelerate == 1 || this.pAccelerate == 3) {
                        this.pAccelerate = 0;
                        if (this.pDX > -this.pMaxDX) {
                            this.pDX -= 256;
                        }
                    }
                }
                if (this.right) {
                    ++this.pAccelerate;
                    if (!this.jumping && !this.falling && this.pAccelerate == 1 || this.pAccelerate == 3) {
                        this.pAccelerate = 0;
                        if (this.pDX < this.pMaxDX) {
                            this.pDX += 256;
                        }
                    }
                }
                if (this.down && !this.jumping && !this.falling) {
                    this.pDX = this.pDX >= 512 ? (this.pDX -= 512) : (this.pDX <= -512 ? (this.pDX += 512) : 0);
                }
                if (this.fire) {
                    this.fire();
                    this.fire = false;
                }
                if (!(this.down || this.left || this.right || this.pDX == 0)) {
                    ++this.pSlowDown;
                    if (this.pSlowDown == 5) {
                        this.pSlowDown = 0;
                        this.pDX = this.pDX <= -256 ? (this.pDX += 256) : (this.pDX >= 256 ? (this.pDX -= 256) : 0);
                    }
                }
                if (this.onLeftRamp || this.onRightRamp) {
                    this.pDX -= this.getSin(this.pAngle);
                }
                this.pOldYPos = this.pYPos;
                if (!this.dead) {
                    int n;
                    this.unifiedMethod(null);
                    for (n = 0; n < this.shots.length; ++n) {
                        if (this.shots[n] == null) continue;
                        this.shots[n][1] = this.shots[n][0];
                        this.shots[n][3] = this.shots[n][2];
                        int[] nArray = this.shots[n];
                        nArray[0] = nArray[0] + this.shots[n][4];
                        int[] nArray2 = this.shots[n];
                        nArray2[2] = nArray2[2] + this.shots[n][5];
                        if (this.shots[n][0] >> 8 <= this.pXPos + this.screenWidth && this.shots[n][0] >> 8 >= this.pXPos - this.screenWidth && this.shots[n][2] >> 8 <= this.pYPos + this.screenHeight && this.shots[n][2] >> 8 >= this.pYPos - this.screenHeight) continue;
                        this.shots[n] = null;
                    }
                    for (n = 0; n < this.monsters.length; ++n) {
                        if (this.monsters[n] == null) continue;
                        this.monsters[n].checkActive(this.xOffSet, this.yOffSet, this.screenWidth, this.screenHeight);
                        this.monsters[n].move();
                        if (this.monsters[n].active) {
                            for (int i = 0; i < this.shots.length; ++i) {
                                if (this.shots[i] == null || !this.monsters[n].shotCollide(this.shots[i][0] >> 8, this.shots[i][1] >> 8, this.shots[i][2] >> 8, this.shots[i][3] >> 8)) continue;
                                BSCanvas.playSound(this.sounds[5]);
                                this.shots[i] = null;
                                this.score += 100;
                                this.updateStatus = true;
                                this.scoreAnims.addElement(new int[]{0, this.monsters[n].xPos + this.monsters[n].width / 2, this.monsters[n].yPos - 10, 0});
                            }
                            if (this.monsters[n].collide(this.pXPos + this.pHalfWidth, this.pYPos - this.pHalfHeight)) {
                                if (this.invincible) {
                                    BSCanvas.playSound(this.sounds[5]);
                                    BSCanvas.vibrate(50, 100);
                                    this.monsters[n].dying();
                                    this.score += this.scores[this.invincibilityScoreAdjust];
                                    if (this.invincibilityScoreAdjust == 5) {
                                        if (this.pLives < 99) {
                                            ++this.pLives;
                                        }
                                        BSCanvas.playSound(this.sounds[2]);
                                    }
                                    this.updateStatus = true;
                                    this.scoreAnims.addElement(new int[]{this.invincibilityScoreAdjust, this.monsters[n].xPos + this.monsters[n].width / 2, this.monsters[n].yPos - 10, 0});
                                    if (this.invincibilityScoreAdjust < 5) {
                                        ++this.invincibilityScoreAdjust;
                                    }
                                } else {
                                    this.dead();
                                }
                            }
                        }
                        if (!this.monsters[n].dead) continue;
                        this.monsters[n] = null;
                    }
                } else {
                    if (this.pYPos > this.backBufferHeight) {
                        Thread.sleep(1000L);
                        if (this.pLives == 0) {
                            this.gameover = true;
                            this.repaint();
                            Thread.sleep(3000L);
                            this.tiles = null;
                            System.gc();
                            this.commandListener.commandAction(BSCanvas.GAME_ENDED, (Displayable)this);
                        }
                        if (!this.gameover) {
                            this.pXPos = this.pOrigXPos;
                            this.pYPos = this.pOrigYPos;
                            this.pDX = 0;
                            this.pDY = 0;
                            this.pCurrentMove = 2;
                            this.xOffSetAdjust = -40;
                            this.pAngle = 0;
                            this.pAngleOffSet = 4;
                            this.xOffSetCounter = 0;
                            this.yOffSetCounter = 0;
                            this.falling = false;
                            this.jumping = false;
                            this.dead = false;
                            this.resetCollisionPoints();
                            for (int i = 0; i < this.monsters.length; ++i) {
                                if (this.monsters[i] == null) continue;
                                this.monsters[i].reset();
                            }
                            this.repaint();
                            Thread.sleep(1000L);
                        }
                    }
                    this.pYPos += this.pDY >> 8;
                }
                if ((this.jumping || this.falling) && this.pDY < this.pMaxDY) {
                    this.pDY += 256;
                    if (this.jumping && this.pDY >= 0) {
                        this.falling = true;
                        this.jumping = false;
                        this.setAngle(0);
                    }
                }
                if (this.pCurrentMove == 1 && this.pDX > 255) {
                    this.pCurrentMove = 2;
                    this.xOffSetCounter = -66 + this.xOffSetCounter;
                    this.xOffSetAdjust = -33;
                }
                if (this.pCurrentMove == 2 && this.pDX < 0) {
                    this.pCurrentMove = 1;
                    this.xOffSetCounter = 66 + this.xOffSetCounter;
                    this.xOffSetAdjust = 33;
                }
                this.repaint();
                Thread.sleep(66L);
            }
            catch (Exception exception) {}
        }
        if (this.won) {
            BSCanvas.playSound(this.sounds[0]);
            this.repaint();
            try {
                Thread.sleep(1000L);
                this.levelClear = true;
                this.repaint();
                Thread.sleep(3000L);
                this.tiles = null;
                System.gc();
                if (this.currentLevel == 4) {
                    this.endGameImage = Image.createImage((String)"/EndScreen.png");
                    this.finishedGame = true;
                    this.repaint();
                    Thread.sleep(5000L);
                    this.endGameImage = null;
                    System.gc();
                    this.commandListener.commandAction(GAME_FINISHED, (Displayable)this);
                } else {
                    this.commandListener.commandAction(BSCanvas.LEVEL_ENDED, (Displayable)this);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getTimeString(int n) {
        int n2 = n / 60;
        int n3 = n - n2 * 60;
        if (n3 < 10) {
            return String.valueOf(String.valueOf(new StringBuffer("").append(n2).append(":0").append(n3)));
        }
        return String.valueOf(String.valueOf(new StringBuffer("").append(n2).append(":").append(n3)));
    }

    public void fire() {
        for (int i = 0; i < this.shots.length; ++i) {
            if (this.shots[i] != null) continue;
            this.shots[i] = new int[6];
            this.shots[i][0] = this.pXPos + this.pHalfWidth << 8;
            this.shots[i][1] = this.pXPos + this.pHalfWidth << 8;
            this.shots[i][2] = this.pYPos - this.pHalfHeight << 8;
            this.shots[i][3] = this.pYPos - this.pHalfHeight << 8;
            switch (this.pCurrentMove) {
                case 1: {
                    this.shots[i][4] = this.pDX - (this.getCos(this.pAngle) * 2048 >> 8);
                    if (this.pAngle != 0) {
                        this.shots[i][5] = (this.pYPos - this.pOldYPos << 8) - (this.getSin(this.pAngle) * -2048 >> 8);
                        break;
                    }
                    this.shots[i][5] = 0;
                    break;
                }
                case 2: {
                    this.shots[i][4] = this.pDX + (this.getCos(this.pAngle) * 2048 >> 8);
                    this.shots[i][5] = this.pAngle != 0 ? (this.pYPos - this.pOldYPos << 8) + (this.getSin(this.pAngle) * -2048 >> 8) : 0;
                }
            }
            BSCanvas.playSound(this.sounds[4]);
            break;
        }
    }

    public void jump() {
        if (!this.jumping && !this.falling || this.pAngle == 270 && this.pXPos > 0 && (this.level[this.pLeftTileY1][(this.pXPos - 1) / 10] > 0 || this.level[this.pLeftTileY2][(this.pXPos - 1) / 10] > 0) || this.pAngle == 90 && (this.level[this.pRightTileY1][this.pRightTileX] > 0 || this.level[this.pRightTileY2][this.pRightTileX] > 0)) {
            this.pDX += this.getSin(this.pAngle) * -1792 >> 8;
            this.pDY += this.getCos(this.pAngle) * -1792 >> 8;
            this.setAngle(0);
            this.jumping = true;
            this.onLeftRamp = false;
            this.onRightRamp = false;
            BSCanvas.playSound(this.sounds[3]);
        }
    }

    public void keyPressed(int n) {
        if (!this.start) {
            if (!this.dead && !this.won) {
                int n2 = this.getGameAction(n);
                if (n == -7) {
                    this.commandListener.commandAction(BSCanvas.DISPLAY_MENU, (Displayable)this);
                } else {
                    block0 : switch (n2) {
                        case 1: {
                            this.up = true;
                            break;
                        }
                        case 6: {
                            this.down = true;
                            break;
                        }
                        case 2: {
                            this.left = true;
                            break;
                        }
                        case 5: {
                            this.right = true;
                            break;
                        }
                        case 8: {
                            this.fire = true;
                            break;
                        }
                        default: {
                            switch (n) {
                                case 50: {
                                    this.up = true;
                                    break block0;
                                }
                                case 56: {
                                    this.down = true;
                                    break block0;
                                }
                                case 52: {
                                    this.left = true;
                                    break block0;
                                }
                                case 54: {
                                    this.right = true;
                                }
                            }
                        }
                    }
                }
            }
            this.keyPressed = true;
        }
    }

    public void keyReleased(int n) {
        int n2 = this.getGameAction(n);
        block0 : switch (n2) {
            case 6: {
                this.down = false;
                break;
            }
            case 2: {
                this.left = false;
                break;
            }
            case 5: {
                this.right = false;
                break;
            }
            default: {
                switch (n) {
                    case 56: {
                        this.down = false;
                        break block0;
                    }
                    case 52: {
                        this.left = false;
                        break block0;
                    }
                    case 54: {
                        this.right = false;
                    }
                }
            }
        }
    }

    public String[] parseString(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != ',') continue;
            ++n;
        }
        String[] stringArray = new String[n + 1];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = string.substring(0, string.indexOf(44));
            string = string.substring(string.indexOf(44) + 1);
        }
        stringArray[n] = string;
        return stringArray;
    }

    public void drawText(Graphics graphics, String[] stringArray, Font font, boolean bl, int n, int n2) {
        Font[] fontArray = new Font[stringArray.length];
        for (int i = 0; i < fontArray.length; ++i) {
            fontArray[i] = font;
        }
        this.drawText(graphics, stringArray, fontArray, bl, n, n2);
    }

    public void drawText(Graphics graphics, String[] stringArray, Font[] fontArray, boolean bl, int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            n5 = Math.max(fontArray[n3].stringWidth(stringArray[n3]), n5);
            n7 += fontArray[n3].getHeight();
        }
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(n - n5 / 2 - 2, n2 - 2, n5 + 2, n7 + 2);
        graphics.setColor(0);
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            n4 = fontArray[n3].stringWidth(stringArray[n3]);
            graphics.setFont(fontArray[n3]);
            graphics.drawString(stringArray[n3], n, n2 + n6, 17);
            n6 += fontArray[n3].getHeight();
        }
        if (bl) {
            graphics.drawRect(n - n5 / 2 - 2, n2 - 2, n5 + 2, n7 + 2);
        }
    }

    private int getSin(int n) {
        if (n <= 90) {
            return this.sin[n];
        }
        if (n <= 180) {
            return this.sin[180 - n];
        }
        if (n <= 270) {
            return -this.sin[n - 180];
        }
        return -this.sin[360 - n];
    }

    private int getCos(int n) {
        if (n <= 90) {
            return this.cos[n];
        }
        if (n <= 180) {
            return -this.cos[180 - n];
        }
        if (n <= 270) {
            return -this.cos[n - 180];
        }
        return this.cos[360 - n];
    }
}

