/*
 * Decompiled with CFR 0.152.
 */
package OTPGen;

import OTPGen.OTPGenException;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;

public class Account {
    public static final String[] hashNames = new String[]{"MD4", "MD5", "SHA1"};
    public static final int HASH_MD4 = 0;
    public static final int HASH_MD5 = 1;
    public static final int HASH_SHA1 = 2;
    String seed;
    int seq;
    int hash;
    int id;

    public Account(String newseed, int newseq, int newhash, int newid) {
        this.seed = new String(newseed);
        this.seq = newseq;
        this.hash = newhash;
        this.id = newid;
    }

    public Account() {
        this("", 0, 0, 0);
    }

    public Account(Account a) {
        this(a.getSeed(), a.getSeq(), a.getHash(), a.getId());
    }

    public Account(int newid) {
        this("", 0, 0, newid);
    }

    public String getLabel() {
        return new String(hashNames[this.hash] + " " + Integer.toString(this.seq) + " " + this.seed).toLowerCase();
    }

    public void save(String rsName) throws OTPGenException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream writer = new DataOutputStream(stream);
        try {
            writer.writeUTF(this.seed);
            writer.writeInt(this.seq);
            writer.writeInt(this.hash);
            writer.flush();
            RecordStore rs = RecordStore.openRecordStore((String)rsName, (boolean)true);
            byte[] record = stream.toByteArray();
            if (this.id == 0) {
                this.id = rs.addRecord(record, 0, record.length);
            } else {
                rs.setRecord(this.id, record, 0, record.length);
            }
            rs.closeRecordStore();
        }
        catch (RecordStoreFullException e) {
            throw new OTPGenException("\u041f\u043e\u043b\u043d\u044b\u0439", "\u0417\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u043e, \u043d\u0435\u043b\u044c\u0437\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f.");
        }
        catch (RecordStoreException e) {
            throw new OTPGenException("\u041e\u0448\u0438\u0431\u043a\u0430", "\u041e\u0448\u0438\u0431\u043a\u0430, \u043d\u0435\u043b\u044c\u0437\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f. \u0414\u0435\u0442\u0430\u043b\u0438: " + e.getMessage());
        }
        catch (Exception e) {
            throw new OTPGenException("Write error", "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043d\u0435\u043e\u0436\u0438\u0434\u0430\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430,  \u0434\u0430\u043d\u043d\u044b\u0435 \u043d\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u044b." + e.getMessage());
        }
    }

    public void delete(String rsName) {
        if (this.id != 0) {
            try {
                RecordStore rs = RecordStore.openRecordStore((String)rsName, (boolean)true);
                rs.deleteRecord(this.id);
                rs.closeRecordStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setSeed(String newseed) {
        this.seed = newseed;
    }

    public String getSeed() {
        return this.seed;
    }

    public void setSeq(int newseq) {
        this.seq = newseq;
    }

    public int decSeq() {
        return --this.seq;
    }

    public int getSeq() {
        return this.seq;
    }

    public void setHash(int h) {
        this.hash = h;
    }

    public int getHash() {
        return this.hash;
    }

    public void setId(int newid) {
        this.id = newid;
    }

    public int getId() {
        return this.id;
    }
}

