/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.sound.Sound;
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import com.nokia.mid.ui.FullCanvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Game
extends FullCanvas {
    public boolean running;
    private int gameState;
    private static final int GAME = 0;
    protected Tools[] toolList = new Tools[3];
    public boolean pause;
    protected boolean newLevelOk;
    public int score;
    protected int curLevel;
    private Level level;
    private Hero hero;
    protected Monster[] monster = new Monster[4];
    private Sprite[] scoreDigits = new Sprite[5];
    private Sprite leak;
    private Sprite pauseSprite;
    private Sprite pauseModeSprite;
    private Image tempSplashImage;
    private boolean tempSplashImageVisible;
    private boolean initialized;
    private int[] leakPositions = new int[]{46, 64, 143, 52, 150, 40, 118, 138, 173, 124, 148, 36, 112, 11, 23, 138, 142, 138, 94, 92};
    protected int leakX;
    protected int leakY;
    private int curFrame;
    private Sound levelCompleteJingle;
    private Sound getReadyJingle;
    private Sound gameOverJingle;
    public long pauseMinusTime;
    public long pauseDeltaTime;
    private boolean typeScore;

    public Game() {
        this.level = new Level();
        int n = 0;
        while (n < this.toolList.length) {
            this.toolList[n] = new Tools(this);
            ++n;
        }
        this.leak = Setup.getSprite("leak.kspr");
        this.hero = new Hero(this);
        this.monster[0] = new Monster(this, this.hero, 0);
        this.monster[1] = new Monster(this, this.hero, 0);
        this.monster[2] = new Monster(this, this.hero, 1);
        this.monster[3] = new Monster(this, this.hero, 1);
        int n2 = 0;
        while (n2 < this.scoreDigits.length) {
            this.scoreDigits[n2] = Setup.getSprite("game_score_font.kspr");
            ++n2;
        }
        this.changeScore(this.score);
        this.levelCompleteJingle = Setup.loadSound("/res/levelcomplete.snd");
        this.getReadyJingle = Setup.loadSound("/res/getready.snd");
        this.gameOverJingle = Setup.loadSound("/res/gameover.snd");
        this.pauseSprite = Setup.getSprite("pause.kspr");
        this.pauseSprite.setPosition((128 - this.pauseSprite.width) / 2, (128 - this.pauseSprite.height) / 2);
        this.pauseModeSprite = Setup.getSprite("pausemode.kspr");
        this.pauseModeSprite.setPosition(0, 128 - this.pauseModeSprite.height);
    }

    public void showSplash(String string, int n) {
        this.level.destroy();
        System.gc();
        try {
            this.tempSplashImage = Image.createImage((String)string);
        }
        catch (Exception exception) {}
        this.tempSplashImageVisible = true;
        this.repaint();
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {}
        this.tempSplashImageVisible = false;
        this.tempSplashImage = null;
        System.gc();
        this.level.newLevel(this.curLevel, this);
    }

    protected void changeScore(int n) {
        this.score = n;
        String string = String.valueOf(n);
        int n2 = 0;
        while (n2 < this.scoreDigits.length) {
            this.scoreDigits[n2].setVisible(false);
            ++n2;
        }
        int n3 = 0;
        while (n3 < string.length()) {
            this.scoreDigits[n3].setVisible(true);
            this.scoreDigits[n3].setFrame((byte)(string.charAt(string.length() - 1 - n3) - 48));
            this.scoreDigits[n3].setPosition(128 - (n3 + 1) * 9 - 4, 6);
            ++n3;
        }
    }

    public void endgame() {
        try {
            if (Oilrig.soundEnabled) {
                this.gameOverJingle.play(1);
            }
        }
        catch (Exception exception) {}
        this.showSplash("/res/gameover.png", 3000);
        this.running = false;
    }

    public void paint(Graphics graphics) {
        graphics.setClip(0, 0, 128, 128);
        if (!this.initialized) {
            graphics.setColor(255, 255, 255);
            graphics.fillRect(0, 0, 128, 128);
            return;
        }
        if (this.tempSplashImageVisible) {
            graphics.drawImage(this.tempSplashImage, 0, 0, 20);
            return;
        }
        DirectGraphics directGraphics = DirectUtils.getDirectGraphics((Graphics)graphics);
        if (this.gameState == 0 && !this.tempSplashImageVisible) {
            this.level.paint(graphics);
            this.leak.paint(directGraphics);
            int n = 0;
            while (n < this.toolList.length) {
                this.toolList[n].paint(directGraphics);
                ++n;
            }
            int n2 = 0;
            while (n2 < this.monster.length) {
                this.monster[n2].paint(directGraphics);
                ++n2;
            }
            this.hero.paint(directGraphics);
            int n3 = 0;
            while (n3 < this.scoreDigits.length) {
                this.scoreDigits[n3].paint(directGraphics);
                ++n3;
            }
            if (this.pause) {
                this.pauseSprite.paint(directGraphics);
                this.pauseModeSprite.paint(directGraphics);
            }
        }
        ++this.curFrame;
    }

    protected synchronized void keyReleased(int n) {
        if (this.gameState == 0) {
            this.hero.keyReleased(n);
        }
    }

    protected synchronized void keyPressed(int n) {
        if (this.gameState == 0) {
            if (n == -6 && this.pause) {
                this.running = false;
            }
            if (n == -7 || n == -5) {
                if (!this.tempSplashImageVisible) {
                    if (!this.pause) {
                        this.pause = true;
                        this.pauseDeltaTime = System.currentTimeMillis();
                    } else {
                        this.pause = false;
                        this.pauseMinusTime += System.currentTimeMillis() - this.pauseDeltaTime;
                    }
                }
                this.repaint();
            }
            if (!this.pause) {
                this.hero.keyPressed(n);
            }
        }
    }

    public void newLevel(boolean bl) {
        if (this.curLevel == 10) {
            this.curLevel = 0;
            try {
                if (Oilrig.soundEnabled) {
                    this.levelCompleteJingle.play(1);
                }
            }
            catch (Exception exception) {}
            this.showSplash("/res/game_complete.png", 5000);
            this.running = false;
            return;
        }
        if (this.curLevel > 0 && !bl) {
            try {
                if (Oilrig.soundEnabled) {
                    this.levelCompleteJingle.play(1);
                }
            }
            catch (Exception exception) {}
            this.showSplash("/res/lev_complete.png", 3000);
        }
        this.level.newLevel(this.curLevel, this);
        this.leakX = this.leakPositions[this.curLevel << 1];
        this.leakY = this.leakPositions[(this.curLevel << 1) + 1];
        this.hero.setLevel(this.level, this.curLevel);
        int n = 0;
        while (n < this.monster.length) {
            this.monster[n].reset(this.level.monsterPositions[this.curLevel][n * 2], this.level.monsterPositions[this.curLevel][n * 2 + 1]);
            this.monster[n].setLevel(this.level);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.toolList.length) {
            this.toolList[n2].reset(this.level.toolPositions[this.curLevel][n2 * 2], this.level.toolPositions[this.curLevel][n2 * 2 + 1]);
            this.toolList[n2].setLevel(this.level);
            ++n2;
        }
        try {
            if (Oilrig.soundEnabled) {
                this.getReadyJingle.play(1);
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public void reset() {
        this.initialized = false;
        this.gameState = 0;
        this.hero.reset();
        this.score = 0;
        this.curLevel = 0;
        this.changeScore(this.score);
        this.newLevel(false);
        this.initialized = true;
        this.repaint();
    }

    public void run() {
        this.running = true;
        this.pauseMinusTime = 0L;
        this.pause = false;
        while (this.running) {
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {}
            if (this.pause) continue;
            if (this.newLevelOk) {
                this.newLevel(false);
                this.newLevelOk = false;
                if (!this.running) {
                    return;
                }
            }
            this.hero.runFrame();
            int n = 0;
            while (n < this.monster.length) {
                this.monster[n].runFrame();
                ++n;
            }
            this.level.center(this.hero.getPositionX(), this.hero.getPositionY() + 4);
            this.hero.updatePosition();
            int n2 = 0;
            while (n2 < this.toolList.length) {
                this.toolList[n2].updatePosition();
                ++n2;
            }
            int n3 = 0;
            while (n3 < this.monster.length) {
                this.monster[n3].updatePosition();
                ++n3;
            }
            this.leak.setFrame((this.curFrame >> 1) % 4);
            this.leak.setPosition(this.leakX - this.level.levelX, this.leakY - this.level.levelY);
            this.initialized = true;
            this.repaint();
            this.serviceRepaints();
        }
    }
}

