/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.sound.Sound;
import com.nokia.mid.ui.DeviceControl;
import com.nokia.mid.ui.DirectGraphics;

public class Hero {
    public int positionX;
    public int positionY;
    private Sprite hero;
    private Sprite heroFall;
    private Sprite heroFallStar;
    private Sprite[] lifeIndicator = new Sprite[3];
    private int state;
    private static final int RIGHT = 0;
    private static final int LEFT = 1;
    private static final int UP = 2;
    private static final int DOWN = 3;
    private static final int HITLEFT = 4;
    private static final int HITRIGHT = 5;
    private int[] heroFrameTable;
    private int[] heroFrameCount;
    private int[] heroStartX;
    private int[] heroStartY;
    private int[] heroStartDirection;
    public static int[] floorTiles = new int[]{28, 53, 36, 37, 8};
    private Sound lostLifeJingle;
    private boolean walking;
    private int climbStartY;
    private int climbUpAdd;
    private Level level;
    private Game game;
    private int score;
    private int curFrame;
    private boolean climbOk;
    private int horizontalWalkDirection;
    private boolean collision;
    private boolean collisionStarsOk;
    private long collisionStartTime;
    public int livesLeft;
    private boolean levelOk;
    private boolean toolsCollected;

    public Hero(Game game) {
        int[] nArray = new int[6];
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 4;
        nArray[4] = 6;
        nArray[5] = 9;
        this.heroFrameTable = nArray;
        this.heroFrameCount = new int[]{2, 2, 2, 2, 3, 3};
        this.heroStartX = new int[]{165, 168, 3, 82, 114, 2, 174, 4, 44, 2};
        this.heroStartY = new int[]{80, 120, 104, 40, 104, 152, 152, 104, 40, 152};
        int[] nArray2 = new int[10];
        nArray2[0] = 1;
        nArray2[1] = 1;
        nArray2[4] = 1;
        nArray2[6] = 1;
        this.heroStartDirection = nArray2;
        this.climbUpAdd = -1;
        this.game = game;
        this.hero = Setup.getSprite("hero.kspr");
        this.heroFall = Setup.getSprite("hero_fall.kspr");
        this.heroFallStar = Setup.getSprite("hero_fall_star.kspr");
        int n = 0;
        while (n < 3) {
            this.lifeIndicator[n] = Setup.getSprite("life.kspr");
            this.lifeIndicator[n].setPosition(n * 20, 1);
            ++n;
        }
        this.lostLifeJingle = Setup.loadSound("/res/lostlife.snd");
    }

    public void setLevel(Level level, int n) {
        this.level = level;
        this.levelOk = false;
        this.state = this.heroStartDirection[n];
        this.positionX = this.heroStartX[n];
        this.positionY = this.heroStartY[n] - this.getHeight();
        this.hero.setVisible(true);
        this.heroFall.setVisible(false);
        this.heroFallStar.setVisible(false);
        this.walking = false;
        this.climbOk = false;
        this.hero.setFrame(this.heroFrameTable[this.state]);
        this.curFrame = 0;
    }

    public void reset() {
        this.livesLeft = 3;
        int n = 0;
        while (n < 3) {
            this.lifeIndicator[n].setVisible(true);
            ++n;
        }
    }

    public static boolean checkTile(int n, int[] nArray) {
        int n2 = 0;
        while (n2 < nArray.length) {
            if (n == nArray[n2]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void runFrame() {
        int n;
        int n2;
        int n3;
        int n4;
        block57: {
            block55: {
                block56: {
                    int n5;
                    if (this.toolsCollected && (this.positionY & 7) == 0 && !this.levelOk && !this.climbOk && (n4 = (n5 = this.game.leakX + 4 - (this.positionX + 8)) * n5 + (n3 = this.game.leakY + 8 - (this.positionY + 8)) * n3) < 100) {
                        this.curFrame = 0;
                        this.levelOk = true;
                        this.state = this.state == 1 ? 4 : 5;
                    }
                    if (this.walking) {
                        if (this.state == 1) {
                            n5 = this.level.map[(this.positionX - 5 + (this.getWidth() >> 1) >> 3) + (this.positionY + this.getHeight() + 1 >> 3) * this.level.mapXSize];
                            if (Hero.checkTile(n5, floorTiles)) {
                                this.positionX -= 2;
                            }
                        } else if (this.state == 0) {
                            n5 = this.level.map[(this.positionX + 4 + (this.getWidth() >> 1) >> 3) + (this.positionY + this.getHeight() + 1 >> 3) * this.level.mapXSize];
                            if (Hero.checkTile(n5, floorTiles)) {
                                this.positionX += 2;
                            }
                        } else if (this.state == 2) {
                            this.positionY -= 2;
                            n5 = this.positionX + (this.getWidth() >> 1) >> 3;
                            n4 = this.level.map[n5 + ((n3 = (this.positionY + this.getHeight() >> 3) + 1) - 1) * this.level.mapXSize];
                            if (n4 != 37 && this.climbStartY != n3 && (this.positionY & 7) == 6) {
                                this.positionY += 2;
                                this.walking = false;
                                this.state = this.horizontalWalkDirection;
                                this.climbOk = false;
                            }
                        } else if (this.state == 3) {
                            this.positionY += 2;
                            n5 = this.positionX + (this.getWidth() >> 1) >> 3;
                            n3 = this.positionY + this.getHeight() >> 3;
                            n4 = this.level.map[n5 + n3 * this.level.mapXSize];
                            n2 = this.level.map[n5 + (n3 - 1) * this.level.mapXSize];
                            if (n4 != 37 && n4 != 18 && this.climbStartY != n3 && (this.positionY & 7) == 0) {
                                this.walking = false;
                                this.state = this.horizontalWalkDirection;
                                this.climbOk = false;
                            }
                            if (n4 == 37 && n2 == 18 && (this.positionY & 7) == 0) {
                                this.walking = false;
                                this.state = this.horizontalWalkDirection;
                                this.climbOk = false;
                            }
                        }
                        if (this.positionX < 0) {
                            this.positionX = 0;
                        }
                        if (this.positionX > (this.level.mapXSize << 3) - this.getWidth()) {
                            this.positionX = (this.level.mapXSize << 3) - this.getWidth();
                        }
                    }
                    if (this.state == 4 || this.state == 5) {
                        this.hero.setFrame(this.heroFrameTable[this.state] + this.curFrame);
                        if (this.curFrame >= this.heroFrameCount[this.state]) {
                            this.walking = false;
                            this.curFrame = 0;
                            this.state = this.state == 4 ? 1 : 0;
                            this.hero.setFrame(this.heroFrameTable[this.state]);
                            if (this.levelOk) {
                                ++this.game.curLevel;
                                this.game.newLevelOk = true;
                            }
                        } else {
                            ++this.curFrame;
                        }
                    } else {
                        if (this.state == 1) {
                            this.horizontalWalkDirection = 1;
                        }
                        if (this.state == 0) {
                            this.horizontalWalkDirection = 0;
                        }
                        if (this.state != 2 && this.state != 3 || this.climbOk) {
                            this.hero.setFrame(this.heroFrameTable[this.state] + this.curFrame % this.heroFrameCount[this.state]);
                        }
                        if (this.walking) {
                            ++this.curFrame;
                        }
                    }
                    if (!this.collision) break block55;
                    if (this.collisionStarsOk) break block56;
                    this.heroFall.setFrame(this.heroFall.getFrame() + 1);
                    this.collisionStarsOk = true;
                    break block57;
                }
                this.heroFallStar.setVisible(true);
                this.heroFallStar.setFrame((this.horizontalWalkDirection << 1) + (this.curFrame & 1));
                if (this.horizontalWalkDirection == 1) {
                    this.heroFallStar.setPosition(this.hero.getPositionX() + 17, this.hero.getPositionY() + 3);
                } else {
                    this.heroFallStar.setPosition(this.hero.getPositionX() - 9, this.hero.getPositionY() + 3);
                }
                ++this.curFrame;
                if (System.currentTimeMillis() - this.game.pauseMinusTime - this.collisionStartTime <= 2500L) break block57;
                if (this.livesLeft <= 0) {
                    this.game.endgame();
                } else {
                    this.game.newLevel(true);
                }
                this.collision = false;
                break block57;
            }
            Monster[] monsterArray = this.game.monster;
            n3 = 0;
            while (n3 < monsterArray.length) {
                if (!monsterArray[n3].isStunned()) {
                    n4 = monsterArray[n3].positionX + 8 - (this.positionX + 8);
                    n2 = monsterArray[n3].positionY + 8 - (this.positionY + 8);
                    n = n4 * n4 + n2 * n2;
                    boolean bl = false;
                    if (n < 100 && this.state != 4 && this.state != 5) {
                        bl = true;
                    } else if (n > 100 && n < 225) {
                        if (this.state == 4) {
                            if (monsterArray[n3].positionX < this.positionX) {
                                monsterArray[n3].hit();
                            } else {
                                bl = true;
                            }
                        }
                        if (this.state == 5) {
                            if (monsterArray[n3].positionX > this.positionX) {
                                monsterArray[n3].hit();
                            } else {
                                bl = true;
                            }
                        }
                    }
                    n4 = monsterArray[n3].bomb.positionX + 8 - (this.positionX + 8);
                    n2 = monsterArray[n3].bomb.positionY + 8 - (this.positionY + 8);
                    n = n4 * n4 + n2 * n2;
                    if (monsterArray[n3].bomb.isExploding() && n < 144) {
                        bl = true;
                    }
                    if (bl) {
                        this.heroFall.setVisible(true);
                        if (this.horizontalWalkDirection == 1) {
                            this.heroFall.setPosition(this.hero.getPositionX(), this.hero.getPositionY() + 3);
                        } else {
                            this.heroFall.setPosition(this.hero.getPositionX() - 8, this.hero.getPositionY() + 3);
                        }
                        this.heroFall.setFrame(this.horizontalWalkDirection << 1);
                        this.hero.setVisible(false);
                        this.walking = false;
                        this.collision = true;
                        this.collisionStarsOk = false;
                        this.collisionStartTime = System.currentTimeMillis() - this.game.pauseMinusTime;
                        --this.livesLeft;
                        try {
                            if (Oilrig.soundEnabled) {
                                this.lostLifeJingle.play(1);
                            }
                        }
                        catch (Exception exception) {}
                        try {
                            if (Oilrig.vibraEnabled) {
                                DeviceControl.startVibra((int)1, (long)200L);
                            }
                        }
                        catch (Exception exception) {}
                        if (this.livesLeft <= 0) {
                            this.lifeIndicator[0].setVisible(false);
                            break;
                        }
                        this.lifeIndicator[this.livesLeft].setVisible(false);
                        break;
                    }
                }
                ++n3;
            }
        }
        this.toolsCollected = true;
        Tools[] toolsArray = this.game.toolList;
        n3 = 0;
        while (n3 < toolsArray.length) {
            if (toolsArray[n3].isVisible()) {
                n4 = toolsArray[n3].positionX + 8 - (this.positionX + 8);
                n2 = toolsArray[n3].positionY + 8 - (this.positionY + 8);
                n = n4 * n4 + n2 * n2;
                if (n < 169) {
                    this.game.changeScore(this.game.score + toolsArray[n3].grab());
                } else {
                    this.toolsCollected = false;
                }
            }
            ++n3;
        }
    }

    public void updatePosition() {
        this.hero.setPosition(this.positionX - this.level.levelX, this.positionY - this.level.levelY);
    }

    public int getPositionX() {
        return this.positionX;
    }

    public int getPositionY() {
        return this.positionY;
    }

    public int getWidth() {
        return 16;
    }

    public int getHeight() {
        return 16;
    }

    public synchronized void keyReleased(int n) {
        if (this.collision || this.levelOk) {
            return;
        }
        if (n == -4) {
            this.walking = false;
            return;
        }
        if (n == -3) {
            this.walking = false;
            return;
        }
        if (n == -2) {
            this.walking = false;
            return;
        }
        if (n == -1) {
            this.walking = false;
        }
    }

    public synchronized void keyPressed(int n) {
        if (this.collision || this.levelOk) {
            return;
        }
        if (n == -6) {
            if (this.state == 0) {
                this.curFrame = 0;
                this.state = 5;
                return;
            }
            if (this.state == 1) {
                this.state = 4;
                this.curFrame = 0;
                return;
            }
        } else if (n == -4) {
            if (!this.climbOk) {
                this.state = 0;
                this.walking = true;
                return;
            }
        } else if (n == -3) {
            if (!this.climbOk) {
                this.state = 1;
                this.walking = true;
                return;
            }
        } else {
            if (n == -2) {
                byte by;
                this.climbStartY = this.positionY + this.getHeight() >> 3;
                if (this.climbStartY >= 19) {
                    this.climbStartY = 18;
                }
                if ((by = this.level.map[(this.positionX + (this.getWidth() >> 1) >> 3) + (this.climbStartY + 1) * this.level.mapXSize]) == 37 || this.climbOk) {
                    if (this.climbOk) {
                        this.climbStartY = -1;
                    }
                    this.climbOk = true;
                    this.state = 3;
                    this.walking = true;
                }
                return;
            }
            if (n == -1) {
                this.climbStartY = this.positionY + this.getHeight() >> 3;
                byte by = this.level.map[(this.positionX + (this.getWidth() >> 1) >> 3) + (this.climbStartY - 2) * this.level.mapXSize];
                if (by == 37 || this.climbOk) {
                    if (this.climbOk) {
                        this.climbStartY = -1;
                    }
                    this.climbOk = true;
                    this.state = 2;
                    this.walking = true;
                }
            }
        }
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int n) {
        this.score = n;
    }

    public boolean isDead() {
        return this.heroFall.isVisible();
    }

    public void paint(DirectGraphics directGraphics) {
        this.heroFall.paint(directGraphics);
        this.heroFallStar.paint(directGraphics);
        this.hero.paint(directGraphics);
        int n = 0;
        while (n < 3) {
            this.lifeIndicator[n].paint(directGraphics);
            ++n;
        }
    }
}

