/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.DirectUtils;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Level {
    public int numBuildInTiles = 3;
    public int mapXSize;
    public int mapYSize;
    public int width;
    public int height;
    private byte[][] maps = new byte[10][480];
    public byte[] map;
    public int levelX;
    public int levelY;
    private int curLevel = -1;
    private TiledBackground background;
    public Sprite tiles;
    private InputStream is;
    private Image levelI;
    private Graphics levelG;
    public int[][] monsterPositions;
    public int[][] toolPositions;

    public Level() {
        int[][] nArrayArray = new int[10][];
        nArrayArray[0] = new int[]{64, 120, 120, 80, -1, -1, -1, -1};
        int[] nArray = new int[8];
        nArray[0] = 88;
        nArray[1] = 152;
        nArray[3] = 88;
        nArray[4] = 152;
        nArray[5] = 64;
        nArray[6] = -1;
        nArray[7] = -1;
        nArrayArray[1] = nArray;
        nArrayArray[2] = new int[]{40, 128, 16, 80, 64, 56, -1, -1};
        int[] nArray2 = new int[8];
        nArray2[1] = 104;
        nArray2[2] = 152;
        nArray2[3] = 152;
        nArray2[4] = 144;
        nArray2[5] = 16;
        nArray2[7] = 16;
        nArrayArray[3] = nArray2;
        int[] nArray3 = new int[8];
        nArray3[1] = 32;
        nArray3[2] = 176;
        nArray3[3] = 104;
        nArray3[5] = 104;
        nArray3[6] = 112;
        nArray3[7] = 16;
        nArrayArray[4] = nArray3;
        int[] nArray4 = new int[8];
        nArray4[0] = 176;
        nArray4[1] = 88;
        nArray4[3] = 120;
        nArray4[4] = 168;
        nArray4[5] = 8;
        nArray4[7] = 64;
        nArrayArray[5] = nArray4;
        nArrayArray[6] = new int[]{24, 152, 144, 152, 104, 24, 24, 24};
        nArrayArray[7] = new int[]{104, 56, 48, 104, 76, 56, 66, 152};
        nArrayArray[8] = new int[]{132, 72, 43, 152, 25, 152, 168, 152};
        nArrayArray[9] = new int[]{120, 40, 72, 152, 144, 156, 48, 128};
        this.monsterPositions = nArrayArray;
        this.toolPositions = new int[][]{{117, 24, 30, 80, 153, 112}, {7, 152, 7, 88, 175, 64}, {170, 32, 170, 152, 104, 80}, {34, 64, 7, 104, 144, 152}, {7, 32, 130, 16, 150, 152}, {170, 152, 120, 16, 172, 88}, {7, 24, 7, 152, 75, 152}, {60, 152, 172, 136, 110, 56}, {164, 152, 172, 24, 2, 56}, {2, 32, 112, 40, 144, 128}};
        this.tiles = Setup.getSprite("tiles.kspr");
        this.levelI = Image.createImage((int)192, (int)160);
        this.levelG = this.levelI.getGraphics();
        String string = "/res/map.dat";
        try {
            this.is = this.getClass().getResourceAsStream(string);
            int n = 0;
            while (n < 10) {
                byte[] byArray = new byte[2];
                this.is.read(byArray);
                this.width = this.mapXSize = MUtils.convertByte(byArray[0]);
                this.height = this.mapYSize = MUtils.convertByte(byArray[1]);
                this.width <<= 3;
                this.height <<= 3;
                this.is.read(this.maps[n]);
                int n2 = 0;
                while (n2 < this.maps[n].length) {
                    byte[] byArray2 = this.maps[n];
                    int n3 = n2++;
                    byArray2[n3] = (byte)(byArray2[n3] + this.numBuildInTiles);
                }
                ++n;
            }
            this.is.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void newLevel(int n, Game game) {
        this.curLevel = n;
        this.levelX = 0;
        this.levelY = 0;
        if (this.levelI == null) {
            this.levelI = Image.createImage((int)192, (int)160);
            this.levelG = this.levelI.getGraphics();
        }
        this.map = this.maps[this.curLevel];
        if (this.background == null) {
            this.background = new TiledBackground(this.tiles, this.mapXSize, this.mapYSize);
        }
        this.background.map = this.map;
        this.background.xpaint(DirectUtils.getDirectGraphics((Graphics)this.levelG));
    }

    public void destroy() {
        this.levelI = null;
        this.levelG = null;
        System.gc();
    }

    public void center(int n, int n2) {
        this.levelY = n2 > 48 ? n2 - 48 : 0;
        this.levelX = n > 64 ? n - 64 : 0;
        if (this.levelX > this.width - 128) {
            this.levelX = this.width - 128;
        }
        if (this.levelY > this.height - 128) {
            this.levelY = this.height - 128;
        }
        this.background.setPositionInMap(this.levelX, this.levelY);
    }

    public void paint(Graphics graphics) {
        this.background.paint(this.levelI, graphics);
    }
}

