/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.DirectGraphics;

public class Monster {
    public int positionX;
    public int positionY;
    private Sprite monster;
    private int state;
    private static final int IDLE = 0;
    private static final int LEFT = 1;
    private static final int RIGHT = 2;
    private static final int HITLEFT = 3;
    private static final int HITRIGHT = 4;
    protected Bomb bomb;
    private Level level;
    private Game game;
    private int curFrame;
    private boolean active;
    private long stunTime;
    private int type;
    private long bombTime;
    private Hero hero;

    public Monster(Game game, Hero hero, int n) {
        this.hero = hero;
        this.game = game;
        this.type = n;
        this.monster = n == 0 ? Setup.getSprite("monster_walk.kspr") : Setup.getSprite("pirat_walk.kspr");
        this.bomb = new Bomb();
    }

    public void setLevel(Level level) {
        this.level = level;
        this.bomb.setLevel(level);
    }

    public void reset(int n, int n2) {
        this.state = 1;
        this.active = n >= 0;
        this.positionX = n;
        this.positionY = n2 - 16 >> 3 << 3;
        this.monster.setVisible(this.active);
        this.bomb.reset(-1, -1, false);
        this.bombTime = System.currentTimeMillis() - this.game.pauseMinusTime;
    }

    public void runFrame() {
        if (!this.active) {
            return;
        }
        this.bomb.runFrame();
        if (!(this.state != 1 && this.state != 2 || this.hero.positionY != this.positionY || this.type != 1 || this.hero.isDead())) {
            this.state = this.hero.positionX < this.positionX ? 1 : 2;
        }
        if (this.state == 1) {
            byte by = this.level.map[(this.positionX - 5 + 8 >> 3) + (this.positionY + 16 + 1 >> 3) * this.level.mapXSize];
            if (Hero.checkTile(by, Hero.floorTiles)) {
                --this.positionX;
                this.monster.setFrame((this.curFrame & 1) + 2);
                ++this.curFrame;
            } else {
                this.state = 2;
            }
        } else if (this.state == 2) {
            byte by = this.level.map[(this.positionX + 5 + 8 >> 3) + (this.positionY + 16 + 1 >> 3) * this.level.mapXSize];
            if (Hero.checkTile(by, Hero.floorTiles)) {
                ++this.positionX;
                this.monster.setFrame(this.curFrame & 1);
                ++this.curFrame;
            } else {
                this.state = 1;
            }
        } else if (this.state == 3) {
            if (System.currentTimeMillis() - this.game.pauseMinusTime - this.stunTime > (long)(3000 + (1 - this.type) * 2000)) {
                if (this.curFrame < 0) {
                    this.state = 1;
                    this.monster.setFrame(2);
                    this.curFrame = 0;
                } else {
                    if (this.curFrame >= 2) {
                        this.curFrame = 2;
                    }
                    this.monster.setFrame(7 + this.curFrame);
                    --this.curFrame;
                }
            } else {
                if (this.curFrame >= 2) {
                    this.curFrame = 2;
                }
                this.monster.setFrame(7 + this.curFrame);
                ++this.curFrame;
            }
        } else if (this.state == 4) {
            if (System.currentTimeMillis() - this.game.pauseMinusTime - this.stunTime > (long)(3000 + (1 - this.type) * 2000)) {
                if (this.curFrame < 0) {
                    this.state = 2;
                    this.monster.setFrame(0);
                    this.curFrame = 0;
                } else {
                    if (this.curFrame >= 2) {
                        this.curFrame = 2;
                    }
                    this.monster.setFrame(4 + this.curFrame);
                    --this.curFrame;
                }
            } else {
                if (this.curFrame >= 2) {
                    this.curFrame = 2;
                }
                this.monster.setFrame(4 + this.curFrame);
                ++this.curFrame;
            }
        }
        if (this.positionX < 0) {
            this.positionX = 0;
            this.state = 2;
        }
        if (this.positionX > (this.level.mapXSize << 3) - 16) {
            this.positionX = (this.level.mapXSize << 3) - 16;
            this.state = 1;
        }
        if (this.type == 1 && System.currentTimeMillis() - this.game.pauseMinusTime - this.bombTime > 4000L && this.state != 3 && this.state != 4) {
            this.bomb.reset(this.positionX, this.positionY + 3, this.active);
            this.bombTime = System.currentTimeMillis() - this.game.pauseMinusTime;
        }
    }

    public void hit() {
        if (this.state != 3 && this.state != 4) {
            this.stunTime = System.currentTimeMillis() - this.game.pauseMinusTime;
            this.state = this.state == 1 ? 3 : 4;
            this.curFrame = 0;
        }
    }

    public void updatePosition() {
        this.monster.setPosition(this.positionX - this.level.levelX, this.positionY - this.level.levelY);
        this.bomb.updatePosition();
    }

    public int getPositionX() {
        return this.positionX;
    }

    public int getPositionY() {
        return this.positionY;
    }

    public boolean isStunned() {
        return this.state == 3 || this.state == 4;
    }

    public void paint(DirectGraphics directGraphics) {
        this.bomb.paint(directGraphics);
        this.monster.paint(directGraphics);
    }
}

