/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class BMP32Encoder {
    private static final int BITMAPFILEHEADER_SIZE = 14;
    private static final int BITMAPINFOHEADER_SIZE = 40;
    private byte[] bitmapFileHeader;
    private byte[] bfType = new byte[]{66, 77};
    private int bfSize;
    private int bfReserved1;
    private int bfReserved2;
    private int bfOffBits;
    private byte[] bitmapInfoHeader;
    private int biSize;
    private int biWidth;
    private int biHeight;
    private int biPlanes;
    private int biBitCount;
    private int biCompression;
    private int biSizeImage;
    private int biXPelsPerMeter;
    private int biYPelsPerMeter;
    private int biClrUsed;
    private int biClrImportant;
    private OutputStream fo;
    private DataInputStream is;
    private int[] bitmap;

    public BMP32Encoder() {
        byte[] bitmapFileHeader = new byte[14];
        this.bfSize = 0;
        this.bfReserved1 = 0;
        this.bfReserved2 = 0;
        this.bfOffBits = 54;
        byte[] bitmapInfoHeader = new byte[40];
        this.biSize = 40;
        this.biWidth = 0;
        this.biHeight = 0;
        this.biPlanes = 1;
        this.biBitCount = 32;
        this.biCompression = 0;
        this.biSizeImage = 196608;
        this.biXPelsPerMeter = 0;
        this.biYPelsPerMeter = 0;
        this.biClrUsed = 0;
        this.biClrImportant = 0;
    }

    public void createBMP(int[] imagePix, int parWidth, int parHeight, OutputStream os) {
        try {
            this.fo = null;
            this.fo = os;
            this.save(imagePix, parWidth, parHeight);
        }
        catch (Exception saveEx) {
            // empty catch block
        }
    }

    public void createBMP(InputStream input, int parWidth, int parHeight, OutputStream os) {
        try {
            this.is = new DataInputStream(input);
            this.fo = null;
            this.fo = os;
            this.save(null, parWidth, parHeight);
        }
        catch (Exception saveEx) {
            // empty catch block
        }
    }

    private void save(int[] imagePix, int parWidth, int parHeight) {
        try {
            this.convertImage(imagePix, parWidth, parHeight);
            this.writeBitmapFileHeader();
            this.writeBitmapInfoHeader();
            this.writeBitmap();
        }
        catch (Exception saveEx) {
            saveEx.printStackTrace();
        }
    }

    private boolean convertImage(int[] imagePix, int parWidth, int parHeight) {
        if (imagePix != null) {
            this.bitmap = imagePix;
        }
        int pad = (4 - parWidth * 4 % 4) * parHeight;
        if (4 - parWidth * 4 % 4 == 4) {
            pad = 0;
        }
        this.biSizeImage = parWidth * parHeight * 4 + pad;
        this.bfSize = this.biSizeImage + 14 + 40;
        this.biWidth = parWidth;
        this.biHeight = parHeight;
        return true;
    }

    private void writeBitmap() {
        int rowIndex;
        byte[] rgb = new byte[4];
        int size = this.biWidth * this.biHeight - 1;
        int pad = 4 - this.biWidth * 4 % 4;
        if (pad == 4) {
            pad = 0;
        }
        int rowCount = 1;
        int padCount = 0;
        int lastRowIndex = rowIndex = size - this.biWidth;
        try {
            for (int j = 0; j < size + 1; ++j) {
                int value;
                if (this.bitmap != null) {
                    value = j < this.biWidth ? this.bitmap[rowIndex + 1] : this.bitmap[rowIndex];
                } else if (j < this.biWidth) {
                    this.is.readInt();
                    value = this.is.readInt();
                } else {
                    value = this.is.readInt();
                }
                rgb[0] = (byte)(value & 0xFF);
                rgb[1] = (byte)(value >> 8 & 0xFF);
                rgb[2] = (byte)(value >> 16 & 0xFF);
                rgb[3] = (byte)(value >> 24 & 0xFF);
                this.fo.write(rgb);
                if (rowCount == this.biWidth) {
                    padCount += pad;
                    for (int i = 1; i <= pad; ++i) {
                        this.fo.write(0);
                    }
                    rowCount = 1;
                    lastRowIndex = rowIndex = lastRowIndex - this.biWidth;
                } else {
                    ++rowCount;
                }
                ++rowIndex;
            }
            this.bfSize += padCount - pad;
            this.biSizeImage += padCount - pad;
        }
        catch (Exception wb) {
            wb.printStackTrace();
        }
    }

    private void writeBitmapFileHeader() {
        try {
            this.fo.write(this.bfType);
            this.fo.write(this.intToDWord(this.bfSize));
            this.fo.write(this.intToWord(this.bfReserved1));
            this.fo.write(this.intToWord(this.bfReserved2));
            this.fo.write(this.intToDWord(this.bfOffBits));
        }
        catch (Exception wbfh) {
            wbfh.printStackTrace();
        }
    }

    private void writeBitmapInfoHeader() {
        try {
            this.fo.write(this.intToDWord(this.biSize));
            this.fo.write(this.intToDWord(this.biWidth));
            this.fo.write(this.intToDWord(this.biHeight));
            this.fo.write(this.intToWord(this.biPlanes));
            this.fo.write(this.intToWord(this.biBitCount));
            this.fo.write(this.intToDWord(this.biCompression));
            this.fo.write(this.intToDWord(this.biSizeImage));
            this.fo.write(this.intToDWord(this.biXPelsPerMeter));
            this.fo.write(this.intToDWord(this.biYPelsPerMeter));
            this.fo.write(this.intToDWord(this.biClrUsed));
            this.fo.write(this.intToDWord(this.biClrImportant));
        }
        catch (Exception wbih) {
            wbih.printStackTrace();
        }
    }

    private byte[] intToWord(int parValue) {
        byte[] retValue = new byte[]{(byte)(parValue & 0xFF), (byte)(parValue >> 8 & 0xFF)};
        return retValue;
    }

    private byte[] intToDWord(int parValue) {
        byte[] retValue = new byte[]{(byte)(parValue & 0xFF), (byte)(parValue >> 8 & 0xFF), (byte)(parValue >> 16 & 0xFF), (byte)(parValue >> 24 & 0xFF)};
        return retValue;
    }
}

