/*
 * Decompiled with CFR 0.152.
 */
public class Float {
    private static final Float ERROR = new Float(Long.MIN_VALUE, Long.MIN_VALUE);
    private static final int ITNUM = 5;
    public static final Float SQRT3 = new Float(1732050807568877294L, -18L);
    public static final Float PI = new Float(3141592653589793238L, -18L);
    public static final Float ZERO = new Float();
    public static final Float ONE = new Float(1L);
    public static final Float E = new Float(271828182845904512L, -17L);
    public static final Float LOG10 = new Float(2302585092994045684L, -18L);
    public static final Float PIdiv2 = PI.Div(2L);
    public static final Float PIdiv4 = PIdiv2.Div(2L);
    public static final Float PIdiv6 = PIdiv2.Div(3L);
    public static final Float PIdiv12 = PIdiv6.Div(2L);
    public static final Float PImul2 = PI.Mul(2L);
    public static final Float PImul4 = PI.Mul(4L);
    public long m_Val;
    public long m_E;
    private long maxLimit = 92233720368547758L;

    public Float() {
        this.m_E = 0L;
        this.m_Val = 0L;
    }

    public Float(long l) {
        this.m_Val = l;
        this.m_E = 0L;
    }

    public Float(long l, long l2) {
        this.m_Val = l;
        this.m_E = this.m_Val == 0L ? 0L : l2;
    }

    public Float(Float float_) {
        this.m_Val = float_.m_Val;
        this.m_E = this.m_Val == 0L ? 0L : float_.m_E;
    }

    public long toLong() {
        long l = this.m_E;
        long l2 = this.m_Val;
        while (l != 0L) {
            if (l < 0L) {
                l2 /= 10L;
                ++l;
                continue;
            }
            l2 *= 10L;
            --l;
        }
        return l2;
    }

    public String toShortString() {
        if (this.isError()) {
            return "NaN";
        }
        Long l = new Long(this.m_Val);
        String string = l.toString();
        int n = string.length() + (int)this.m_E;
        if (this.m_Val < 0L ? n > 1 : n > 0) {
            return string.substring(0, n);
        }
        return "0";
    }

    public boolean isError() {
        return this.m_Val == Float.ERROR.m_Val && this.m_E == Float.ERROR.m_E;
    }

    public String toString() {
        if (this.isError()) {
            return "NaN";
        }
        this.RemoveZero();
        Long l = new Long(this.m_Val);
        String string = l.toString();
        int n = string.length();
        boolean bl = false;
        if (this.m_Val < 0L) {
            bl = true;
            string = string.substring(1, n);
            --n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_E < 0L) {
            int n2 = (int)Math.abs(this.m_E);
            if (n2 < n) {
                stringBuffer.append(string.substring(0, n - n2));
                stringBuffer.append(".");
                stringBuffer.append(string.substring(n - n2));
            } else {
                stringBuffer.append(string);
                for (int i = 0; i < n2 - n; ++i) {
                    stringBuffer.insert(0, "0");
                }
                stringBuffer.insert(0, "0.");
            }
        } else if ((long)n + this.m_E > 6L) {
            stringBuffer.append(string.charAt(0));
            if (string.length() > 1) {
                stringBuffer.append(".");
                stringBuffer.append(string.substring(1));
            } else {
                stringBuffer.append(".0");
            }
            stringBuffer.append("E" + ((long)(n - 1) + this.m_E));
        } else {
            stringBuffer.append(string);
            int n3 = 0;
            while ((long)n3 < this.m_E) {
                stringBuffer.append("0");
                ++n3;
            }
        }
        string = stringBuffer.toString();
        stringBuffer = null;
        if (bl) {
            string = "-" + string;
        }
        return string;
    }

    public Float Add(Float float_) {
        if (float_.Equal(ZERO)) {
            return new Float(this);
        }
        long l = this.m_E;
        long l2 = float_.m_E;
        long l3 = this.m_Val;
        long l4 = float_.m_Val;
        while (l != l2) {
            if (l > l2) {
                if (Math.abs(l3) < this.maxLimit) {
                    l3 *= 10L;
                    --l;
                    continue;
                }
                l4 /= 10L;
                ++l2;
                continue;
            }
            if (l >= l2) continue;
            if (Math.abs(l4) < this.maxLimit) {
                l4 *= 10L;
                --l2;
                continue;
            }
            l3 /= 10L;
            ++l;
        }
        if (l3 > 0L && l4 > Long.MAX_VALUE - l3 || l3 < 0L && l4 < Long.MIN_VALUE - l3) {
            l3 /= 10L;
            ++l;
            l4 /= 10L;
            ++l2;
        }
        if (l3 > 0L && l4 > Long.MAX_VALUE - l3) {
            return new Float(ERROR);
        }
        if (l3 < 0L && l4 < Long.MIN_VALUE - l3) {
            return new Float(ERROR);
        }
        return new Float(l3 + l4, l);
    }

    public Float Sub(Float float_) {
        if (float_.Equal(ZERO)) {
            return new Float(this.m_Val, this.m_E);
        }
        return this.Add(new Float(-float_.m_Val, float_.m_E));
    }

    public Float Mul(long l) {
        return this.Mul(new Float(l, 0L));
    }

    public Float Mul(Float float_) {
        boolean bl;
        boolean bl2;
        if (float_.Equal(ZERO) || this.Equal(ZERO)) {
            return new Float(ZERO);
        }
        if (float_.Equal(ONE)) {
            return new Float(this);
        }
        boolean bl3 = bl2 = this.m_Val < 0L;
        if (bl2) {
            this.m_Val = -this.m_Val;
        }
        boolean bl4 = bl = float_.m_Val < 0L;
        if (bl) {
            float_.m_Val = -float_.m_Val;
        }
        while (true) {
            if (float_.m_Val > this.m_Val) {
                if (Long.MAX_VALUE / this.m_Val >= float_.m_Val) break;
                float_.m_Val /= 10L;
                ++float_.m_E;
                continue;
            }
            if (Long.MAX_VALUE / float_.m_Val >= this.m_Val) break;
            this.m_Val /= 10L;
            ++this.m_E;
        }
        if (bl2) {
            this.m_Val = -this.m_Val;
        }
        if (bl) {
            float_.m_Val = -float_.m_Val;
        }
        long l = this.m_E + float_.m_E;
        long l2 = this.m_Val * float_.m_Val;
        return new Float(l2, l);
    }

    public Float Div(long l) {
        return this.Div(new Float(l, 0L));
    }

    public Float Div(Float float_) {
        if (float_.Equal(ONE)) {
            return new Float(this);
        }
        long l = this.m_E;
        long l2 = float_.m_E;
        long l3 = float_.m_Val;
        if (l3 == 0L) {
            return new Float(ERROR);
        }
        long l4 = this.m_Val;
        if (l4 == 0L) {
            return new Float(ZERO);
        }
        long l5 = 0L;
        while ((l4 %= l3) != 0L && Math.abs(l5 += l4 / l3) <= 0xCCCCCCCCCCCCCCCL) {
            if (Math.abs(l4) > 0xCCCCCCCCCCCCCCCL) {
                l3 /= 10L;
                ++l2;
            } else {
                l4 *= 10L;
                --l;
            }
            l5 *= 10L;
        }
        Float float_2 = new Float(l5, l - l2);
        float_2.RemoveZero();
        return float_2;
    }

    public void RemoveZero() {
        if (this.m_Val == 0L) {
            return;
        }
        while (this.m_Val % 10L == 0L) {
            this.m_Val /= 10L;
            ++this.m_E;
        }
    }

    public boolean Great(Float float_) {
        long l = this.m_E;
        long l2 = float_.m_E;
        long l3 = this.m_Val;
        long l4 = float_.m_Val;
        while (l != l2) {
            if (l > l2) {
                if (Math.abs(l3) < this.maxLimit) {
                    l3 *= 10L;
                    --l;
                    continue;
                }
                l4 /= 10L;
                ++l2;
                continue;
            }
            if (l >= l2) continue;
            if (Math.abs(l4) < this.maxLimit) {
                l4 *= 10L;
                --l2;
                continue;
            }
            l3 /= 10L;
            ++l;
        }
        return l3 > l4;
    }

    public boolean Less(long l) {
        return this.Less(new Float(l, 0L));
    }

    public boolean Less(Float float_) {
        long l = this.m_E;
        long l2 = float_.m_E;
        long l3 = this.m_Val;
        long l4 = float_.m_Val;
        while (l != l2) {
            if (l > l2) {
                if (Math.abs(l3) < this.maxLimit) {
                    l3 *= 10L;
                    --l;
                    continue;
                }
                l4 /= 10L;
                ++l2;
                continue;
            }
            if (l >= l2) continue;
            if (Math.abs(l4) < this.maxLimit) {
                l4 *= 10L;
                --l2;
                continue;
            }
            l3 /= 10L;
            ++l;
        }
        return l3 < l4;
    }

    public boolean Equal(Float float_) {
        long l = this.m_E;
        long l2 = float_.m_E;
        long l3 = this.m_Val;
        long l4 = float_.m_Val;
        if (l3 == 0L && l4 == 0L || l3 == l4 && l == l2) {
            return true;
        }
        if (Math.abs(l - l2) > 20L) {
            return false;
        }
        while (l != l2) {
            if (l > l2) {
                if (Math.abs(l3) < this.maxLimit) {
                    l3 *= 10L;
                    --l;
                    continue;
                }
                l4 /= 10L;
                ++l2;
                continue;
            }
            if (l >= l2) continue;
            if (Math.abs(l4) < this.maxLimit) {
                l4 *= 10L;
                --l2;
                continue;
            }
            l3 /= 10L;
            ++l;
        }
        return l3 == l4;
    }

    public Float Neg() {
        return new Float(-this.m_Val, this.m_E);
    }

    public static Float sin(Float float_) {
        while (float_.Great(PI)) {
            float_ = float_.Sub(PImul2);
        }
        while (float_.Less(PI.Neg())) {
            float_ = float_.Add(PImul2);
        }
        Float float_2 = float_.Mul(float_.Mul(float_));
        Float float_3 = float_2.Div(6L);
        Float float_4 = float_.Mul(float_.Mul(float_2));
        Float float_5 = float_4.Div(120L);
        Float float_6 = float_.Mul(float_.Mul(float_4));
        Float float_7 = float_6.Div(5040L);
        Float float_8 = float_.Mul(float_.Mul(float_6));
        Float float_9 = float_8.Div(362880L);
        Float float_10 = float_.Mul(float_.Mul(float_8));
        Float float_11 = float_10.Div(39916800L);
        Float float_12 = float_.Sub(float_3).Add(float_5).Sub(float_7).Add(float_9).Sub(float_11);
        if (float_12.Less(new Float(-999999L, -6L))) {
            return new Float(-1L);
        }
        if (float_12.Great(new Float(999999L, -6L))) {
            return new Float(1L);
        }
        if (float_12.Great(new Float(-5L, -4L)) && float_12.Less(new Float(5L, -4L))) {
            return new Float(0L);
        }
        return float_12;
    }

    public static Float cos(Float float_) {
        while (float_.Great(PI)) {
            float_ = float_.Sub(PImul2);
        }
        while (float_.Less(PI.Neg())) {
            float_ = float_.Add(PImul2);
        }
        Float float_2 = float_.Mul(float_);
        Float float_3 = float_2.Div(2L);
        Float float_4 = float_2.Mul(float_2);
        Float float_5 = float_4.Div(24L);
        Float float_6 = float_2.Mul(float_4);
        Float float_7 = float_6.Div(720L);
        Float float_8 = float_4.Mul(float_4);
        Float float_9 = float_8.Div(40320L);
        Float float_10 = float_8.Mul(float_2);
        Float float_11 = float_10.Div(3628800L);
        Float float_12 = ONE.Sub(float_3).Add(float_5).Sub(float_7).Add(float_9).Sub(float_11);
        if (float_12.Less(new Float(-999999L, -6L))) {
            return ONE.Neg();
        }
        if (float_12.Great(new Float(999999L, -6L))) {
            return new Float(ONE);
        }
        if (float_12.Great(new Float(-5L, -4L)) && float_12.Less(new Float(5L, -4L))) {
            return new Float(ZERO);
        }
        return float_12;
    }

    public static Float sqrt(Float float_) {
        int n = 0;
        boolean bl = false;
        if (float_.Less(ZERO)) {
            return new Float(ERROR);
        }
        if (float_.Equal(ZERO)) {
            return new Float(ZERO);
        }
        if (float_.Equal(ONE)) {
            return new Float(ONE);
        }
        if (float_.Less(ONE)) {
            float_ = ONE.Div(float_);
            bl = true;
        }
        long l = float_.m_E / 2L;
        Float float_2 = new Float(float_.m_Val, float_.m_E - l * 2L);
        while (float_2.Great(new Float(16L))) {
            ++n;
            float_2 = float_2.Div(16L);
        }
        Float float_3 = new Float(2L);
        for (int i = 5; i > 0; --i) {
            Float float_4 = float_2.Div(float_3);
            float_3 = float_3.Add(float_4);
            float_3 = float_3.Div(2L);
        }
        while (n > 0) {
            --n;
            float_3 = float_3.Mul(4L);
        }
        float_3.m_E += l;
        if (bl) {
            float_3 = ONE.Div(float_3);
        }
        return float_3;
    }

    public static Float tan(Float float_) {
        Float float_2 = Float.cos(float_);
        if (float_2.Equal(ZERO)) {
            return new Float(ERROR);
        }
        return Float.sin(float_).Div(float_2);
    }

    public static Float parse(String string, int n) throws NumberFormatException {
        boolean bl = false;
        if (string.length() == 0) {
            throw new NumberFormatException();
        }
        if (string.charAt(0) == '-') {
            string = string.substring(1);
            bl = true;
        } else if (string.charAt(0) == '+') {
            string = string.substring(1);
        }
        if (string.length() == 0 || !Character.isDigit(string.charAt(0))) {
            throw new NumberFormatException();
        }
        int n2 = string.indexOf(".");
        if (n2 < 0) {
            n2 = string.indexOf(44);
        }
        long l = 0L;
        int n3 = string.indexOf(69);
        if (n3 == -1) {
            n3 = string.indexOf(101);
        }
        if (n3 != -1) {
            String string2 = new String(string.substring(n3 + 1));
            l = Long.parseLong(string2);
            string = string.substring(0, n3);
        }
        if (n2 != -1) {
            if (n3 >= 0 && n2 >= n3) {
                throw new NumberFormatException();
            }
            for (int i = n2 + 1; i < string.length(); ++i) {
                if (Character.isDigit(string.charAt(i))) {
                    --l;
                    continue;
                }
                throw new NumberFormatException();
            }
            string = string.substring(0, n2) + string.substring(n2 + 1);
            while (n2 > 1 && string.charAt(0) == '0') {
                string = string.substring(1);
                --n2;
            }
        }
        long l2 = 0L;
        int n4 = string.length();
        StringBuffer stringBuffer = new StringBuffer(string);
        while (true) {
            if (n4 > 20) {
                stringBuffer = stringBuffer.deleteCharAt(n4 - 1);
                if (n4 < n2 || n2 == -1) {
                    ++l;
                }
                --n4;
                continue;
            }
            try {
                l2 = Long.parseLong(stringBuffer.toString(), n);
                if (!bl) break;
                l2 = -l2;
            }
            catch (Exception exception) {
                stringBuffer = stringBuffer.deleteCharAt(n4 - 1);
                if (n4 < n2 || n2 == -1) {
                    ++l;
                }
                --n4;
                continue;
            }
            break;
        }
        stringBuffer = null;
        Float float_ = new Float(l2, l);
        float_.RemoveZero();
        return float_;
    }

    public static Float acos(Float float_) {
        return PIdiv2.Sub(Float.asin(float_));
    }

    public static Float asin(Float float_) {
        if (float_.Less(ONE.Neg()) || float_.Great(ONE)) {
            return new Float(ERROR);
        }
        if (float_.Equal(ONE.Neg())) {
            return PIdiv2.Neg();
        }
        if (float_.Equal(ONE)) {
            return PIdiv2;
        }
        return Float.atan(float_.Div(Float.sqrt(ONE.Sub(float_.Mul(float_)))));
    }

    public static Float atan(Float float_) {
        Float float_2;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        if (float_.Less(ZERO)) {
            float_ = float_.Neg();
            bl = true;
        }
        if (float_.Great(ONE)) {
            float_ = ONE.Div(float_);
            bl2 = true;
        }
        while (float_.Great(PIdiv12)) {
            ++n;
            float_2 = float_.Add(SQRT3);
            float_2 = ONE.Div(float_2);
            float_ = float_.Mul(SQRT3);
            float_ = float_.Sub(ONE);
            float_ = float_.Mul(float_2);
        }
        Float float_3 = float_.Mul(float_);
        float_2 = float_3.Add(new Float(14087812L, -7L));
        float_2 = new Float(55913709L, -8L).Div(float_2);
        float_2 = float_2.Add(new Float(60310579L, -8L));
        float_2 = float_2.Sub(float_3.Mul(new Float(5160454L, -8L)));
        float_2 = float_2.Mul(float_);
        while (n > 0) {
            float_2 = float_2.Add(PIdiv6);
            --n;
        }
        if (bl2) {
            float_2 = PIdiv2.Sub(float_2);
        }
        if (bl) {
            float_2 = float_2.Neg();
        }
        return float_2;
    }

    public static Float atan2(Float float_, Float float_2) {
        if (float_2.Equal(ZERO)) {
            return new Float(ERROR);
        }
        Float float_3 = Float.atan(float_.Div(float_2));
        if (float_.m_Val > 0L && float_2.m_Val < 0L) {
            float_3 = float_3.Add(PI);
        }
        if (float_.m_Val < 0L && float_2.m_Val < 0L) {
            float_3 = float_3.Sub(PI);
        }
        return float_3;
    }

    public static Float exp(Float float_) {
        if (float_.Equal(ZERO)) {
            return new Float(ONE);
        }
        Float float_2 = new Float(ONE);
        long l = 1L;
        Float float_3 = null;
        boolean bl = float_.Less(ZERO);
        if (bl) {
            float_ = float_.Neg();
        }
        float_3 = new Float(float_).Div(l);
        for (long i = 2L; i < 50L; ++i) {
            float_2 = float_2.Add(float_3);
            float_3 = float_3.Mul(float_).Div(i);
        }
        if (bl) {
            return ONE.Div(float_2);
        }
        return float_2;
    }

    private static Float _log(Float float_) {
        if (!float_.Great(ZERO)) {
            return new Float(ERROR);
        }
        Float float_2 = new Float(ZERO);
        Float float_3 = float_.Sub(ONE);
        Float float_4 = float_.Add(ONE);
        Float float_5 = float_3.Div(float_4);
        Float float_6 = new Float(float_5);
        float_4 = float_6.Mul(float_5);
        for (long i = 1L; i < 50L; i += 2L) {
            float_2 = float_2.Add(float_6.Div(i));
            float_6 = float_6.Mul(float_4);
        }
        return float_2.Mul(2L);
    }

    public static Float log(Float float_) {
        if (!float_.Great(ZERO)) {
            return new Float(ERROR);
        }
        boolean bl = false;
        Float float_2 = Float._log(new Float(5L, -1L));
        if (float_.m_Val < 0L) {
            bl = true;
            float_.m_Val = -float_.m_Val;
        }
        int n = 0;
        while (float_.Great(ONE)) {
            float_ = float_.Div(2L);
            ++n;
        }
        Float float_3 = Float._log(float_);
        for (int i = 0; i < n; ++i) {
            float_3 = float_3.Sub(float_2);
        }
        if (bl) {
            return ONE.Div(float_3);
        }
        return float_3;
    }

    public static Float log10(Float float_) {
        if (!float_.Great(ZERO)) {
            return new Float(ERROR);
        }
        boolean bl = false;
        Float float_2 = Float._log(new Float(5L, -1L));
        if (float_.m_Val < 0L) {
            bl = true;
            float_.m_Val = -float_.m_Val;
        }
        int n = 0;
        if (float_.Great(ONE)) {
            while (float_.Great(ONE)) {
                float_ = float_.Div(10L);
                ++n;
            }
        } else {
            while (float_.Less(ONE)) {
                float_ = float_.Mul(10L);
                --n;
            }
        }
        Float float_3 = new Float(n);
        if (!float_.Equal(ONE)) {
            float_3 = float_3.Add(Float.log(float_).Div(LOG10));
        }
        if (bl) {
            return ONE.Div(float_3);
        }
        return float_3;
    }

    public static Float pow(Float float_, Float float_2) {
        if (float_.Equal(ZERO)) {
            return new Float(ZERO);
        }
        if (float_.Equal(ONE)) {
            return new Float(ONE);
        }
        long l = float_2.toLong();
        boolean bl = float_2.Equal(new Float(l));
        if (bl) {
            boolean bl2 = false;
            if (float_2.Less(0L)) {
                bl2 = true;
            }
            Float float_3 = new Float(float_);
            for (long i = 1L; i < (bl2 ? -l : l); ++i) {
                float_3 = float_3.Mul(float_);
            }
            if (bl2) {
                return ONE.Div(float_3);
            }
            return float_3;
        }
        if (float_.Great(ZERO)) {
            return Float.exp(float_2.Mul(Float.log(float_)));
        }
        return new Float(ERROR);
    }

    public static Float ceil(Float float_) {
        long l = float_.m_Val;
        if (float_.m_E < 0L) {
            long l2 = 1L;
            if (float_.m_E > -19L) {
                for (long i = 0L; i < -float_.m_E; ++i) {
                    l2 *= 10L;
                }
                l /= l2;
                if (float_.m_Val - (l *= l2) > 0L) {
                    l += l2;
                }
            } else {
                if (l > 0L) {
                    return ONE;
                }
                return ZERO;
            }
        }
        return new Float(l, float_.m_E);
    }

    public static Float floor(Float float_) {
        long l = float_.m_Val;
        if (float_.m_E < 0L) {
            long l2 = 1L;
            if (float_.m_E > -19L) {
                for (long i = 0L; i < -float_.m_E; ++i) {
                    l2 *= 10L;
                }
                l /= l2;
                if (float_.m_Val - (l *= l2) < 0L) {
                    l -= l2;
                }
            } else {
                if (l < 0L) {
                    return ONE.Neg();
                }
                return ZERO;
            }
        }
        return new Float(l, float_.m_E);
    }

    public static Float abs(Float float_) {
        if (float_.m_Val < 0L) {
            return float_.Neg();
        }
        return new Float(float_);
    }

    public static Float Int(Float float_) {
        long l = float_.m_Val;
        if (float_.m_E < 0L) {
            long l2 = 1L;
            if (float_.m_E > -19L) {
                for (long i = 0L; i < -float_.m_E; ++i) {
                    l2 *= 10L;
                }
                l /= l2;
                l *= l2;
            } else {
                return ZERO;
            }
        }
        return new Float(l, float_.m_E);
    }

    public static Float Frac(Float float_) {
        long l = float_.m_Val;
        if (float_.m_E < 0L) {
            long l2 = 1L;
            if (float_.m_E > -19L) {
                for (long i = 0L; i < -float_.m_E; ++i) {
                    l2 *= 10L;
                }
                l /= l2;
                l *= l2;
                l = float_.m_Val - l;
            } else {
                return ZERO;
            }
        }
        return new Float(l, float_.m_E);
    }
}

