/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;

public class VirtualMachine {
    static final int OPERAND_STACK_SIZE = 128;
    static final int CALL_STACK_SIZE = 128;
    static Float HALF = new Float(1L, -1L);
    static final int MAX_NUMBER_LEN = 32;
    static final int SIZEOF_FLOAT = 16;
    Float[] opdStack;
    int oSp;
    Frame[] callStack;
    int cSp;
    Frame currFrame;
    static Random random = new Random();
    Program prog;
    boolean running;
    static final int LITERAL = 0;
    static final int LOAD = 1;
    static final int INPUT = 2;
    static final int STORE = 3;
    static final int DUP = 4;
    static final int SWAP = 5;
    static final int LOAD_E = 6;
    static final int LOAD_PI = 7;
    static final int NEG = 8;
    static final int ADD = 9;
    static final int SUB = 10;
    static final int MUL = 11;
    static final int DIV = 12;
    static final int EQ = 13;
    static final int NE = 14;
    static final int GT = 15;
    static final int GE = 16;
    static final int LT = 17;
    static final int LE = 18;
    static final int ABS = 19;
    static final int ACOS = 20;
    static final int ASIN = 21;
    static final int ATAN = 22;
    static final int ATAN2 = 23;
    static final int CEIL = 24;
    static final int COS = 25;
    static final int EXP = 26;
    static final int FLOOR = 27;
    static final int FRAC = 28;
    static final int INT = 29;
    static final int LOG = 30;
    static final int LOG10 = 31;
    static final int MAX = 32;
    static final int MIN = 33;
    static final int POW = 34;
    static final int RND = 35;
    static final int ROUND = 36;
    static final int SIN = 37;
    static final int SQRT = 38;
    static final int TAN = 39;
    static final int IF = 40;
    static final int CALL = 41;
    static final int RETURN = 42;
    static final int GOTO = 43;
    static final String[] insnMnemonic = new String[]{"", "load", "input", "store", "dup", "swap", "E", "PI", "neg", "+", "-", "*", "/", "=", "!=", ">", ">=", "<", "<=", "abs", "acos", "asin", "atan", "atan2", "ceil", "cos", "exp", "floor", "frac", "int", "log", "log10", "max", "min", "pow", "rnd", "round", "sin", "sqrt", "tan", "if", "call", "return", "goto"};
    static final int[] insnSize = new int[]{17, 3, 2, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 5, 3, 1, 5};

    VirtualMachine(Program program) {
        this.prog = program;
        this.opdStack = new Float[128];
        this.callStack = new Frame[128];
        this.callStack[0] = this.currFrame = new Frame(program.main, null);
        this.cSp = 1;
        this.oSp = 0;
    }

    static String printNumber(Float float_) {
        return float_.toString();
    }

    static void packFloat(byte[] byArray, int n, Float float_) {
        Converter.packLong(byArray, n, float_.m_Val);
        Converter.packLong(byArray, n + 8, float_.m_E);
    }

    static Float unpackFloat(byte[] byArray, int n) {
        return new Float(Converter.unpackLong(byArray, n), Converter.unpackLong(byArray, n + 8));
    }

    static Float inputNumber(String string) throws NumberFormatException {
        return Float.parse(string, 10);
    }

    static void moveLabel(byte[] byArray, int n, int n2) {
        block3: for (int i = 0; i < byArray.length; i += insnSize[byArray[i]]) {
            switch (byArray[i]) {
                case 40: 
                case 43: {
                    if (Converter.unpackInt(byArray, i + 1) != n) continue block3;
                    Converter.packInt(byArray, i + 1, n2);
                }
            }
        }
    }

    static int getPcForInstruction(byte[] byArray, int n) {
        int n2 = 0;
        while (--n >= 0) {
            n2 += insnSize[byArray[n2]];
        }
        return n2;
    }

    static int getInstructionForPc(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; i += insnSize[byArray[i]]) {
            ++n2;
        }
        return n2;
    }

    static String[] printInstructions(Procedure procedure) {
        int n;
        byte[] byArray = procedure.code;
        String[] stringArray = new String[byArray.length + 1];
        int n2 = 0;
        int[] nArray = new int[byArray.length];
        int n3 = 0;
        block10: for (n = 0; n < byArray.length; n += insnSize[byArray[n]]) {
            switch (byArray[n]) {
                case 40: 
                case 43: {
                    if (nArray[Converter.unpackInt(byArray, n + 1)] != 0) continue block10;
                    nArray[Converter.unpackInt((byte[])byArray, (int)(n + 1))] = ++n3;
                }
            }
        }
        procedure.nLabels = n3;
        for (n = 0; n < byArray.length; n += insnSize[byArray[n]]) {
            StringBuffer stringBuffer = new StringBuffer();
            if (nArray[n] != 0) {
                stringBuffer.append(nArray[n]);
                stringBuffer.append(':');
            } else {
                stringBuffer.append("  ");
            }
            stringBuffer.append(insnMnemonic[byArray[n]]);
            switch (byArray[n]) {
                case 1: 
                case 3: {
                    stringBuffer.append(' ');
                    byte by = byArray[n + 1];
                    Procedure procedure2 = procedure;
                    while (by != procedure2.level) {
                        procedure2 = procedure2.top;
                    }
                    stringBuffer.append(procedure2.vars[byArray[n + 2] & 0xFF]);
                    break;
                }
                case 0: {
                    stringBuffer.append(VirtualMachine.printNumber(VirtualMachine.unpackFloat(byArray, n + 1)));
                    break;
                }
                case 2: {
                    stringBuffer.append(' ');
                    stringBuffer.append(procedure.prog.inputParamNames[byArray[n + 1] & 0xFF]);
                    break;
                }
                case 41: {
                    stringBuffer.append(' ');
                    byte by = byArray[n + 1];
                    Procedure procedure2 = procedure;
                    while (by != procedure2.level) {
                        procedure2 = procedure2.top;
                    }
                    stringBuffer.append(procedure2.subprocs[byArray[n + 2] & 0xFF].name);
                    break;
                }
                case 40: 
                case 43: {
                    stringBuffer.append(' ');
                    stringBuffer.append(nArray[Converter.unpackInt(procedure.code, n + 1)]);
                    stringBuffer.append(':');
                }
            }
            stringArray[n2++] = stringBuffer.toString();
        }
        stringArray[n2++] = "[* Program End *]";
        String[] stringArray2 = new String[n2];
        System.arraycopy(stringArray, 0, stringArray2, 0, n2);
        return stringArray2;
    }

    public void run() throws ArithmeticException, StackOverflowException, StackEmptyException {
        this.running = true;
        while (this.cSp != 0 && this.running) {
            this.step();
        }
        this.running = false;
    }

    private final void push(Float float_) throws StackOverflowException {
        if (this.oSp == this.opdStack.length) {
            throw new StackOverflowException();
        }
        this.opdStack[this.oSp++] = float_;
    }

    private final Float pop() throws StackEmptyException {
        if (this.oSp == 0) {
            throw new StackEmptyException();
        }
        return this.opdStack[--this.oSp];
    }

    public void step() throws ArithmeticException, StackOverflowException, StackEmptyException {
        byte[] byArray = this.currFrame.proc.code;
        switch (byArray[this.currFrame.pc]) {
            case 0: {
                this.push(VirtualMachine.unpackFloat(byArray, this.currFrame.pc + 1));
                this.currFrame.pc += 16;
                break;
            }
            case 1: {
                this.push(this.currFrame.display[byArray[this.currFrame.pc + 1]].vars[byArray[this.currFrame.pc + 2] & 0xFF]);
                this.currFrame.pc += 2;
                break;
            }
            case 2: {
                this.push(this.prog.inputParams[byArray[this.currFrame.pc + 1] & 0xFF]);
                ++this.currFrame.pc;
                break;
            }
            case 6: {
                this.push(Float.E);
                break;
            }
            case 7: {
                this.push(Float.PI);
                break;
            }
            case 3: {
                this.currFrame.display[byArray[this.currFrame.pc + 1]].vars[byArray[this.currFrame.pc + 2] & 0xFF] = this.pop();
                this.currFrame.pc += 2;
                break;
            }
            case 4: {
                Float float_ = this.pop();
                this.push(float_);
                this.push(float_);
                break;
            }
            case 5: {
                Float float_ = this.pop();
                Float float_2 = this.pop();
                this.push(float_);
                this.push(float_2);
                break;
            }
            case 8: {
                this.push(this.pop().Neg());
                break;
            }
            case 9: {
                this.push(this.pop().Add(this.pop()));
                break;
            }
            case 10: {
                Float float_ = this.pop();
                Float float_3 = this.pop();
                this.push(float_3.Sub(float_));
                break;
            }
            case 11: {
                this.push(this.pop().Mul(this.pop()));
                break;
            }
            case 12: {
                Float float_ = this.pop();
                Float float_4 = this.pop();
                this.push(float_4.Div(float_));
                break;
            }
            case 13: {
                this.push(this.pop().Equal(this.pop()) ? Float.ONE : Float.ZERO);
                break;
            }
            case 14: {
                this.push(this.pop().Equal(this.pop()) ? Float.ZERO : Float.ONE);
                break;
            }
            case 15: {
                Float float_ = this.pop();
                Float float_5 = this.pop();
                this.push(float_5.Great(float_) ? Float.ONE : Float.ZERO);
                break;
            }
            case 16: {
                Float float_ = this.pop();
                Float float_6 = this.pop();
                this.push(float_6.Great(float_) || float_6.Equal(float_) ? Float.ONE : Float.ZERO);
                break;
            }
            case 17: {
                Float float_ = this.pop();
                Float float_7 = this.pop();
                this.push(float_7.Less(float_) ? Float.ONE : Float.ZERO);
                break;
            }
            case 18: {
                Float float_ = this.pop();
                Float float_8 = this.pop();
                this.push(float_8.Less(float_) || float_8.Equal(float_) ? Float.ONE : Float.ZERO);
                break;
            }
            case 19: {
                this.push(Float.abs(this.pop()));
                break;
            }
            case 20: {
                this.push(Float.acos(this.pop()));
                break;
            }
            case 21: {
                this.push(Float.asin(this.pop()));
                break;
            }
            case 22: {
                this.push(Float.atan(this.pop()));
                break;
            }
            case 23: {
                Float float_ = this.pop();
                Float float_9 = this.pop();
                this.push(Float.atan2(float_9, float_));
                break;
            }
            case 24: {
                this.push(Float.ceil(this.pop()));
                break;
            }
            case 25: {
                this.push(Float.cos(this.pop()));
                break;
            }
            case 26: {
                this.push(Float.exp(this.pop()));
                break;
            }
            case 27: {
                this.push(Float.floor(this.pop()));
                break;
            }
            case 28: {
                this.push(Float.Frac(this.pop()));
                break;
            }
            case 29: {
                this.push(Float.Int(this.pop()));
                break;
            }
            case 30: {
                this.push(Float.log(this.pop()));
                break;
            }
            case 31: {
                this.push(Float.log10(this.pop()));
                break;
            }
            case 32: {
                Float float_ = this.pop();
                Float float_10 = this.pop();
                this.push(float_10.Great(float_) ? float_10 : float_);
                break;
            }
            case 33: {
                Float float_ = this.pop();
                Float float_11 = this.pop();
                this.push(float_11.Less(float_) ? float_11 : float_);
                break;
            }
            case 34: {
                Float float_ = this.pop();
                Float float_12 = this.pop();
                this.push(Float.pow(float_12, float_));
                break;
            }
            case 35: {
                this.push(new Float(random.nextInt() & Integer.MAX_VALUE).Div(Integer.MAX_VALUE));
                break;
            }
            case 36: {
                this.push(Float.floor(this.pop().Add(HALF)));
                break;
            }
            case 37: {
                this.push(Float.sin(this.pop()));
                break;
            }
            case 38: {
                this.push(Float.sqrt(this.pop()));
                break;
            }
            case 39: {
                this.push(Float.tan(this.pop()));
                break;
            }
            case 40: {
                this.currFrame.pc = this.pop().Equal(Float.ZERO) ? Converter.unpackInt(byArray, this.currFrame.pc + 1) : (this.currFrame.pc += 5);
                return;
            }
            case 41: {
                if (this.cSp == this.callStack.length) {
                    throw new StackOverflowException();
                }
                Procedure procedure = this.currFrame.display[byArray[this.currFrame.pc + 1]].proc.subprocs[byArray[this.currFrame.pc + 2] & 0xFF];
                this.currFrame.pc += 3;
                this.callStack[this.cSp++] = this.currFrame = new Frame(procedure, this.currFrame);
                return;
            }
            case 42: {
                --this.cSp;
                if (this.cSp == 0) break;
                this.currFrame = this.callStack[this.cSp - 1];
                return;
            }
            case 43: {
                this.currFrame.pc = Converter.unpackInt(byArray, this.currFrame.pc + 1);
                return;
            }
        }
        ++this.currFrame.pc;
    }
}

