/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class GraphMenu {
    Displayable displayable;
    Vector vCommands;
    CommandListener commandListener;
    int menuIndex;
    int menuX;
    int menuY;
    int menuW;
    int menuH;
    int menuBarH;
    Font linesFont;
    int width;
    int height;

    public void setProperty() throws  {
        this.menuX = this.width;
        this.menuY = this.height;
        this.menuW = 0;
        this.menuH = 0;
        this.menuBarH = this.linesFont.getHeight() + 2;
        this.menuIndex = 0;
        Enumeration enumeration = this.vCommands.elements();
        while (enumeration.hasMoreElements()) {
            Command command = (Command)enumeration.nextElement();
            if (this.menuW - 14 < this.linesFont.stringWidth(command.getLabel())) {
                this.menuW = 14 + this.linesFont.stringWidth(command.getLabel());
                this.menuX = this.width - this.menuW;
            }
            this.menuH = 4 + this.vCommands.size() * (this.linesFont.getHeight() + 1);
            this.menuY = this.height - this.menuBarH - this.menuH;
        }
    }

    public void setCommandListener(CommandListener commandListener) throws  {
        this.commandListener = commandListener;
    }

    public void addCommand(Command command) throws  {
        if (!this.vCommands.contains(command)) {
            this.vCommands.addElement(command);
            if (this.menuW - 14 < this.linesFont.stringWidth(command.getLabel())) {
                this.menuW = 14 + this.linesFont.stringWidth(command.getLabel());
                this.menuX = this.width - this.menuW;
            }
            this.menuH = 4 + this.vCommands.size() * (this.linesFont.getHeight() + 1);
            this.menuY = this.height - this.menuBarH - this.menuH;
        }
    }

    public void moveUp() throws  {
        --this.menuIndex;
        if (this.menuIndex < 0) {
            this.menuIndex = this.vCommands.size() - 1;
        }
    }

    public void moveDown() throws  {
        ++this.menuIndex;
        if (this.menuIndex >= this.vCommands.size()) {
            this.menuIndex = 0;
        }
    }

    public void select() throws  {
        if (this.commandListener != null) {
            this.commandListener.commandAction((Command)this.vCommands.elementAt(this.menuIndex), this.displayable);
        }
    }

    public void drawMenu(Graphics graphics, boolean bl) throws  {
        if (bl) {
            graphics.setFont(this.linesFont);
            graphics.setColor(0xCECECE);
            graphics.fillRect(this.menuX, this.menuY, this.menuW, this.menuH);
            graphics.setColor(0x656565);
            graphics.drawRect(this.menuX, this.menuY, this.menuW, this.menuH);
            graphics.setColor(7444942);
            graphics.fillRect(this.menuX + 1, this.menuY + 3 + (this.linesFont.getHeight() + 1) * this.menuIndex, this.menuW - 1, this.linesFont.getHeight());
            int n = this.menuY + 3;
            int n2 = 0;
            Enumeration enumeration = this.vCommands.elements();
            while (enumeration.hasMoreElements()) {
                Command command = (Command)enumeration.nextElement();
                String string = command.getLabel();
                if (n2 == this.menuIndex) {
                    graphics.setColor(0xEEEEEE);
                } else {
                    graphics.setColor(0);
                }
                graphics.drawString(string, this.menuX + 7, n, 20);
                n += this.linesFont.getHeight() + 1;
                ++n2;
            }
        }
    }

    GraphMenu(int n, int n2) throws  {
        this.width = n - 7;
        this.height = n2 - 4;
        this.vCommands = new Vector();
        this.linesFont = Font.getFont((int)32, (int)1, (int)8);
        this.setProperty();
    }
}

