/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FileBrowser {
    int Type;
    int OPEN_IMAGE = 1;
    int ADD_ICON = 2;
    int ADD_FRAME = 3;
    int IS_ROOT = 0;
    int IS_FOLDER = 1;
    int IS_IMAGE = 2;
    int IS_FONT = 3;
    int IN_CORRUPT = 4;
    PhotoCanvas canvas;
    PhotoEditorMIDlet midlet;
    int scanindex = 0;
    boolean scan = false;
    boolean scanin = false;
    Graphics g;
    String currDirName;
    FileConnection fc;
    Enumeration enumeration;
    Vector menu;
    Container[] container;
    int menuSize;
    int menuIndex;
    int WIDTH;
    int HEIGHT;
    Image folder;
    Image picture;
    Image root;
    Image fontimg;
    Font linesFont;
    int FMH;
    int FSH;
    int X;
    int Y;
    int W;
    int H;
    int MVI;
    int CMVI;
    boolean dirIndexIsImage = false;
    boolean dirIndexIsFolder = false;
    String TH_FOLDER;

    public void init(int n, int n2) throws  {
        this.HEIGHT = n2;
        this.WIDTH = n;
        this.X = 0;
        this.Y = 0;
        this.W = this.WIDTH;
        this.H = this.HEIGHT;
    }

    public void setType(int n) throws  {
        this.Type = n;
        if (this.Type == this.OPEN_IMAGE) {
            this.currDirName = this.TH_FOLDER;
        }
        if (this.Type == this.ADD_ICON) {
            this.currDirName = this.midlet.patch_icon;
        }
        if (this.Type == this.ADD_FRAME) {
            this.currDirName = this.midlet.patch_frame;
        }
        FileBrowser.showCurrDir$(this);
    }

    public void fileBrowser(Graphics graphics, int n, int n2, int n3, int n4) throws  {
        this.g = graphics;
        this.X = n;
        this.Y = n2;
        this.W = n3;
        this.H = n4;
        this.MVI = this.H / this.FSH - 2;
        if (this.MVI > this.menuSize) {
            this.MVI = this.menuSize - 1;
        }
        graphics.setClip(this.X, this.Y, this.W, this.H);
        int n5 = 0;
        int n6 = 0;
        while (n6 < this.container.length) {
            if (this.menuIndex == n6) {
                graphics.setColor(7444942);
                graphics.fillRoundRect(this.X, this.Y + this.FMH + (n5 + 1 + this.CMVI) * this.FSH - (this.menuIndex + 1) * this.FSH, this.WIDTH, this.FSH, 4, 2);
            }
            if (this.container[n6].type == this.IS_ROOT) {
                graphics.drawImage(this.root, this.X + 7, this.Y + this.FMH + (n5 + 1) * this.FSH - (this.menuIndex + 1) * this.FSH, 0);
            } else if (this.container[n6].type == this.IS_FOLDER) {
                graphics.drawImage(this.folder, this.X + 7, this.Y + this.FMH + (n5 + 1) * this.FSH - (this.menuIndex + 1) * this.FSH, 0);
            } else if (this.container[n6].type == this.IS_FONT) {
                graphics.drawImage(this.fontimg, this.X + 7, this.Y + this.FMH + (n5 + 1) * this.FSH - (this.menuIndex + 1) * this.FSH, 0);
            } else if (this.container[n6].type == this.IS_IMAGE && !this.container[n6].mini) {
                graphics.drawImage(this.picture, this.X + 7, this.Y + this.FMH + (n5 + 1) * this.FSH - (this.menuIndex + 1) * this.FSH, 0);
            } else if (this.container[n6].type == this.IS_IMAGE && this.container[n6].mini) {
                graphics.drawImage(this.container[n6].imgmini, this.X + 7, this.Y + this.FMH + (n5 + 1) * this.FSH - (this.menuIndex + 1) * this.FSH, 0);
            }
            graphics.setColor(0xEEEEEE);
            String string = this.container[n6].name;
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            graphics.drawString(string, this.X + 7 + Math.max(this.FSH, this.picture.getHeight()), this.Y + this.FMH + (n5 + 1) * this.FSH - (this.menuIndex + 1) * this.FSH, 0);
            ++n5;
            ++n6;
        }
        graphics.setColor(0x656565);
        graphics.fillRect(this.X, this.Y, this.W, this.FSH);
        graphics.setColor(0xCECECE);
        graphics.drawString(this.currDirName, this.X + 3, this.Y, 20);
        graphics.setClip(0, 0, this.WIDTH, this.HEIGHT);
        if (this.scan && !this.scanin) {
            this.scanIcons();
        }
    }

    public void moveUp() throws  {
        if (this.CMVI == 0) {
            --this.menuIndex;
        }
        if (this.menuIndex <= 0 && this.CMVI == 0) {
            this.CMVI = 0;
            this.menuIndex = 0;
        }
        --this.CMVI;
        if (this.CMVI <= 0) {
            this.CMVI = 0;
        }
    }

    public void moveDown() throws  {
        if (this.CMVI == this.MVI) {
            ++this.menuIndex;
        }
        if (this.menuIndex > this.menuSize - 1 - this.CMVI) {
            this.CMVI = this.MVI;
            this.menuIndex = this.menuSize - 1 - this.CMVI;
        }
        ++this.CMVI;
        if (this.CMVI > this.MVI) {
            this.CMVI = this.MVI;
        }
    }

    public void select() throws  {
        String string = this.container[this.menuIndex + this.CMVI].name;
        if (string.endsWith("/") || string.equals("..")) {
            FileBrowser.traverseDirectory$(this, string);
            this.scan = false;
            FileBrowser.showCurrDir$(this);
        } else {
            if (string.endsWith(".fnt")) {
                this.loadFont(1, String.valueOf(this.currDirName).concat(String.valueOf(string)));
                this.canvas.closeTrueType();
                this.canvas.fileexplo = false;
                return;
            }
            if (string.endsWith(".ttf") || string.endsWith(".ttf.gz") || string.endsWith(".ttz")) {
                this.canvas.loadTrueType(String.valueOf(this.currDirName).concat(String.valueOf(string)));
                this.canvas.fileexplo = false;
                return;
            }
            if (string.endsWith(".jpg") || string.endsWith(".bmp") || string.endsWith(".png") || string.endsWith(".gif") || string.endsWith(".jpeg") || string.endsWith(".wbmp") || string.endsWith(".JPEG") || string.endsWith(".JPG")) {
                Image image = null;
                Image image2 = null;
                Object var4_4 = null;
                InputStream inputStream = null;
                byte[] byArray = null;
                try {
                    this.fc = new FileConnection("file:///".concat(String.valueOf(this.currDirName)).concat(String.valueOf(string)));
                    inputStream = this.fc.openInputStream();
                    long l = this.fc.fileSize();
                    int n = (int)l;
                    try {
                        byArray = new byte[n];
                        inputStream.read(byArray, 0, n);
                        if ((string.endsWith(".jpeg") || string.endsWith(".jpg") || string.endsWith(".JPG") || string.endsWith(".JPEG")) && byArray != null) {
                            image2 = this.iconJpeg(byArray);
                        }
                        if (byArray != null) {
                            image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
                        }
                        byArray = null;
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        byArray = null;
                        image = null;
                    }
                    byArray = null;
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (this.fc != null) {
                        this.fc.close();
                    }
                    System.gc();
                }
                catch (Exception exception) {
                    byArray = null;
                    image = null;
                }
                if (image == null && image2 != null) {
                    image = Image.createImage(image2);
                }
                image2 = null;
                if (image != null) {
                    if (this.Type == this.OPEN_IMAGE) {
                        this.canvas.newimage = true;
                        this.canvas.srcImage(image);
                    }
                    if (this.Type == this.ADD_ICON) {
                        this.canvas.srcIcon(image);
                    }
                    if (this.Type == this.ADD_FRAME) {
                        this.canvas.srcFrame(image);
                    }
                    image = null;
                    this.scan = false;
                }
                System.gc();
            }
        }
    }

    public void back() throws  {
        int n = this.currDirName.lastIndexOf(47, this.currDirName.length() - 2);
        this.currDirName = n != -1 ? this.currDirName.substring(0, n + 1) : "/";
        this.scan = false;
        FileBrowser.showCurrDir$(this);
    }

    public void scanIcons() throws  {
        if (!this.midlet.filltool) {
            this.scan = false;
            return;
        }
        this.scanin = true;
        if (this.scanindex < this.container.length) {
            if (this.container[this.scanindex].type == this.IS_IMAGE && !this.container[this.scanindex].mini) {
                this.container[this.scanindex].imgmini = FileBrowser.loadIcon$(this, String.valueOf(this.container[this.scanindex].dir).concat(String.valueOf(this.container[this.scanindex].name)));
            }
            if (this.container[this.scanindex].imgmini != null) {
                this.container[this.scanindex].mini = true;
            }
        } else {
            this.scan = false;
        }
        ++this.scanindex;
        this.scanin = false;
    }

    public Image iconJpeg(byte[] byArray) throws  {
        Image image;
        block5: {
            image = null;
            boolean bl = false;
            boolean bl2 = false;
            try {
                if (byArray == null || (byArray[0] & 0xFF) != 255 || (byArray[1] & 0xFF) != 216) break block5;
                int n = 2;
                do {
                    if ((byArray[++n] & 0xFF) != 255 || (byArray[n + 1] & 0xFF) != 216) continue;
                    bl = true;
                } while (!bl && (n < byArray.length - 2 || n < 5120));
                if (!bl || n >= 5120 || n >= byArray.length - 2) break block5;
                int n2 = n + 1;
                do {
                    if ((byArray[++n2] & 0xFF) != 255 || (byArray[n2 + 1] & 0xFF) != 217) continue;
                    bl2 = true;
                } while (!bl2 && (n2 < byArray.length - 2 || n2 < 20480));
                if (bl && bl2 && (n2 < byArray.length - 2 || n2 < 20480)) {
                    image = Image.createImage((byte[])byArray, (int)n, (int)(n2 - n + 2));
                    break block5;
                }
                return null;
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return image;
    }

    static Image loadIcon$(FileBrowser fileBrowser, String string) throws  {
        Image image = null;
        Image image2 = null;
        Object var4_4 = null;
        InputStream inputStream = null;
        byte[] byArray = null;
        try {
            fileBrowser.fc = new FileConnection("file:///".concat(String.valueOf(string)));
            inputStream = fileBrowser.fc.openInputStream();
            long l = fileBrowser.fc.fileSize();
            int n = (int)l;
            try {
                byArray = new byte[n];
                inputStream.read(byArray, 0, n);
                if ((string.endsWith(".jpeg") || string.endsWith(".jpg") || string.endsWith(".JPG") || string.endsWith(".JPEG")) && byArray != null) {
                    image = fileBrowser.iconJpeg(byArray);
                }
                if (image == null) {
                    image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
                }
                byArray = null;
                if (image != null) {
                    image2 = ImageEffects.resizeImage(image, fileBrowser.FSH, fileBrowser.FSH, true);
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                byArray = null;
            }
            byArray = null;
            image = null;
            if (inputStream != null) {
                inputStream.close();
            }
            if (fileBrowser.fc != null) {
                fileBrowser.fc.close();
            }
            System.gc();
        }
        catch (Exception exception) {
            byArray = null;
            return null;
        }
        return image2;
    }

    public void loadFont(int n, String string) throws  {
        try {
            FileConnection fileConnection = new FileConnection("file:///".concat(String.valueOf(string)));
            InputStream inputStream = fileConnection.openInputStream();
            this.midlet.createFont(n, inputStream);
            inputStream.close();
            fileConnection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void showCurrDir$(FileBrowser fileBrowser) throws  {
        String string;
        if (fileBrowser.Type == fileBrowser.OPEN_IMAGE) {
            fileBrowser.TH_FOLDER = fileBrowser.currDirName;
        }
        fileBrowser.scan = false;
        fileBrowser.scanin = false;
        fileBrowser.CMVI = 0;
        fileBrowser.menuIndex = 0;
        try {
            fileBrowser.menu.removeAllElements();
            int n = 0;
            if ("/".equals(fileBrowser.currDirName)) {
                fileBrowser.enumeration = FileSystemRegistry.listRoots();
            } else {
                string = fileBrowser.currDirName;
                fileBrowser.fc = new FileConnection("file:///".concat(String.valueOf(string)));
                fileBrowser.enumeration = fileBrowser.fc.list();
                fileBrowser.menu.addElement("..");
                ++n;
            }
            while (fileBrowser.enumeration.hasMoreElements()) {
                string = (String)fileBrowser.enumeration.nextElement();
                FileBrowser.dirIndexIsType$(fileBrowser, string);
                if (string.endsWith("/")) {
                    fileBrowser.menu.insertElementAt(string, n);
                    ++n;
                    continue;
                }
                if (!fileBrowser.dirIndexIsImage) continue;
                fileBrowser.menu.addElement(string);
            }
            if (fileBrowser.fc != null) {
                fileBrowser.fc.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        fileBrowser.menuSize = fileBrowser.menu.size();
        fileBrowser.container = new Container[fileBrowser.menuSize];
        int n = 0;
        while (n < fileBrowser.menuSize) {
            string = (String)fileBrowser.menu.elementAt(n);
            fileBrowser.container[n] = new Container(fileBrowser);
            fileBrowser.container[n].name = string;
            fileBrowser.container[n].dir = fileBrowser.currDirName;
            fileBrowser.container[n].imgmini = null;
            fileBrowser.container[n].mini = false;
            fileBrowser.container[n].type = string.equals("..") ? fileBrowser.IS_ROOT : (string.endsWith("/") ? fileBrowser.IS_FOLDER : (string.endsWith(".fnt") || string.endsWith(".ttf") || string.endsWith(".ttf.gz") || string.endsWith(".ttz") ? fileBrowser.IS_FONT : fileBrowser.IS_IMAGE));
            ++n;
        }
        fileBrowser.menu.removeAllElements();
        fileBrowser.scanindex = 0;
        fileBrowser.scan = true;
    }

    static void traverseDirectory$(FileBrowser fileBrowser, String string) throws  {
        int n;
        fileBrowser.currDirName = fileBrowser.currDirName.equals("/") ? string : (string.equals("..") ? ((n = fileBrowser.currDirName.lastIndexOf(47, fileBrowser.currDirName.length() - 2)) != -1 ? fileBrowser.currDirName.substring(0, n + 1) : "/") : String.valueOf(fileBrowser.currDirName).concat(String.valueOf(string)));
    }

    static void dirIndexIsType$(FileBrowser fileBrowser, String string) throws  {
        fileBrowser.dirIndexIsImage = false;
        fileBrowser.dirIndexIsFolder = false;
        if (string.endsWith(".jpg") || string.endsWith(".bmp") || string.endsWith(".png") || string.endsWith(".gif") || string.endsWith(".jpeg") || string.endsWith(".wbmp") || string.endsWith(".JPEG") || string.endsWith(".JPG") || string.endsWith(".fnt") || string.endsWith(".ttf") || string.endsWith(".ttf.gz") || string.endsWith(".ttz")) {
            fileBrowser.dirIndexIsImage = true;
        }
        if (string.endsWith("/")) {
            fileBrowser.dirIndexIsFolder = true;
        }
    }

    public void loadImage() throws  {
        try {
            this.folder = Image.createImage((String)"/res/folder.png");
            this.picture = Image.createImage((String)"/res/picture.png");
            this.root = Image.createImage((String)"/res/root.png");
            this.fontimg = Image.createImage((String)"/res/font.png");
        }
        catch (Exception exception) {
            return;
        }
    }

    public FileBrowser(PhotoEditorMIDlet photoEditorMIDlet, PhotoCanvas photoCanvas) throws  {
        this.midlet = photoEditorMIDlet;
        this.canvas = photoCanvas;
        this.currDirName = "/";
        this.menu = new Vector();
        this.linesFont = Font.getFont((int)32, (int)0, (int)8);
        this.FSH = this.linesFont.getHeight();
        this.FMH = this.linesFont.getHeight();
        this.TH_FOLDER = photoEditorMIDlet.patch_new;
        this.loadImage();
    }

    public final class Container {
        public String name;
        public String dir;
        public int type;
        public Image imgmini;
        public boolean mini;
        FileBrowser this$0;

        public Container(FileBrowser fileBrowser) throws  {
            this.this$0 = fileBrowser;
        }
    }
}

