/*
 * Decompiled with CFR 0.152.
 */
package com.java4ever.apime.io;

import java.io.IOException;

public class GZIP {
    private static final int FTEXT_MASK = 1;
    private static final int FHCRC_MASK = 2;
    private static final int FEXTRA_MASK = 4;
    private static final int FNAME_MASK = 8;
    private static final int FCOMMENT_MASK = 16;
    private static final int BTYPE_NONE = 0;
    private static final int BTYPE_FIXED = 1;
    private static final int BTYPE_DYNAMIC = 2;
    private static final int BTYPE_RESERVED = 3;
    private static final int MAX_BITS = 16;
    private static final int MAX_CODE_LITERALS = 287;
    private static final int MAX_CODE_DISTANCES = 31;
    private static final int MAX_CODE_LENGTHS = 18;
    private static final int EOB_CODE = 256;
    private static final int[] LENGTH_EXTRA_BITS = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0, 99, 99};
    private static final int[] LENGTH_VALUES = new int[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31, 35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258, 0, 0};
    private static final int[] DISTANCE_EXTRA_BITS = new int[]{0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13};
    private static final int[] DISTANCE_VALUES = new int[]{1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577};
    private static final int[] DYNAMIC_LENGTH_ORDER = new int[]{16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};
    private static int gzipIndex;
    private static int gzipByte;
    private static int gzipBit;

    public static byte[] inflate(byte[] byArray) throws IOException {
        gzipBit = 0;
        gzipByte = 0;
        gzipIndex = 0;
        if (GZIP.readBits(byArray, 16) != 35615 || GZIP.readBits(byArray, 8) != 8) {
            throw new IOException("Invalid GZIP format");
        }
        int n = GZIP.readBits(byArray, 8);
        gzipIndex += 6;
        if ((n & 4) != 0) {
            gzipIndex += GZIP.readBits(byArray, 16);
        }
        if ((n & 8) != 0) {
            while (byArray[gzipIndex++] != 0) {
            }
        }
        if ((n & 0x10) != 0) {
            while (byArray[gzipIndex++] != 0) {
            }
        }
        if ((n & 2) != 0) {
            gzipIndex += 2;
        }
        int n2 = gzipIndex;
        gzipIndex = byArray.length - 4;
        byte[] byArray2 = new byte[GZIP.readBits(byArray, 16) | GZIP.readBits(byArray, 16) << 16];
        int n3 = 0;
        gzipIndex = n2;
        int n4 = 0;
        int n5 = 0;
        do {
            int[] nArray;
            int[] nArray2;
            int n6;
            int n7;
            int n8;
            n4 = GZIP.readBits(byArray, 1);
            n5 = GZIP.readBits(byArray, 2);
            if (n5 == 0) {
                gzipBit = 0;
                int n9 = GZIP.readBits(byArray, 16);
                int n10 = GZIP.readBits(byArray, 16);
                System.arraycopy(byArray, gzipIndex, byArray2, n3, n9);
                gzipIndex += n9;
                n3 += n9;
                continue;
            }
            if (n5 == 2) {
                n8 = GZIP.readBits(byArray, 5) + 257;
                n7 = GZIP.readBits(byArray, 5) + 1;
                n6 = GZIP.readBits(byArray, 4) + 4;
                byte[] byArray3 = new byte[19];
                for (int i = 0; i < n6; ++i) {
                    byArray3[GZIP.DYNAMIC_LENGTH_ORDER[i]] = (byte)GZIP.readBits(byArray, 3);
                }
                int[] nArray3 = GZIP.createHuffmanTree(byArray3, 18);
                nArray2 = GZIP.createHuffmanTree(GZIP.decodeCodeLengths(byArray, nArray3, n8), n8 - 1);
                nArray = GZIP.createHuffmanTree(GZIP.decodeCodeLengths(byArray, nArray3, n7), n7 - 1);
            } else {
                byte[] byArray4 = new byte[288];
                for (n7 = 0; n7 < 144; ++n7) {
                    byArray4[n7] = 8;
                }
                for (n7 = 144; n7 < 256; ++n7) {
                    byArray4[n7] = 9;
                }
                for (n7 = 256; n7 < 280; ++n7) {
                    byArray4[n7] = 7;
                }
                for (n7 = 280; n7 < 288; ++n7) {
                    byArray4[n7] = 8;
                }
                nArray2 = GZIP.createHuffmanTree(byArray4, 287);
                byte[] byArray5 = new byte[32];
                for (n6 = 0; n6 < byArray5.length; ++n6) {
                    byArray5[n6] = 5;
                }
                nArray = GZIP.createHuffmanTree(byArray5, 31);
            }
            n8 = 0;
            n7 = 0;
            n6 = 0;
            while ((n8 = GZIP.readCode(byArray, nArray2)) != 256) {
                if (n8 > 256) {
                    int n11 = LENGTH_VALUES[n8 -= 257];
                    n7 = LENGTH_EXTRA_BITS[n8];
                    if (n7 > 0) {
                        n11 += GZIP.readBits(byArray, n7);
                    }
                    n8 = GZIP.readCode(byArray, nArray);
                    int n12 = DISTANCE_VALUES[n8];
                    n6 = DISTANCE_EXTRA_BITS[n8];
                    if (n6 > 0) {
                        n12 += GZIP.readBits(byArray, n6);
                    }
                    int n13 = n3 - n12;
                    while (n12 < n11) {
                        System.arraycopy(byArray2, n13, byArray2, n3, n12);
                        n3 += n12;
                        n11 -= n12;
                        n12 <<= 1;
                    }
                    System.arraycopy(byArray2, n13, byArray2, n3, n11);
                    n3 += n11;
                    continue;
                }
                byArray2[n3++] = (byte)n8;
            }
        } while (n4 == 0);
        return byArray2;
    }

    private static int readBits(byte[] byArray, int n) {
        int n2 = gzipBit == 0 ? (gzipByte = byArray[gzipIndex++] & 0xFF) : gzipByte >> gzipBit;
        for (int i = 8 - gzipBit; i < n; i += 8) {
            gzipByte = byArray[gzipIndex++] & 0xFF;
            n2 |= gzipByte << i;
        }
        gzipBit = gzipBit + n & 7;
        return n2 & (1 << n) - 1;
    }

    private static int readCode(byte[] byArray, int[] nArray) {
        int n = nArray[0];
        while (n >= 0) {
            if (gzipBit == 0) {
                gzipByte = byArray[gzipIndex++] & 0xFF;
            }
            n = (gzipByte & 1 << gzipBit) == 0 ? nArray[n >> 16] : nArray[n & 0xFFFF];
            gzipBit = gzipBit + 1 & 7;
        }
        return n & 0xFFFF;
    }

    private static byte[] decodeCodeLengths(byte[] byArray, int[] nArray, int n) {
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n2 < n) {
            n3 = GZIP.readCode(byArray, nArray);
            if (n3 >= 16) {
                int n5 = 0;
                if (n3 == 16) {
                    n5 = 3 + GZIP.readBits(byArray, 2);
                    n3 = n4;
                } else {
                    n5 = n3 == 17 ? 3 + GZIP.readBits(byArray, 3) : 11 + GZIP.readBits(byArray, 7);
                    n3 = 0;
                }
                while (n5-- > 0) {
                    byArray2[n2++] = (byte)n3;
                }
            } else {
                byArray2[n2++] = (byte)n3;
            }
            n4 = n3;
        }
        return byArray2;
    }

    private static int[] createHuffmanTree(byte[] byArray, int n) {
        int n2;
        int[] nArray = new int[17];
        for (n2 = 0; n2 < byArray.length; ++n2) {
            byte by = byArray[n2];
            nArray[by] = nArray[by] + 1;
        }
        n2 = 0;
        nArray[0] = 0;
        int[] nArray2 = new int[17];
        for (int i = 1; i <= 16; ++i) {
            nArray2[i] = n2 = n2 + nArray[i - 1] << 1;
        }
        int[] nArray3 = new int[(n << 1) + 16];
        int n3 = 1;
        for (int i = 0; i <= n; ++i) {
            byte by = byArray[i];
            if (by == 0) continue;
            byte by2 = by;
            nArray2[by2] = nArray2[by2] + 1;
            int n4 = 0;
            for (int j = by - 1; j >= 0; --j) {
                int n5;
                int n6 = n2 & 1 << j;
                if (n6 == 0) {
                    n5 = nArray3[n4] >> 16;
                    if (n5 == 0) {
                        int n7 = n4;
                        nArray3[n7] = nArray3[n7] | n3 << 16;
                        n4 = n3++;
                        continue;
                    }
                    n4 = n5;
                    continue;
                }
                n5 = nArray3[n4] & 0xFFFF;
                if (n5 == 0) {
                    int n8 = n4;
                    nArray3[n8] = nArray3[n8] | n3;
                    n4 = n3++;
                    continue;
                }
                n4 = n5;
            }
            nArray3[n4] = Integer.MIN_VALUE | i;
        }
        return nArray3;
    }
}

