/*
 * Decompiled with CFR 0.152.
 */
package ntr.ttme;

import javax.microedition.lcdui.Graphics;
import ntr.ttme.DoublePolygon;
import ntr.ttme.IntPolygon;
import ntr.ttme.Polyline;

public final class BezierCurveRenderer {
    public static final int DEFAULT_CASTELJAU_RECURSION_DEPTH = 5;
    int recursionDepth;
    IntPolygon points;
    DoublePolygon worldPoints;

    public BezierCurveRenderer() {
        this.recursionDepth = 5;
        this.points = new IntPolygon();
        this.worldPoints = new DoublePolygon();
    }

    public BezierCurveRenderer(int depth) {
        this.recursionDepth = depth;
        this.points = new IntPolygon();
        this.worldPoints = new DoublePolygon();
    }

    public int getRecursionDepth() {
        return this.recursionDepth;
    }

    public void renderBezier(Graphics g, int p0x, int p0y, int p1x, int p1y, int p2x, int p2y, int p3x, int p3y, int curveColor) {
        this.calculateBezier(p0x, p0y, p1x, p1y, p2x, p2y, p3x, p3y);
        g.setColor(curveColor);
        Polyline.draw(g, this.points.xpoints, this.points.ypoints, this.points.npoints);
    }

    public void calculateBezier(int p0x, int p0y, int p1x, int p1y, int p2x, int p2y, int p3x, int p3y) {
        this.points.npoints = 0;
        this.points.addPoint(p0x, p0y);
        this.casteljauBezierSubDivision(p0x, p0y, p1x, p1y, p2x, p2y, p3x, p3y, this.recursionDepth);
    }

    private void casteljauBezierSubDivision(int p0x, int p0y, int p1x, int p1y, int p2x, int p2y, int p3x, int p3y, int depth) {
        if (depth == 0) {
            this.points.addPoint(p3x, p3y);
        } else {
            int q0x = (p0x + p1x) / 2;
            int q0y = (p0y + p1y) / 2;
            int q1x = (p1x + p2x) / 2;
            int q1y = (p1y + p2y) / 2;
            int q2x = (p2x + p3x) / 2;
            int q2y = (p2y + p3y) / 2;
            int r0x = (q0x + q1x) / 2;
            int r0y = (q0y + q1y) / 2;
            int r1x = (q1x + q2x) / 2;
            int r1y = (q1y + q2y) / 2;
            int r2x = (r0x + r1x) / 2;
            int r2y = (r0y + r1y) / 2;
            this.casteljauBezierSubDivision(p0x, p0y, q0x, q0y, r0x, r0y, r2x, r2y, depth - 1);
            this.casteljauBezierSubDivision(r2x, r2y, r1x, r1y, q2x, q2y, p3x, p3y, depth - 1);
        }
    }

    public void worldCalculateBezier(double p0x, double p0y, double p1x, double p1y, double p2x, double p2y, double p3x, double p3y) {
        this.worldPoints.clear();
        this.worldPoints.addPoint(p0x, p0y);
        this.worldCasteljauBezierSubDivision(p0x, p0y, p1x, p1y, p2x, p2y, p3x, p3y, this.recursionDepth);
    }

    private void worldCasteljauBezierSubDivision(double p0x, double p0y, double p1x, double p1y, double p2x, double p2y, double p3x, double p3y, int depth) {
        if (depth == 0) {
            this.worldPoints.addPoint(p3x, p3y);
        } else {
            double q0x = (p0x + p1x) / 2.0;
            double q0y = (p0y + p1y) / 2.0;
            double q1x = (p1x + p2x) / 2.0;
            double q1y = (p1y + p2y) / 2.0;
            double q2x = (p2x + p3x) / 2.0;
            double q2y = (p2y + p3y) / 2.0;
            double r0x = (q0x + q1x) / 2.0;
            double r0y = (q0y + q1y) / 2.0;
            double r1x = (q1x + q2x) / 2.0;
            double r1y = (q1y + q2y) / 2.0;
            double r2x = (r0x + r1x) / 2.0;
            double r2y = (r0y + r1y) / 2.0;
            this.worldCasteljauBezierSubDivision(p0x, p0y, q0x, q0y, r0x, r0y, r2x, r2y, depth - 1);
            this.worldCasteljauBezierSubDivision(r2x, r2y, r1x, r1y, q2x, q2y, p3x, p3y, depth - 1);
        }
    }
}

