/*
 * Decompiled with CFR 0.152.
 */
package ntr.ttme;

import ntr.ttme.DoubleRectangle;

public final class DoublePolygon {
    public static final int DEFAULT_INITIAL_CAPACITY = 4;
    int numberOfPoints;
    double[] xPoints;
    double[] yPoints;
    DoubleRectangle bounds = null;

    public DoublePolygon() {
        this(4);
    }

    public DoublePolygon(int initialCapacity) {
        this.xPoints = new double[initialCapacity];
        this.yPoints = new double[initialCapacity];
    }

    public DoublePolygon(double[] xPoints, double[] yPoints, int numberOfPoints) {
        this(numberOfPoints);
        System.arraycopy(xPoints, 0, this.xPoints, 0, numberOfPoints);
        System.arraycopy(yPoints, 0, this.yPoints, 0, numberOfPoints);
        this.numberOfPoints = numberOfPoints;
    }

    public int getNumberOfPoints() {
        return this.numberOfPoints;
    }

    public double getPointX(int index) {
        return this.xPoints[index];
    }

    public double getPointY(int index) {
        return this.yPoints[index];
    }

    public void clear() {
        this.numberOfPoints = 0;
    }

    public void setPoint(int i, double x, double y) {
        this.xPoints[i] = x;
        this.yPoints[i] = y;
    }

    public void ensureCapacity(int required) {
        if (this.xPoints.length < required || this.yPoints.length < required) {
            int newSize = this.determineNewSize(required);
            double[] newArray = new double[newSize];
            if (this.numberOfPoints > 0) {
                System.arraycopy(this.xPoints, 0, newArray, 0, this.numberOfPoints);
            }
            this.xPoints = newArray;
            newArray = new double[newSize];
            if (this.numberOfPoints > 0) {
                System.arraycopy(this.yPoints, 0, newArray, 0, this.numberOfPoints);
            }
            this.yPoints = newArray;
        }
    }

    private int determineNewSize(int n) {
        int result = Math.max(this.numberOfPoints, 1);
        while (result <= n) {
            result *= 2;
        }
        return result;
    }

    public void ensureFreeSpaceOnHead(int requiredFree) {
        int required = requiredFree + this.numberOfPoints;
        if (this.xPoints.length < required || this.yPoints.length < required) {
            int newSize = this.determineNewSize(required);
            double[] newArray = new double[newSize];
            if (this.numberOfPoints > 0) {
                System.arraycopy(this.xPoints, 0, newArray, requiredFree, this.numberOfPoints);
            }
            this.xPoints = newArray;
            newArray = new double[newSize];
            if (this.numberOfPoints > 0) {
                System.arraycopy(this.yPoints, 0, newArray, requiredFree, this.numberOfPoints);
            }
            this.yPoints = newArray;
        } else if (this.numberOfPoints > 0) {
            System.arraycopy(this.xPoints, 0, this.xPoints, requiredFree, this.numberOfPoints);
            System.arraycopy(this.yPoints, 0, this.yPoints, requiredFree, this.numberOfPoints);
        }
        this.numberOfPoints = required;
    }

    public void ensureFreeSpaceOnTail(int requiredFree) {
        this.ensureCapacity(this.numberOfPoints + requiredFree);
        this.numberOfPoints += requiredFree;
    }

    public void translate(double deltaX, double deltaY) {
        int i = 0;
        while (i < this.numberOfPoints) {
            if (this.xPoints[i] != Double.MAX_VALUE) {
                int n = i;
                this.xPoints[n] = this.xPoints[n] + deltaX;
            }
            int n = i++;
            this.yPoints[n] = this.yPoints[n] + deltaY;
        }
        if (this.bounds != null) {
            this.bounds.translate(deltaX, deltaY);
        }
    }

    public void translateCurves(double deltaX, double deltaY) {
        int i = 0;
        while (i < this.numberOfPoints) {
            if (this.xPoints[i] != Double.MAX_VALUE) {
                int n = i;
                this.xPoints[n] = this.xPoints[n] + deltaX;
                int n2 = i;
                this.yPoints[n2] = this.yPoints[n2] + deltaY;
            }
            ++i;
        }
        if (this.bounds != null) {
            this.bounds.translate(deltaX, deltaY);
        }
    }

    void calculateBounds() {
        double boundsMinX = Double.POSITIVE_INFINITY;
        double boundsMinY = Double.POSITIVE_INFINITY;
        double boundsMaxX = Double.NEGATIVE_INFINITY;
        double boundsMaxY = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.numberOfPoints) {
            double x = this.xPoints[i];
            if (x != Double.MAX_VALUE) {
                boundsMinX = Math.min(boundsMinX, x);
                boundsMaxX = Math.max(boundsMaxX, x);
                double y = this.yPoints[i];
                boundsMinY = Math.min(boundsMinY, y);
                boundsMaxY = Math.max(boundsMaxY, y);
            }
            ++i;
        }
        this.bounds = new DoubleRectangle(boundsMinX, boundsMinY, boundsMaxX - boundsMinX, boundsMaxY - boundsMinY);
    }

    void recalculateBounds() {
        double boundsMinX = Double.POSITIVE_INFINITY;
        double boundsMinY = Double.POSITIVE_INFINITY;
        double boundsMaxX = Double.NEGATIVE_INFINITY;
        double boundsMaxY = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.numberOfPoints) {
            double x = this.xPoints[i];
            if (x != Double.MAX_VALUE) {
                boundsMinX = Math.min(boundsMinX, x);
                boundsMaxX = Math.max(boundsMaxX, x);
                double y = this.yPoints[i];
                boundsMinY = Math.min(boundsMinY, y);
                boundsMaxY = Math.max(boundsMaxY, y);
            }
            ++i;
        }
        if (this.bounds == null) {
            this.bounds = new DoubleRectangle(boundsMinX, boundsMinY, boundsMaxX - boundsMinX, boundsMaxY - boundsMinY);
        } else {
            this.bounds.setX(boundsMinX);
            this.bounds.setY(boundsMinY);
            this.bounds.setWidth(boundsMaxX - boundsMinX);
            this.bounds.setHeight(boundsMaxY - boundsMinY);
        }
    }

    void updateBounds(double x, double y) {
        if (x != Double.MAX_VALUE) {
            this.bounds.setX(Math.min(this.bounds.getX(), x));
            this.bounds.setWidth(Math.max(this.bounds.getWidth(), x - this.bounds.getX()));
            this.bounds.setY(Math.min(this.bounds.getY(), y));
            this.bounds.setHeight(Math.max(this.bounds.getHeight(), y - this.bounds.getY()));
        }
    }

    public void addPoint(double x, double y) {
        if (this.numberOfPoints == this.xPoints.length) {
            double[] tmp = new double[this.numberOfPoints * 2];
            System.arraycopy(this.xPoints, 0, tmp, 0, this.numberOfPoints);
            this.xPoints = tmp;
            tmp = new double[this.numberOfPoints * 2];
            System.arraycopy(this.yPoints, 0, tmp, 0, this.numberOfPoints);
            this.yPoints = tmp;
        }
        this.xPoints[this.numberOfPoints] = x;
        this.yPoints[this.numberOfPoints] = y;
        ++this.numberOfPoints;
        if (this.bounds != null) {
            this.updateBounds(x, y);
        }
    }

    public DoubleRectangle getBounds() {
        if (this.bounds == null) {
            this.calculateBounds();
        }
        return this.bounds;
    }

    public boolean contains(double x, double y) {
        if (this.getBounds().contains(x, y)) {
            int hits = 0;
            double ySave = 0.0;
            int i = 0;
            while (i < this.numberOfPoints && this.yPoints[i] == y) {
                ++i;
            }
            int n = 0;
            while (n < this.numberOfPoints) {
                int j = (i + 1) % this.numberOfPoints;
                double dx = this.xPoints[j] - this.xPoints[i];
                double dy = this.yPoints[j] - this.yPoints[i];
                if (dy != 0.0) {
                    double s;
                    double rx = x - this.xPoints[i];
                    double ry = y - this.yPoints[i];
                    if (this.yPoints[j] == y && this.xPoints[j] >= x) {
                        ySave = this.yPoints[i];
                    }
                    if (this.yPoints[i] == y && this.xPoints[i] >= x && ySave > y != this.yPoints[j] > y) {
                        --hits;
                    }
                    if ((s = ry / dy) >= 0.0 && s <= 1.0 && s * dx >= rx) {
                        ++hits;
                    }
                }
                i = j;
                ++n;
            }
            return hits % 2 != 0;
        }
        return false;
    }

    public static final boolean lineHit(double x1, double y1, double x2, double y2, double hx, double hy, double epsilon) {
        double tmp;
        boolean hit = false;
        if (y1 > y2) {
            tmp = x1;
            x1 = x2;
            x2 = tmp;
            tmp = y1;
            y1 = y2;
            y2 = tmp;
        }
        if (hy >= y1 && hy <= y2) {
            if (y1 == y2) {
                double dx = hx - x1;
                hit = Math.abs(dx) <= epsilon;
            } else {
                double dx = (x2 - x1) * ((hy - y1) / (y2 - y1));
                boolean bl = hit = Math.abs(hx - (x1 + dx)) <= epsilon;
            }
        }
        if (!hit) {
            if (x1 > x2) {
                tmp = x1;
                x1 = x2;
                x2 = tmp;
                tmp = y1;
                y1 = y2;
                y2 = tmp;
            }
            if (hx >= x1 && hx <= x2) {
                double dy;
                hit = x1 == x2 ? Math.abs(dy = y2 - hy) <= epsilon : Math.abs(y2 - (dy = (y2 - y1) * ((x2 - hx) / (x2 - x1))) - hy) <= epsilon;
            }
        }
        return hit;
    }

    public boolean polygonWireHit(double wx, double wy, double epsilon) {
        boolean hit = false;
        int prev = this.numberOfPoints - 1;
        int i = 0;
        while (!hit && i < this.numberOfPoints) {
            hit = DoublePolygon.lineHit(this.xPoints[prev], this.yPoints[prev], this.xPoints[i], this.yPoints[i], wx, wy, epsilon);
            prev = i++;
        }
        return hit;
    }

    public boolean polylineWireHit(double wx, double wy, double epsilon) {
        boolean hit = false;
        int prev = 0;
        int i = 1;
        while (!hit && i < this.numberOfPoints) {
            hit = DoublePolygon.lineHit(this.xPoints[prev], this.yPoints[prev], this.xPoints[i], this.yPoints[i], wx, wy, epsilon);
            prev = i++;
        }
        return hit;
    }

    public boolean multiContourWireHit(double wx, double wy, double epsilon) {
        boolean hit = false;
        int prev = 0;
        int i = 1;
        while (!hit && i < this.numberOfPoints) {
            if (this.xPoints[prev] != Double.MAX_VALUE && this.xPoints[i] != Double.MAX_VALUE) {
                hit = DoublePolygon.lineHit(this.xPoints[prev], this.yPoints[prev], this.xPoints[i], this.yPoints[i], wx, wy, epsilon);
            }
            prev = i++;
        }
        return hit;
    }

    public void rotateAround(double cx, double cy, double angle) {
        boolean lookBack = false;
        int i = 0;
        while (i < this.numberOfPoints) {
            if (this.xPoints[i] == Double.MAX_VALUE) {
                boolean foundInline = false;
                if (i > 0 && this.xPoints[i - 1] != Double.MAX_VALUE) {
                    this.yPoints[i] = this.yPoints[i - 1];
                    foundInline = true;
                }
                if (!foundInline && i < this.numberOfPoints - 1 && this.xPoints[i + 1] != Double.MAX_VALUE) {
                    lookBack = true;
                    foundInline = true;
                }
            } else {
                double cdx = this.xPoints[i] - cx;
                double cdy = this.yPoints[i] - cy;
                this.xPoints[i] = cx + cdx * Math.cos(angle) - cdy * Math.sin(angle);
                this.yPoints[i] = cy + cdx * Math.sin(angle) + cdy * Math.cos(angle);
                if (lookBack) {
                    this.yPoints[i - 1] = this.yPoints[i];
                    lookBack = false;
                }
            }
            ++i;
        }
    }

    public void rotateCurvesAround(double cx, double cy, double angle) {
        int i = 0;
        while (i < this.numberOfPoints) {
            if (this.xPoints[i] != Double.MAX_VALUE) {
                double cdx = this.xPoints[i] - cx;
                double cdy = this.yPoints[i] - cy;
                this.xPoints[i] = cx + cdx * Math.cos(angle) - cdy * Math.sin(angle);
                this.yPoints[i] = cy + cdx * Math.sin(angle) + cdy * Math.cos(angle);
            }
            ++i;
        }
    }

    public void resize(double origX, double origY, double dx, double dy, double xScale, double yScale) {
        this.recalculateBounds();
        double distX = this.bounds.getX() - origX;
        origX += distX * xScale;
        double distY = this.bounds.getY() - origY;
        origY += distY * yScale;
        int i = 0;
        while (i < this.numberOfPoints) {
            if (this.xPoints[i] != Double.MAX_VALUE) {
                distX = this.xPoints[i] - this.bounds.getX();
                this.xPoints[i] = dx + (origX + distX * xScale);
            }
            distY = this.yPoints[i] - this.bounds.getY();
            this.yPoints[i] = dy + (origY + distY * yScale);
            ++i;
        }
    }

    public void resizeCurves(double origX, double origY, double dx, double dy, double xScale, double yScale) {
        this.recalculateBounds();
        double distX = this.bounds.getX() - origX;
        origX += distX * xScale;
        double distY = this.bounds.getY() - origY;
        origY += distY * yScale;
        int i = 0;
        while (i < this.numberOfPoints) {
            if (this.xPoints[i] != Double.MAX_VALUE) {
                distX = this.xPoints[i] - this.bounds.getX();
                this.xPoints[i] = dx + (origX + distX * xScale);
                distY = this.yPoints[i] - this.bounds.getY();
                this.yPoints[i] = dy + (origY + distY * yScale);
            }
            ++i;
        }
    }

    public void horizontalPush(double baseY, double angle) {
        double sinA = Math.sin(-angle);
        int i = 0;
        while (i < this.numberOfPoints) {
            if (this.xPoints[i] != Double.MAX_VALUE) {
                double distY = this.yPoints[i] - baseY;
                int n = i;
                this.xPoints[n] = this.xPoints[n] + distY * sinA;
            }
            ++i;
        }
    }

    public void horizontalPushCurves(double baseY, double angle) {
        double sinA = Math.sin(-angle);
        int i = 0;
        while (i < this.numberOfPoints) {
            if (this.xPoints[i] != Double.MAX_VALUE) {
                double distY = this.yPoints[i] - baseY;
                int n = i;
                this.xPoints[n] = this.xPoints[n] + distY * sinA;
            }
            ++i;
        }
    }

    public void verticalPush(double baseX, double angle) {
        boolean lookBack = false;
        double sinA = Math.sin(angle);
        int i = 0;
        while (i < this.numberOfPoints) {
            if (this.xPoints[i] == Double.MAX_VALUE) {
                boolean foundInline = false;
                if (i > 0 && this.xPoints[i - 1] != Double.MAX_VALUE) {
                    this.yPoints[i] = this.yPoints[i - 1];
                    foundInline = true;
                }
                if (!foundInline && i < this.numberOfPoints - 1 && this.xPoints[i + 1] != Double.MAX_VALUE) {
                    lookBack = true;
                    foundInline = true;
                }
            } else {
                double distX = this.xPoints[i] - baseX;
                int n = i;
                this.yPoints[n] = this.yPoints[n] + sinA * distX;
                if (lookBack) {
                    this.yPoints[i - 1] = this.yPoints[i];
                    lookBack = false;
                }
            }
            ++i;
        }
    }

    public void verticalPushCurves(double baseX, double angle) {
        double sinA = Math.sin(angle);
        int i = 0;
        while (i < this.numberOfPoints) {
            if (this.xPoints[i] != Double.MAX_VALUE) {
                double distX = this.xPoints[i] - baseX;
                int n = i;
                this.yPoints[n] = this.yPoints[n] + distX * sinA;
            }
            ++i;
        }
    }

    public void reverse() {
        if (this.numberOfPoints > 1) {
            int i = 0;
            while (i < this.numberOfPoints / 2) {
                int j = this.numberOfPoints - 1 - i;
                double tmp = this.xPoints[i];
                this.xPoints[i] = this.xPoints[j];
                this.xPoints[j] = tmp;
                tmp = this.yPoints[i];
                this.yPoints[i] = this.yPoints[j];
                this.yPoints[j] = tmp;
                ++i;
            }
        }
    }

    public boolean containsAllPointsOf(DoublePolygon p) {
        int i = 0;
        while (i < p.numberOfPoints) {
            if (p.xPoints[i] != Double.MAX_VALUE && !this.contains(p.xPoints[i], p.yPoints[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public DoublePolygon duplicate() {
        DoublePolygon result = new DoublePolygon(this.xPoints, this.yPoints, this.numberOfPoints);
        if (this.bounds != null) {
            result.bounds = new DoubleRectangle(this.bounds);
        }
        return result;
    }
}

