/*
 * Decompiled with CFR 0.152.
 */
package ntr.ttme;

import ntr.ttme.DoubleMatrix3x3;
import ntr.ttme.Transformable;

public abstract class MatrixTransformationAdapter
implements Transformable {
    protected boolean modified;
    protected DoubleMatrix3x3 ctm = DoubleMatrix3x3.createIdentityMatrix();

    protected MatrixTransformationAdapter() {
    }

    public void translate(double dx, double dy) {
        this.ctm.rightMul(DoubleMatrix3x3.translate(dx, dy));
        this.modified = true;
    }

    public void rotate(double angle) {
        this.ctm.rightMul(DoubleMatrix3x3.rotate(angle));
        this.modified = true;
    }

    public void rotate(double angle, double x, double y) {
        this.ctm.rightMul(DoubleMatrix3x3.rotate(angle, x, y));
        this.modified = true;
    }

    public void scale(double xFactor, double yFactor) {
        this.ctm.rightMul(DoubleMatrix3x3.scale(xFactor, yFactor));
        this.modified = true;
    }

    public void scale(double xFactor, double yFactor, double originX, double originY, double dx, double dy) {
        this.ctm.rightMul(DoubleMatrix3x3.scale(xFactor, yFactor, originX, originY, dx, dy));
        this.modified = true;
    }

    public void skew(double angle) {
        this.ctm.rightMul(DoubleMatrix3x3.skew(angle));
        this.modified = true;
    }

    public void skew(double angle, double originX, double originY) {
        this.ctm.rightMul(DoubleMatrix3x3.skew(angle, originX, originY));
        this.modified = true;
    }
}

