/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.microedition.amms.control.tuner.RDSControl;
import javax.microedition.amms.control.tuner.TunerControl;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.RecordControl;
import javax.microedition.midlet.MIDlet;

public class GUI
extends Canvas
implements PlayerListener,
Runnable {
    public String chanellName;
    public String radioText;
    public String programType;
    public Date localDate;
    public boolean debugMode;
    private boolean recStarted = false;
    private RDSControl rdsc;
    private TunerControl tc;
    private Player radioPlayer;
    private int manualSeek;
    private Font fntEnabled;
    private Font fntDisabled;
    private Font fntSmall;
    private Font fntInfo;
    private Font fntMenu;
    private int colEnabled = 40960;
    private int colDisabled = 0x505050;
    private int colBar = 0xFF8000;
    private int colCommandEnabled = 36864;
    private int colCommandDisabled = 5261898;
    private int colMenuBg = 2101296;
    private int colMenuBorder = 0x707070;
    private int colMenuSelector = 0x303000;
    private int menuWidth = 0;
    private int menuHeight = 0;
    private int tmpMenuW = 0;
    private int tmpMenuH = 0;
    private int menuAnim = 0;
    private int menuPos = 0;
    private boolean widthChngDone;
    private boolean heightChngDone;
    private boolean menuVisible = false;
    private int selectorPos = 0;
    private int dbgcodeStep = 0;
    private RecordManager rm;
    private Thread thr;
    private int topBorder;
    private MIDlet midlet;
    private RecordControl rc;
    private OutputStream os;
    private int stereoMode = 1;
    private Player tmpPlayer;
    Command[] commands = new Command[]{new Command(true, "Record"), new Command(false, "Play last rec"), new Command(true, "Stereo"), new Command(true, "Enable AS"), new Command(true, "Switch to AM"), new Command(true, "Enable TA"), new Command(true, "Exit")};
    volatile int freq;
    volatile boolean finish = false;

    public GUI(MIDlet midlet) {
        this.midlet = midlet;
        this.rm = new RecordManager();
        this.setFullScreenMode(true);
        this.fntEnabled = Font.getFont((int)32, (int)1, (int)16);
        this.fntDisabled = Font.getFont((int)32, (int)0, (int)0);
        this.fntSmall = Font.getFont((int)32, (int)0, (int)8);
        this.fntInfo = Font.getFont((int)64, (int)1, (int)8);
        this.fntMenu = Font.getFont((int)0, (int)0, (int)8);
        this.topBorder = this.fntEnabled.getHeight() + 4;
        this.recalcMenu();
        try {
            this.radioPlayer = Manager.createPlayer((String)"capture://radio?f=103.9M&st=mono");
            this.radioPlayer.realize();
            this.tc = (TunerControl)this.radioPlayer.getControl("javax.microedition.amms.control.tuner.TunerControl");
            this.freq = this.tc.getFrequency();
            this.rdsc = (RDSControl)this.radioPlayer.getControl("javax.microedition.amms.control.tuner.RDSControl");
            this.updateRDS();
            this.rdsc.setAutomaticSwitching(false);
            this.tc.setStereoMode(1);
            this.radioPlayer.addPlayerListener((PlayerListener)this);
            this.radioPlayer.start();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
        this.thr = new Thread(this);
        this.thr.start();
    }

    public void updateRDS() {
        this.chanellName = this.rdsc.getPS();
        this.programType = this.rdsc.getPTYString(true);
        this.radioText = this.rdsc.getRT();
        this.localDate = this.rdsc.getCT();
    }

    private String formatFreq(int freq) {
        StringBuffer tmp = new StringBuffer("0.00");
        tmp = new StringBuffer(String.valueOf(freq / 100));
        tmp.insert(tmp.length() - 2, '.');
        if (tmp.length() < 4) {
            tmp.insert(0, "0");
        }
        return tmp.toString();
    }

    public void paint(Graphics g) {
        int endPos = 5;
        g.fillRect(0, 0, g.getClipWidth(), g.getClipHeight());
        g.setColor(this.tc.getStereoMode() != 1 ? this.colEnabled : this.colDisabled);
        g.setFont(this.tc.getStereoMode() != 1 ? this.fntEnabled : this.fntDisabled);
        g.drawString("STEREO", endPos, 5, 20);
        g.setColor(this.rdsc.getAutomaticSwitching() ? this.colEnabled : this.colDisabled);
        g.setFont(this.rdsc.getAutomaticSwitching() ? this.fntEnabled : this.fntDisabled);
        g.drawString("AS", endPos += this.fntEnabled.stringWidth("STEREO") + 5, 5, 20);
        g.setColor(this.rdsc.isRDSSignal() ? this.colEnabled : this.colDisabled);
        g.setFont(this.rdsc.isRDSSignal() ? this.fntEnabled : this.fntDisabled);
        g.drawString("RDS", endPos += this.fntEnabled.stringWidth("AS") + 5, 5, 20);
        g.setColor(this.rdsc.getAutomaticTA() ? this.colEnabled : this.colDisabled);
        g.setFont(this.rdsc.getAutomaticTA() ? this.fntEnabled : this.fntDisabled);
        g.drawString("TA", endPos += this.fntEnabled.stringWidth("RDS") + 5, 5, 20);
        endPos += this.fntEnabled.stringWidth("TA") + 5;
        g.setColor(this.colEnabled);
        g.setFont(this.fntEnabled);
        g.drawString(this.tc.getModulation().toUpperCase(), g.getClipWidth() - 5, 5, 24);
        g.setColor(this.colBar);
        g.fillRect(20, g.getClipHeight() - 30, g.getClipWidth() - 40, 5);
        g.setColor(0x303030);
        g.drawRect(20, g.getClipHeight() - 30, g.getClipWidth() - 40, 5);
        g.setFont(this.fntSmall);
        g.setColor(this.colBar);
        g.drawString(this.formatFreq(this.tc.getMinFreq(this.tc.getModulation())), 10, g.getClipHeight() - 20, 20);
        g.drawString(this.formatFreq(this.tc.getMaxFreq(this.tc.getModulation())), g.getClipWidth() - 10, g.getClipHeight() - 20, 24);
        this.selectorPos = (this.tc.getFrequency() - this.tc.getMinFreq(this.tc.getModulation())) * (g.getClipWidth() - 40) / (this.tc.getMaxFreq(this.tc.getModulation()) - this.tc.getMinFreq(this.tc.getModulation())) + 20;
        g.setColor(this.colBar);
        g.drawLine(this.selectorPos, g.getClipHeight() - 33, this.selectorPos, g.getClipHeight() - 22);
        g.drawString(this.formatFreq(this.freq), this.selectorPos, g.getClipHeight() - 37, 33);
        g.setFont(this.fntInfo);
        g.setColor(0xE0E0E0);
        g.drawString("Stantion: " + this.chanellName, 5, this.topBorder + this.fntInfo.getHeight() * 1, 20);
        g.drawString("Message:" + this.radioText, 5, this.topBorder + this.fntInfo.getHeight() * 2, 20);
        g.drawString("Genre:" + this.programType, 5, this.topBorder + this.fntInfo.getHeight() * 3, 20);
        g.drawString("Date:" + this.localDate, 5, this.topBorder + this.fntInfo.getHeight() * 4, 20);
        if (this.debugMode) {
            // empty if block
        }
        if (this.menuAnim != 0) {
            g.setColor(this.colMenuBg);
            g.fillRect(0, g.getClipHeight() - this.tmpMenuH, this.tmpMenuW, this.tmpMenuH);
            g.setColor(this.colMenuBorder);
            g.drawRect(0, g.getClipHeight() - this.tmpMenuH, this.tmpMenuW, this.tmpMenuH);
        }
        if (this.menuVisible) {
            g.setColor(this.colMenuBg);
            g.fillRect(0, g.getClipHeight() - this.menuHeight - 2, this.menuWidth, this.menuHeight);
            g.setColor(this.colMenuSelector);
            g.fillRect(0, g.getClipHeight() - (this.commands.length - this.menuPos) * this.fntMenu.getHeight() - 2, this.menuWidth, this.fntMenu.getHeight());
            g.setColor(this.colMenuBorder);
            g.drawRect(0, g.getClipHeight() - this.menuHeight - 2, this.menuWidth, this.menuHeight);
            for (int i = 0; i < this.commands.length; ++i) {
                g.setColor(this.commands[i].enabled ? this.colCommandEnabled : this.colCommandDisabled);
                g.drawString(this.commands[i].label, 5, g.getClipHeight() - (this.commands.length - i) * this.fntMenu.getHeight() - 2, 20);
            }
        }
    }

    protected final synchronized void keyPressed(int keyCode) {
        switch (keyCode) {
            case -6: {
                this.changeMenuState();
                this.dbgcodeStep = 0;
                break;
            }
            case -7: {
                this.dbgcodeStep = 0;
                break;
            }
            case -3: {
                if (!this.menuVisible) {
                    this.freq -= 200;
                }
                this.dbgcodeStep = 0;
                break;
            }
            case -4: {
                if (!this.menuVisible) {
                    this.freq += 200;
                }
                this.dbgcodeStep = 0;
                break;
            }
            case -1: {
                if (this.menuVisible) {
                    --this.menuPos;
                    if (this.menuPos < 0) {
                        this.menuPos = this.commands.length - 1;
                    }
                }
                this.dbgcodeStep = 0;
                break;
            }
            case -2: {
                if (this.menuVisible) {
                    ++this.menuPos;
                    this.menuPos %= this.commands.length;
                }
                this.dbgcodeStep = 0;
                break;
            }
            case -5: {
                if (this.menuVisible) {
                    this.commandAction(this.menuPos);
                    this.changeMenuState();
                }
            }
            case 51: {
                this.dbgcodeStep = 1;
                break;
            }
            case 55: {
                if (this.dbgcodeStep == 1) {
                    this.dbgcodeStep = 2;
                    break;
                }
                this.dbgcodeStep = 0;
                break;
            }
            case 57: {
                if (this.dbgcodeStep == 2) {
                    this.dbgcodeStep = 3;
                    break;
                }
                this.dbgcodeStep = 0;
                break;
            }
            case 49: {
                if (this.dbgcodeStep == 3) {
                    this.debugMode = true;
                    break;
                }
                this.dbgcodeStep = 0;
                break;
            }
            default: {
                System.out.println(keyCode);
                this.dbgcodeStep = 0;
            }
        }
        this.recalcMenu();
        this.setFreq();
    }

    protected void keyReleased(int keyCode) {
        if (keyCode == -3 || keyCode == -4) {
            this.manualSeek = 0;
        }
    }

    protected void keyRepeated(int keyCode) {
        if (!this.menuVisible) {
            if (keyCode == -4) {
                ++this.manualSeek;
            }
            if (keyCode == -3) {
                this.manualSeek += -1;
            }
        }
    }

    protected void pointerDragged(int x, int y) {
    }

    protected void pointerPressed(int x, int y) {
    }

    protected void pointerReleased(int x, int y) {
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if (event.equals("RDS_NEW_DATA")) {
            this.updateRDS();
        }
    }

    void setFreq() {
        if (this.freq > this.tc.getMaxFreq(this.tc.getModulation())) {
            this.freq = this.tc.getMinFreq(this.tc.getModulation());
        }
        if (this.freq < this.tc.getMinFreq(this.tc.getModulation())) {
            this.freq = this.tc.getMaxFreq(this.tc.getModulation());
        }
        this.tc.setFrequency(this.freq, this.tc.getModulation());
        this.updateRDS();
    }

    public void run() {
        while (!this.finish) {
            if (this.menuAnim != 0) {
                if (this.tmpMenuW < this.menuWidth && this.tmpMenuW >= 0) {
                    this.tmpMenuW += this.menuAnim * 2;
                } else {
                    this.widthChngDone = true;
                }
                if (this.tmpMenuH < this.menuHeight && this.tmpMenuH >= 0) {
                    this.tmpMenuH += this.menuAnim * 2;
                } else {
                    this.heightChngDone = true;
                }
            }
            if (this.heightChngDone && this.widthChngDone && this.menuAnim > 0) {
                this.menuAnim = 0;
                this.menuVisible = true;
            }
            this.freq += this.manualSeek * 200;
            this.setFreq();
            this.repaint();
            Thread.yield();
        }
    }

    private void recalcMenu() {
        for (int i = 0; i < this.commands.length; ++i) {
            if (this.menuWidth >= this.fntMenu.stringWidth(this.commands[i].label)) continue;
            this.menuWidth = this.fntMenu.stringWidth(this.commands[i].label);
            this.menuWidth += 10;
        }
        this.menuHeight = this.fntMenu.getHeight() * this.commands.length + 4;
    }

    private void commandAction(int i) {
        if (this.commands[i].enabled) {
            switch (i) {
                case 0: {
                    this.record();
                    break;
                }
                case 1: {
                    this.playLastRec();
                    break;
                }
                case 2: {
                    this.switchStereo();
                    break;
                }
                case 3: {
                    this.switchAS();
                    break;
                }
                case 4: {
                    this.switchModulation();
                    break;
                }
                case 5: {
                    this.switchTA();
                    break;
                }
                case 6: {
                    this.exit();
                }
            }
        }
    }

    public void exit() {
        this.midlet.notifyDestroyed();
    }

    public void switchTA() {
        try {
            this.rdsc.setAutomaticTA(!this.rdsc.getAutomaticTA());
            this.commands[5].label = this.rdsc.getAutomaticTA() ? "Disable TA" : "Enable TA";
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
    }

    public void record() {
        if (this.recStarted) {
            try {
                this.rc.commit();
                this.commands[0].label = "Record";
                this.commands[1].enabled = true;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else {
            try {
                this.rc = (RecordControl)this.radioPlayer.getControl("RecordControl");
                this.rc.setRecordStream(this.rm.getStream());
                this.rc.startRecord();
                this.rc.reset();
                this.commands[0].label = "Stop record";
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void playLastRec() {
        try {
            if (this.tmpPlayer.getState() == 400) {
                this.tmpPlayer.stop();
                this.tmpPlayer.close();
                this.commands[1].label = "Play last record";
            } else {
                this.tmpPlayer = Manager.createPlayer((InputStream)this.rm.getLastRecord(), (String)this.rc.getContentType());
                this.tmpPlayer.realize();
                this.tmpPlayer.prefetch();
                this.tmpPlayer.start();
                this.commands[1].label = "Stop";
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
    }

    public void switchStereo() {
        this.stereoMode = this.tc.getStereoMode();
        ++this.stereoMode;
        this.stereoMode = (this.stereoMode - 1) % 2 + 1;
        this.commands[2].label = this.stereoMode == 1 ? "Mono" : "Stereo";
        this.tc.setStereoMode(this.stereoMode);
    }

    public void switchAS() {
        try {
            this.rdsc.setAutomaticSwitching(!this.rdsc.getAutomaticSwitching());
            this.commands[3].label = this.rdsc.getAutomaticSwitching() ? "Disable AS" : "Enable AS";
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
    }

    public void switchModulation() {
        String modul = this.tc.getModulation().toLowerCase().equals("fm") ? "am" : "fm";
        this.tc.setFrequency(this.tc.getMinFreq(modul), modul);
        this.commands[4].label = "Switch to " + (this.tc.getModulation().toLowerCase().equals("fm") ? "AM" : "FM");
    }

    private void changeMenuState() {
        this.menuAnim = this.menuVisible ? -1 : 1;
        this.menuVisible = false;
        this.tmpMenuH += this.menuAnim * 2;
        this.tmpMenuW += this.menuAnim * 2;
        this.widthChngDone = false;
        this.heightChngDone = false;
        this.menuPos = 0;
    }
}

