/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import e.a.a;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Exception;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.BERApplicationSpecificParser;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.BEROctetStringParser;
import org.bouncycastle.asn1.BERSequenceParser;
import org.bouncycastle.asn1.BERSetParser;
import org.bouncycastle.asn1.BERTaggedObjectParser;
import org.bouncycastle.asn1.BERTags;
import org.bouncycastle.asn1.DERApplicationSpecific;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DEREnumerated;
import org.bouncycastle.asn1.DERExternal;
import org.bouncycastle.asn1.DERExternalParser;
import org.bouncycastle.asn1.DERGeneralString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERNumericString;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DERUniversalString;
import org.bouncycastle.asn1.DERVisibleString;
import org.bouncycastle.asn1.e;
import org.bouncycastle.asn1.f;
import org.bouncycastle.asn1.g;
import org.bouncycastle.asn1.i;
import org.bouncycastle.asn1.k;
import org.bouncycastle.util.io.Streams;

public class ASN1InputStream
extends a
implements BERTags {
    private final int b;
    private final boolean c;
    private final byte[][] d;

    private ASN1InputStream(InputStream inputStream) {
        this(inputStream, k.a(inputStream));
    }

    public ASN1InputStream(byte[] byArray) {
        this(new ByteArrayInputStream(byArray), byArray.length);
    }

    public ASN1InputStream(byte[] byArray, byte by2) {
        this(new ByteArrayInputStream(byArray), byArray.length, true);
    }

    private ASN1InputStream(InputStream inputStream, int n2) {
        this(inputStream, n2, false);
    }

    private ASN1InputStream(InputStream inputStream, int n2, boolean bl2) {
        super(inputStream);
        this.b = n2;
        this.c = bl2;
        this.d = new byte[11][];
    }

    final int a() {
        return this.b;
    }

    private int c() {
        return ASN1InputStream.b(this, this.b);
    }

    private ASN1Primitive a(int n2, int n3, int n4) {
        boolean bl2 = (n2 & 0x20) != 0;
        f f2 = new f(this, n4);
        if ((n2 & 0x40) != 0) {
            return new DERApplicationSpecific(bl2, n3, f2.b());
        }
        if ((n2 & 0x80) != 0) {
            return new ASN1StreamParser(f2).a(bl2, n3);
        }
        if (bl2) {
            switch (n3) {
                case 4: {
                    ASN1EncodableVector aSN1EncodableVector = ASN1InputStream.a(f2);
                    ASN1OctetString[] aSN1OctetStringArray = new ASN1OctetString[aSN1EncodableVector.a()];
                    for (int i2 = 0; i2 != aSN1OctetStringArray.length; ++i2) {
                        aSN1OctetStringArray[i2] = (ASN1OctetString)aSN1EncodableVector.a(i2);
                    }
                    return new BEROctetString(aSN1OctetStringArray);
                }
                case 16: {
                    if (this.c) {
                        return new i(f2.b());
                    }
                    return e.a(ASN1InputStream.a(f2));
                }
                case 17: {
                    return e.b(ASN1InputStream.a(f2));
                }
                case 8: {
                    return new DERExternal(ASN1InputStream.a(f2));
                }
            }
            throw new IOException("unknown tag " + n3 + " encountered");
        }
        return ASN1InputStream.a(n3, f2, this.d);
    }

    private static ASN1EncodableVector a(f inputStream) {
        ASN1Primitive aSN1Primitive;
        inputStream = new ASN1InputStream(inputStream);
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        while ((aSN1Primitive = ((ASN1InputStream)inputStream).b()) != null) {
            aSN1EncodableVector.a(aSN1Primitive);
        }
        return aSN1EncodableVector;
    }

    public final ASN1Primitive b() {
        int n2 = this.read();
        if (n2 <= 0) {
            if (n2 == 0) {
                throw new IOException("unexpected end-of-contents marker");
            }
            return null;
        }
        int n3 = ASN1InputStream.a(this, n2);
        boolean bl2 = (n2 & 0x20) != 0;
        int n4 = this.c();
        if (n4 < 0) {
            if (!bl2) {
                throw new IOException("indefinite length primitive encoding encountered");
            }
            Object object = new g(this, this.b);
            object = new ASN1StreamParser((InputStream)object, this.b);
            if ((n2 & 0x40) != 0) {
                return new BERApplicationSpecificParser(n3, (ASN1StreamParser)object).e();
            }
            if ((n2 & 0x80) != 0) {
                return new BERTaggedObjectParser(true, n3, (ASN1StreamParser)object).e();
            }
            switch (n3) {
                case 4: {
                    return new BEROctetStringParser((ASN1StreamParser)object).e();
                }
                case 16: {
                    return new BERSequenceParser((ASN1StreamParser)object).e();
                }
                case 17: {
                    return new BERSetParser((ASN1StreamParser)object).e();
                }
                case 8: {
                    return new DERExternalParser((ASN1StreamParser)object).e();
                }
            }
            throw new IOException("unknown BER object encountered");
        }
        try {
            return this.a(n2, n3, n4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ASN1Exception("corrupted stream detected", 0);
        }
    }

    static int a(InputStream inputStream, int n2) {
        if ((n2 &= 0x1F) == 31) {
            n2 = 0;
            int n3 = inputStream.read();
            if ((n3 & 0x7F) == 0) {
                throw new IOException("corrupted stream - invalid high tag number found");
            }
            while (n3 >= 0 && (n3 & 0x80) != 0) {
                n2 = (n2 | n3 & 0x7F) << 7;
                n3 = inputStream.read();
            }
            if (n3 < 0) {
                throw new EOFException("EOF found inside tag value.");
            }
            n2 |= n3 & 0x7F;
        }
        return n2;
    }

    static int b(InputStream inputStream, int n2) {
        int n3 = inputStream.read();
        if (n3 < 0) {
            throw new EOFException("EOF found when length expected");
        }
        if (n3 == 128) {
            return -1;
        }
        if (n3 > 127) {
            int n4 = n3 & 0x7F;
            if (n4 > 4) {
                throw new IOException("DER length more than 4 bytes: " + n4);
            }
            n3 = 0;
            for (int i2 = 0; i2 < n4; ++i2) {
                int n5 = inputStream.read();
                if (n5 < 0) {
                    throw new EOFException("EOF found reading length");
                }
                n3 = (n3 << 8) + n5;
            }
            if (n3 < 0) {
                throw new IOException("corrupted stream - negative length found");
            }
            if (n3 >= n2) {
                throw new IOException("corrupted stream - out of bounds length found");
            }
        }
        return n3;
    }

    private static byte[] a(f f2, byte[][] byArray) {
        int n2 = f2.a();
        if (f2.a() < byArray.length) {
            byte[] byArray2 = byArray[n2];
            if (byArray2 == null) {
                byArray[n2] = new byte[n2];
                byArray2 = byArray[n2];
            }
            Streams.a((InputStream)f2, byArray2);
            return byArray2;
        }
        return f2.b();
    }

    private static char[] b(f f2) {
        int n2;
        int n3;
        int n4 = f2.a() / 2;
        char[] cArray = new char[n4];
        int n5 = 0;
        while (n5 < n4 && (n3 = f2.read()) >= 0 && (n2 = f2.read()) >= 0) {
            cArray[n5++] = (char)(n3 << 8 | n2 & 0xFF);
        }
        return cArray;
    }

    static ASN1Primitive a(int n2, f f2, byte[][] byArray) {
        switch (n2) {
            case 3: {
                return DERBitString.a(f2.a(), f2);
            }
            case 30: {
                return new DERBMPString(ASN1InputStream.b(f2));
            }
            case 1: {
                return DERBoolean.b(ASN1InputStream.a(f2, byArray));
            }
            case 10: {
                return DEREnumerated.b(ASN1InputStream.a(f2, byArray));
            }
            case 24: {
                return new ASN1GeneralizedTime(f2.b());
            }
            case 27: {
                return new DERGeneralString(f2.b());
            }
            case 22: {
                return new DERIA5String(f2.b());
            }
            case 2: {
                return new ASN1Integer(f2.b());
            }
            case 5: {
                return DERNull.a;
            }
            case 18: {
                return new DERNumericString(f2.b());
            }
            case 6: {
                return DERObjectIdentifier.b(ASN1InputStream.a(f2, byArray));
            }
            case 4: {
                return new DEROctetString(f2.b());
            }
            case 19: {
                return new DERPrintableString(f2.b());
            }
            case 20: {
                return new DERT61String(f2.b());
            }
            case 28: {
                return new DERUniversalString(f2.b());
            }
            case 23: {
                return new ASN1UTCTime(f2.b());
            }
            case 12: {
                return new DERUTF8String(f2.b());
            }
            case 26: {
                return new DERVisibleString(f2.b());
            }
        }
        throw new IOException("unknown tag " + n2 + " encountered");
    }
}

