/*
 * Decompiled with CFR 0.152.
 */
package midp.shopper;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;
import midp.shopper.Category;
import midp.shopper.NewProductBox;
import midp.shopper.Product;
import midp.shopper.Shopper;

public class ProductList
extends List
implements CommandListener {
    Displayable parent;
    Category category;

    public ProductList(Category category, Displayable displayable) {
        super(category.name, 2);
        this.category = category;
        this.parent = displayable;
        int n = category.products.size();
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            Product product = (Product)category.products.elementAt(i);
            blArray[i] = product.selected;
            this.append(product.name, null);
        }
        this.setSelectedFlags(blArray);
        this.setCommandListener(this);
        this.addCommand(Shopper.ADD_CMD);
        this.addCommand(Shopper.REMOVE_CMD);
        this.addCommand(Shopper.BACK_CMD);
        Display.getDisplay((MIDlet)Shopper.getInstance()).setCurrent((Displayable)this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == Shopper.BACK_CMD) {
            int n = this.size();
            boolean[] blArray = new boolean[n];
            this.getSelectedFlags(blArray);
            Shopper shopper = Shopper.getInstance();
            for (int i = 0; i < n; ++i) {
                Product product = (Product)this.category.products.elementAt(i);
                if (!(blArray[i] ^ product.selected)) continue;
                product.selected = blArray[i];
                shopper.storeProduct(product);
            }
            Display.getDisplay((MIDlet)shopper).setCurrent(this.parent);
        } else if (command == Shopper.REMOVE_CMD) {
            int n = this.size();
            boolean[] blArray = new boolean[n];
            this.getSelectedFlags(blArray);
            Shopper shopper = Shopper.getInstance();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if (blArray[i]) {
                    Product product = (Product)this.category.products.elementAt(n2);
                    shopper.removeProduct(n2, product);
                    this.delete(n2);
                    continue;
                }
                ++n2;
            }
        } else if (command == Shopper.ADD_CMD) {
            new NewProductBox(this);
        }
    }
}

