/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.rms.RecordStore;

public class Location {
    public static Random random = new Random();
    public static int traffic = 0;
    public static String error = "";
    public static String lac = "";
    public static String cid = "";
    public static String mcc = "";
    public static String mnc = "";
    public static String lon = "";
    public static String lat = "";
    public static String elevation = "";
    public static String country = "";
    public static String city = "";
    public static String area = "";
    public static String street = "";
    public static String tod = "";
    public static String clovid = "";
    public static String prec = "";
    public static String rpwr = "";
    public static String spwr = "";
    public static String pressmax = "";
    public static String pressmin = "";
    public static String tempmax = "";
    public static String tempmin = "";
    public static String windmax = "";
    public static String windmin = "";
    public static String winddir = "";
    public static String wetmax = "";
    public static String wetmin = "";
    public static String heatmax = "";
    public static String heatmin = "";
    public static boolean update = false;
    public static RecordStore recordstore;
    public static boolean isfs;
    public static String folder;
    public static double distance;
    public static String time;
    public static String dist;
    public static Vector vector;
    public static Vector v;
    public static String rl;
    public static String output;
    public static LocationApi lapi;
    public static String[] gkeys;
    public static int gcount;
    public static String gkey;
    public static String[] ykeys;
    public static int ycount;
    public static String ykey;
    public static boolean go;
    public static String bboxsize;

    static {
        isfs = false;
        folder = "";
        distance = 0.0;
        time = "";
        dist = "";
        vector = new Vector();
        v = new Vector();
        rl = "";
        output = "";
        Location.getData();
        gkeys = new String[]{"ABQIAAAAqV2OGt7lLeOqPjzPlWRjDBQtQh0ezKOPW00oHzqZrcnTyszRtRTn0Uj75S3FLNMnfvKIsHobfsjW7A", "ABQIAAAAqV2OGt7lLeOqPjzPlWRjDBR-51eTUNBQxkC3j-AWWroD5UXSfxStAEfFiy_TlLBRu-Hacb33IlknUA", "ABQIAAAAzr2EBOXUKnm_jVnk0OJI7xSosDVG8KKPE1-m51RBrvYughuyMxQ-i1QfUnH94QxWIa6N4U6MouMmBA", ""};
        gcount = 0;
        gkey = gkeys[gcount];
        ykeys = new String[]{"AP_JbUkBAAAAO0APBQMAZgGGKZqIKMmRDJwfN0enUZD1R8cAAAAAAAAAAAB5Jg3D4sMkVd6DxzmwfS3sJnVnqg==", "ANpUFEkBAAAAf7jmJwMAHGZHrcKNDsbEqEVjEUtCmufxQMwAAAAAAAAAAAAvVrubVT4btztbduoIgTLAeFILaQ==", "ABYQNEkBAAAAgM-ZTwMAK_IKAfJkc-72mWoAq8el6lFmTeEAAAAAAAAAAAChHQgTyECkUqGduyet_fMaeQ6ckw=="};
        ycount = 0;
        ykey = ykeys[gcount];
        go = true;
        bboxsize = "25000";
    }

    public static boolean numeric(String string) throws  {
        try {
            int n = Integer.parseInt(string);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static int getTraffic() throws  {
        return traffic;
    }

    public static String[] fullInfo(int n) throws  {
        return (String[])v.elementAt(n);
    }

    public static String[] list() throws  {
        Object[] objectArray = Location.splitString(rl, "\n");
        vector.removeAllElements();
        int n = 0;
        while (n < objectArray.length) {
            String string = objectArray[n];
            String[] stringArray = Location.splitString(string, ",");
            try {
                double d = Double.parseDouble(stringArray[0]);
                d = Double.parseDouble(stringArray[1]);
                vector.addElement(string);
                v.addElement(Location.splitString(Location.getRecord(string).trim(), "\n"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n;
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        vector.removeAllElements();
        return objectArray;
    }

    public static boolean availableRecord(String string) throws  {
        try {
            recordstore = RecordStore.openRecordStore((String)String.valueOf(string.hashCode()).concat(""), (boolean)false);
            recordstore.closeRecordStore();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static String getRecord(String string) throws  {
        String string2 = "";
        try {
            recordstore = RecordStore.openRecordStore((String)String.valueOf(string.hashCode()).concat(""), (boolean)false);
            byte[] byArray = recordstore.getRecord(1);
            recordstore.closeRecordStore();
            string2 = new String(byArray, "UTF-8");
            recordstore = RecordStore.openRecordStore((String)String.valueOf("rl".hashCode()).concat(""), (boolean)false);
            byArray = recordstore.getRecord(1);
            recordstore.closeRecordStore();
            rl = new String(byArray, "UTF-8");
        }
        catch (Throwable throwable) {
            string2 = "No Record!";
        }
        return string2;
    }

    public static void setRecord(String string, String string2) throws  {
        Location.deleteRecord(string);
        try {
            byte[] byArray = string2.getBytes("UTF-8");
            recordstore = RecordStore.openRecordStore((String)String.valueOf(string.hashCode()).concat(""), (boolean)true);
            recordstore.addRecord(byArray, 0, byArray.length);
            recordstore.closeRecordStore();
            Location.deleteRecord("rl");
            rl = rl.length() == 0 ? "\n".concat(String.valueOf(string)) : String.valueOf(rl).concat("\n").concat(String.valueOf(string));
            byArray = rl.getBytes("UTF-8");
            recordstore = RecordStore.openRecordStore((String)String.valueOf("rl".hashCode()).concat(""), (boolean)true);
            recordstore.addRecord(byArray, 0, byArray.length);
            recordstore.addRecord(byArray, 0, byArray.length);
            recordstore.closeRecordStore();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void deleteRecord(String string) throws  {
        if (recordstore != null) {
            try {
                RecordStore.deleteRecordStore((String)String.valueOf(string.hashCode()).concat(""));
                rl = Location.replace(rl, string, "");
                rl = Location.replace(rl, "\n\n", "\n");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static boolean update() throws  {
        boolean bl = update;
        if (Location.checkData()) {
            update = false;
            if (!mcc.equals(Location.getMcc())) {
                update = true;
            }
            if (!mnc.equals(Location.getMnc())) {
                update = true;
            }
            if (!lac.equals(Location.getLac())) {
                update = true;
            }
            if (!cid.equals(Location.getCid())) {
                update = true;
            }
        }
        if (bl) {
            update = bl;
        }
        return update;
    }

    public static void done() throws  {
        update = false;
    }

    public static String trim(String string) throws  {
        string = string.trim();
        if ((string = Location.splitString(string, " ")[0]).startsWith("0")) {
            string = string.substring(1, string.length());
        }
        if (string.startsWith("0")) {
            string = Location.trim(string);
        }
        return string;
    }

    public static void getData() throws  {
        lac = Location.getLac();
        cid = Location.getCid();
        mnc = Location.getMnc();
        mcc = Location.getMcc();
    }

    public static String getLac() throws  {
        lac = CellGps.LAC();
        lac = Location.trim(lac);
        return lac;
    }

    public static String getCid() throws  {
        cid = CellGps.CellId();
        cid = Location.trim(cid);
        return cid;
    }

    public static String getMnc() throws  {
        mnc = CellGps.MNC();
        mnc = Location.trim(mnc);
        return mnc;
    }

    public static String getMcc() throws  {
        mcc = CellGps.MCC();
        mcc = Location.trim(mcc);
        return mcc;
    }

    public static String reverseGeocodingG(String string, String string2) throws  {
        String string3 = "";
        try {
            String string4 = "http://maps.google.com/maps/geo?q=" + String.valueOf(String.valueOf(string.trim())) + "," + String.valueOf(String.valueOf(string2.trim())) + "&output=json&oe=utf8&sensor=fals&language=ru&key=" + String.valueOf(gkey);
            HttpConnection httpConnection = (HttpConnection)Connector.open((String)string4);
            httpConnection.setRequestMethod("GET");
            httpConnection.setRequestProperty("User-Agent", String.valueOf(System.getProperty("microedition.platform")).concat("/").concat(String.valueOf(Math.abs(random.nextInt()))));
            httpConnection.setRequestProperty("Accept-Language", "ru-ru,ru;");
            if (httpConnection.getResponseCode() != 200) {
                httpConnection.close();
                if (++gcount < gkeys.length) {
                    gkey = gkeys[gcount];
                    return Location.reverseGeocodingG(string, string2);
                }
                gcount = 0;
            }
            if (httpConnection.getResponseCode() == 200) {
                InputStream inputStream = httpConnection.openInputStream();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n = 1024;
                byte[] byArray = new byte[n];
                int n2 = 0;
                do {
                    if ((n2 = inputStream.read(byArray, 0, n)) == -1) continue;
                    byteArrayOutputStream.write(byArray, 0, n2);
                } while (n2 != -1);
                byArray = byteArrayOutputStream.toByteArray();
                traffic += byArray.length;
                String string5 = new String(byArray, "UTF-8");
                inputStream.close();
                string5 = string5.substring(string5.indexOf("address") + "address".length(), string5.length());
                string5 = string5.substring(0, string5.indexOf("AddressDetails"));
                string5 = string5.replace((char)34, (char)32).replace((char)58, (char)32).trim();
                String[] stringArray = Location.splitString(string5, ",");
                try {
                    if (stringArray[stringArray.length - 1].trim().length() == 0) {
                        string5 = stringArray[stringArray.length - 2].trim();
                        string5 = String.valueOf(string5).concat(",").concat(String.valueOf(stringArray[stringArray.length - 3].trim()));
                        string5 = String.valueOf(string5).concat(",").concat(String.valueOf(stringArray[stringArray.length - 4].trim()));
                        string5 = String.valueOf(string5).concat(",").concat(String.valueOf(stringArray[stringArray.length - 5].trim()));
                    } else {
                        string5 = stringArray[stringArray.length - 1].trim();
                        string5 = String.valueOf(string5).concat(",").concat(String.valueOf(stringArray[stringArray.length - 2].trim()));
                        string5 = String.valueOf(string5).concat(",").concat(String.valueOf(stringArray[stringArray.length - 3].trim()));
                        string5 = String.valueOf(string5).concat(",").concat(String.valueOf(stringArray[stringArray.length - 4].trim()));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                string3 = string5;
            }
            httpConnection.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string3;
    }

    public static String reverseGeocodingY(String string, String string2) throws  {
        String string3 = "";
        try {
            String string4 = "http://geocode-maps.yandex.ru/1.x/?format=xml&geocode=" + String.valueOf(String.valueOf(string2.trim())) + "," + String.valueOf(String.valueOf(string.trim())) + "&kind=house&plng=ru&key=" + String.valueOf(ykey);
            HttpConnection httpConnection = (HttpConnection)Connector.open((String)string4);
            httpConnection.setRequestMethod("GET");
            httpConnection.setRequestProperty("User-Agent", String.valueOf(System.getProperty("microedition.platform")).concat("/").concat(String.valueOf(Math.abs(random.nextInt()))));
            httpConnection.setRequestProperty("Accept-Language", "ru-ru,ru;");
            if (httpConnection.getResponseCode() != 200) {
                httpConnection.close();
                if (++ycount < ykeys.length) {
                    ykey = ykeys[ycount];
                    return Location.reverseGeocodingY(string, string2);
                }
                ycount = 0;
            }
            if (httpConnection.getResponseCode() == 200) {
                InputStream inputStream = httpConnection.openInputStream();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n = 1024;
                byte[] byArray = new byte[n];
                int n2 = 0;
                do {
                    if ((n2 = inputStream.read(byArray, 0, n)) == -1) continue;
                    byteArrayOutputStream.write(byArray, 0, n2);
                } while (n2 != -1);
                byArray = byteArrayOutputStream.toByteArray();
                traffic += byArray.length;
                String string5 = new String(byArray, "UTF-8");
                inputStream.close();
                httpConnection.close();
                string5 = string5.substring(string5.indexOf("<text>") + "<text>".length(), string5.length());
                string3 = string5 = string5.substring(0, string5.indexOf("</text>"));
            }
            httpConnection.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (Location.reallyNull(string3)) {
            string3 = Location.reverseGeocodingOSM(string, string2);
        }
        return string3;
    }

    public static String reverseGeocodingOSM(String string, String string2) throws  {
        String string3 = "";
        try {
            String string4 = "http://nominatim.openstreetmap.org/reverse?lat=" + String.valueOf(String.valueOf(string2.trim())) + "&lon=" + String.valueOf(String.valueOf(string.trim()));
            HttpConnection httpConnection = (HttpConnection)Connector.open((String)string4);
            httpConnection.setRequestMethod("GET");
            httpConnection.setRequestProperty("User-Agent", String.valueOf(System.getProperty("microedition.platform")).concat("/").concat(String.valueOf(Math.abs(random.nextInt()))));
            httpConnection.setRequestProperty("Accept-Language", "ru-ru,ru;");
            if (httpConnection.getResponseCode() == 200) {
                InputStream inputStream = httpConnection.openInputStream();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n = 1024;
                byte[] byArray = new byte[n];
                int n2 = 0;
                do {
                    if ((n2 = inputStream.read(byArray, 0, n)) == -1) continue;
                    byteArrayOutputStream.write(byArray, 0, n2);
                } while (n2 != -1);
                byArray = byteArrayOutputStream.toByteArray();
                traffic += byArray.length;
                String string5 = new String(byArray, "UTF-8");
                inputStream.close();
                httpConnection.close();
                string5 = string5.substring(0, string5.indexOf("</result>") + "</result>".length());
                string5 = string5.substring(string5.lastIndexOf(62) + 1, string5.length());
                String[] stringArray = Location.splitString(string5, ",");
                try {
                    if (stringArray[stringArray.length - 1].trim().length() == 0) {
                        string5 = stringArray[stringArray.length - 2].trim();
                        string5 = String.valueOf(string5).concat(",").concat(String.valueOf(stringArray[stringArray.length - 3].trim()));
                        string5 = String.valueOf(string5).concat(",").concat(String.valueOf(stringArray[stringArray.length - 4].trim()));
                        string5 = String.valueOf(string5).concat(",").concat(String.valueOf(stringArray[stringArray.length - 5].trim()));
                    } else {
                        string5 = stringArray[stringArray.length - 1].trim();
                        string5 = String.valueOf(string5).concat(",").concat(String.valueOf(stringArray[stringArray.length - 2].trim()));
                        string5 = String.valueOf(string5).concat(",").concat(String.valueOf(stringArray[stringArray.length - 3].trim()));
                        string5 = String.valueOf(string5).concat(",").concat(String.valueOf(stringArray[stringArray.length - 4].trim()));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                string3 = string5;
            }
            httpConnection.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (Location.reallyNull(string3)) {
            string3 = Location.reverseGeocodingG(string, string2);
        }
        return string3;
    }

    public static boolean reallyNull(String string) throws  {
        try {
            if (string == null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (string.equals("null")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (string.equals("0")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (string.equals("0.0")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (string.trim().length() == 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static void setAddress(String string, String string2, String string3, String string4) throws  {
        country = string;
        area = string2;
        city = string3;
        street = string4;
    }

    public static boolean checkData() throws  {
        if (lac == null) {
            return false;
        }
        if (cid == null) {
            return false;
        }
        if (mcc == null) {
            return false;
        }
        if (mnc == null) {
            return false;
        }
        if (lac.equals("null")) {
            return false;
        }
        if (cid.equals("null")) {
            return false;
        }
        if (mcc.equals("null")) {
            return false;
        }
        if (mnc.equals("null")) {
            return false;
        }
        if (lac.length() == 0) {
            return false;
        }
        if (cid.length() == 0) {
            return false;
        }
        if (mcc.length() == 0) {
            return false;
        }
        return mnc.length() != 0;
    }

    public static void getCoordinates() throws  {
        block36: {
            Object[] objectArray;
            elevation = "0.0";
            lon = "0.0";
            lat = "0.0";
            if (Location.reallyNull(System.getProperty("microedition.location.version"))) {
                Location.setRecord("jsr179", "not supported");
            }
            if (!Location.availableRecord("jsr179") && !Location.reallyNull(System.getProperty("microedition.location.version"))) {
                try {
                    if (lapi == null) {
                        lapi = new LocationApi();
                        lapi.getCoordinates();
                    } else {
                        lat = lapi.getLatitude();
                        lon = lapi.getLongitude();
                        lat = lat.substring(0, lat.indexOf(46) + 6);
                        lon = lon.substring(0, lon.indexOf(46) + 6);
                        if (Location.reallyNull(lat)) {
                            Location.setRecord("jsr179", "not supported");
                        }
                        if (Location.reallyNull(lon)) {
                            Location.setRecord("jsr179", "not supported");
                        }
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    Location.setRecord("jsr179", "not supported");
                }
            }
            if (Location.checkData() && (Location.reallyNull(lon) || lon.equals("0.0") || Location.reallyNull(lat))) {
                if (Location.availableRecord("bs-" + String.valueOf(String.valueOf(lac)) + "-" + String.valueOf(String.valueOf(cid)) + "-" + String.valueOf(String.valueOf(mnc)) + "-" + String.valueOf(String.valueOf(mcc)))) {
                    objectArray = Location.splitString(Location.getRecord("bs-" + String.valueOf(String.valueOf(lac)) + "-" + String.valueOf(String.valueOf(cid)) + "-" + String.valueOf(String.valueOf(mnc)) + "-" + String.valueOf(String.valueOf(mcc))).trim(), "\n");
                    try {
                        lat = objectArray[0];
                        lon = objectArray[1];
                        lat = lat.substring(0, lat.indexOf(46) + 6);
                        lon = lon.substring(0, lon.indexOf(46) + 6);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                if (Location.reallyNull(lon) || lon.equals("0.0") || Location.reallyNull(lat)) {
                    if (Location.reallyNull(lon) || lon.equals("0.0") || Location.reallyNull(lat)) {
                        try {
                            if (!SystemUtil.signal().equals("0")) {
                                objectArray = CellGps.LatLon(Integer.parseInt(mcc), Integer.parseInt(mnc), Integer.parseInt(lac), Integer.parseInt(cid), SystemUtil.signal());
                                if (objectArray[0] != 0.0) {
                                    lat = "".concat(String.valueOf(new Double((double)objectArray[0])));
                                }
                                if (objectArray[1] != 0.0) {
                                    lon = "".concat(String.valueOf(new Double((double)objectArray[1])));
                                }
                                lat = lat.substring(0, lat.indexOf(46) + 6);
                                lon = lon.substring(0, lon.indexOf(46) + 6);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (Location.reallyNull(lon) || lon.equals("0.0") || Location.reallyNull(lat)) {
                        try {
                            objectArray = CellGps.LatLon(Integer.parseInt(mcc), Integer.parseInt(mnc), Integer.parseInt(lac), Integer.parseInt(cid));
                            if (objectArray[0] != 0.0) {
                                lat = "".concat(String.valueOf(new Double((double)objectArray[0])));
                            }
                            if (objectArray[1] != 0.0) {
                                lon = "".concat(String.valueOf(new Double((double)objectArray[1])));
                            }
                            lat = lat.substring(0, lat.indexOf(46) + 6);
                            lon = lon.substring(0, lon.indexOf(46) + 6);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    Location.setRecord("bs-" + String.valueOf(String.valueOf(lac)) + "-" + String.valueOf(String.valueOf(cid)) + "-" + String.valueOf(String.valueOf(mnc)) + "-" + String.valueOf(String.valueOf(mcc)), String.valueOf(lat).concat("\n").concat(String.valueOf(lon)));
                    Location.db();
                }
            }
            if (!(lon == null && lon.equals("null") && lon.length() == 0 && lon.equals("0.0") || lat == null && lat.equals("null") && lat.length() == 0 && lat.equals("0.0"))) {
                try {
                    if (Location.availableRecord(String.valueOf(String.valueOf(lat)).concat(",").concat(String.valueOf(String.valueOf(lon))))) {
                        objectArray = Location.splitString(Location.getRecord(String.valueOf(String.valueOf(lat)).concat(",").concat(String.valueOf(String.valueOf(lon)))).trim(), "\n");
                        try {
                            lat = objectArray[0];
                            lon = objectArray[1];
                            if (Location.numeric(objectArray[2])) {
                                country = objectArray[3];
                                area = objectArray[4];
                                city = objectArray[5];
                                street = objectArray[6];
                                elevation = objectArray[7];
                            } else {
                                country = objectArray[2];
                                area = objectArray[3];
                                city = objectArray[4];
                                street = objectArray[5];
                                elevation = objectArray[6];
                            }
                            if (elevation.length() == 0) {
                                elevation = Location.downloadElevation(lat, lon);
                                Location.setRecord(String.valueOf(String.valueOf(lat)).concat(",").concat(String.valueOf(String.valueOf(lon))), String.valueOf(String.valueOf(lat)) + "\n" + String.valueOf(String.valueOf(lon)) + "\n" + String.valueOf(String.valueOf(country)) + "\n" + String.valueOf(String.valueOf(area)) + "\n" + String.valueOf(String.valueOf(city)) + "\n" + String.valueOf(String.valueOf(street)) + "\n" + String.valueOf(String.valueOf(elevation)));
                            }
                            break block36;
                        }
                        catch (Throwable throwable) {}
                        break block36;
                    }
                    if (Location.reallyNull(elevation)) {
                        elevation = Location.downloadElevation(lat, lon);
                    }
                    objectArray = Location.reverseGeocodingY(lat, lon);
                    String[] stringArray = Location.splitString((String)objectArray, ",");
                    try {
                        country = stringArray[0];
                        area = stringArray[1];
                        city = stringArray[2];
                        street = stringArray[3];
                        street = String.valueOf(street).concat(",").concat(String.valueOf(stringArray[4]));
                        street = String.valueOf(street).concat(",").concat(String.valueOf(stringArray[5]));
                        street = String.valueOf(street).concat(",").concat(String.valueOf(stringArray[6]));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    Location.setRecord(String.valueOf(String.valueOf(lat)).concat(",").concat(String.valueOf(String.valueOf(lon))), String.valueOf(String.valueOf(lat)) + "\n" + String.valueOf(String.valueOf(lon)) + "\n" + String.valueOf(String.valueOf(country)) + "\n" + String.valueOf(String.valueOf(area)) + "\n" + String.valueOf(String.valueOf(city)) + "\n" + String.valueOf(String.valueOf(street)) + "\n" + String.valueOf(String.valueOf(elevation)));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public static void updateDb(Thread thread) throws  {
        thread.setPriority(1);
        thread.start();
    }

    public static void db() throws  {
        Location.updateDb(new Location$1());
    }

    public static String downloadElevation(String string, String string2) throws  {
        String string3 = "0";
        try {
            String string4 = "http://maps.googleapis.com/maps/api/elevation/json?locations=" + String.valueOf(String.valueOf(string)) + "," + String.valueOf(String.valueOf(string2)) + "&sensor=false";
            HttpConnection httpConnection = (HttpConnection)Connector.open((String)string4);
            httpConnection.setRequestMethod("GET");
            httpConnection.setRequestProperty("User-Agent", String.valueOf(System.getProperty("microedition.platform")).concat("/").concat(String.valueOf(Math.abs(random.nextInt()))));
            httpConnection.setRequestProperty("Accept-Language", "ru-ru,ru;");
            if (httpConnection.getResponseCode() == 200) {
                InputStream inputStream = httpConnection.openInputStream();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n = 1024;
                byte[] byArray = new byte[n];
                int n2 = 0;
                do {
                    if ((n2 = inputStream.read(byArray, 0, n)) == -1) continue;
                    byteArrayOutputStream.write(byArray, 0, n2);
                } while (n2 != -1);
                byArray = byteArrayOutputStream.toByteArray();
                traffic += byArray.length;
                String string5 = new String(byArray, "UTF-8");
                inputStream.close();
                string5 = string5.substring(string5.indexOf("elevation") + "elevation".length() + 3, string5.length());
                string5 = string5.substring(0, string5.indexOf("."));
                string3 = string5.trim();
            }
            httpConnection.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string3;
    }

    public static String getLongitude() throws  {
        if (!Location.reallyNull(lon)) {
            String string = !(Double.parseDouble(lon.trim()) <= 0.0) ? String.valueOf("".concat(String.valueOf(lon)).concat(" ")).concat("'E") : String.valueOf("".concat(String.valueOf(lon)).concat(" ")).concat("'W");
            return string;
        }
        return "0.0";
    }

    public static String getLatitude() throws  {
        if (!Location.reallyNull(lat)) {
            String string = !(Double.parseDouble(lat.trim()) <= 0.0) ? String.valueOf("".concat(String.valueOf(lat)).concat(" ")).concat("'N") : String.valueOf("".concat(String.valueOf(lat)).concat(" ")).concat("'S");
            return string;
        }
        return "0.0";
    }

    public static String getElevation() throws  {
        if (!Location.reallyNull(elevation)) {
            return "".concat(String.valueOf((int)Double.parseDouble(elevation)));
        }
        return "0.0";
    }

    public static String getCountry() throws  {
        if (!Location.reallyNull(country)) {
            return country;
        }
        return "";
    }

    public static String getArea() throws  {
        if (!Location.reallyNull(area)) {
            return area;
        }
        return "";
    }

    public static String getCity() throws  {
        if (!Location.reallyNull(city)) {
            return city;
        }
        return "";
    }

    public static String getStreet() throws  {
        if (street != null) {
            return street;
        }
        return "";
    }

    public static String[] splitString(String string, String string2) throws  {
        if (string == null) {
            return null;
        }
        if (string.length() == 0 || string2 == null || string2.length() == 0) {
            return new String[]{string};
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        int n2 = string.indexOf(string2, n);
        while (n2 != -1) {
            vector.addElement(string.substring(n, n2));
            n = n2 + string2.length();
            n2 = string.indexOf(string2, n);
        }
        vector.addElement(string.substring(n));
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        vector = null;
        return objectArray;
    }

    public static String URLEncode(String string) throws  {
        return DownloadWeather.URLEncode(string);
    }

    public static String replace(String string, String string2, String string3) throws  {
        String string4 = " ";
        string = String.valueOf(string).concat(" ");
        int n = string.indexOf(string2);
        while (n > -1) {
            string4 = String.valueOf(string4).concat(String.valueOf(String.valueOf(string.substring(0, n)).concat(String.valueOf(string3))));
            string = string.substring(n + string2.length());
            n = string.indexOf(string2);
        }
        string4 = String.valueOf(string4).concat(String.valueOf(string));
        return string4.substring(1, string4.length() - 1);
    }
}

