/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.io.Connector;
import javax.microedition.sensor.ChannelInfo;
import javax.microedition.sensor.Data;
import javax.microedition.sensor.DataListener;
import javax.microedition.sensor.MeasurementRange;
import javax.microedition.sensor.SensorConnection;
import javax.microedition.sensor.SensorInfo;
import javax.microedition.sensor.SensorManager;

public class SensorApi
implements DataListener {
    int[] channels;
    String[] channelNames;
    SensorConnection sensor;
    String URL;
    int numChannels;
    int dataType;
    double minValue;
    double maxValue;

    public static String getSensor(int n) throws  {
        String string = "battery_charge";
        switch (n) {
            case 1: {
                string = "network_field_intensity";
                break;
            }
            case 2: {
                string = "com.sonyericsson.io.sensor.steps_per_minute";
                break;
            }
            case 3: {
                string = "step_count";
                break;
            }
            case 4: {
                string = "acceleration";
                break;
            }
        }
        try {
            SensorInfo[] sensorInfoArray = SensorManager.findSensors((String)string, null);
            SensorConnection sensorConnection = (SensorConnection)Connector.open((String)sensorInfoArray[0].getUrl());
            Data[] dataArray = sensorConnection.getData(1);
            return String.valueOf(dataArray[0].getIntValues()[0]);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return "0";
        }
    }

    static void getInfo$(SensorApi sensorApi) throws  {
        SensorInfo[] sensorInfoArray = SensorManager.findSensors(null, null);
        if (sensorInfoArray == null || sensorInfoArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < sensorInfoArray.length) {
            String string = sensorInfoArray[n].getQuantity().toLowerCase();
            if (string.startsWith("accel")) {
                SensorInfo sensorInfo = sensorInfoArray[n];
                sensorApi.URL = sensorInfo.getUrl();
                ChannelInfo[] channelInfoArray = sensorInfo.getChannelInfos();
                sensorApi.numChannels = channelInfoArray.length;
                sensorApi.channels = new int[sensorApi.numChannels];
                sensorApi.channelNames = new String[sensorApi.numChannels];
                sensorApi.dataType = channelInfoArray[0].getDataType();
                MeasurementRange measurementRange = channelInfoArray[0].getMeasurementRanges()[0];
                sensorApi.minValue = measurementRange.getSmallestValue();
                sensorApi.maxValue = measurementRange.getLargestValue();
                int n2 = 0;
                while (n2 < sensorApi.numChannels) {
                    sensorApi.channelNames[n2] = channelInfoArray[n2].getName();
                    ++n2;
                }
            }
            ++n;
        }
        try {
            sensorApi.sensor = (SensorConnection)Connector.open((String)sensorApi.URL);
            sensorApi.sensor.setDataListener((DataListener)sensorApi, 1);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void dataReceived(SensorConnection sensorConnection, Data[] dataArray, boolean bl) throws  {
        int n = 0;
        while (n < dataArray.length) {
            int n2 = 0;
            while (n2 < this.numChannels) {
                String string = dataArray[n].getChannelInfo().getName();
                if (string.equals(this.channelNames[n2])) {
                    this.channels[n2] = SensorApi.getValue$(this, dataArray[n]);
                }
                ++n2;
            }
            ++n;
        }
    }

    static int getValue$(SensorApi sensorApi, Object object) throws  {
        int n = 0;
        double d = 0.0;
        if (sensorApi.dataType == 2) {
            d = ((Data)object).getIntValues()[0];
        } else if (sensorApi.dataType == 1) {
            d = ((Data)object).getDoubleValues()[0];
        }
        n = !(d < 0.0) ? (int)(d * (double)1024 / sensorApi.maxValue) : (int)(d * (double)-1024 / sensorApi.minValue);
        return n;
    }

    public SensorApi() throws  {
        SensorApi.getInfo$(this);
    }
}

