/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;

public class Unicode {
    static final String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";

    public static String convCp1251ToUnicode(byte[] byArray) throws  {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = byArray[n2];
            int n4 = n3 == -77 ? 1110 : (n3 == -65 ? 1111 : (n3 == -70 ? 1108 : (n3 == -76 ? 1169 : (n3 == -78 ? 1030 : (n3 == -81 ? 1031 : (n3 == -91 ? 1168 : (n3 == -86 ? 1028 : (n3 == -70 ? 1025 : (n3 == -72 ? 1105 : (n3 < 0 ? (int)((short)(0x400 | (n3 & 0x7F) - 48)) : n3))))))))));
            cArray[n2] = n4;
            ++n2;
        }
        return new String(cArray);
    }

    public static String convCp1251ToUnicode(String string) throws  {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            int n2 = string.charAt(n);
            if (n2 == 179) {
                n2 = 1110;
            } else if (n2 == 191) {
                n2 = 1111;
            } else if (n2 == 186) {
                n2 = 1108;
            } else if (n2 == 180) {
                n2 = 1169;
            } else if (n2 == 178) {
                n2 = 1030;
            } else if (n2 == 175) {
                n2 = 1031;
            } else if (n2 == 165) {
                n2 = 1168;
            } else if (n2 == 170) {
                n2 = 1028;
            } else if (n2 > 191 && n2 < 1040 && n2 != 1025) {
                n2 = (short)(n2 + 848);
            } else if (n2 == 168) {
                n2 = 1025;
            } else if (n2 == 184) {
                n2 = 1105;
            }
            stringBuffer.append((char)n2);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String convUnicodeToCp1251(String string) throws  {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            int n2 = string.charAt(n);
            if (n2 == 1110) {
                n2 = 179;
            } else if (n2 == 1111) {
                n2 = 191;
            } else if (n2 == 1108) {
                n2 = 186;
            } else if (n2 == 1169) {
                n2 = 180;
            } else if (n2 == 1030) {
                n2 = 178;
            } else if (n2 == 1031) {
                n2 = 175;
            } else if (n2 == 1168) {
                n2 = 165;
            } else if (n2 == 1028) {
                n2 = 170;
            } else if (n2 == 1025) {
                n2 = 168;
            } else if (n2 == 1105) {
                n2 = 184;
            } else if (n2 > 1033) {
                n2 = (short)(n2 + -848);
            }
            stringBuffer.append((char)n2);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static byte[] convUnicodeToCp1251Byte(String string) throws  {
        char[] cArray = Unicode.convUnicodeToCp1251(string).toCharArray();
        int n = cArray.length;
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)cArray[n2];
            ++n2;
        }
        return byArray;
    }

    public static String toBase64(String string) throws  {
        int n = string.length();
        char[] cArray = new char[(n + 2) / 3 * 4];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            boolean bl = false;
            boolean bl2 = false;
            int n4 = (0xFF & string.charAt(n2)) << 8;
            if (n2 + 1 < n) {
                n4 |= 0xFF & string.charAt(n2 + 1);
                bl = true;
            }
            n4 <<= 8;
            if (n2 + 2 < n) {
                n4 |= 0xFF & string.charAt(n2 + 2);
                bl2 = true;
            }
            cArray[n3 + 3] = alphabet.charAt(bl2 ? n4 & 0x3F : 64);
            cArray[n3 + 2] = alphabet.charAt(bl ? (n4 >>= 6) & 0x3F : 64);
            cArray[n3 + 1] = alphabet.charAt((n4 >>= 6) & 0x3F);
            cArray[n3] = alphabet.charAt((n4 >>= 6) & 0x3F);
            n2 += 3;
            n3 += 4;
        }
        return new String(cArray);
    }

    public static String toBase64(byte[] byArray, int n) throws  {
        if (n < 0) {
            n = byArray.length;
        }
        char[] cArray = new char[(n + 2) / 3 * 4];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            boolean bl = false;
            boolean bl2 = false;
            int n4 = (0xFF & byArray[n2]) << 8;
            if (n2 + 1 < n) {
                n4 |= 0xFF & byArray[n2 + 1];
                bl = true;
            }
            n4 <<= 8;
            if (n2 + 2 < n) {
                n4 |= 0xFF & byArray[n2 + 2];
                bl2 = true;
            }
            cArray[n3 + 3] = alphabet.charAt(bl2 ? n4 & 0x3F : 64);
            cArray[n3 + 2] = alphabet.charAt(bl ? (n4 >>= 6) & 0x3F : 64);
            cArray[n3 + 1] = alphabet.charAt((n4 >>= 6) & 0x3F);
            cArray[n3] = alphabet.charAt((n4 >>= 6) & 0x3F);
            n2 += 3;
            n3 += 4;
        }
        return new String(cArray);
    }

    public static StringBuffer toUTFSb(StringBuffer stringBuffer) throws  {
        int n = stringBuffer.length();
        StringBuffer stringBuffer2 = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c = stringBuffer.charAt(n2);
            if (c >= '\u0001' && c <= '\u007f') {
                stringBuffer2.append(c);
            }
            if (c >= '\u0080' && c <= '\u07ff' || c == '\u0000') {
                stringBuffer2.append((char)(0xC0 | 0x1F & c >> 6));
                stringBuffer2.append((char)(0x80 | 0x3F & c));
            }
            if (c >= '\u0800' && c <= '\uffff') {
                stringBuffer2.append((char)(0xE0 | 0xF & c >> 12));
                stringBuffer2.append((char)(0x80 | 0x3F & c >> 6));
                stringBuffer2.append((char)(0x80 | 0x3F & c));
            }
            ++n2;
        }
        return stringBuffer2;
    }

    public static byte[] fromBase64(String string) throws  {
        return Unicode.baosFromBase64(string).toByteArray();
    }

    public static String sFromBase64(String string) throws  {
        return Unicode.baosFromBase64(string).toString();
    }

    static ByteArrayOutputStream baosFromBase64(String string) throws  {
        int n = 0;
        int n2 = 1;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        int n3 = 0;
        while (n3 < string.length()) {
            char c = string.charAt(n3);
            int n4 = -1;
            if (c > 65 - 1 && c < 90 + 1) {
                n4 = c - 65;
            } else if (c > 97 - 1 && c < 122 + 1) {
                n4 = c + 26 - 97;
            } else if (c > 48 - 1 && c < 57 + 1) {
                n4 = c + 52 - 48;
            } else if (c == '+') {
                n4 = 62;
            } else if (c == '/') {
                n4 = 63;
            } else if (c == '=') {
                n4 = 0;
                ++n;
            } else if (c == '<') break;
            if (n4 >= 0) {
                n2 = (n2 << 6) + n4;
            }
            if (n2 >= 0x1000000) {
                byteArrayOutputStream.write(n2 >> 16 & 0xFF);
                if (n < 2) {
                    byteArrayOutputStream.write(n2 >> 8 & 0xFF);
                }
                if (n == 0) {
                    byteArrayOutputStream.write(n2 & 0xFF);
                }
                n2 = 1;
            }
            ++n3;
        }
        try {
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byteArrayOutputStream;
    }

    public static String unicodeToUTF(String string) throws  {
        return Unicode.toUTFSb(new StringBuffer(string)).toString();
    }
}

