/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GUIGraphics {
    static Hashtable table = new Hashtable();
    public static boolean lightmode = true;
    public static int key = 0;
    public static int value = 255;
    public static boolean border = true;

    public static void setFullMode(boolean bl) throws  {
        GUIGraphics.setMode(bl);
    }

    public static boolean getFullMode() throws  {
        return GUIGraphics.getMode();
    }

    public static void setMode(boolean bl) throws  {
        lightmode = !bl;
    }

    public static boolean getMode() throws  {
        return !lightmode;
    }

    public static void fillRect(Graphics graphics, int n, int n2, int n3, int n4) throws  {
        graphics.fillRect(n, n2, n3, n4);
        if (!lightmode) {
            int[] nArray;
            if (table.containsKey(String.valueOf(n3).concat("x").concat(String.valueOf(n4)))) {
                nArray = (int[])table.get(String.valueOf(n3).concat("x").concat(String.valueOf(n4)));
            } else {
                nArray = GUIGraphics.glassRect(n3, n4, 255, 0);
                table.put(String.valueOf(n3).concat("x").concat(String.valueOf(n4)), nArray);
            }
            graphics.drawRGB(nArray, 0, n3, n, n2, n3, n4, true);
        }
    }

    public static void fillRoundRect(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) throws  {
        graphics.fillRoundRect(n, n2, n3, n4, n5, n6);
        if (!lightmode) {
            int[] nArray;
            if (table.containsKey(String.valueOf(n3).concat("x").concat(String.valueOf(n4)))) {
                nArray = (int[])table.get(String.valueOf(n3).concat("x").concat(String.valueOf(n4)));
            } else {
                nArray = GUIGraphics.glassRoundRect(n3, n4, 255, 0);
                table.put(String.valueOf(n3).concat("x").concat(String.valueOf(n4)), nArray);
            }
            graphics.drawRGB(nArray, 0, n3, n, n2, n3, n4, true);
        }
    }

    static int invert(int n, int n2) throws  {
        key = n;
        value = n2;
        return value;
    }

    public static int invert(int n) throws  {
        if (n == key) {
            return value;
        }
        int n2 = n >> 24 & 0xFF;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        float f = 0.3f * (float)n3 + 0.59f * (float)n4 + 0.11f * (float)n5;
        if (f < 102.0f) {
            return GUIGraphics.invert(n, 0xFFFFFF);
        }
        if (!(f <= 191.25f)) {
            return GUIGraphics.invert(n, 0);
        }
        if (GUIGraphics.Cm(n3) && GUIGraphics.Cm(n4) && GUIGraphics.Cm(n5)) {
            return GUIGraphics.invert(n, !(f <= 153.0f) ? 0 : 0xFFFFFF);
        }
        int n6 = GUIGraphics.rgb2hsb(n3, n4, n5)[0];
        if (n6 > 340 || n6 >= 0 && n6 < 20) {
            return GUIGraphics.invert(n, 0xFFFF00);
        }
        if (n6 > 100 && n6 < 140) {
            return GUIGraphics.invert(n, 35723);
        }
        if (n6 > 220 && n6 < 260) {
            return GUIGraphics.invert(n, 0xFFFF00);
        }
        return GUIGraphics.invert(n, n2 << 24 | (int)(GUIGraphics.pow(255.0, n3) % 255.0) << 16 | (int)(GUIGraphics.pow(255.0, n4) % 255.0) << 8 | (int)(GUIGraphics.pow(255.0, n5) % 255.0));
    }

    public static int[] rgb2hsb(int n, int n2, int n3) throws  {
        float f;
        float f2;
        float f3;
        float f4 = n;
        float f5 = n2;
        float f6 = n3;
        float f7 = f3 = !(f4 <= f5) ? f4 : f5;
        if (!(f6 <= f3)) {
            f3 = f6;
        }
        float f8 = f2 = f4 < f5 ? f4 : f5;
        if (f6 < f2) {
            f2 = f6;
        }
        float f9 = f3 / 255.0f;
        float f10 = f3 != 0.0f ? (f3 - f2) / f3 : 0.0f;
        if (f10 == 0.0f) {
            f = 0.0f;
        } else {
            float f11 = (f3 - f4) / (f3 - f2);
            float f12 = (f3 - f5) / (f3 - f2);
            float f13 = (f3 - f6) / (f3 - f2);
            f = f4 == f3 ? f13 - f12 : (f5 == f3 ? 2.0f + f11 - f13 : 4.0f + f12 - f11);
            if ((f /= 6.0f) < 0.0f) {
                f += 1.0f;
            }
        }
        return new int[]{(int)(f * (float)360), (int)(f10 * (float)100), (int)(f9 * (float)100)};
    }

    public static double pow(double d, int n) throws  {
        double d2 = 1.0;
        int n2 = 0;
        while (n2 < n) {
            d2 *= d;
            ++n2;
        }
        return d2;
    }

    public static boolean Cm(int n) throws  {
        return n > 100 && n < 156;
    }

    public static void drawString(Graphics graphics, String string, int n, int n2, int n3) throws  {
        int n4 = graphics.getColor();
        if (border) {
            graphics.setColor(GUIGraphics.invert(n4));
            graphics.drawString(string, n - 1, n2 - 1, n3);
            graphics.drawString(string, n + 1, n2 - 1, n3);
            graphics.drawString(string, n - 1, n2 + 1, n3);
            graphics.drawString(string, n + 1, n2 + 1, n3);
        }
        graphics.setColor(n4);
        graphics.drawString(string, n, n2, n3);
    }

    public static void drawSubstring(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5) throws  {
        GUIGraphics.drawString(graphics, string.substring(n, n2), n3, n4, n5);
    }

    public static void drawChar(Graphics graphics, char c, int n, int n2, int n3) throws  {
        GUIGraphics.drawString(graphics, String.valueOf(c).concat(""), n, n2, n3);
    }

    public void drawChars(Graphics graphics, char[] cArray, int n, int n2, int n3, int n4, int n5) throws  {
        GUIGraphics.drawString(graphics, new String(cArray).substring(n, n2), n3, n4, n5);
    }

    public static void drawImage(Graphics graphics, Image image, int n, int n2, int n3) throws  {
        graphics.drawImage(image, n, n2, n3);
        int n4 = image.getWidth();
        int n5 = image.getHeight() / 2;
        if (!lightmode) {
            int[] nArray;
            if (table.containsKey(String.valueOf(n4).concat("x").concat(String.valueOf(n5)))) {
                nArray = (int[])table.get(String.valueOf(n4).concat("x").concat(String.valueOf(n5)));
            } else {
                nArray = GUIGraphics.glassRect(n4, n5, 255, 0);
                table.put(String.valueOf(n4).concat("x").concat(String.valueOf(n5)), nArray);
            }
            if (n3 == 6) {
                n2 -= image.getHeight() / 2;
            }
            if (n3 == 68) {
                n2 -= image.getHeight();
            }
            if (n3 == 17) {
                n -= image.getWidth() / 2;
            }
            if (n3 == 3) {
                n -= image.getWidth() / 2;
                n2 -= image.getHeight() / 2;
            }
            if (n3 == 65) {
                n -= image.getWidth() / 2;
                n2 -= image.getHeight();
            }
            if (n3 == 24) {
                n -= image.getWidth();
            }
            if (n3 == 10) {
                n2 -= image.getHeight() / 2;
                n -= image.getWidth();
            }
            if (n3 == 72) {
                n2 -= image.getHeight();
                n -= image.getWidth();
            }
            graphics.drawRGB(nArray, 0, image.getWidth(), n, n2, image.getWidth(), n5, true);
        }
    }

    public static void fillTriangle(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) throws  {
        graphics.fillTriangle(n, n2, n3, n4, n5, n6);
    }

    public static void drawRGB(Graphics graphics, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) throws  {
        if (!lightmode) {
            int n7 = 0;
            while (n7 < nArray.length) {
                int n8 = 127;
                int n9 = nArray[n7] >> 16 & 0xFF;
                int n10 = nArray[n7] >> 8 & 0xFF;
                int n11 = nArray[n7] & 0xFF;
                nArray[n7] = n8 << 24 | n9 << 16 | n10 << 8 | n11;
                ++n7;
            }
        }
        graphics.drawRGB(nArray, n, n2, n3, n4, n5, n6, bl);
    }

    public static int[] glassSpot(int n, int n2, int n3) throws  {
        if (n2 == -1) {
            n2 = 255;
        }
        if (n3 == -1) {
            n2 = 0;
        }
        int n4 = n2;
        int n5 = n3;
        int n6 = 255;
        int n7 = 0;
        int n8 = 255;
        int n9 = 0;
        int n10 = 255;
        int n11 = 0;
        return GUIGraphics.gradientSpot(n, n4, n5, n6, n7, n8, n9, n10, n11);
    }

    public static int[] gradientSpot(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) throws  {
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15 = n / 2;
        int n16 = n / 2;
        Image image = Image.createImage((int)n, (int)n);
        Graphics graphics = image.getGraphics();
        graphics.setColor(0);
        graphics.fillRect(0, 0, n, n);
        int n17 = n15 - 1;
        while (n17 > -1) {
            n14 = n2 + (n17 - n15) * (n3 - n2) / (n15 - 1) + (n3 - n2);
            n13 = n4 + (n17 - n15) * (n5 - n4) / (n15 - 1) + (n5 - n4);
            n12 = n6 + (n17 - n15) * (n7 - n6) / (n15 - 1) + (n7 - n6);
            n11 = n8 + (n17 - n15) * (n9 - n8) / (n15 - 1) + (n9 - n8);
            n10 = n14 << 24 | n13 << 16 | n12 << 8 | n11;
            graphics.setColor(n10);
            graphics.fillArc(n15 - n17, n15 - n17, n17 * 2, n17 * 2, 0, 360);
            --n17;
        }
        int[] nArray = new int[n * n];
        image.getRGB(nArray, 0, n, 0, 0, n, n);
        graphics = null;
        image = null;
        n10 = nArray[0];
        int n18 = 0;
        while (n18 < nArray.length) {
            int n19;
            n13 = nArray[n18] >> 16 & 0xFF;
            n12 = nArray[n18] >> 8 & 0xFF;
            n11 = nArray[n18] & 0xFF;
            n14 = n2 * n12 / 255;
            nArray[n18] = n19 = n14 << 24 | n13 << 16 | n12 << 8 | n11;
            if (n10 == nArray[n18]) {
                nArray[n18] = 0;
            }
            ++n18;
        }
        nArray = GUIGraphics.blur(nArray, n, n);
        return nArray;
    }

    public static int[] glassRect(int n, int n2, int n3, int n4) throws  {
        if (n3 == -1) {
            n3 = 255;
        }
        if (n4 == -1) {
            n3 = 0;
        }
        int n5 = n3;
        int n6 = n4;
        int n7 = 255;
        int n8 = 255;
        int n9 = 255;
        int n10 = 255;
        int n11 = 255;
        int n12 = 255;
        return GUIGraphics.gradientRect(n, n2, n5, n6, n7, n8, n9, n10, n11, n12);
    }

    public static int[] gradientRect(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) throws  {
        int[] nArray = new int[n * n2];
        int n11 = n3 + (0 - n2 + 1) * (n4 - n3) / (n2 - 1) + (n4 - n3) - 255;
        int n12 = 0;
        while (n12 < n2) {
            int n13 = n3 + (n12 - n2 + 1) * (n4 - n3) / (n2 - 1) + (n4 - n3) - n11;
            int n14 = n5 + (n12 - n2 + 1) * (n6 - n5) / (n2 - 1) + (n6 - n5) - n11;
            int n15 = n7 + (n12 - n2 + 1) * (n8 - n7) / (n2 - 1) + (n8 - n7) - n11;
            int n16 = n9 + (n12 - n2 + 1) * (n10 - n9) / (n2 - 1) + (n10 - n9) - n11;
            int n17 = Math.abs(n13) << 24 | Math.abs(n14) << 16 | Math.abs(n15) << 8 | Math.abs(n16);
            int n18 = 0;
            while (n18 < n) {
                nArray[n18 + n12 * n] = n17;
                ++n18;
            }
            ++n12;
        }
        return nArray;
    }

    public static int[] glassTriangle(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) throws  {
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16 = n7;
        Image image = Image.createImage((int)n7, (int)n8);
        Graphics graphics = image.getGraphics();
        graphics.setColor(0);
        graphics.fillRect(0, 0, n7, n8);
        if (n9 == -1) {
            n9 = 255;
        }
        if (n10 == -1) {
            n9 = 0;
        }
        int n17 = n9;
        int n18 = n10;
        int n19 = 255;
        int n20 = 0;
        int n21 = 255;
        int n22 = 0;
        int n23 = 255;
        int n24 = 0;
        int n25 = n16;
        while (n25 > 0) {
            n15 = n17 + (n25 - n16) * (n18 - n17) / (n16 - 1) + (n18 - n17);
            n14 = n19 + (n25 - n16) * (n20 - n19) / (n16 - 1) + (n20 - n19);
            n13 = n21 + (n25 - n16) * (n22 - n21) / (n16 - 1) + (n22 - n21);
            n12 = n23 + (n25 - n16) * (n24 - n23) / (n16 - 1) + (n24 - n23);
            n11 = n15 << 24 | n14 << 16 | n13 << 8 | n12;
            graphics.setColor(n11);
            graphics.fillTriangle(n, n2, n3, n4, n5, n25 * n6 / n5);
            --n25;
        }
        int[] nArray = new int[n7 * n8];
        image.getRGB(nArray, 0, n7, 0, 0, n7, n8);
        graphics = null;
        image = null;
        n11 = nArray[nArray.length - 1];
        int n26 = 0;
        while (n26 < nArray.length) {
            int n27;
            n14 = nArray[n26] >> 16 & 0xFF;
            n13 = nArray[n26] >> 8 & 0xFF;
            n12 = nArray[n26] & 0xFF;
            n15 = n17 * n13 / 255;
            nArray[n26] = n27 = n15 << 24 | n14 << 16 | n13 << 8 | n12;
            if (n11 == nArray[n26]) {
                nArray[n26] = 0;
            }
            ++n26;
        }
        nArray = GUIGraphics.blur(nArray, n7, n8);
        return nArray;
    }

    public static int[] glassRoundRect(int n, int n2, int n3, int n4) throws  {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11 = 0;
        Image image = Image.createImage((int)n, (int)n2);
        Graphics graphics = image.getGraphics();
        graphics.setColor(0);
        graphics.fillRect(0, 0, n, n2);
        if (n3 == -1) {
            n3 = 255;
        }
        if (n4 == -1) {
            n3 = 0;
        }
        int n12 = n3;
        int n13 = n4;
        int n14 = 255;
        int n15 = 0;
        int n16 = 255;
        int n17 = 0;
        int n18 = 255;
        int n19 = 0;
        n11 = n2 / 2;
        int n20 = n / 2;
        int n21 = n11;
        while (n21 > 0) {
            n10 = n12 + (n21 - n11) * (n13 - n12) / (n11 - 1) + (n13 - n12);
            n9 = n14 + (n21 - n11) * (n15 - n14) / (n11 - 1) + (n15 - n14);
            n8 = n16 + (n21 - n11) * (n17 - n16) / (n11 - 1) + (n17 - n16);
            n7 = n18 + (n21 - n11) * (n19 - n18) / (n11 - 1) + (n19 - n18);
            n6 = n10 << 24 | n9 << 16 | n8 << 8 | n7;
            graphics.setColor(n6);
            n5 = n20 / n21;
            graphics.fillRoundRect(n5 * 2, n11 - n21, n - n5 * 4, n21 * 2, n21 * 2, n21 * 2);
            --n21;
        }
        int[] nArray = new int[n * n2];
        image.getRGB(nArray, 0, n, 0, 0, n, n2);
        graphics = null;
        image = null;
        n6 = nArray[nArray.length - 1];
        n5 = 0;
        while (n5 < nArray.length) {
            int n22;
            n9 = nArray[n5] >> 16 & 0xFF;
            n8 = nArray[n5] >> 8 & 0xFF;
            n7 = nArray[n5] & 0xFF;
            n10 = n12 * n8 / 255;
            nArray[n5] = n22 = n10 << 24 | n9 << 16 | n8 << 8 | n7;
            if (n6 == nArray[n5]) {
                nArray[n5] = 0;
            }
            ++n5;
        }
        nArray = GUIGraphics.blur(nArray, n, n2);
        return nArray;
    }

    public static int[] blur(int[] nArray, int n, int n2) throws  {
        int[] nArray2 = new int[n * n2];
        int n3 = 1 + n;
        while (n3 < nArray2.length - 1 - n) {
            int n4 = nArray[n3 - 1 - n] >> 24 & 0xFF;
            int n5 = nArray[n3 - 1 - n] >> 16 & 0xFF;
            int n6 = nArray[n3 - 1 - n] >> 8 & 0xFF;
            int n7 = nArray[n3 - 1 - n] & 0xFF;
            int n8 = nArray[n3 - n] >> 24 & 0xFF;
            int n9 = nArray[n3 - n] >> 16 & 0xFF;
            int n10 = nArray[n3 - n] >> 8 & 0xFF;
            int n11 = nArray[n3 - n] & 0xFF;
            int n12 = nArray[n3 + 1 - n] >> 24 & 0xFF;
            int n13 = nArray[n3 + 1 - n] >> 16 & 0xFF;
            int n14 = nArray[n3 + 1 - n] >> 8 & 0xFF;
            int n15 = nArray[n3 + 1 - n] & 0xFF;
            int n16 = nArray[n3 - 1] >> 24 & 0xFF;
            int n17 = nArray[n3 - 1] >> 16 & 0xFF;
            int n18 = nArray[n3 - 1] >> 8 & 0xFF;
            int n19 = nArray[n3 - 1] & 0xFF;
            int n20 = nArray[n3] >> 24 & 0xFF;
            int n21 = nArray[n3] >> 16 & 0xFF;
            int n22 = nArray[n3] >> 8 & 0xFF;
            int n23 = nArray[n3] & 0xFF;
            int n24 = nArray[n3 + 1] >> 24 & 0xFF;
            int n25 = nArray[n3 + 1] >> 16 & 0xFF;
            int n26 = nArray[n3 + 1] >> 8 & 0xFF;
            int n27 = nArray[n3 + 1] & 0xFF;
            int n28 = nArray[n3 - 1 + n] >> 24 & 0xFF;
            int n29 = nArray[n3 - 1 + n] >> 16 & 0xFF;
            int n30 = nArray[n3 - 1 + n] >> 8 & 0xFF;
            int n31 = nArray[n3 - 1 + n] & 0xFF;
            int n32 = nArray[n3 + n] >> 24 & 0xFF;
            int n33 = nArray[n3 + n] >> 16 & 0xFF;
            int n34 = nArray[n3 + n] >> 8 & 0xFF;
            int n35 = nArray[n3 + n] & 0xFF;
            int n36 = nArray[n3 + 1 + n] >> 24 & 0xFF;
            int n37 = nArray[n3 + 1 + n] >> 16 & 0xFF;
            int n38 = nArray[n3 + 1 + n] >> 8 & 0xFF;
            int n39 = nArray[n3 + 1 + n] & 0xFF;
            n20 = (n4 + n8 + n12 + n16 + n20 + n24 + n28 + n32 + n36) / 9;
            n21 = (n5 + n9 + n13 + n17 + n21 + n25 + n29 + n33 + n37) / 9;
            n22 = (n6 + n10 + n14 + n18 + n22 + n26 + n30 + n34 + n38) / 9;
            n23 = (n7 + n11 + n15 + n19 + n23 + n27 + n31 + n35 + n39) / 9;
            nArray2[n3] = n20 << 24 | n21 << 16 | n22 << 8 | n23;
            ++n3;
        }
        return nArray2;
    }

    public static int[] reverse(int[] nArray) throws  {
        int[] nArray2 = new int[nArray.length];
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            nArray2[n - 1 - n2] = nArray[n2];
            ++n2;
        }
        return nArray2;
    }
}

